/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.Strings;

public class FroRequestFailedException
extends MoAccessException {
    private static final long serialVersionUID = 3168504920558737580L;
    private String errorCode;
    private int orgErrorCode;

    public FroRequestFailedException(String aRequest, int aResult, String errorCode, int orgErrorCode, String addinfo) {
        super("FroRequestFailed");
        this.addVariableValue("Request ", aRequest);
        this.addVariableValue("result", new Integer(aResult));
        this.addVariableValue("Fro error code", Strings.toPascalCase(FroRequestFailedException.removeErrorCodePrefix(errorCode)));
        this.addVariableValue("Additional information", addinfo);
        this.errorCode = errorCode;
        this.orgErrorCode = orgErrorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int getOrgErrorCode() {
        return this.orgErrorCode;
    }

    public static String removeErrorCodePrefix(String rbsTypeErrorCodeString) {
        String UNDERSCORE = "_";
        String[] legalPrefixes = new String[]{"BC_SYS_CONST", "LRS_SYNC_RES", "LRS_CELL_CARRIER", "SCC_SCMI_CEM"};
        String[] subSystemPrefixes = new String[]{"BC", "CHC", "EC", "LRS", "NC", "RBS", "SCC"};
        try {
            if (!Strings.contains(rbsTypeErrorCodeString, "_")) {
                return rbsTypeErrorCodeString;
            }
            for (int i = 0; i < subSystemPrefixes.length; ++i) {
                if (!rbsTypeErrorCodeString.startsWith(subSystemPrefixes[i])) continue;
                for (int j = 0; j < legalPrefixes.length; ++j) {
                    if (!rbsTypeErrorCodeString.startsWith(legalPrefixes[j])) continue;
                    return rbsTypeErrorCodeString.substring(legalPrefixes[j].length() + 1);
                }
                int firstUnderscoreIndex = rbsTypeErrorCodeString.indexOf("_");
                int secondUnderscoreIndex = rbsTypeErrorCodeString.indexOf("_", firstUnderscoreIndex + 1);
                if (secondUnderscoreIndex < 0) {
                    return rbsTypeErrorCodeString.substring(firstUnderscoreIndex + 1);
                }
                return rbsTypeErrorCodeString.substring(secondUnderscoreIndex + 1);
            }
            return rbsTypeErrorCodeString;
        }
        catch (IndexOutOfBoundsException ignored) {
            return rbsTypeErrorCodeString;
        }
    }
}

