/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.xmlutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.pbootutil.OseProcessHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.GeoLocationCheckHandlerImpl;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;

public class NlhFileEncryptDecryption {
    private static final int keyLength = 16;
    private static final int keyOffset = 2;
    private static final int blockSize = 8;
    private static final String algorithm = "AES";

    public static String getXmlEncryptionKey() {
        String serialNo = null;
        try {
            serialNo = GeoLocationCheckHandlerImpl.getSerialNumberFromSlot(false);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(NlhFileEncryptDecryption.class, "MoAccessException: failed to get serialNo" + e.getMessage(), e);
            serialNo = null;
        }
        catch (Exception e) {
            MessageLog.traceError(NlhFileEncryptDecryption.class, "Exception: failed to get serialNo" + e.getMessage(), e);
            serialNo = null;
        }
        if (serialNo == null) {
            String SERIAL_NUMBER = "serialnumber";
            serialNo = NlhFileEncryptDecryption.getAttributeByPboot("serialnumber", false);
        }
        String macAddress = NlhFileEncryptDecryption.getMacAddress();
        if (serialNo != null && macAddress != null) {
            return serialNo + macAddress;
        }
        return null;
    }

    private static String getMacAddress() {
        MessageLog.traceEnter(NlhFileEncryptDecryption.class, "getMacAddress()");
        String strMacAddress = null;
        EthernetLinkMo ethernetLinkMo = (EthernetLinkMo)BoamHelper.getFirstMatchingMo("EthernetLink", "1");
        if (ethernetLinkMo != null) {
            try {
                strMacAddress = ethernetLinkMo.getMacAddress(null);
            }
            catch (MoAccessException e) {
                MessageLog.traceError(NlhFileEncryptDecryption.class, "MoAccessException: failed to getMacAddress" + e.getMessage(), e);
            }
        }
        if (strMacAddress == null) {
            String ETHERNET_ID_0 = "ethernetid0";
            strMacAddress = NlhFileEncryptDecryption.getAttributeByPboot("ethernetid0", true);
        }
        return strMacAddress;
    }

    private static String getAttributeByPboot(String grepValue, boolean isNeedFormat) {
        String attributeValue = null;
        attributeValue = OseProcessHelper.getPbootParameter(grepValue);
        attributeValue = isNeedFormat ? NlhFileEncryptDecryption.formatAttribute(attributeValue) : attributeValue;
        return attributeValue;
    }

    private static String formatAttribute(String attributeValue) {
        int len = attributeValue.length();
        if (len <= 2) {
            return null;
        }
        String prefix = "0x";
        if (!attributeValue.startsWith(prefix)) {
            return attributeValue.toLowerCase(Locale.getDefault());
        }
        String split = ":";
        attributeValue = attributeValue.toLowerCase(Locale.getDefault());
        StringBuffer sb = new StringBuffer();
        for (int i = 2; i < len; i += 2) {
            sb.append(attributeValue.substring(i, i + 2));
            sb.append(":");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static Cipher makeCipher(String password, int encryptMode) throws GeneralSecurityException {
        MessageLog.traceEnter(NlhFileEncryptDecryption.class, "makeCipher()");
        BouncyCastleProvider bcJce = new BouncyCastleProvider();
        Security.addProvider((Provider)bcJce);
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            MessageLog.info(class$se$ericsson$wcdma$rbs$boam$common$xmlutil$NlhFileEncryptDecryption == null ? NlhFileEncryptDecryption.class$("se.ericsson.wcdma.rbs.boam.common.xmlutil.NlhFileEncryptDecryption") : class$se$ericsson$wcdma$rbs$boam$common$xmlutil$NlhFileEncryptDecryption, "JCE Provider found:  " + providers[i].getName());
        }
        SecretKeySpec secretKey = new SecretKeySpec(NlhFileEncryptDecryption.getCopy(password.getBytes(), 2, 18), algorithm);
        Cipher cipher = Cipher.getInstance(algorithm, (Provider)bcJce);
        cipher.init(encryptMode, secretKey);
        MessageLog.traceReturn(NlhFileEncryptDecryption.class, "makeCipher()");
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean decryptFile(String fileName, String targetFileName, String password) {
        block46: {
            block45: {
                block43: {
                    block44: {
                        result = false;
                        MessageLog.traceEnter(NlhFileEncryptDecryption.class, "decryptFile(): " + fileName);
                        inFile = new File(fileName);
                        cipher = null;
                        inStream = null;
                        fileLen = (int)inFile.length();
                        encData = new byte[fileLen];
                        inStream = new FileInputStream(inFile);
                        if (fileLen == inStream.read(encData)) break block43;
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "The length of nlh file is not matched.");
                        var10_9 = false;
                        var12_15 = null;
                        if (inStream == null) break block44;
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                        }
                    }
                    return var10_9;
                }
                try {
                    cipher = NlhFileEncryptDecryption.makeCipher(password, 2);
                    var12_16 = null;
                    ** if (inStream == null) goto lbl-1000
                }
                catch (Throwable var11_29) {
                    var12_21 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                        }
                    }
                    throw var11_29;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block45;
                    catch (FileNotFoundException e) {
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "FileNotFoundException: failed to read " + fileName + e.getMessage(), e);
                        var12_17 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e) {
                                MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                            }
                        }
                        break block45;
                    }
                    catch (IOException e) {
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed to read " + fileName + e.getMessage(), e);
                        var12_18 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e) {
                                MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                            }
                        }
                        break block45;
                    }
                    catch (GeneralSecurityException e) {
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "GeneralSecurityException: failed to init Cipher " + e.getMessage(), e);
                        var12_19 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e) {
                                MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                            }
                        }
                        break block45;
                    }
                    catch (Exception e) {
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "Exception: failed to decryptFile " + fileName + e.getMessage(), e);
                        var12_20 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e) {
                                MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                            }
                        }
                    }
                }
            }
            target = null;
            try {
                decData = cipher.doFinal(encData);
                padCount = decData[decData.length - 1];
                if (padCount >= 1 && padCount <= 8) {
                    decData = NlhFileEncryptDecryption.getCopy(decData, 0, decData.length - padCount);
                }
                target = new FileOutputStream(new File(targetFileName));
                target.write(decData);
                result = true;
                var15_36 = null;
                ** if (target == null) goto lbl-1000
            }
            catch (Throwable var14_48) {
                var15_41 = null;
                if (target != null) {
                    try {
                        target.close();
                    }
                    catch (IOException e) {
                        MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                    }
                }
                throw var14_48;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    target.close();
                }
                catch (IOException e) {
                    MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block46;
                catch (IllegalBlockSizeException e) {
                    MessageLog.traceError(NlhFileEncryptDecryption.class, "IllegalBlockSizeException: failed to decrypt file " + fileName + e.getMessage(), e);
                    var15_37 = null;
                    if (target != null) {
                        try {
                            target.close();
                        }
                        catch (IOException e) {
                            MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                        }
                    }
                    break block46;
                }
                catch (BadPaddingException e) {
                    MessageLog.traceError(NlhFileEncryptDecryption.class, "BadPaddingException: failed to decrypt file " + fileName + e.getMessage(), e);
                    var15_38 = null;
                    if (target != null) {
                        try {
                            target.close();
                        }
                        catch (IOException e) {
                            MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                        }
                    }
                    break block46;
                }
                catch (FileNotFoundException e) {
                    MessageLog.traceError(NlhFileEncryptDecryption.class, "FileNotFoundException: failed to write file " + targetFileName + e.getMessage(), e);
                    var15_39 = null;
                    if (target != null) {
                        try {
                            target.close();
                        }
                        catch (IOException e) {
                            MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                        }
                    }
                    break block46;
                }
                catch (IOException e) {
                    MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed to write file " + targetFileName + e.getMessage(), e);
                    var15_40 = null;
                    if (target != null) {
                        try {
                            target.close();
                        }
                        catch (IOException e) {
                            MessageLog.traceError(NlhFileEncryptDecryption.class, "IOException: failed close iostream " + e.getMessage(), e);
                        }
                    }
                }
            }
        }
        MessageLog.traceReturn(NlhFileEncryptDecryption.class, "decryptFile()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean encryptFile(String fileName, String targetFile, String password) throws GeneralSecurityException, IOException {
        MessageLog.traceEnter(NlhFileEncryptDecryption.class, "encryptFile(): " + fileName);
        boolean result2 = false;
        File inFile = new File(fileName);
        Cipher cipher = NlhFileEncryptDecryption.makeCipher(password, 1);
        int paddedCount = 8 - (int)inFile.length() % 8;
        int padded = (int)inFile.length() + paddedCount;
        byte[] decData = new byte[padded];
        FileInputStream inStream = new FileInputStream(inFile);
        try {
            if (inFile.length() != (long)inStream.read(decData)) {
                MessageLog.traceError(NlhFileEncryptDecryption.class, "The length of nlh file is not matched.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            inStream.close();
        }
        for (int i = (int)inFile.length(); i < padded; ++i) {
            decData[i] = (byte)paddedCount;
        }
        byte[] encData = cipher.doFinal(decData);
        FileOutputStream outStream = new FileOutputStream(targetFile);
        try {
            outStream.write(encData);
        }
        finally {
            outStream.close();
        }
        MessageLog.traceReturn(NlhFileEncryptDecryption.class, "encryptFile()");
        return result2;
    }

    private static byte[] getCopy(byte[] original, int from, int to) {
        int newLength = to - from;
        int start = 0;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        int targetLength = original.length - from;
        byte[] copy = new byte[newLength];
        if (newLength > targetLength && targetLength > 0) {
            System.arraycopy(original, from, copy, start, targetLength);
        } else if (newLength < targetLength) {
            System.arraycopy(original, from, copy, start, newLength);
        }
        return copy;
    }

    public static String generateEncryptStr(String content, String password) throws GeneralSecurityException, IOException {
        int i;
        MessageLog.traceEnter(NlhFileEncryptDecryption.class, "generateEncryptStr(): ");
        Cipher cipher = NlhFileEncryptDecryption.makeCipher(password, 1);
        int paddedCount = 8 - content.length() % 8;
        int padded = content.length() + paddedCount;
        byte[] decData = new byte[padded];
        for (i = 0; i < content.length(); ++i) {
            decData[i] = content.getBytes()[i];
        }
        for (i = content.length(); i < padded; ++i) {
            decData[i] = (byte)paddedCount;
        }
        byte[] encData = cipher.doFinal(decData);
        MessageLog.traceReturn(NlhFileEncryptDecryption.class, "generateEncryptStr()");
        return new String(encData);
    }
}

