/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.common.AvcIndication;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcErrorCodeMapper;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcAuxPiuAvcIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcAuxPiuHwPidChangedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcAuxPiuSupportUnitIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSubscrAuxPiuAvcReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.AvcIndProxy;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxPlugInUnitMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;

public class EcAuxPiuAvcIndProxy
extends AvcIndProxy {
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    private static EcAuxPiuAvcIndProxy uniqueInstance;

    private EcAuxPiuAvcIndProxy() {
        super(SERVICE_NAME);
        this.boamSignalPort.addSignalObserver(this, EcAuxPiuAvcIndS.class);
        this.boamSignalPort.addSignalObserver(this, EcAuxPiuSupportUnitIndS.class);
        this.boamSignalPort.addSignalObserver(this, EcAuxPiuHwPidChangedIndS.class);
    }

    public static synchronized EcAuxPiuAvcIndProxy instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new EcAuxPiuAvcIndProxy();
        }
        return uniqueInstance;
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification()");
        int CLIENT_ID = 0;
        try {
            this.subscEcAuxPiuAvc(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private void subscEcAuxPiuAvc(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscEcAuxPiuAvc()");
        RbsServiceNameT rbsServiceName = new RbsServiceNameT();
        rbsServiceName.serviceName = this.signalPort.getServiceName();
        EcSubscrAuxPiuAvcReqS reqSig = new EcSubscrAuxPiuAvcReqS(clientId, subscribeOperation, rbsServiceName);
        this.sendAndRec(reqSig);
    }

    protected void handleAVCind(AvcIndication avcSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "handleAVCind()");
        if (avcSig instanceof EcAuxPiuSupportUnitIndS) {
            this.handleAuxPiuSupportUnitInd((EcAuxPiuSupportUnitIndS)avcSig);
        } else if (avcSig instanceof EcAuxPiuHwPidChangedIndS) {
            this.handleAuxHwPidChangedInd((EcAuxPiuHwPidChangedIndS)avcSig);
        } else {
            ManagedObject auxPiu = this.getMoFromFroId("AuxPlugInUnit", (int)avcSig.getFroId());
            if (!(auxPiu instanceof AuxPlugInUnitMo)) {
                MessageLog.traceError(this.getClass(), "The MO that corresponds to froId: " + avcSig.getFroId() + " is not of type " + "AuxPlugInUnit" + ", instead: " + auxPiu.getType());
            } else {
                ((BoamManagedObject)auxPiu).sendAVC("administrativeState", avcSig.getAvcValue());
            }
        }
    }

    private void handleAuxPiuSupportUnitInd(EcAuxPiuSupportUnitIndS avcSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "handleAuxPiuSupportUnitInd()");
        AuxPlugInUnitMoImpl auxPiuMo = (AuxPlugInUnitMoImpl)this.getMoFromFroId("AuxPlugInUnit", (int)avcSig.auxPiuFroId);
        try {
            TransactionWrapper tw = new TransactionWrapper();
            try {
                MoData aData = auxPiuMo.getMyMoData();
                aData.handleTransaction(tw.getCoordinator(), MoData.WRITE_ACCESS);
                SequenceAttribute sequenceAttr = (SequenceAttribute)aData.getAttribute("supportUnitRef");
                Attribute[] attributes = null;
                if (null == sequenceAttr) {
                    MessageLog.traceError(this.getClass(), "No such attribute: supportUnitRef in AuxPlugInUnit froId: " + avcSig.auxPiuFroId);
                    return;
                }
                attributes = sequenceAttr.getValue(tw.getCoordinator());
                if (null == attributes) {
                    MessageLog.traceError(this.getClass(), "Attribute sequence can't be null: supportUnitRef in AuxPlugInUnit froId: " + avcSig.auxPiuFroId);
                    return;
                }
                ManagedObject supportUnit = BoamHelper.getMoForLdn(avcSig.supportUnitRef);
                if (!(supportUnit instanceof Reservable)) {
                    MessageLog.traceError(this.getClass(), avcSig.supportUnitRef + " is not reservable.");
                    return;
                }
                int supportUnitIndex = -1;
                for (int i = 0; i < attributes.length; ++i) {
                    ReferenceAttribute attr = (ReferenceAttribute)attributes[i];
                    if (!attr.getReferenceAsLDN().equals(avcSig.supportUnitRef)) continue;
                    supportUnitIndex = i;
                    break;
                }
                if (0 == avcSig.action) {
                    if (-1 == supportUnitIndex) {
                        ReferenceAttribute attr = new ReferenceAttribute("", avcSig.supportUnitRef, false);
                        sequenceAttr.addElement((Attribute)attr);
                        ((Reservable)supportUnit).reserve((ManagedObject)auxPiuMo, tw.getCoordinator());
                    }
                } else if (1 == avcSig.action) {
                    if (0 <= supportUnitIndex) {
                        sequenceAttr.removeElement(attributes[supportUnitIndex]);
                        ((Reservable)supportUnit).release((ManagedObject)auxPiuMo, tw.getCoordinator());
                    }
                } else {
                    MessageLog.traceError(this.getClass(), "Unkown action: " + avcSig.action);
                }
                tw.commit();
            }
            catch (InactiveTransactionException e) {
                try {
                    tw.rollback();
                    MessageLog.traceError(this.getClass(), "Error while handling EcAuxPiuSupportUnitIndS on the AuxPlugInUnit MO, the transaction is rolled back " + tw.getID(), e);
                }
                catch (InactiveTransactionException e1) {
                    MessageLog.traceError(this.getClass(), "Failed to rollback transaction " + tw.getID(), e1);
                }
            }
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(this.getClass(), "Error while creating transaction", e);
        }
    }

    private void handleAuxHwPidChangedInd(EcAuxPiuHwPidChangedIndS avcSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "handleAuxHwPidChangedInd()");
        ManagedObject auxPiuMo = this.getMoFromFroId("AuxPlugInUnit", (int)avcSig.auxPiuFroId);
        if (!(auxPiuMo instanceof AuxPlugInUnitMo)) {
            MessageLog.traceError(this.getClass(), "The MO that corresponds to froId: " + avcSig.auxPiuFroId + " is not of type " + "AuxPlugInUnit" + ", instead: " + auxPiuMo.getType());
        } else {
            String[] attrArr = new String[]{"productName", "productNumber", "productRevision", "productType", "productionDate", "serialNumber"};
            String[] valArr = new String[]{avcSig.basicHwPid.hwProductName, avcSig.basicHwPid.hwProductNumber, avcSig.basicHwPid.hwProductRevision, avcSig.basicHwPid.hwProductType, avcSig.basicHwPid.hwProductionDate, avcSig.basicHwPid.hwSerialNumber};
            TransactionWrapper tw = null;
            try {
                tw = new TransactionWrapper();
                Coordinator context = tw.getCoordinator();
                ((AuxPlugInUnitMoImpl)auxPiuMo).checkAndSetIsRadioInUcf(avcSig.basicHwPid.hwProductNumber, avcSig.basicHwPid.hwProductRevision, context);
                tw.commit();
            }
            catch (InactiveTransactionException e) {
                try {
                    tw.rollback();
                    MessageLog.traceError(this.getClass(), "Error while handling EcAuxPiuHwPidChangedIndS on the AuxPlugInUnit MO, the transaction is rolled back " + tw.getID(), e);
                }
                catch (InactiveTransactionException e1) {
                    MessageLog.traceError(this.getClass(), "Failed to rollback transaction " + tw.getID(), e1);
                }
            }
            catch (TransactionRolledBackException e) {
                MessageLog.traceError(this.getClass(), "Error while creating transaction", e);
            }
            for (int i = 0; i < attrArr.length; ++i) {
                ((BoamManagedObject)auxPiuMo).sendAVC(attrArr[i], valArr[i]);
            }
        }
    }

    public void ensureResponse(String aRequest, int result2, int errorCode) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "ensureResponse()");
        if (result2 == 0) {
            return;
        }
        EcErrorCodeMapper.throwFroRequestFailedException(this.serviceName, aRequest, result2, errorCode);
    }
}

