/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateUlsaReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateUlsaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteUlsaReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteUlsaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetUlsaCapabilityReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetUlsaCapabilityRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStartSamplingIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStartSamplingReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStartSamplingRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStopSamplingReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStopSamplingRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsUlsaSamplingConfigT;

public class EcUlsaProxy
extends EcGenericProxy {
    private static EcUlsaProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    public static final String CURRENT_CLASS = EcUlsaProxy.class.getName();

    private EcUlsaProxy() {
        super(SERVICE_NAME);
        this.boamSignalPort.addSignalObserver(this, EqcStartSamplingIndS.class);
    }

    public static synchronized EcUlsaProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EcUlsaProxy();
        }
        return theOneAndOnly;
    }

    public EqcCreateUlsaRspS createUlsa(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createUlsa()");
        EqcCreateUlsaReqS reqSig = new EqcCreateUlsaReqS(transactionId, clientId);
        return (EqcCreateUlsaRspS)this.sendAndRec(reqSig);
    }

    public EqcDeleteUlsaRspS deleteUlsa(int transactionId, int clientId, int ulsaFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "deleteUlsa()");
        EqcDeleteUlsaReqS reqSig = new EqcDeleteUlsaReqS(transactionId, clientId, ulsaFroId);
        return (EqcDeleteUlsaRspS)this.sendAndRec(reqSig);
    }

    public EqcGetUlsaCapabilityRspS getUlsaCapability(int transactionId, int clientId, int ulsaFroId, int groupFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getUlsaCapability()");
        EqcGetUlsaCapabilityReqS reqSig = new EqcGetUlsaCapabilityReqS(transactionId, clientId, ulsaFroId, groupFroId);
        return (EqcGetUlsaCapabilityRspS)this.sendAndRec(reqSig);
    }

    public EqcStartSamplingRspS startSampling(int transactionId, int clientId, int ulsaFroId, int samplingType, RbsUlsaSamplingConfigT samplingConfig) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "startSampling()");
        EqcStartSamplingReqS reqSig = new EqcStartSamplingReqS(transactionId, clientId, ulsaFroId, samplingType, samplingConfig);
        return (EqcStartSamplingRspS)this.sendAndRec(reqSig);
    }

    public EqcStopSamplingRspS stopSampling(int transactionId, int clientId, int ulsaFroId, int portId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "stopSampling()");
        EqcStopSamplingReqS reqSig = new EqcStopSamplingReqS(transactionId, clientId, ulsaFroId, portId);
        return (EqcStopSamplingRspS)this.sendAndRec(reqSig);
    }
}

