/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.fpx.common.PlugAndPlayIndImpl;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcDeviceScanAldInfoT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcDeviceScanPortInfoT;

public class EcAntennaDeviceScanIndS
extends PlugAndPlayIndImpl {
    public static final int SIG_NO = 16816507;
    public long clientId;
    public long endFlag;
    public long radioGroupFroId;
    public long nrOfPort;
    public EcDeviceScanPortInfoT[] portInfo = null;
    public List portInfoList = new ArrayList();
    public int comments;

    public EcAntennaDeviceScanIndS() {
        super(16816507);
    }

    public EcAntennaDeviceScanIndS(long clientId, long endFlag, long radioGroupFroId, long nrOfPort, EcDeviceScanPortInfoT[] portInfo, int comments) {
        super(16816507);
        this.clientId = clientId;
        this.endFlag = endFlag;
        this.radioGroupFroId = radioGroupFroId;
        this.nrOfPort = nrOfPort;
        this.portInfo = portInfo;
        this.comments = comments;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.endFlag = in.readU32();
            this.radioGroupFroId = in.readU32();
            this.nrOfPort = in.readU32();
            this.comments = in.readS32();
            int portIndex = 0;
            while ((long)portIndex < this.nrOfPort) {
                EcDeviceScanPortInfoT tempEcDeviceScanPortInfoT = new EcDeviceScanPortInfoT();
                tempEcDeviceScanPortInfoT.comments = in.readS32();
                tempEcDeviceScanPortInfoT.portId = Strings.toString(in.readS8Array(1));
                tempEcDeviceScanPortInfoT.padding = in.readU8Array(3);
                tempEcDeviceScanPortInfoT.nrOfAld = in.readU32();
                int tmpNrOfAld = 0;
                boolean aldFlag = true;
                if (tempEcDeviceScanPortInfoT.nrOfAld == 0L) {
                    tmpNrOfAld = 1;
                    aldFlag = false;
                } else {
                    tmpNrOfAld = (int)tempEcDeviceScanPortInfoT.nrOfAld;
                }
                for (int aldIndex = 0; aldIndex < tmpNrOfAld; ++aldIndex) {
                    EcDeviceScanAldInfoT tempEcDeviceScanAldInfoT = new EcDeviceScanAldInfoT();
                    tempEcDeviceScanAldInfoT.swVersion = Strings.toString(in.readS8Array(8));
                    tempEcDeviceScanAldInfoT.hwVersion = Strings.toString(in.readS8Array(8));
                    tempEcDeviceScanAldInfoT.hwSerialNumber = Strings.toString(in.readS8Array(14));
                    tempEcDeviceScanAldInfoT.hwProductNumber = Strings.toString(in.readS8Array(25));
                    tempEcDeviceScanAldInfoT.uniqueHwId = Strings.toString(in.readS8Array(20));
                    tempEcDeviceScanAldInfoT.padding = in.readU8Array(1);
                    tempEcDeviceScanAldInfoT.comments = in.readS32();
                    tempEcDeviceScanAldInfoT.type = in.readS32();
                    for (int tmaDataIndex = 0; tmaDataIndex < tempEcDeviceScanAldInfoT.tmaData.length; ++tmaDataIndex) {
                        tempEcDeviceScanAldInfoT.tmaData[tmaDataIndex].comments = in.readS32();
                        tempEcDeviceScanAldInfoT.tmaData[tmaDataIndex].rxFreqBandLowEdge = in.readU16();
                        tempEcDeviceScanAldInfoT.tmaData[tmaDataIndex].rxFreqBandHighEdge = in.readU16();
                        tempEcDeviceScanAldInfoT.tmaData[tmaDataIndex].txFreqBandLowEdge = in.readU16();
                        tempEcDeviceScanAldInfoT.tmaData[tmaDataIndex].txFreqBandHighEdge = in.readU16();
                    }
                    tempEcDeviceScanAldInfoT.retData.comments = in.readS32();
                    tempEcDeviceScanAldInfoT.retData.baseStationId = Strings.toString(in.readS8Array(33));
                    tempEcDeviceScanAldInfoT.retData.installationDate = Strings.toString(in.readS8Array(7));
                    tempEcDeviceScanAldInfoT.retData.installersId = Strings.toString(in.readS8Array(6));
                    tempEcDeviceScanAldInfoT.retData.sectorId = Strings.toString(in.readS8Array(33));
                    tempEcDeviceScanAldInfoT.retData.antennaModelNumber = Strings.toString(in.readS8Array(16));
                    tempEcDeviceScanAldInfoT.retData.antennaSerialNumber = Strings.toString(in.readS8Array(18));
                    tempEcDeviceScanAldInfoT.retData.padding = in.readU8Array(3);
                    tempEcDeviceScanAldInfoT.retData.antennaBearing = in.readU16();
                    tempEcDeviceScanAldInfoT.retData.antennaOperatingBands = in.readU16();
                    tempEcDeviceScanAldInfoT.retData.antennaGains = in.readU8Array(4);
                    tempEcDeviceScanAldInfoT.retData.antennaMinTilt = in.readS16();
                    tempEcDeviceScanAldInfoT.retData.antennaMaxTilt = in.readS16();
                    if (!aldFlag) continue;
                    tempEcDeviceScanPortInfoT.aldInfoList.add(tempEcDeviceScanAldInfoT);
                }
                this.portInfoList.add(tempEcDeviceScanPortInfoT);
                ++portIndex;
            }
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initReceive failed in EcAntennaDeviceScanIndS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeU32(this.endFlag);
            out.writeU32(this.radioGroupFroId);
            out.writeU32(this.nrOfPort);
            out.writeS32(this.comments);
            for (int portIndex = 0; (long)portIndex < this.nrOfPort && portIndex < this.portInfo.length; ++portIndex) {
                out.writeString(this.portInfo[portIndex].portId);
                out.writeU8Array(this.portInfo[portIndex].padding);
                out.writeU32(this.portInfo[portIndex].nrOfAld);
                for (int aldIndex = 0; (long)aldIndex < this.portInfo[portIndex].nrOfAld && aldIndex < this.portInfo[portIndex].aldInfo.length; ++aldIndex) {
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].swVersion, 8));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].hwVersion, 8));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].hwSerialNumber, 14));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].hwProductNumber, 25));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].uniqueHwId, 20));
                    out.writeS32(this.portInfo[portIndex].aldInfo[aldIndex].comments);
                    out.writeS32(this.portInfo[portIndex].aldInfo[aldIndex].type);
                    for (int tmaDataIndex = 0; tmaDataIndex < this.portInfo[portIndex].aldInfo[aldIndex].tmaData.length; ++tmaDataIndex) {
                        out.writeU16(this.portInfo[portIndex].aldInfo[aldIndex].tmaData[tmaDataIndex].rxFreqBandLowEdge);
                        out.writeU16(this.portInfo[portIndex].aldInfo[aldIndex].tmaData[tmaDataIndex].rxFreqBandHighEdge);
                        out.writeU16(this.portInfo[portIndex].aldInfo[aldIndex].tmaData[tmaDataIndex].txFreqBandLowEdge);
                        out.writeU16(this.portInfo[portIndex].aldInfo[aldIndex].tmaData[tmaDataIndex].txFreqBandHighEdge);
                    }
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].retData.baseStationId, 32));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].retData.installationDate, 6));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].retData.installersId, 5));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].retData.sectorId, 32));
                    out.writeU16(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaBearing);
                    out.writeU16(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaOperatingBands);
                    out.writeU8Array(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaGains);
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaModelNumber, 15));
                    out.writeS8Array(Strings.getBytes(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaSerialNumber, 17));
                    out.writeS16(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaMinTilt);
                    out.writeS16(this.portInfo[portIndex].aldInfo[aldIndex].retData.antennaMaxTilt);
                }
            }
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initSend failed in EcAntennaDeviceScanIndS: " + e));
        }
    }
}

