/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.main;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Terminator;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.BoamGenericMoFactory;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcAvcIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcBbpProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcCommContextsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcEulProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaCellServiceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaIubProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcIubdsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcNodeBFunctionProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPrachProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcRlsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.BatteryEqcProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcAuxPiuAvcIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcNodeBFunctionProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcPowerDistributeProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcPowerProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcTimingProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcUlsaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAntennaBranchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAuxPiuProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBbifProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceSetProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcExtTmaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcHsdpaIubProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcPmHelperProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcProgramProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRiuProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRnProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorAntennaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSlotProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSubrackProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcBsctProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcControlLinkProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcGpehScannerProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcNbapProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcNphL3SupMgrProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcOverloadProtProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcRestartServiceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcSystemConstantsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.SccAvcIndProxy;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.ue.RoRoc;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.common.ConnectionFieldAttrList;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxPlugInUnitMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.UpgradeManager;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.XpProgramMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.BoamTopologyAndAVCSubscriber;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DpProgramMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.timing.TimDeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RdbtAal5TpVccTpMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RdbtTestPortMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RdbtUdpTpMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.AntFeederCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.ConnectionFieldMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.DigitalCableMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.HiPowTxCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.IntJumperCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.LoPowTxCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.OptoCommCableMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.RbsCableMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.RdiCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.RfCableMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.TrxRfCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.climate.CluMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.intf.BbifBoardMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.BoamSubrackMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.RbsSlotMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.AccuMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.BatteryMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.BfuMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.PowerDistrSystemMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.PowerSupplySystemMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.PsuMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.antenna.AntennaBranchMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.antenna.ExternalTmaMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.antenna.RetProfileMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.CarrierMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.ExternalAntennaMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RiuMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorAntennaMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.AichMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.CommContextsMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.EDchResourcesMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.HsDschResourcesMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PccpchMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PrachMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.SccpchMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.IubDataStreamsMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.IubMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.NbapCommonMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.NbapDedicatedMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.links.RadioLinksCellMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.links.RadioLinksMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoAttrList;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.PredefRbsScannerGpehMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.RbsFeatureMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.RbsSynchronizationAttrList;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.RbsSynchronizationMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.SystemConstantsMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.UlSpectrumAnalyzerMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.RBScannerFactory;

public class BoamMain
implements Mopplet {
    public static final Class SELF = BoamMain.class;
    public static final String MODEL_VERSION = "4.1470";
    public static final String MODEL_TYPE = "RBS_NODE_MODEL_U";
    private static final int BOAM_DATA_REV = 56213900;
    private NodeBFunctionMoFactory nodeBFunctionMoFactory;
    private RbsSynchronizationMoFactory rbsSynchronizationMoFactory;
    private CommContextsMoFactory commContextsMoFactory;
    private ConnectionFieldMoFactory connectionFieldMoFactory;
    private PredefRbsScannerGpehMoFactory predefRbsScannerGpehMoFactory;
    private SystemConstantsMoFactory systemConstantsMoFactory;
    private RbsConfigurationMoFactory rbsConfigurationMoFactory;

    public void init() {
        MessageLog.info(SELF, "init()");
        UpgradeManager.instance();
        RoRoc.instance();
        BoamMain.initProxies();
        MessageLog.info(SELF, "Proxies initiated");
        this.initFactories();
        RBScannerFactory.instance().moMoppletInit();
        MessageLog.info(SELF, "Factories initiated");
    }

    public void start() {
        MessageLog.info(SELF, "start()");
        this.createMOs();
        BoamMain.startSubscriptionObserver();
        this.startAiHandler();
        this.startGeoLocationCheckHandler();
        this.tryToInformOss();
        MessageLog.info(SELF, "Proxies subscribed for RO-services in OseNameServer");
        MessageLog.info(SELF, "Application Mub server started");
    }

    public static int getBoamDataRev() {
        return 56213900;
    }

    private static void initProxies() {
        ChcNodeBFunctionProxy.instance();
        ScCellProxy.instance();
        NcNbapProxy.instance();
        NcNphL3SupMgrProxy.instance();
        NcGpehScannerProxy.instance();
        ChcCommContextsProxy.instance();
        NcOverloadProtProxy.instance();
        NcRestartServiceProxy.instance();
        ScCellCarrierProxy.instance();
        NcControlLinkProxy.instance();
        ChcPccpchProxy.instance();
        ChcSccpchProxy.instance();
        ChcPrachProxy.instance();
        ScRfAccessProxy.instance();
        ScRfAccessCarrierProxy.instance();
        EcTimingProxy.instance();
        ChcRlsProxy.instance();
        ChcIubdsProxy.instance();
        EcPowerDistributeProxy.instance();
        EqcAuxPiuProxy.instance();
        EqcAntennaBranchProxy.instance();
        EqcBbifProxy.instance();
        ChcBbpProxy.instance();
        EqcBdhIndProxy.instance();
        EqcRrhIndProxy.instance();
        EqcCableProxy.instance();
        EqcDeviceGroupProxy.instance();
        EqcDeviceSetProxy.instance();
        EqcDeviceProxy.instance();
        EqcExtTmaProxy.instance();
        EqcHsdpaIubProxy.instance();
        EqcPmHelperProxy.instance();
        EqcProgramProxy.instance();
        EqcRiuProxy.instance();
        EqcSectorProxy.instance();
        EqcSectorAntennaProxy.instance();
        EqcSlotProxy.instance();
        EqcSubrackProxy.instance();
        EqcRnProxy.instance();
        EcUlsaProxy.instance();
        EcPowerProxy.instance();
        ChcHsdpaProxy.instance();
        ChcHsdpaCellServiceProxy.instance();
        NcSystemConstantsProxy.instance();
        ChcEulProxy.instance();
        BatteryEqcProxy.instance();
        EcNodeBFunctionProxy.instance();
        ChcAvcIndProxy.instance();
        SccAvcIndProxy.instance();
        EcAuxPiuAvcIndProxy.instance();
        ChcHsdpaIubProxy.instance();
        NcBsctProxy.instance();
    }

    private void initFactories() {
        this.nodeBFunctionMoFactory = NodeBFunctionMoFactory.instance();
        this.rbsSynchronizationMoFactory = RbsSynchronizationMoFactory.instance();
        this.commContextsMoFactory = CommContextsMoFactory.instance();
        this.connectionFieldMoFactory = ConnectionFieldMoFactory.instance();
        this.predefRbsScannerGpehMoFactory = PredefRbsScannerGpehMoFactory.instance();
        this.systemConstantsMoFactory = SystemConstantsMoFactory.instance();
        this.rbsConfigurationMoFactory = RbsConfigurationMoFactory.instance();
        NbapCommonMoFactory.instance();
        new BoamGenericMoFactory(NbapDedicatedMoImpl.class, "NbapDedicated");
        RbsLocalCellMoFactory.instance();
        CarrierMoFactory.instance();
        new BoamGenericMoFactory(SectorMoImpl.class, "Sector");
        new BoamGenericMoFactory(SectorAntennaMoImpl.class, "SectorAntenna");
        IubMoFactory.instance();
        IubDataStreamsMoFactory.instance();
        RadioLinksMoFactory.instance();
        RadioLinksCellMoFactory.instance();
        new BoamGenericMoFactory(PowerSupplySystemMoImpl.class, "PowerSupplySystem");
        new BoamGenericMoFactory(PowerDistrSystemMoImpl.class, "PowerDistrSystem");
        PrachMoFactory.instance();
        PccpchMoFactory.instance();
        SccpchMoFactory.instance();
        AichMoFactory.instance();
        new BoamGenericMoFactory(AccuMoImpl.class, "Accu");
        new BoamGenericMoFactory(BfuMoImpl.class, "Bfu");
        new BoamGenericMoFactory(CluMoImpl.class, "Clu");
        new BoamGenericMoFactory(PsuMoImpl.class, "Psu");
        DeviceGroupMoFactory.instance(49569);
        DeviceGroupMoFactory.instance(49570);
        DeviceGroupMoFactory.instance(49571);
        DeviceGroupMoFactory.instance(49572);
        DeviceGroupMoFactory.instance(49573);
        DeviceGroupMoFactory.instance(49574);
        DeviceGroupMoFactory.instance(49575);
        DeviceGroupMoFactory.instance(49576);
        DeviceGroupMoFactory.instance(49577);
        new BoamGenericMoFactory(DeviceGroupMoImpl.class, "DeviceGroup");
        TimDeviceSetMoFactory.instance();
        DeviceSetMoFactory.instance(49754);
        DeviceSetMoFactory.instance(49755);
        DeviceSetMoFactory.instance(49756);
        DeviceSetMoFactory.instance(49757);
        DeviceSetMoFactory.instance(49759);
        DeviceSetMoFactory.instance(49758);
        DeviceSetMoFactory.instance(49775);
        DeviceSetMoFactory.instance(49777);
        DeviceSetMoFactory.instance(49776);
        DeviceMoFactory.instance(1);
        DeviceMoFactory.instance(3);
        DeviceMoFactory.instance(4);
        DeviceMoFactory.instance(5);
        DeviceMoFactory.instance(7);
        new BoamGenericMoFactory(AuxPlugInUnitMoImpl.class, "AuxPlugInUnit");
        AuxDeviceGroupMoFactory.instance(49553);
        AuxDeviceGroupMoFactory.instance(49554);
        AuxDeviceGroupMoFactory.instance(49555);
        AuxDeviceGroupMoFactory.instance(49556);
        AuxDeviceGroupMoFactory.instance(800004);
        AuxDeviceGroupMoFactory.instance(49558);
        AuxDeviceGroupMoFactory.instance(49559);
        AuxDeviceGroupMoFactory.instance(49560);
        AuxDeviceGroupMoFactory.instance(49561);
        AuxDeviceGroupMoFactory.instance(49562);
        AuxDeviceGroupMoFactory.instance(49564);
        AuxDeviceGroupMoFactory.instance(49563);
        AuxDeviceGroupMoFactory.instance(49567);
        AuxDeviceGroupMoFactory.instance(49568);
        AuxDeviceGroupMoFactory.instance(49565);
        AuxDeviceGroupMoFactory.instance(49566);
        AuxDeviceSetMoFactory.instance(49760);
        AuxDeviceSetMoFactory.instance(49762);
        AuxDeviceSetMoFactory.instance(49765);
        AuxDeviceSetMoFactory.instance(49761);
        AuxDeviceSetMoFactory.instance(49766);
        AuxDeviceSetMoFactory.instance(49767);
        AuxDeviceSetMoFactory.instance(49768);
        AuxDeviceSetMoFactory.instance(49769);
        AuxDeviceSetMoFactory.instance(49763);
        AuxDeviceSetMoFactory.instance(49764);
        AuxDeviceMoFactory.instance(8);
        AuxDeviceMoFactory.instance(10);
        AuxDeviceMoFactory.instance(13);
        AuxDeviceMoFactory.instance(9);
        AuxDeviceMoFactory.instance(14);
        AuxDeviceMoFactory.instance(15);
        AuxDeviceMoFactory.instance(16);
        AuxDeviceMoFactory.instance(17);
        AuxDeviceMoFactory.instance(11);
        AuxDeviceMoFactory.instance(12);
        XpProgramMoFactory.instance();
        new BoamGenericMoFactory(DpProgramMoImpl.class, "DpProgram");
        new BoamGenericMoFactory(RetProfileMoImpl.class, "RetProfile");
        RbsSlotMoFactory.instance();
        AntennaBranchMoFactory.instance();
        MessageLog.trace(1, SELF, "AntennaBranchMoFactory ready");
        new BoamGenericMoFactory(ExternalTmaMoImpl.class, "ExternalTma");
        new BoamGenericMoFactory(BbifBoardMoImpl.class, "BbifBoard");
        DownlinkBaseBandPoolMoFactory.instance();
        UplinkBaseBandPoolMoFactory.instance();
        BoamSubrackMoFactory.instance(1);
        BoamSubrackMoFactory.instance(2);
        BoamSubrackMoFactory.instance(3);
        BoamSubrackMoFactory.instance(800005);
        BoamSubrackMoFactory.instance(7);
        BoamSubrackMoFactory.instance(8);
        new BoamGenericMoFactory(BatteryMoImpl.class, "Battery");
        RbsCableMoFactory.instance(50160);
        RbsCableMoFactory.instance(50164);
        RbsCableMoFactory.instance(50163);
        new BoamGenericMoFactory(TrxRfCableMoImpl.class, "TrxRfCable");
        new BoamGenericMoFactory(AntFeederCableMoImpl.class, "AntFeederCable");
        new BoamGenericMoFactory(HiPowTxCableMoImpl.class, "HiPowTxCable");
        new BoamGenericMoFactory(LoPowTxCableMoImpl.class, "LoPowTxCable");
        RfCableMoFactory.instance();
        RbsCableMoFactory.instance(50159);
        MessageLog.trace(1, SELF, "RbsCableMoFactory for IntraCabTiming cable ready");
        RbsCableMoFactory.instance(50158);
        MessageLog.trace(1, SELF, "RbsCableMoFactory for InterSubTiming cable ready");
        new BoamGenericMoFactory(IntJumperCableMoImpl.class, "IntJumperCable");
        OptoCommCableMoFactory.instance();
        DigitalCableMoFactory.instance();
        new BoamGenericMoFactory(RdiCableMoImpl.class, "RdiCable");
        HsDschResourcesMoFactory.instance();
        EDchResourcesMoFactory.instance();
        new BoamGenericMoFactory(RdbtAal5TpVccTpMoImpl.class, "RdbtAal5TpVccTp");
        new BoamGenericMoFactory(RdbtTestPortMoImpl.class, "RdbtTestPort");
        new BoamGenericMoFactory(RdbtUdpTpMoImpl.class, "RdbtUdpTp");
        new BoamGenericMoFactory(ExternalAntennaMoImpl.class, "ExternalAntenna");
        new BoamGenericMoFactory(RiuMoImpl.class, "Riu");
        UlSpectrumAnalyzerMoFactory.instance();
        RbsFeatureMoFactory.instance();
    }

    private void createMOs() {
        try {
            ManagedObject rootMo = BoamMain.getRequiredMo("ManagedElement", 0);
            ManagedObject equipmentMo = BoamMain.getRequiredMo("Equipment", 1);
            Control tx = TransactionServiceImpl.instance().getTransactionFactory().create(5000);
            Coordinator txCoordinator = tx.getCoordinator();
            Terminator txTerminator = tx.getTerminator();
            this.createSystemMos(rootMo, txCoordinator);
            this.createConnectionFieldMo(equipmentMo, txCoordinator);
            this.createPredefRbsScannerGpehMo(equipmentMo, txCoordinator);
            BoamMain.setMimRevision(txCoordinator);
            ManagedObject nodeBFunctionMo = BoamMain.getRequiredMo("NodeBFunction", 1);
            this.createSysConstMo(nodeBFunctionMo, txCoordinator);
            this.createRbsConfigurationMo(nodeBFunctionMo, txCoordinator);
            BoamMain.setBoamDataRev(nodeBFunctionMo, txCoordinator);
            txTerminator.commit();
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "Unrecoverable ERROR when starting BOAM", e);
        }
        catch (InactiveTransactionException e) {
            MessageLog.traceError(SELF, "Unrecoverable ERROR when starting BOAM", e);
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(SELF, "Unrecoverable ERROR when starting BOAM", e);
        }
        MessageLog.info(SELF, "System created MAOs ready");
    }

    private void createSystemMos(ManagedObject parent, Coordinator txCoordinator) throws MoAccessException {
        MessageLog.trace(1, SELF, "createSystemMos");
        try {
            ManagedObject nbfMo = this.nodeBFunctionMoFactory.createMo(parent, new NodeBFunctionMoAttrList(), "1", null, txCoordinator);
            this.rbsSynchronizationMoFactory.createMo(nbfMo, RbsSynchronizationAttrList.createAttrList(), "1", null, txCoordinator);
            this.commContextsMoFactory.createMo(nbfMo, null, "1", null, txCoordinator);
        }
        catch (MoCanNotBeCreatedException e) {
            MessageLog.trace(1, SELF, "NodeBFunctionMo,RbsSynchronizationMo and CommContextsMo are recovered.");
        }
    }

    private void createConnectionFieldMo(ManagedObject parent, Coordinator txCoordinator) throws MoAccessException {
        try {
            this.connectionFieldMoFactory.createMo(parent, ConnectionFieldAttrList.createAttrList(), "1", null, txCoordinator);
        }
        catch (MoCanNotBeCreatedException e) {
            MessageLog.trace(1, SELF, "ConnectionFieldMo is recovered.");
        }
    }

    private void createPredefRbsScannerGpehMo(ManagedObject parent, Coordinator txCoordinator) throws MoAccessException {
        try {
            this.predefRbsScannerGpehMoFactory.createMo(parent, new AttrListImpl(), "1", null, txCoordinator);
        }
        catch (MoCanNotBeCreatedException e) {
            MessageLog.trace(1, SELF, "PredefRbsScannerGpehMo cannot be created.");
        }
    }

    private static void setMimRevision(Coordinator context) throws MoAccessException {
        Mib mibRef = MibMgr.instance().getMib();
        String oldVersion = mibRef.getModelVersion();
        String oldType = mibRef.getModelType();
        MessageLog.info(SELF, "Old ModelType/ModelVersion was: " + oldType + "/" + oldVersion);
        MessageLog.info(SELF, "New ModelType/ModelVersion is set to: RBS_NODE_MODEL_U/4.1470");
        mibRef.setModelType(MODEL_TYPE, context);
        mibRef.setModelVersion(MODEL_VERSION, context);
    }

    private void createSysConstMo(ManagedObject parent, Coordinator txCoordinator) throws MoAccessException {
        try {
            this.systemConstantsMoFactory.createMo(parent, new AttrListImpl(), "1", null, txCoordinator);
        }
        catch (MoCanNotBeCreatedException e) {
            MessageLog.trace(1, SELF, "systemConstantsMo are recovered.");
        }
    }

    private void createRbsConfigurationMo(ManagedObject parent, Coordinator txCoordinator) throws MoAccessException {
        try {
            MoIterator moIter = BoamHelper.findMOs("RbsConfiguration");
            if (!moIter.hasMoreElements()) {
                this.rbsConfigurationMoFactory.createMyMo(parent, "1", txCoordinator);
            } else {
                RbsConfigurationMoImpl rbsConfiguration = (RbsConfigurationMoImpl)moIter.nextMo();
                rbsConfiguration.registerNodeIdAttributes(txCoordinator);
            }
        }
        catch (MoCanNotBeCreatedException e) {
            MessageLog.trace(1, SELF, "RbsConfigurationMo are recovered.");
        }
    }

    private static void setBoamDataRev(ManagedObject mo, Coordinator context) throws MoAccessException {
        ((NodeBFunctionMoImpl)mo).updateBoamDataRev(56213900, context);
        MessageLog.info(SELF, "Boam data rev. is updated: 56213900");
    }

    private static void startSubscriptionObserver() {
        try {
            MessageLog.traceEnter(SELF, "startSubscriptionObserver()");
            ScCellProxy.instance().addServiceObserver();
            NcNbapProxy.instance().addServiceObserver();
            NcNphL3SupMgrProxy.instance().addServiceObserver();
            ChcCommContextsProxy.instance().addServiceObserver();
            NcOverloadProtProxy.instance().addServiceObserver();
            NcGpehScannerProxy.instance().addServiceObserver();
            NcRestartServiceProxy.instance().addServiceObserver();
            ScCellCarrierProxy.instance().addServiceObserver();
            NcControlLinkProxy.instance().addServiceObserver();
            ChcPccpchProxy.instance().addServiceObserver();
            ChcSccpchProxy.instance().addServiceObserver();
            ChcPrachProxy.instance().addServiceObserver();
            ScRfAccessProxy.instance().addServiceObserver();
            ScRfAccessCarrierProxy.instance().addServiceObserver();
            EcTimingProxy.instance().addServiceObserver();
            ChcRlsProxy.instance().addServiceObserver();
            ChcIubdsProxy.instance().addServiceObserver();
            EcPowerProxy.instance().addServiceObserver();
            EqcAuxPiuProxy.instance().addServiceObserver();
            EqcAntennaBranchProxy.instance().addServiceObserver();
            EqcBbifProxy.instance().addServiceObserver();
            ChcBbpProxy.instance().addServiceObserver();
            EqcBdhIndProxy.instance().addServiceObserver();
            EqcRrhIndProxy.instance().addServiceObserver();
            EqcCableProxy.instance().addServiceObserver();
            EqcDeviceGroupProxy.instance().addServiceObserver();
            EqcDeviceSetProxy.instance().addServiceObserver();
            EqcDeviceProxy.instance().addServiceObserver();
            EqcExtTmaProxy.instance().addServiceObserver();
            EqcHsdpaIubProxy.instance().addServiceObserver();
            EcPowerDistributeProxy.instance().addServiceObserver();
            EqcPmHelperProxy.instance().addServiceObserver();
            EqcRiuProxy.instance().addServiceObserver();
            EqcSectorProxy.instance().addServiceObserver();
            EqcSectorAntennaProxy.instance().addServiceObserver();
            EqcSlotProxy.instance().addServiceObserver();
            EqcSubrackProxy.instance().addServiceObserver();
            EqcProgramProxy.instance().addServiceObserver();
            EqcRnProxy.instance().addServiceObserver();
            EcUlsaProxy.instance().addServiceObserver();
            ChcHsdpaProxy.instance().addServiceObserver();
            ChcHsdpaCellServiceProxy.instance().addServiceObserver();
            NcSystemConstantsProxy.instance().addServiceObserver();
            ChcEulProxy.instance().addServiceObserver();
            BatteryEqcProxy.instance().addServiceObserver();
            ChcNodeBFunctionProxy.instance().addServiceObserver();
            EcNodeBFunctionProxy.instance().addServiceObserver();
            ChcMeasurementProxy.instance().addServiceObserver();
            EcAuxPiuAvcIndProxy.instance().addServiceObserver();
            ChcHsdpaIubProxy.instance().addServiceObserver();
            NcBsctProxy.instance().addServiceObserver();
            MessageLog.trace(8, BoamTopologyAndAVCSubscriber.class, "register TopologyAndAVCSubscriber!");
            BoamTopologyAndAVCSubscriber subscriber = BoamTopologyAndAVCSubscriber.instance();
            SubscriptionFilter filter = new SubscriptionFilter();
            filter.setMoTypes(new String[]{"PlugInUnit", "IpHostLink"});
            CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr().register((TopologyAndAVCSubscriber)subscriber, filter);
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            MessageLog.traceError(SELF, "InterruptedException");
        }
    }

    private static ManagedObject getRequiredMo(String moTypeName, int depth) throws MoNotFoundException {
        MoIterator moIter = BoamHelper.findMOs(moTypeName, depth);
        if (!moIter.hasMoreElements()) {
            throw new MoNotFoundException(moTypeName + "=...");
        }
        return moIter.nextMo();
    }

    public static void _reset_onlyForTest(boolean all) {
        ScCellProxy.instance()._reset_onlyForTest(all);
        NcNbapProxy.instance()._reset_onlyForTest(all);
        NcNphL3SupMgrProxy.instance()._reset_onlyForTest(all);
        NcGpehScannerProxy.instance()._reset_onlyForTest(all);
        ChcCommContextsProxy.instance()._reset_onlyForTest(all);
        NcOverloadProtProxy.instance()._reset_onlyForTest(all);
        NcRestartServiceProxy.instance()._reset_onlyForTest(all);
        ScCellCarrierProxy.instance()._reset_onlyForTest(all);
        NcControlLinkProxy.instance()._reset_onlyForTest(all);
        ChcPccpchProxy.instance()._reset_onlyForTest(all);
        ChcSccpchProxy.instance()._reset_onlyForTest(all);
        ChcPrachProxy.instance()._reset_onlyForTest(all);
        ScRfAccessProxy.instance()._reset_onlyForTest(all);
        ScRfAccessCarrierProxy.instance()._reset_onlyForTest(all);
        EcTimingProxy.instance()._reset_onlyForTest(all);
        ChcRlsProxy.instance()._reset_onlyForTest(all);
        ChcIubdsProxy.instance()._reset_onlyForTest(all);
        EcPowerDistributeProxy.instance()._reset_onlyForTest(all);
        EqcAuxPiuProxy.instance()._reset_onlyForTest(all);
        EqcAntennaBranchProxy.instance()._reset_onlyForTest(all);
        EqcBbifProxy.instance()._reset_onlyForTest(all);
        ChcBbpProxy.instance()._reset_onlyForTest(all);
        EqcBdhIndProxy.instance()._reset_onlyForTest(all);
        EqcRrhIndProxy.instance()._reset_onlyForTest(all);
        EqcCableProxy.instance()._reset_onlyForTest(all);
        EqcDeviceGroupProxy.instance()._reset_onlyForTest(all);
        EqcDeviceSetProxy.instance()._reset_onlyForTest(all);
        EqcDeviceProxy.instance()._reset_onlyForTest(all);
        EqcExtTmaProxy.instance()._reset_onlyForTest(all);
        EqcHsdpaIubProxy.instance()._reset_onlyForTest(all);
        EqcPmHelperProxy.instance()._reset_onlyForTest(all);
        EqcProgramProxy.instance()._reset_onlyForTest(all);
        EqcRiuProxy.instance()._reset_onlyForTest(all);
        EqcSectorProxy.instance()._reset_onlyForTest(all);
        EqcSectorAntennaProxy.instance()._reset_onlyForTest(all);
        EqcSlotProxy.instance()._reset_onlyForTest(all);
        EqcSubrackProxy.instance()._reset_onlyForTest(all);
        EqcRnProxy.instance()._reset_onlyForTest(all);
        EcUlsaProxy.instance()._reset_onlyForTest(all);
        EcPowerProxy.instance()._reset_onlyForTest(all);
        ChcHsdpaProxy.instance()._reset_onlyForTest(all);
        ChcHsdpaCellServiceProxy.instance()._reset_onlyForTest(all);
        NcSystemConstantsProxy.instance()._reset_onlyForTest(all);
        ChcEulProxy.instance()._reset_onlyForTest(all);
        BatteryEqcProxy.instance()._reset_onlyForTest(all);
        ChcNodeBFunctionProxy.instance()._reset_onlyForTest(all);
        EcNodeBFunctionProxy.instance()._reset_onlyForTest(all);
        ChcMeasurementProxy.instance()._reset_onlyForTest(all);
        ChcHsdpaIubProxy.instance()._reset_onlyForTest(all);
        NcBsctProxy.instance()._reset_onlyForTest(all);
    }

    public void _createSystemMos_4_test_only() {
        this.createMOs();
    }

    private void startAiHandler() {
        try {
            RbsConfigurationMoImpl rbsConfig = (RbsConfigurationMoImpl)BoamMain.getRequiredMo("RbsConfiguration", 2);
            rbsConfig.startAiHandler();
        }
        catch (MoNotFoundException e) {
            MessageLog.traceError(this.getClass(), "Could not get RbsConfiguration MO instance, AI handler will not be started", e);
        }
    }

    private void startGeoLocationCheckHandler() {
        try {
            RbsConfigurationMoImpl rbsConfig = (RbsConfigurationMoImpl)BoamMain.getRequiredMo("RbsConfiguration", 2);
            if (rbsConfig.getIntegrationType() == 0) {
                rbsConfig.startGeoLocationCheckHandler(1);
            }
        }
        catch (MoNotFoundException e) {
            MessageLog.traceError(this.getClass(), "Could not get RbsConfiguration MO instance, Geo location check handler will not be started", e);
        }
    }

    private void tryToInformOss() {
        InformOssTask informOssTask = new InformOssTask();
        new Thread((Runnable)informOssTask, "Oss_Informing_Thread").start();
    }

    private static class InformOssTask
    implements Runnable {
        private InformOssTask() {
        }

        public void run() {
            try {
                RbsConfigurationMoImpl rbsConfig = (RbsConfigurationMoImpl)BoamMain.getRequiredMo("RbsConfiguration", 2);
                rbsConfig.informOssOnRestart(1, null);
            }
            catch (MoNotFoundException e) {
                MessageLog.traceEnter(this.getClass(), "Could not get RbsConfiguration MO instance, OSS will not be informed");
            }
        }
    }
}

