/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;

public class IpHostLinkConfigure {
    public final int ENUMVAL_HOST_MODE = 0;
    public final int ENUMVAL_ROUTER_MODE = 1;
    private Control control;
    private Coordinator context;
    private ManagedObject ipInterface = null;
    private static final HashMap map = new HashMap();
    private static final String MAX_KEY = "255";
    private static final int MAX_VALUE = 8;
    private static final String KEY_SEVEN = "254";
    private static final int VALUE_SEVEN = 7;
    private static final String KEY_SIX = "252";
    private static final int VALUE_SIX = 6;
    private static final String KEY_FIVE = "248";
    private static final int VALUE_FIVE = 5;
    private static final String KEY_FOUR = "240";
    private static final int VALUE_FOUR = 4;
    private static final String KEY_THREE = "224";
    private static final int VALUE_THREE = 3;
    private static final String KEY_TWO = "192";
    private static final int VALUE_TWO = 2;
    private static final String KEY_ONE = "128";
    private static final int VALUE_ONE = 1;
    private static final String MIN_KEY = "0";
    private static final int MIN_VALUE = 0;

    public void startConfigureIpHostLinkMo(String ipAddress, String defaultRouter, String subnetMask) throws TransactionRolledBackException, InactiveTransactionException, CreateMoException {
        AiMessageLog.traceEnter(this.getClass(), "Will configure IpHostLinkMo !");
        this.startTransaction();
        try {
            this.createGigaBitEthernetMo();
            this.cerateIpInterfaceMo(ipAddress, defaultRouter, subnetMask);
            this.cerateIpMo();
            this.createIpHostLink(ipAddress);
            this.endTransaction();
        }
        catch (MoAccessException e) {
            this.control.getTerminator().rollback();
            throw new CreateMoException("create ipHostLinkMo Exception!");
        }
    }

    private void startTransaction() throws TransactionRolledBackException {
        this.control = TransactionServiceImpl.instance().getTransactionFactory().create(0);
        this.context = this.control.getCoordinator();
    }

    private void endTransaction() throws TransactionRolledBackException, InactiveTransactionException {
        this.control.getTerminator().commit();
        this.context = null;
    }

    private void createGigaBitEthernetMo() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        ManagedObject parentMo = BoamHelper.getFirstMatchingMo("ExchangeTerminalIp");
        AttrListImpl attributes = new AttrListImpl();
        attributes.insert("portNo", new Integer(1));
        this.myMoFactoryCreateMo("GigaBitEthernet", parentMo, attributes, "GigaBitEthernet");
    }

    private void cerateIpInterfaceMo(String ownIpAddressActive, String defaultRouter, String subnetMask) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        Object binarySum = this.convertToMomValue(subnetMask);
        ManagedObject parentMo = BoamHelper.getFirstMatchingMo("GigaBitEthernet");
        AttrListImpl attributes = new AttrListImpl();
        attributes.insert("ownIpAddressActive", ownIpAddressActive);
        attributes.insert("defaultRouter0", defaultRouter);
        attributes.insert("networkPrefixLength", new Integer(String.valueOf(binarySum)));
        this.myMoFactoryCreateMo("IpInterface", parentMo, attributes, "IpInterface");
    }

    private void cerateIpMo() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        ManagedObject parentMo = BoamHelper.getFirstMatchingMo("IpOam");
        AttrListImpl attributes = new AttrListImpl();
        attributes.insert("workingMode", new Integer(0));
        this.myMoFactoryCreateMo("Ip", parentMo, attributes, "Ip");
    }

    private void createIpHostLink(String ipAddress) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        ManagedObject parentMo = BoamHelper.getFirstMatchingMo("Ip");
        this.ipInterface = BoamHelper.getFirstMatchingMo("IpInterface");
        AttrListImpl attributes = new AttrListImpl();
        attributes.insert("ipAddress", ipAddress);
        attributes.insert("ipInterfaceMoRef", this.ipInterface);
        this.myMoFactoryCreateMo("IpHostLink", parentMo, attributes, "IpHostLink");
    }

    private ManagedObject myMoFactoryCreateMo(String moTypeName, ManagedObject parent, AttrListImpl attributes, String moName) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        ManagedObject requireMo = BoamHelper.getFirstMatchingMo(moTypeName);
        if (null != requireMo) {
            AiMessageLog.traceEnter(this.getClass(), moTypeName + " is already exists!");
            return requireMo;
        }
        MoFactory moFactory = MoFactoryMgr.instance().lookup(moTypeName);
        ManagedObject createRequireMo = null;
        createRequireMo = moFactory.createMo(parent, (AttrList)attributes, moName, null, this.context);
        AiMessageLog.traceEnter(this.getClass(), "Create " + moTypeName);
        return createRequireMo;
    }

    public void deleteMo() throws MoHasChildrenException, MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        ArrayList<String> listMo = new ArrayList<String>();
        listMo.add("GigaBitEthernet");
        listMo.add("IpInterface");
        listMo.add("Ip");
        listMo.add("IpHostLink");
        this.startTransaction();
        for (int i = listMo.size() - 1; i >= 0; --i) {
            ManagedObject mo = BoamHelper.getFirstMatchingMo(listMo.get(i).toString());
            if (null != mo) {
                mo.delete(this.context);
                AiMessageLog.traceEnter(this.getClass(), listMo.get(i) + " is deleted");
                continue;
            }
            AiMessageLog.traceEnter(this.getClass(), listMo.get(i) + " does not exist");
        }
        this.endTransaction();
    }

    public Object convertToMomValue(String parameterValue) {
        int prefixValue = 0;
        if (null == parameterValue) {
            return new Integer(prefixValue);
        }
        String subnet = parameterValue;
        StringTokenizer tokens = new StringTokenizer(subnet, ".", true);
        String subnetPart = tokens.nextToken();
        prefixValue = IpHostLinkConfigure.getPrefixValue(subnetPart);
        tokens.nextToken();
        if (subnetPart.equals(MAX_KEY)) {
            subnetPart = tokens.nextToken();
            prefixValue += IpHostLinkConfigure.getPrefixValue(subnetPart);
            tokens.nextToken();
            if (subnetPart.equals(MAX_KEY)) {
                subnetPart = tokens.nextToken();
                prefixValue += IpHostLinkConfigure.getPrefixValue(subnetPart);
                tokens.nextToken();
                if (subnetPart.equals(MAX_KEY)) {
                    subnetPart = tokens.nextToken();
                    prefixValue += IpHostLinkConfigure.getPrefixValue(subnetPart);
                }
            }
        }
        return new Integer(prefixValue);
    }

    public static int getPrefixValue(String subnetPart) {
        map.put(MAX_KEY, new Integer(8));
        map.put(KEY_SEVEN, new Integer(7));
        map.put(KEY_SIX, new Integer(6));
        map.put(KEY_FIVE, new Integer(5));
        map.put(KEY_FOUR, new Integer(4));
        map.put(KEY_THREE, new Integer(3));
        map.put(KEY_TWO, new Integer(2));
        map.put(KEY_ONE, new Integer(1));
        map.put(MIN_KEY, new Integer(0));
        if (!map.containsKey(subnetPart)) {
            return 0;
        }
        return Integer.parseInt(map.get(subnetPart).toString());
    }

    public static class CreateMoException
    extends Exception {
        private static final long serialVersionUID = 843304382782551590L;

        public CreateMoException(String message) {
            super(message);
        }
    }
}

