/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetOutParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.OutDeviceMo;

public class OutDeviceMoImpl
extends AuxDeviceMoImpl
implements OutDeviceMo {
    public static final int MO_DATA_REVISION = 1030301;

    public OutDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 16, deviceFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "OutDevice Normal constructor");
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.bcmStoreAndRegisterStringAttribute("equipmentName", "");
        this.myData.setRevision(1030301);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(16, context);
    }

    public OutDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "OutDevice: Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(16, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public int getAdministrativeState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAdministrativeState()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int result2 = 0;
        try {
            EqcGetOutParametersRspS cfmSig = eqcDeviceProxy.getOutParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
            result2 = cfmSig.admState;
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "getadministrativeState() NOT OK");
            throw e;
        }
        return result2;
    }

    public void setAdministrativeState(int newAdminState, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAdministrativeState()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if ((newAdminState & 0xFFFFFFFE) != 0) {
            throw new ValueOutOfRangeException("administrativeState", this.getType());
        }
        try {
            eqcDeviceProxy.setDeviceAdmState(this.getTxIdTransactional(context), 0L, this.getAuxDeviceFroId(context), newAdminState);
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "setAdministrativeState Failed");
            throw e;
        }
        this.sendAVC("administrativeState", newAdminState, context);
    }

    public boolean getNormallyOpen(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNormallyOpen()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        boolean result2 = false;
        try {
            EqcGetOutParametersRspS cfmSig = eqcDeviceProxy.getOutParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
            if (cfmSig.normallyOpen != 0) {
                result2 = true;
            }
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "EqcGetAlmParametersRspS NOT OK");
            throw e;
        }
        return result2;
    }

    public void setNormallyOpen(boolean open, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNormallyOpen()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int normallyOpen = 0;
        if (open) {
            normallyOpen = 1;
        }
        if ((normallyOpen & 0xFFFFFFFE) != 0) {
            throw new ValueOutOfRangeException("normallyOpen", this.getType());
        }
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " NormallyOpen can not be set over Mub, because OutDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        eqcDeviceProxy.setDeviceNormallyOpen(this.getTxIdTransactional(context), 0L, this.getAuxDeviceFroId(context), normallyOpen);
        this.sendAVC("normallyOpen", open, context);
    }

    public int getOutDeviceStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOutDeviceStatus()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int result2 = 0;
        try {
            EqcGetOutParametersRspS cfmSig = eqcDeviceProxy.getOutParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDeviceFroId(context));
            result2 = cfmSig.deviceStatus;
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "getadministrativeState() NOT OK");
            throw e;
        }
        return result2;
    }

    public void setOutDeviceStatus(int newDeviceStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setOutDeviceStatus()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if ((newDeviceStatus & 0xFFFFFFFE) != 0) {
            throw new ValueOutOfRangeException("outDeviceStatus", this.getType());
        }
        try {
            eqcDeviceProxy.setDeviceStatus(this.getTxIdTransactional(context), 0L, this.getAuxDeviceFroId(context), newDeviceStatus);
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "setOutDeviceStatus() Failed");
            throw e;
        }
        this.sendAVC("outDeviceStatus", newDeviceStatus, context);
    }

    public String getEquipmentName(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEquipmentName() ");
        return this.bcmGetStringAttribute("equipmentName", context);
    }

    public void setEquipmentName(String equiName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setEquipmentName()");
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " EquipmentName can not be set over Mub, because OutDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        this.bcmSetStringAttribute("equipmentName", equiName, 0, 63, "OutDevice", context);
        this.sendAVC("equipmentName", equiName, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " UserLabel can not be set over Mub, because OutDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public void setAlarmStatus(int newStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int admState = this.getAdministrativeState(context);
        if (admState != 0) {
            String msg = " AlarmStatus can not be set over Mub, because OutDevice is unlocked! ";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        super.setAlarmStatus(newStatus, context);
    }

    public String getType() {
        return "OutDevice";
    }

    public String getOutDeviceId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOutDeviceId()");
        return super.getIdentity(c);
    }
}

