/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.EScDeviceSetMo;

public class EScDeviceSetMoImpl
extends DeviceSetMoImpl
implements EScDeviceSetMo {
    public static final int MO_DATA_REVISION = 4020001;

    public EScDeviceSetMoImpl(ManagedObject parent, String thisMoName, int devSetFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, devSetFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initAlarmStatus(0, context);
        this.myData.setRevision(4020001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(49777, context);
    }

    public EScDeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(49777, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public String getType() {
        return "EScDeviceSet";
    }

    public void reserve(ManagedObject aUser, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reserve()");
        MoData aData = this.getMyMoData();
        if (aUser == null) {
            MessageLog.trace(1, this.getClass(), "The reserver reference is null");
            throw new SoftwareErrorException();
        }
        aData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute transientReservers = this.getSequenceAttribute(aData, "transientReservers");
        ReferenceAttribute aRefAttr = this.checkReserver(aUser, transientReservers, context);
        if (aRefAttr != null) {
            transientReservers.addElement((Attribute)aRefAttr);
        }
    }

    public int[] getActiveRdbtMeasurements(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getActiveRdbtMeasurements()");
        return this.chcMeasurementProxy.getUPT(0, this.getFroId(c));
    }

    public void actionStartRdbtMeasurement(int measType, Coordinator c) throws MoAccessException, AlreadyActiveException, InternalErrorException {
        MessageLog.traceEnter(this.getClass(), "actionStartRdbtMeasurement()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        if (measType < 100 || measType > 104 && measType < 108 || measType > 110) {
            throw new ValueOutOfRangeException("measTypehas wrong value : " + measType, "EScDeviceSet");
        }
        this.chcMeasurementProxy.startUPT(0, measType, this.getFroId(c));
    }

    public void actionStopRdbtMeasurement(int measType, Coordinator c) throws MoAccessException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopRdbtMeasurement()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        if (measType < 100 || measType > 104 && measType < 108 || measType > 110) {
            throw new ValueOutOfRangeException("measTypehas wrong value : " + measType, "EScDeviceSet");
        }
        this.chcMeasurementProxy.stopUPT(0, measType, this.getFroId(c));
    }
}

