/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.bb;

import enea.ose.system.InSignal;
import java.util.Enumeration;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcBbpProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcBbpParamsT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcCreateUlbbpRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.InvalidReferenceException;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.UplinkBaseBandPoolMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsConst;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class UplinkBaseBandPoolMoImpl
extends BoamManagedObjectWithAlarms
implements UplinkBaseBandPoolMo {
    private static final int CLIENT_ID = 0;
    public static final int MO_DATA_REVISION = 5020000;
    private final MoScanner myScanner;
    private int thisFroId = 0;
    private MoEvents myMoEvents;
    protected ChcBbpProxy chcBbpProxy = ChcBbpProxy.instance();

    public UplinkBaseBandPoolMoImpl(ManagedObject parent, AttrList attributes, String identity, String checkedUserLabel, int alarmStatus, int checkedMdsWindLength, Coordinator context) throws MoAccessException {
        super(parent, "UplinkBaseBandPool", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initMoData(checkedUserLabel, attributes, context);
        this.initAlarmStatus(alarmStatus, context);
        EqcCreateUlbbpRspS rsp = this.chcBbpProxy.createUlbbp(this.getTxIdTransactional(context), 0L, Integer.parseInt(identity));
        this.thisFroId = (int)rsp.ulbbpFroId;
        IntegerAttribute tmpIntAttr = new IntegerAttribute("froId", false);
        tmpIntAttr.setValue(this.thisFroId);
        this.myData.registerPersistentAttr((Attribute)tmpIntAttr);
        this.setMdsWindLength(checkedMdsWindLength, context);
        this.myScanner = this.createMoScanner(false, context);
        this.addObservers(124, context);
    }

    public UplinkBaseBandPoolMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        this.thisFroId = this.getFroId(null);
        try {
            this.addObservers(124, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        this.myScanner = this.createMoScanner();
        MessageLog.trace(1, this.getClass(), "Recovered PM as well");
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
    }

    protected static void checkParent(ManagedObject parent, String moTypeName) throws IllegalParentException {
        if (!(parent instanceof SubrackMo)) {
            IllegalParentException e = new IllegalParentException(moTypeName);
            throw e;
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(UplinkBaseBandPoolMoImpl.class, "create()");
        MessageLog.trace(1, UplinkBaseBandPoolMoImpl.class, "Invalid Create attempt, this is a System Created MO");
        throw new OperationNotAllowedException();
    }

    public static synchronized ManagedObject createSystemMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(UplinkBaseBandPoolMoImpl.class, "createSystemMo()");
        UplinkBaseBandPoolMoImpl thisMo = null;
        UplinkBaseBandPoolMoImpl.checkTransaction(context);
        UplinkBaseBandPoolMoImpl.checkParent(parent, "UplinkBaseBandPool");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "UplinkBaseBandPool");
        int checkedAlarmStatus = UplinkBaseBandPoolMoImpl.checkAndGetAlarmStatus(attributes, 0, "UplinkBaseBandPool", context);
        ValidateAttributes.checkAndGetIntAttribute(attributes, "ulGraceTimeLeft", "optional", 0, NodeBFunctionMo.UL_GRACE_TIME_LEFT_MIN_VALUES, NodeBFunctionMo.UL_GRACE_TIME_LEFT_MAX_VALUES, "UplinkBaseBandPool");
        ValidateAttributes.checkAndGetBooleanAttribute(attributes, "ulLimitedByLicenseLevel", "optional", true, false, true, "UplinkBaseBandPool");
        int checkedMdsWindLength = ValidateAttributes.checkAndGetIntAttribute(attributes, "mdsWindLength", "optional", 160, UplinkBaseBandPoolMo.MDS_WIND_LENGTH_MIN_VALUES, UplinkBaseBandPoolMo.MDS_WIND_LENGTH_MAX_VALUES, "UplinkBaseBandPool");
        ValidateAttributes.checkOtherAttributes(attributes, "UplinkBaseBandPool");
        thisMo = new UplinkBaseBandPoolMoImpl(parent, attributes, identity, checkedUserLabel, checkedAlarmStatus, checkedMdsWindLength, context);
        return thisMo;
    }

    public void cleanAfterCommitDelete() {
        MessageLog.traceEnter(this.getClass(), "cleanAfterCommitDelete()");
    }

    private MoScanner createMoScanner(boolean recovery, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMoScanner()");
        int poolId = Integer.valueOf(this.getNamingAttributeValue());
        int[] addInfo = new int[]{0, poolId};
        return new MoScanner(this, this.chcBbpProxy, this.thisFroId, poolId, UplinkBaseBandPoolMoFactory.instance().getCounters(), addInfo, recovery, context);
    }

    private MoScanner createMoScanner() {
        try {
            return this.createMoScanner(true, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't setup Counters!!", e);
            return null;
        }
    }

    public int[] getScannerValue(String name) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        if (this.getBaseBandPoolState(null) == 0) {
            return PmsConst.getCounterDefaultArray(name);
        }
        return this.myScanner.getValue(name);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        MessageLog.trace(1, UplinkBaseBandPoolMoImpl.class, "Invalid Delete attempt, this is operation can only be performed by the System");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(ManagedObject caller, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.releasePool(caller, context);
        SequenceAttribute reservedBySeq = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        if (reservedBySeq.isEmpty()) {
            if (this.myScanner != null) {
                this.myScanner.delete(context);
            }
            this.chcBbpProxy.deleteUlbbp(this.getTxIdTransactional(context), 0L, this.thisFroId);
            this.removeObservers(context);
            this.myData.delete(context);
            super.delete(context);
            MessageLog.trace(1, this.getClass(), "UplinkBaseBandPool Mo is Deleted ");
        }
    }

    private static ReferenceAttribute reserverSearch(ManagedObject userId, Coordinator context, MoData data, SequenceAttribute reservedBy) throws MoAccessException {
        data.handleTransaction(context, MoData.READ_ACCESS);
        Enumeration enumList = reservedBy.elements();
        while (enumList.hasMoreElements()) {
            ReferenceAttribute element = (ReferenceAttribute)enumList.nextElement();
            if (!userId.equals(element.getValue(context))) continue;
            return element;
        }
        return null;
    }

    public void reservePool(ManagedObject caller, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reservePool() ");
        if (caller == null) {
            throw new InvalidReferenceException(this.myData.getMoTypeName(), null);
        }
        SequenceAttribute seq = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (UplinkBaseBandPoolMoImpl.reserverSearch(caller, context, this.myData, seq) == null) {
            ReferenceAttribute newRefElement = new ReferenceAttribute("", false);
            newRefElement.setValue(caller);
            seq.addElement((Attribute)newRefElement);
            ((Reservable)caller).reserve((ManagedObject)this, context);
        } else {
            MessageLog.traceError(this.getClass(), "reservePool(): userId (" + caller + ") already reserved by " + this.myData.getMoTypeName() + "/another MO.");
        }
    }

    public void releasePool(ManagedObject caller, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releasePool() ");
        if (caller == null) {
            throw new InvalidReferenceException(this.myData.getMoTypeName(), null);
        }
        SequenceAttribute reservedBySeq = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        ReferenceAttribute foundMo = UplinkBaseBandPoolMoImpl.reserverSearch(caller, context, this.myData, reservedBySeq);
        if (foundMo == null) {
            MessageLog.traceState(this.getClass(), "release(): userId (" + caller + ") is not reserver/has already released ");
        } else {
            reservedBySeq.removeElement((Attribute)foundMo);
            ((Reservable)caller).release((ManagedObject)this, context);
            foundMo.setValue(null);
        }
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute("froId");
        return attribute.getValue(context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public String getType() {
        return "UplinkBaseBandPool";
    }

    public String getUplinkBaseBandPoolId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUplinkBaseBandPoolId() ");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute("userLabel", context);
    }

    private void initMoData(String checkedUserLabel, AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), "UplinkBaseBandPool", true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        SequenceAttribute radioInterfaceBoardRefAttrList = new SequenceAttribute("radioInterfaceBoardRef", false);
        this.myData.registerPersistentAttr((Attribute)radioInterfaceBoardRefAttrList);
        this.myData.setRevision(5020000);
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "UplinkBaseBandPool", context);
        this.sendAVC("userLabel", value, context);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.chcBbpProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.chcBbpProxy, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }

    public int getUlGraceTimeLeft(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlGraceTimeLeft()<---");
        return NodeBFunctionMoImpl.getTheOneAndOnly() != null ? NodeBFunctionMoImpl.getTheOneAndOnly().getUlGraceTimeLeft(c) : 0;
    }

    public boolean getUlLimitedByLicenseLevel(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlLimitedByLicenseLevel()");
        return NodeBFunctionMoImpl.getTheOneAndOnly() != null ? NodeBFunctionMoImpl.getTheOneAndOnly().getUlLimitedByLicenseLevel(c) : false;
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
    }

    private ManagedObject[] getMoRefArray(SequenceAttribute MoRefAttrList, Coordinator context) throws MoAccessException {
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        Attribute[] attrList = MoRefAttrList.getValue(context);
        if (attrList == null) {
            MessageLog.trace(2, this.getClass(), "SequenceAttribute == null !?");
            return new ManagedObject[0];
        }
        int length = attrList.length;
        ManagedObject[] moRefArr = new ManagedObject[length];
        for (int i = 0; i < length; ++i) {
            moRefArr[i] = ((ReferenceAttribute)attrList[i]).getValue(context);
        }
        return moRefArr;
    }

    public ManagedObject[] getRadioInterfaceBoardRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRadioInterfaceBoardRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute radioInterfaceBoardRefAttrList = (SequenceAttribute)this.myData.getAttribute("radioInterfaceBoardRef");
        return this.getMoRefArray(radioInterfaceBoardRefAttrList, context);
    }

    public int getMdsWindLength(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMdsWindLength()");
        long transactionId = this.getTxIdNonTransactional(c);
        int bbpFroId = this.getFroId(c);
        ChcBbpParamsT params = this.chcBbpProxy.getBbpParam(transactionId, bbpFroId);
        return params.mdsWindowLength;
    }

    public void setMdsWindLength(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMdsWindLength()");
        ValidateAttributes.checkTransaction(c);
        ValidateAttributes.intValueRangeCheck("mdsWindLength", value, UplinkBaseBandPoolMo.MDS_WIND_LENGTH_MIN_VALUES, UplinkBaseBandPoolMo.MDS_WIND_LENGTH_MAX_VALUES, "UplinkBaseBandPool");
        long transactionId = this.getTxIdTransactional(c);
        int bbpFroId = this.getFroId(c);
        this.chcBbpProxy.setBbpParam(transactionId, bbpFroId, 0, value);
    }

    public int getBaseBandPoolState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBaseBandPoolState()");
        return this.chcBbpProxy.getBbpParam((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (int)this.getFroId((Coordinator)c)).bbpStatus;
    }

    public int getAvailableTotalCeUl(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailableTotalCeDl()");
        return this.chcBbpProxy.getBbpParam((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (int)this.getFroId((Coordinator)c)).availableTotalCe;
    }
}

