/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.mechanics;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.RbsSlotMoImpl;

public class RbsSlotMoFactory
implements MoFactory {
    private static RbsSlotMoFactory instance = null;

    private RbsSlotMoFactory() {
        MessageLog.traceEnter(this.getClass(), "RbsSlotMoFactory()");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized RbsSlotMoFactory instance() {
        if (instance == null) {
            instance = new RbsSlotMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        String msg = " RbsSlot MO cannot be created over Mub ";
        MessageLog.traceError(this.getClass(), msg);
        throw new MoCanNotBeCreatedException(msg);
    }

    public ManagedObject createTheMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context, int slotFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        try {
            ManagedObject createdMo = RbsSlotMoImpl.create(parent, attributes, identity, source, context, slotFroId);
            return createdMo;
        }
        catch (MoAccessException e) {
            MessageLog.trace(1, this.getClass(), "RbsSlot could not be created:" + (Object)((Object)e));
            throw e;
        }
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo");
        return new RbsSlotMoImpl(recoveredData);
    }

    public String getMoTypeName() {
        MessageLog.traceEnter(this.getClass(), "getMoTypeName()");
        return "RbsSlot";
    }

    public static RbsSlotMoFactory getInstance() {
        return instance;
    }
}

