/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.mechanics;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSlotProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetSlotParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.McpaSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSlotMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSubrackMo;

public class RbsSlotMoImpl
extends BoamManagedObject
implements RbsSlotMo {
    public static final String SLOT_FRO_ID = "slotFroId";
    public static final String USER_LABEL_DEFAULT = "";
    private static final int RBS_SLOT_MAX_NO_OF_CHILDREN = 99;
    public static final int MO_DATA_REVISION = 70701;
    private static final int CLIENT_ID = 0;
    private StringAttribute userLabelAttr;
    private IntegerAttribute slotPositionAttr;
    private IntegerAttribute slotFroIdAttr;
    private MoData myData;
    private EqcSlotProxy eqcSlotProxy = EqcSlotProxy.instance();

    public RbsSlotMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, ManagedObject source, int slotFroId) throws MoAccessException {
        super(parent, motypeName, identity, context, 99);
        MessageLog.traceEnter(this.getClass(), "RbsSlotMoImpl()");
        this.initMoData(checkedUserLabel, identity, context, slotFroId);
    }

    public RbsSlotMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "RbsSlotMoImpl()");
        this.myData = recoveredData;
        this.userLabelAttr = (StringAttribute)recoveredData.getAttribute("userLabel");
        this.slotPositionAttr = (IntegerAttribute)recoveredData.getAttribute("slotPosition");
        this.slotFroIdAttr = (IntegerAttribute)recoveredData.getAttribute(SLOT_FRO_ID);
        if (this.userLabelAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute userLabel is null");
        }
        if (this.slotPositionAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute slotPosition is null");
        }
        if (this.slotFroIdAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute slotFroId is null");
        }
        MessageLog.trace(1, this.getClass(), "MO is Restored, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context, int slotFroId) throws MoAccessException {
        MessageLog.traceEnter(RbsSlotMoImpl.class, "create()");
        RbsSlotMoImpl.checkTransaction(context);
        RbsSlotMoImpl.checkParent(parent, "RbsSlot");
        String checkedUserLabel = USER_LABEL_DEFAULT;
        RbsSlotMoImpl createdMo = new RbsSlotMoImpl(parent, "RbsSlot", identity, context, checkedUserLabel, source, slotFroId);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteTheMo(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteTheMo()");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (super.isReserved(c)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "RbsSlotMo is Deleted ");
    }

    public int getSlotFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSlotFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.slotFroIdAttr.getValue(context);
    }

    public String getType() {
        return "RbsSlot";
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getRbsSlotId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsSlotId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "RbsSlot", context);
        this.sendAVC("userLabel", value, context);
    }

    public int getSlotPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSlotPosition()");
        EqcGetSlotParamRspS cfmSig = this.getSlotData(context);
        return cfmSig.slotPosition;
    }

    public int getSlotState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSlotState()");
        if (this.getChildren().size() > 0) {
            return 1;
        }
        return 0;
    }

    private EqcGetSlotParamRspS getSlotData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSlotData()");
        EqcGetSlotParamRspS cfmSig = this.eqcSlotProxy.getSlotParam(this.getTxIdNonTransactional(context), 0, this.slotFroIdAttr.getValue(context));
        if (cfmSig.slotPosition != this.slotPositionAttr.getValue(context)) {
            String msg1 = " EqcGetSlotParamRspS.slotPosition differs to the value assumed in BOAM";
            MessageLog.traceError(this.getClass(), msg1);
        }
        return cfmSig;
    }

    private void storeUserLabelAttr(String value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " storeUserLabelAttr() ");
        this.userLabelAttr = new StringAttribute("userLabel", false, value);
        this.myData.registerPersistentAttr((Attribute)this.userLabelAttr);
    }

    private void storeSlotPositionAttr(int value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " storeSlotPositionAttr() ");
        this.slotPositionAttr = new IntegerAttribute("slotPosition", false, value);
        this.myData.registerPersistentAttr((Attribute)this.slotPositionAttr);
    }

    private void storeSlotFroIdAttr(int value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " storeSlotFroIdAttr() ");
        this.slotFroIdAttr = new IntegerAttribute(SLOT_FRO_ID, false, value);
        this.myData.registerPersistentAttr((Attribute)this.slotFroIdAttr);
    }

    protected static void checkParent(ManagedObject parent, String moTypeName) throws IllegalParentException {
        if (parent == null || !(parent instanceof McpaSubrackMo) && !(parent instanceof PowerSupplySubrackMo) && !(parent instanceof RbsSubrackMo)) {
            throw new IllegalParentException(moTypeName);
        }
    }

    private void initMoData(String checkedUserLabel, String identity, Coordinator context, int slotFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(70701);
        this.storeUserLabelAttr(checkedUserLabel);
        this.storeSlotPositionAttr(Integer.parseInt(identity));
        this.storeSlotFroIdAttr(slotFroId);
        MessageLog.trace(1, this.getClass(), " slot identity corresponding to slot id is  " + identity);
    }
}

