/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.MoTypeCheckMoTypeAndIdFilter;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.DefaultFaultDevFroId;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDeviceBHwPidRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsBasicHwPidT;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ProductDataUtil;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AcDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AcDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AccuMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AccuSubrackMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcuDeviceGroupMo;

public class AccuMoImpl
extends BoamManagedObjectWithAlarms
implements AccuMo {
    private static final EqcDeviceProxy eqcDeviceProxy = EqcDeviceProxy.instance();
    private static final EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    private static final int SLOTPOSITION = 0;
    public static final int MO_DATA_REVISION = 274433;
    private int myFroId = 0;

    public AccuMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, int checkedAlarmStatus, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " Accu Normal constructor");
        int deviceFroId = 0;
        int devSetFroId = 0;
        ManagedObject pcuDevGr = this.checkPcuDevGroupExistence(parent, context);
        ManagedObject acSet = AuxDeviceSetMoFactory.instance(49763).createTheMo(pcuDevGr, devSetFroId, "1", "", context);
        ManagedObject acDev = AuxDeviceMoFactory.instance(11).createTheMo(acSet, deviceFroId, "1", "", context);
        AcDeviceMo acDeviceRef = (AcDeviceMo)acDev;
        this.initMoData(checkedUserLabel, acDeviceRef, checkedAlarmStatus, context);
        acDeviceRef.reserve(this, context);
        this.addObservers(99, context);
        MessageLog.trace(1, this.getClass(), "Accu Mo is Created ");
    }

    public AccuMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " Accu recovery constructor");
        this.myData = recoveredData;
        ReferenceAttribute deviceRefAttr = (ReferenceAttribute)recoveredData.getAttribute("deviceRef");
        if (deviceRefAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute deviceRefAttr is null");
        }
        ProductRepository.instance().registerHw((HardwareProductData)this);
        try {
            this.addObservers(99, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Accu MO is Restored ");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AccuMoImpl.class, "create()");
        AccuMoImpl.checkTransaction(context);
        AccuMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Accu");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "Accu");
        ValidateAttributes.checkOtherAttributes(attributes, "Accu");
        AccuMoImpl createdMo = new AccuMoImpl(parent, "Accu", identity, context, checkedUserLabel, checkedAlarmStatus, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        AcDeviceMo acDeviceRef = (AcDeviceMo)this.getDeviceRef(c);
        AcDeviceSetMo acDevSetRef = (AcDeviceSetMo)acDeviceRef.getParent();
        acDeviceRef.release(this, c);
        acDeviceRef.npuDelete(c, 11);
        acDevSetRef.sysDelete(c);
        ProductRepository.instance().deregisterHw((HardwareProductData)this);
        this.removeObservers(c);
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "Accu Mo is Deleted ");
    }

    public String getType() {
        return "Accu";
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getAccuId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAccuId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "Accu", context);
        this.sendAVC("userLabel", value, context);
    }

    public ManagedObject getDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDeviceRef()");
        return this.bcmGetReferenceAttribute("deviceRef", context);
    }

    private RbsBasicHwPidT getRbsBasicHwPidT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsBasicHwPidT()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        RbsBasicHwPidT rbsBasicHwPidT = null;
        int acDeviceFroId = ((AcDeviceMo)this.getDeviceRef(context)).getAuxDeviceFroId(context);
        EqcGetDeviceBHwPidRspS rspSig = eqcDeviceProxy.getRbsBasicHwPidT(0L, acDeviceFroId);
        if (rspSig != null && rspSig.result == 0) {
            rbsBasicHwPidT = rspSig.basicHwPid;
        }
        return rbsBasicHwPidT;
    }

    public String getProductNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductNumber()");
        String productNumber = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productNumber;
    }

    public String getProductRevision(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductRevision()");
        String productRevision = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productRevision = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productRevision;
    }

    public String getProductName(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductName()");
        String productName = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productName = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductName);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productName;
    }

    public String getProductType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductType()");
        String productType = "HW";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productType = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductType);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productType;
    }

    public String getProductionDate(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductionDate()");
        String productionDate = "00000000";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productionDate = ProductDataUtil.verifyDateFormat(rbsBasicHwPidT);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productionDate;
    }

    public String getSerialNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSerialNumber()");
        String serialNumber = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                serialNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwSerialNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return serialNumber;
    }

    public String getRState(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getRState()");
        String rState = "";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                rState = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return rState;
    }

    public int getSlotPosition(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSlotPosition()");
        return 0;
    }

    public String getSubrackId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSubrackId()");
        try {
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            ManagedObject parMo = this.getParent();
            if (parMo instanceof AccuSubrackMo) {
                AccuSubrackMo acMo = (AccuSubrackMo)parMo;
                return acMo.getSubrackPosition(context);
            }
            return "";
        }
        catch (MoAccessException e) {
            return "";
        }
    }

    public int getGreenLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getGreenLed()");
        return 1;
    }

    public int getRedLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRedLed()");
        return 1;
    }

    public int getYellowLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getYellowLed()");
        return 1;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof AccuSubrackMo)) {
            String msg = parent != null ? " Illegal parent, Expecting AccuSubrackMo, received: " + parent.getClass().getName() : "parent is null";
            throw new IllegalParentException(msg);
        }
    }

    private ManagedObject checkPcuDevGroupExistence(ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPcuDevGroupExistence()");
        ManagedObject mo = null;
        MoIterator moIter = MoRepository.instance().select(parent.getParent(), 4, (MoFilter)new MoTypeFilter("PcuDeviceGroup"));
        if (moIter.size() == 0) {
            moIter = MoRepository.instance().select(parent.getParent(), 5, (MoFilter)new MoTypeCheckMoTypeAndIdFilter("DeviceGroup", "PCU"));
        }
        if (moIter.size() == 0) {
            throw new IllegalParentException(this.getType() + "MaoNotAllocated");
        }
        if (moIter.hasMoreElements()) {
            mo = moIter.nextMo();
            int pcuDevGrFroId = 0;
            if (mo instanceof PcuDeviceGroupMo) {
                pcuDevGrFroId = ((PcuDeviceGroupMo)mo).getAuxGroupFroId(context);
            } else if (mo instanceof DeviceGroupMo) {
                pcuDevGrFroId = ((DeviceGroupMo)mo).getAuxGroupFroId(context);
            }
            MessageLog.trace(1, this.getClass(), "Accu checkPcuDevGroupExistence() executed pcuDevGrFroId :" + pcuDevGrFroId);
        }
        return mo;
    }

    private void initMoData(String checkedUserLabel, ManagedObject checkedDeviceRef, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " Accu initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(274433);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("deviceRef", checkedDeviceRef);
        this.initAlarmStatus(checkedAlarmStatus, context);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.myData.setRevision(274433);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myFroId = DefaultFaultDevFroId.getNextNpuFroId();
        this.myMoAlarms = new MoAlarms((ManagedObject)this, eqcBdhIndProxy, froType, this.myFroId, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public void setAlarmStatus(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus()");
        super.setAlarmStatus(value, c);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.myFroId;
    }
}

