/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellProxy;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;

public class RbsLocalCellMoFactory
implements PmCapableMoFactory {
    private static RbsLocalCellMoFactory instance = null;
    private List counterList = new ArrayList();

    private RbsLocalCellMoFactory() {
        MessageLog.traceEnter(this.getClass(), " constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.setupPmsCounters();
        ScCellProxy.instance();
    }

    public static synchronized RbsLocalCellMoFactory instance() {
        if (instance == null) {
            instance = new RbsLocalCellMoFactory();
        }
        return instance;
    }

    private void setupPmsCounters() {
        MessageLog.traceEnter(this.getClass(), "setupPmsCounters()");
        try {
            CounterGroup counterGroup = new CounterGroup("pmsUsedDlCodesGrp");
            Counter cnt = new Counter("pmSumUsedDlCodes", 1, counterGroup);
            this.counterList.add(cnt);
            cnt = new Counter("pmSampledUsedDlCodes", 1, counterGroup);
            this.counterList.add(cnt);
            cnt = new Counter("pmUsedDlCodesUtilisation", 20, counterGroup);
            this.counterList.add(cnt);
            new MoScannerAgent("RbsLocalCell", this.counterList);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), " Could not setup boam.pms.MoScannerAgent." + pmse);
        }
    }

    public String getMoTypeName() {
        return "RbsLocalCell";
    }

    public static synchronized void _reset_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }

    public List getCounters() {
        return this.counterList;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject mo = RbsLocalCellMoImpl.create(parent, attributes, identity, source, context);
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredGuts) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        return new RbsLocalCellMoImpl(recoveredGuts);
    }
}

