/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.HsdpaCodeResourceMismatchException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorMoImpl;

public class SectorHelper {
    public static final int RX_NUMBER_OF_SECTOR_ANTENNAS_DEFAULT = 1;
    public static final int RX_NUMBER_OF_SECTOR_ANTENNAS_AIR = 1;
    public static final int RX_NUMBER_OF_SECTOR_ANTENNAS_4WAY_DIVERSITY = 2;
    public static final int RX_NUMBER_OF_SECTOR_ANTENNAS_PSI_COVERAGE = 3;
    public static final int RX_NUMBER_OF_SECTOR_ANTENNAS_Y_COVERAGE = 2;

    public static void checkSectorAntennasPrecondition(SectorMo sector, int numberOfRxBranches, Coordinator context) throws MoAccessException {
        int numberOfSectorAntennas = sector.getNumberOfSectorAntennas(context);
        if (numberOfSectorAntennas == 1 && numberOfRxBranches == 2) {
            return;
        }
        if (numberOfSectorAntennas == 2 && numberOfRxBranches == 4) {
            return;
        }
        if (numberOfSectorAntennas == 2 && numberOfRxBranches == 2) {
            return;
        }
        if (numberOfSectorAntennas == 3 && numberOfRxBranches == 6) {
            return;
        }
        if (numberOfSectorAntennas == 1 && numberOfRxBranches == 4) {
            return;
        }
        if (SectorHelper.checkPsiDLOnLyCell(numberOfRxBranches, numberOfSectorAntennas, sector, context)) {
            return;
        }
        throw new ConfigurationNotSupportedException("Inconsistency between numberOfSectorAntennas (" + numberOfSectorAntennas + ") and numberOfRxBranches (" + numberOfRxBranches + ")");
    }

    private static boolean checkPsiDLOnLyCell(int numberOfRxBranches, int numberOfSectorAntennas, SectorMo sector, Coordinator context) throws MoAccessException {
        if (0 != numberOfRxBranches) {
            return false;
        }
        return 3 == numberOfSectorAntennas || 2 == numberOfSectorAntennas;
    }

    public static CarrierMo[] getCarriers(SectorMo sector) throws ConfigurationNotSupportedException {
        MoIterator carrierIterator = BoamHelper.findMOs("Carrier", sector, 1);
        if (carrierIterator == null) {
            throw new ConfigurationNotSupportedException("Cannot get Carriers");
        }
        CarrierMo[] carriers = new CarrierMo[carrierIterator.size()];
        int i = 0;
        while (carrierIterator.hasMoreElements()) {
            carriers[i] = (CarrierMo)carrierIterator.nextMo();
            ++i;
        }
        return carriers;
    }

    public static void checkAntennaBranchPreconditionOnInitSector(SectorMo sector, Coordinator context) throws MoAccessException {
        ManagedObject[] sectorAntennas = sector.getSectorAntennasRef(context);
        for (int i = 0; i < sectorAntennas.length; ++i) {
            MoIterator antennaBranchIterator = BoamHelper.findMOs("AntennaBranch", sectorAntennas[i], 1);
            if (antennaBranchIterator.size() >= 1) continue;
            throw new ConfigurationNotSupportedException("Incorrect number of AntennaBranches found.");
        }
    }

    public static void checkCarrierPreconditionOnInitSector(CarrierMo[] carriers, int numberOfTxBranches, Coordinator c) throws MoAccessException {
        if (carriers.length == 0 || carriers[0] == null) {
            throw new ConfigurationNotSupportedException("No Carriers can be found under this Sector");
        }
        for (int i = 0; i < carriers.length; ++i) {
            if (carriers[i].getNumberOfTxBranches(c) <= numberOfTxBranches) continue;
            throw new ConfigurationNotSupportedException("Carrier.numberOfTxBranches (" + carriers[i].getNumberOfTxBranches(c) + ") must be less than or equal to Sector.numberOfTxBranches (" + numberOfTxBranches + ") , for all carriers within the sector");
        }
    }

    public static void checkRBBPreconditionOnInitSector(SectorMo sector, int actualNoTxBranches, int actualNoRxBranches, Coordinator c) throws MoAccessException {
        int maxNoRxBranches;
        int maxNoTxBranches;
        int rbb = sector.getRadioBuildingBlock(c);
        switch (rbb) {
            case 6: 
            case 7: {
                maxNoTxBranches = 1;
                maxNoRxBranches = -1;
                break;
            }
            case 1: 
            case 9: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                maxNoTxBranches = 1;
                maxNoRxBranches = 2;
                int num = ((SectorMoImpl)sector).getSectorConfigurationType(c);
                if (num == 98) {
                    maxNoRxBranches = 4;
                    break;
                }
                if (num != 99) break;
                maxNoRxBranches = 6;
                break;
            }
            case 18: 
            case 21: {
                maxNoTxBranches = 1;
                maxNoRxBranches = 4;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 25: 
            case 26: 
            case 34: {
                maxNoTxBranches = 2;
                maxNoRxBranches = 2;
                break;
            }
            case 2: 
            case 8: {
                maxNoTxBranches = 2;
                maxNoRxBranches = 2;
                int num = ((SectorMoImpl)sector).getSectorConfigurationType(c);
                if (num == 98) {
                    maxNoRxBranches = 4;
                    break;
                }
                if (num != 99) break;
                maxNoRxBranches = 6;
                break;
            }
            case 3: 
            case 19: 
            case 22: 
            case 27: {
                maxNoTxBranches = 2;
                maxNoRxBranches = 4;
                break;
            }
            case 11: {
                maxNoTxBranches = 3;
                maxNoRxBranches = 2;
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                maxNoTxBranches = 4;
                maxNoRxBranches = 2;
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                maxNoTxBranches = 4;
                maxNoRxBranches = 4;
                break;
            }
            case 0: {
                maxNoTxBranches = -1;
                maxNoRxBranches = -1;
                break;
            }
            default: {
                maxNoTxBranches = -1;
                maxNoRxBranches = -1;
                MessageLog.traceError(SectorHelper.class.getClass(), "Unexpected DUW RBB found: " + rbb + ", precondition check incomplete");
            }
        }
        if (maxNoTxBranches != -1 && actualNoTxBranches > maxNoTxBranches) {
            throw new ConfigurationNotSupportedException(maxNoTxBranches + " Tx Antenna Branches allowed for this RBB, but found " + actualNoTxBranches);
        }
        if (maxNoRxBranches != -1 && actualNoRxBranches > maxNoRxBranches) {
            throw new ConfigurationNotSupportedException(maxNoRxBranches + " Rx Antenna Branches allowed for this RBB, but found " + actualNoRxBranches);
        }
    }

    public static void checkTxDivPreconditionOnInitSector(int numberOfTxBranches, int txDiversity) throws ConfigurationNotSupportedException {
        if (numberOfTxBranches < 2 && txDiversity == 1) {
            throw new ConfigurationNotSupportedException("Initializing Sector with numberOfTxBranches = 1 is not allowed when numberOfTxBranches for Carrier > 1.");
        }
    }

    public static void checkSumHsNumCodeResourcesInAllTxDeviceGroup(Coordinator c) throws MoAccessException {
        MoIterator rbsLocalCellIter = BoamHelper.findMOs("RbsLocalCell");
        while (rbsLocalCellIter.hasMoreElements()) {
            int sumHsNumCodeResources = 0;
            ManagedObject rbsLocalCell = rbsLocalCellIter.nextMo();
            ManagedObject carrierRef = ((RbsLocalCellMo)rbsLocalCell).getCarriersRef(c)[0];
            ManagedObject[] dbccDeviceRef = ((CarrierMo)carrierRef).getDbccDeviceRef(c);
            if (dbccDeviceRef == null || dbccDeviceRef.length == 0) continue;
            for (int i = 0; i < dbccDeviceRef.length; ++i) {
                ManagedObject txDeviceGroupRef = dbccDeviceRef[i].getParent().getParent();
                if (txDeviceGroupRef == null) continue;
                if (txDeviceGroupRef instanceof TxDeviceGroupMo) {
                    sumHsNumCodeResources += ((TxDeviceGroupMo)txDeviceGroupRef).getNumHsCodeResources(c);
                }
                if (!DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(txDeviceGroupRef, "TX")) continue;
                sumHsNumCodeResources += ((DeviceGroupMoImpl)txDeviceGroupRef).getNumHsCodeResources(c);
            }
            if (((RbsLocalCellMo)rbsLocalCell).getHsCodeResourceId(c) <= sumHsNumCodeResources) continue;
            throw new HsdpaCodeResourceMismatchException();
        }
    }
}

