/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcEulProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulEDchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulEDchDeletedIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.PmCounterSetup;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.EDchResourcesCellMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.EDchResourcesMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;

public class EDchResourcesMoFactory
implements PmCapableMoFactory,
PlugAndPlayObserver,
FroStateObserver {
    public static final int CLIENT_ID = 0;
    public static final int CM_OPERATION_OK = 0;
    private static EDchResourcesMoFactory instance = null;
    private final List counterList = new ArrayList();
    private final List edResCellcounterList = new ArrayList();
    private final HashMap edchResList = new HashMap(6);
    private final HashMap edchResCellList = new HashMap(6);

    private EDchResourcesMoFactory() {
        MessageLog.traceEnter(this.getClass(), "constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        MoFactoryMgr.instance().register((MoFactory)this, this.getSecondaryMoTypeName());
        ChcEulProxy.instance().registerForPlugAndPLayInd(null, this, -19L);
        ChcEulProxy.instance().registerForStatePropagation(null, this);
        this.setupCounters();
        this.setupRbsPredefScanner();
    }

    public static synchronized EDchResourcesMoFactory instance() {
        if (instance == null) {
            instance = new EDchResourcesMoFactory();
        }
        return instance;
    }

    public ManagedObject lookUpEDchResMo(int cellCarrierFroId) {
        return (ManagedObject)this.edchResList.get(new Integer(cellCarrierFroId));
    }

    public String getMoTypeName() {
        return "EDchResources";
    }

    public String getSecondaryMoTypeName() {
        return "EDchResourcesCell";
    }

    public ManagedObject createMo(ManagedObject arg0, AttrList arg1, String arg2, ManagedObject arg3, Coordinator arg4) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        throw new MoCanNotBeCreatedException(this.getMoTypeName());
    }

    public ManagedObject recoverMo(MoData arg0) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        return null;
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()");
        if (pnpIndSig == null) {
            MessageLog.traceError(this.getClass(), "The received signal is null!!");
            return;
        }
        if (pnpIndSig.getClass().getName().equals(LrsEulEDchCreatedIndS.class.getName())) {
            this.createInd(pnpIndSig);
        } else if (pnpIndSig.getClass().getName().equals(LrsEulEDchDeletedIndS.class.getName())) {
            this.deleteInd(pnpIndSig);
        } else {
            MessageLog.traceError(this.getClass(), "unexpected signal is received!! recSig:" + pnpIndSig.getClass().getName());
        }
    }

    public synchronized void createInd(InSignal createInd) {
        MessageLog.traceEnter(this.getClass(), "createInd()");
        ManagedObject edchResMo = null;
        ManagedObject edchResCellMo = null;
        LrsEulEDchCreatedIndS indicationSig = (LrsEulEDchCreatedIndS)createInd;
        Integer froId = new Integer(indicationSig.cellCarrierFroId);
        try {
            int cellFroId;
            ManagedObject cellCarrierRef = BoamHelper.getMoForFroId("Carrier", indicationSig.cellCarrierFroId);
            if (cellCarrierRef == null) {
                throw new MoNotFoundException("Carrier has not been created");
            }
            edchResMo = EDchResourcesMoImpl.createEDchResources(cellCarrierRef, indicationSig.eDbchSetFroId, indicationSig.eScSetFroId);
            this.edchResList.put(froId, edchResMo);
            ManagedObject[] reservedByList = ((CarrierMo)cellCarrierRef).getReservedBy(null);
            RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedByList, "RbsLocalCell");
            if (cell != null && cell.isCombinedCell(null) && !this.edchResCellList.containsKey(new Integer(cellFroId = cell.getFroId(null)))) {
                edchResCellMo = EDchResourcesCellMoImpl.createEDchResourcesCell(cell);
                this.edchResCellList.put(new Integer(cellFroId), edchResCellMo);
            }
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be created, froId: " + indicationSig.cellCarrierFroId, e);
        }
    }

    public synchronized void deleteInd(InSignal deleteInd) {
        MessageLog.traceEnter(this.getClass(), "deleteInd()");
        LrsEulEDchDeletedIndS indicationSig = (LrsEulEDchDeletedIndS)deleteInd;
        try {
            this.deleteEDchResources(indicationSig.cellCarrierFroId);
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be deleted, froId: " + indicationSig.cellCarrierFroId, e);
        }
    }

    private void deleteEDchResources(int froId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteEDchResources()");
        Integer key = new Integer(froId);
        EDchResourcesMoImpl edchResourcesMoImpl = (EDchResourcesMoImpl)this.edchResList.get(key);
        if (edchResourcesMoImpl == null) {
            throw new MoNotFoundException("Couldn't find EDchResourcesMo related to carrier froId:" + froId);
        }
        edchResourcesMoImpl.sysDelete(null);
        this.edchResList.remove(key);
        ManagedObject cellCarrierRef = BoamHelper.getMoForFroId("Carrier", froId);
        ManagedObject[] reservedByList = ((CarrierMo)cellCarrierRef).getReservedBy(null);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedByList, "RbsLocalCell");
        if (cell != null && cell.isCombinedCell(null)) {
            int cellFroId = cell.getFroId(null);
            Integer cellKey = new Integer(cellFroId);
            ManagedObject[] carriers = cell.getCarriersRef(null);
            for (int i = 0; i < carriers.length; ++i) {
                Integer carrierKey = new Integer(((CarrierMo)carriers[i]).getFroId(null));
                if (!this.edchResList.containsKey(carrierKey)) continue;
                return;
            }
            EDchResourcesCellMoImpl edchResourcesCellMoImpl = (EDchResourcesCellMoImpl)this.edchResCellList.get(cellKey);
            if (edchResourcesCellMoImpl != null) {
                edchResourcesCellMoImpl.sysDelete(null);
                this.edchResCellList.remove(cellKey);
            } else {
                throw new MoNotFoundException("Couldn't find EDchResourcesCellMo related to RbsLocalCell froId:" + cellFroId);
            }
        }
    }

    public void serviceAvailable(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceAvailable()" + proxyName);
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved()" + proxyName);
        try {
            this.deleteAll();
        }
        catch (Throwable t) {
            MessageLog.traceError(this.getClass(), "EDchResourcesMo could not be deleted when res. layer service lost " + t);
        }
    }

    private void setupCounters() {
        try {
            PmCounterSetup.setupCounters(this.getMoTypeName(), this.counterList);
            this.counterList.add(new Counter("pmNoUlUuLoadLimitEul", 1, null));
            CounterGroup group = new CounterGroup("pmsNoiseFloor");
            this.counterList.add(new Counter("pmNoiseFloor", 56, group));
            this.counterList.add(new Counter("pmNoiseFloor1", 56, group));
            this.counterList.add(new Counter("pmNoiseFloor2", 56, group));
            this.counterList.add(new Counter("pmNoiseFloor3", 56, group));
            this.counterList.add(new Counter("pmNoiseFloorHighRes", 202, group));
            this.counterList.add(new Counter("pmCapacityAllocAttServEDchUsers", 1, null));
            this.counterList.add(new Counter("pmCapacityServEDchUsers", 11, null));
            this.counterList.add(new Counter("pmCapacityAllocRejServEDchUsers", 1, null));
            group = new CounterGroup("capacityNumServEDchUsers");
            this.counterList.add(new Counter("pmSumCapacityServEDchUsers", 1, group));
            this.counterList.add(new Counter("pmSumSqrCapacityServEDchUsers", 1, group));
            this.counterList.add(new Counter("pmSamplesCapacityServEDchUsers", 1, group));
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
            PmCounterSetup.setupCounters(this.getSecondaryMoTypeName(), this.edResCellcounterList);
            group = new CounterGroup("capacityNumServEDchUsers");
            this.edResCellcounterList.add(new Counter("pmSumCapacityServEDchUsers", 1, group));
            this.edResCellcounterList.add(new Counter("pmSumSqrCapacityServEDchUsers", 1, group));
            this.edResCellcounterList.add(new Counter("pmSamplesCapacityServEDchUsers", 1, group));
            this.edResCellcounterList.add(new Counter("pmCapacityAllocAttServEDchUsers", 1, null));
            this.edResCellcounterList.add(new Counter("pmCapacityServEDchUsers", 11, null));
            this.edResCellcounterList.add(new Counter("pmCapacityAllocRejServEDchUsers", 1, null));
            this.edResCellcounterList.add(new Counter("pmNoUsersCEdchEul", 33, null));
            new MoScannerAgent(this.getSecondaryMoTypeName(), this.edResCellcounterList);
            MessageLog.traceEnter(this.getClass(), "Finished setuping the counter");
        }
        catch (PmsException pmse) {
            MessageLog.traceError(this.getClass(), "setupCounter(): Setup counters failed!!", (Throwable)((Object)pmse));
        }
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }

    private synchronized void deleteAll() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAll()");
        Collection set = this.edchResList.values();
        Iterator objs = set.iterator();
        EDchResourcesMoImpl tmpObj = null;
        while (objs.hasNext()) {
            tmpObj = (EDchResourcesMoImpl)objs.next();
            tmpObj.moScannerServiceNotAvailable();
            tmpObj.sysDelete(null);
        }
        this.edchResList.clear();
        Collection Cellset = this.edchResCellList.values();
        Iterator Cellobjs = Cellset.iterator();
        while (Cellobjs.hasNext()) {
            ((EDchResourcesCellMoImpl)Cellobjs.next()).sysDelete(null);
        }
        this.edchResCellList.clear();
    }

    public List getCounters() {
        return this.counterList;
    }

    public List getSecondaryCounters() {
        return this.edResCellcounterList;
    }

    private void setupRbsPredefScanner() {
        MessageLog.traceEnter(this.getClass(), "setupRbsPredefScanner()");
        String[] classnames = new String[]{this.getMoTypeName()};
        String[][] counterArray = new String[][]{{"pmCapacityAllocAttServEDchUsers", "pmCapacityAllocRejServEDchUsers", "pmSumCapacityServEDchUsers", "pmSamplesCapacityServEDchUsers", "pmEdchThpAppLim", "pmEdchThpNonGlim", "pmEdchThpGlim", "pmSumAckedBitsCellEulNonGlim", "pmSumAckedBitsCellEulGlim", "pmNoActive2msIntervalsEulGlim", "pmNoActive2msIntervalsEulNonGlim"}};
        PredefinedScannerMgr.instance().createPredefinedScanner("PREDEF.PRIMARY.STATS", classnames, counterArray, 5);
        String[] classnames2 = new String[]{this.getSecondaryMoTypeName()};
        String[][] counterArray2 = new String[][]{{"pmAllocRejEdchRlEul", "pmCapacityAllocAttServEDchUsers", "pmCapacityAllocRejServEDchUsers", "pmSumCapacityServEDchUsers", "pmSamplesCapacityServEDchUsers"}};
        PredefinedScannerMgr.instance().createPredefinedScanner("PREDEF.PRIMARY.STATS", classnames2, counterArray2, 5);
    }
}

