/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcEulProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetEDchParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.EDchResourcesReadNbapDataStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.EDchResourcesMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.EDchResourcesMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class EDchResourcesMoImpl
extends BoamManagedObject
implements EDchResourcesMo {
    private static final Class SELF = EDchResourcesMoImpl.class;
    public static final int EDCHRESOURCESID = 4096;
    public static final int MO_DATA_REVISION = 0;
    private static final ChcEulProxy relatedProxy = ChcEulProxy.instance();
    private final MoData myData;
    private final MoScanner myScanner;
    private final ReferenceAttribute edbchDeviceSetRef;
    private final ReferenceAttribute escDeviceSetRef;

    private EDchResourcesMoImpl(ManagedObject checkedParent, String thisMoName, String identity, int eDbchDeviceSetFroId, int eScDeviceSetFroId, Coordinator context) throws MoAccessException, IllegalParentException {
        super(checkedParent, thisMoName, identity, context);
        MessageLog.traceEnter(SELF, "EDchResourcesMoImpl() <---");
        this.edbchDeviceSetRef = new ReferenceAttribute("eDbchDeviceSetRef", false);
        this.escDeviceSetRef = new ReferenceAttribute("eScDeviceSetRef", false);
        this.myData = this.initMoData(eDbchDeviceSetFroId, eScDeviceSetFroId, context);
        this.myScanner = this.createMoScanner(this, this.getCarrierFroId(context), false, context);
    }

    private MoData initMoData(int eDbchDeviceSetFroId, int eScDeviceSetFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "initMoData()<--");
        MoData moData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, context);
        moData.registerTransientAttr((Attribute)this.edbchDeviceSetRef);
        moData.registerTransientAttr((Attribute)this.escDeviceSetRef);
        this.setDeviceSet(this.edbchDeviceSetRef, "EDbchDeviceSet", eDbchDeviceSetFroId);
        this.setDeviceSet(this.escDeviceSetRef, "EScDeviceSet", eScDeviceSetFroId);
        moData.setRevision(0);
        return moData;
    }

    private void setDeviceSet(ReferenceAttribute attr, String deviceSetMoType, int froId) throws MoAccessException {
        ManagedObject deviceSetMo = ChannelHelper.resolveDeviceSetRefAndReserve(froId, deviceSetMoType, this);
        attr.setValue(deviceSetMo);
        MessageLog.trace(1, SELF, attr.getName() + " is " + deviceSetMo);
    }

    private MoScanner createMoScanner(ManagedObject mo, int carrierFroId, boolean recovery, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createMoScanner() ");
        CarrierMo carrier = (CarrierMo)this.getParent();
        RbsLocalCellMo rbsLocalCell = (RbsLocalCellMo)carrier.getReservedBy(context)[0];
        int isCombinedCell = rbsLocalCell.isCombinedCell(context) ? 1 : 0;
        int[] additionalInfo = new int[]{0, 4096, isCombinedCell, rbsLocalCell.getFroId(context)};
        MessageLog.trace(3, SELF, "create MO scanner <---");
        return new MoScanner(mo, relatedProxy, carrierFroId, 0, EDchResourcesMoFactory.instance().getCounters(), additionalInfo, false, context);
    }

    public void deleteMoScanner(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "deleteMoScanner() ");
        this.myScanner.delete(context);
    }

    public void moScannerServiceNotAvailable() throws MoAccessException {
        MessageLog.traceEnter(SELF, "moScannerServiceNotAvailable() ");
        this.myScanner.serviceRemoved(relatedProxy.getServiceName());
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()<--");
        return false;
    }

    public static synchronized ManagedObject createEDchResources(ManagedObject mo, int eDbchSetFroId, int eScSetFroId) throws MoAccessException {
        MessageLog.traceEnter(EDchResourcesMoImpl.class, "createEDchResources() <---");
        return new EDchResourcesMoImpl(mo, "EDchResources", "1", eDbchSetFroId, eScSetFroId, null);
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "delete() <---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "sysDelete() <---");
        this.myData.delete(c);
        this.deleteMoScanner(c);
        if (this.getEDbchDeviceSetRef(c) != null) {
            ((Reservable)this.getEDbchDeviceSetRef(c)).release((ManagedObject)this, c);
        }
        if (this.getEScDeviceSetRef(c) != null) {
            ((Reservable)this.getEScDeviceSetRef(c)).release((ManagedObject)this, c);
        }
        super.delete(c);
        MessageLog.trace(1, SELF, "EDchResources was deleted");
    }

    public String getType() {
        return "EDchResources";
    }

    public int getCarrierFroId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getCarrierFroId()<---");
        return ((MaoHasFro)this.getParent()).getFroId(c);
    }

    public ManagedObject getEDbchDeviceSetRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getEDbchDeviceSetRef()<---");
        return this.bcmGetReferenceAttribute("eDbchDeviceSetRef", c);
    }

    public ManagedObject getEScDeviceSetRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getEScDeviceSetRef()<---");
        return this.bcmGetReferenceAttribute("eScDeviceSetRef", c);
    }

    public int getOperationalState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getOperationalState()<---");
        return EDchResourcesMoImpl.relatedProxy.getEulEDchParameter((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)this.getCarrierFroId((Coordinator)c)).operationalState;
    }

    public int getAvailabilityStatus(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAvailabilityStatus()<---");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(EDchResourcesMoImpl.relatedProxy.getEulEDchParameter((int)ValidateAttributes.getTxIdNonTransactional((Coordinator)c), (int)0, (int)this.getCarrierFroId((Coordinator)c)).availStatus);
    }

    public Struct actionReadNbapData(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "actionReadNbapData()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.actionReadNbapData(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCarrierFroId(c), c);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.myData;
    }

    private EDchResourcesReadNbapDataStruct actionReadNbapData(int transactionId, int clientId, int cellCarrierFroId, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "actionReadNbapData()<---");
        LrsEulGetEDchParamRspS rspSig = relatedProxy.getEulEDchParameter(transactionId, clientId, cellCarrierFroId);
        return new EDchResourcesReadNbapDataStruct(rspSig.scramblingCode, rspSig.noOfEAgchCodes, rspSig.eAgchCodes, rspSig.noOfEHichERgchCodes, rspSig.eHichERgchCodes, rspSig.eulMaxTargetRtwp);
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }
}

