/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import enea.ose.system.InSignal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPccpchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPccpchDeletedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPccpchRelChangeIndS;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PccpchMoImpl;

public class PccpchMoFactory
implements MoFactory,
PlugAndPlayObserver,
FroStateObserver {
    private static PccpchMoFactory instance = null;
    public static final int CLIENT_ID = 0;
    public static final int CM_OPERATION_OK = 0;
    private ChcPccpchProxy myProxy = ChcPccpchProxy.instance();
    private HashMap pccpchList = new HashMap(5);

    private PccpchMoFactory() {
        MessageLog.traceEnter(this.getClass(), "constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.myProxy.registerForPlugAndPLayInd(null, this, -8L);
        this.myProxy.registerForStatePropagation(null, this);
    }

    public static synchronized PccpchMoFactory instance() {
        if (instance == null) {
            instance = new PccpchMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        throw new MoCanNotBeCreatedException(this.getMoTypeName());
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        ErrorMgr.shotDownIfNull(null, "SW error!!, this shouldn't be happened. No recovery for " + this.getMoTypeName());
        return null;
    }

    public synchronized void createInd(InSignal createInd) {
        MessageLog.traceEnter(this.getClass(), "createInd()");
        PccpchMoImpl pccpchMo = null;
        LrsPccpchCreatedIndS indicationSig = (LrsPccpchCreatedIndS)createInd;
        try {
            pccpchMo = (PccpchMoImpl)this.createPhysicalCommonChannel(indicationSig);
            Integer froId = new Integer(indicationSig.pccpchFroId);
            this.pccpchList.put(froId, pccpchMo);
            MessageLog.trace(1, this.getClass(), "Mo: " + pccpchMo.getLocalDistinguishedName() + " ,  with FroId: " + froId + " is created.");
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be created, froId: " + indicationSig.pccpchFroId, e);
        }
    }

    public synchronized void deleteInd(InSignal deleteInd) {
        MessageLog.traceEnter(this.getClass(), "deleteInd()");
        LrsPccpchDeletedIndS indicationSig = (LrsPccpchDeletedIndS)deleteInd;
        try {
            this.deletePccpch(indicationSig.pccpchFroId);
            MessageLog.trace(1, this.getClass(), "deleteInd(), pccpchMo with FroId: " + indicationSig.pccpchFroId + " is deleted.");
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be deleted, froId: " + indicationSig.pccpchFroId, e);
        }
    }

    public synchronized void changeInd(InSignal changeInd) {
        MessageLog.traceEnter(this.getClass(), "changeInd()");
        LrsPccpchRelChangeIndS indicationSig = (LrsPccpchRelChangeIndS)changeInd;
        try {
            this.changeDev(indicationSig);
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "PccpchMo could not be changed froID:" + indicationSig.pccpchFroId + ", " + e);
        }
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved()");
        try {
            this.deleteAll();
        }
        catch (Exception t) {
            MessageLog.traceError(this.getClass(), "Couldn't reset the object list " + t);
        }
    }

    public void serviceAvailable(String proxyName) {
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()");
        if (pnpIndSig == null) {
            MessageLog.traceError(this.getClass(), "The received signal is null!!");
            return;
        }
        if (pnpIndSig.getClass().getName().equals(LrsPccpchCreatedIndS.class.getName())) {
            this.createInd(pnpIndSig);
        } else if (pnpIndSig.getClass().getName().equals(LrsPccpchDeletedIndS.class.getName())) {
            this.deleteInd(pnpIndSig);
        } else if (pnpIndSig.getClass().getName().equals(LrsPccpchRelChangeIndS.class.getName())) {
            this.changeInd(pnpIndSig);
        } else {
            MessageLog.traceError(this.getClass(), "unexpected signal is received!! recSig:" + pnpIndSig.getClass().getName());
        }
    }

    public String getMoTypeName() {
        return "Pccpch";
    }

    private synchronized void deleteAll() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAll()");
        Collection set = this.pccpchList.values();
        Iterator objs = set.iterator();
        while (objs.hasNext()) {
            ((PccpchMoImpl)objs.next()).deletePccpch(null);
        }
        this.pccpchList.clear();
    }

    private void changeDev(LrsPccpchRelChangeIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "changeDev()");
        Integer froId = new Integer(indicationSig.pccpchFroId);
        PccpchMoImpl mo = (PccpchMoImpl)this.pccpchList.get(froId);
        if (mo == null) {
            throw new MoNotFoundException("Couldn't find PccpchMo froId:" + indicationSig.pccpchFroId);
        }
        mo.releaseOldAndAllocatedNewDbchDevice(indicationSig.dbchDevSetFroId, null);
    }

    private void deletePccpch(int froId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePccpch()");
        Integer key = new Integer(froId);
        PccpchMoImpl mo = (PccpchMoImpl)this.pccpchList.get(key);
        if (mo == null) {
            throw new MoNotFoundException("Couldn't find PccpchMo froId:" + froId);
        }
        mo.deletePccpch(null);
        this.pccpchList.remove(key);
    }

    private ManagedObject createPhysicalCommonChannel(LrsPccpchCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createPhysicalCommonChannel()");
        return PccpchMoImpl.create(indicationSig);
    }

    public static synchronized void _reset_onlyForTest() {
        instance = null;
    }
}

