/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsPschGetNbapParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsPschGetParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.CellNotSetupException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PschMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;

public class PschMoImpl
extends BoamManagedObject
implements PschMo {
    private static final String ID = "1";
    private static final String CELL_CARRIER_FRO_ID = "cellCarrierFroId";
    private final MoData myData;
    private final ScCellCarrierProxy lrsProxy = ScCellCarrierProxy.instance();

    public PschMoImpl(ManagedObject parent, AttrList attributes) throws MoAccessException {
        super(parent, "Psch", ID, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        ValidateAttributes.checkParent(parent, new String[]{"Carrier", "RbsLocalCell"});
        this.myData = this.initMoData(ID, attributes);
        MessageLog.trace(1, this.getClass(), "MO is created");
    }

    public void delete(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    public String getType() {
        return "Psch";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        ManagedObject parent = this.getParent();
        if (parent instanceof CarrierMo) {
            ManagedObject[] reservedBy = ((CarrierMo)parent).getReservedBy(context);
            RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
            return cell.getOperationalState(context);
        }
        return ((RbsLocalCellMo)parent).getOperationalState(context);
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        int availabilityStatus = this.getAttribute(context, "availabilityStatus");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(availabilityStatus);
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int cellCarrierFroId = this.bcmGetIntAttribute(CELL_CARRIER_FRO_ID, context);
        try {
            LrsPschGetNbapParamRspS rspSig = this.lrsProxy.pschGetNbapParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
            return this.convertSigToStruct(context, rspSig);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 12) {
                throw new CellNotSetupException();
            }
            throw e;
        }
    }

    private Struct convertSigToStruct(Coordinator context, LrsPschGetNbapParamRspS rspSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "convertSigToStruct() ");
        String[] names = new String[3];
        Object[] values = new Object[3];
        names[0] = "phChId";
        names[1] = "pschPower";
        names[2] = "tstdIndicator";
        Integer phChId = new Integer(rspSig.pschCommonPhChId);
        Integer pschPower = new Integer(rspSig.pschPower);
        Integer tstdIndicator = new Integer(rspSig.pschTstdIndicator);
        values[0] = phChId;
        values[1] = pschPower;
        values[2] = tstdIndicator;
        StructImpl status = new StructImpl(names, values);
        return status;
    }

    private int getAttribute(Coordinator context, String attributeName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAttribute()");
        int cellCarrierFroId = this.bcmGetIntAttribute(CELL_CARRIER_FRO_ID, context);
        LrsPschGetParamRspS rspSig = this.lrsProxy.pschGetParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
        if (attributeName.equals("operationalState")) {
            return rspSig.pschOpState;
        }
        if (attributeName.equals("availabilityStatus")) {
            return rspSig.pschAvailStatus;
        }
        String msg = "Attribute LrsPschGetParamRspS." + attributeName + " no such attribute";
        MessageLog.trace(2, this.getClass(), msg);
        throw new NoSuchAttributeException(msg, "Psch");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    private MoData initMoData(String identity, AttrList attributes) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        MoData moData = new MoData(this.getLocalDistinguishedName(), "Psch", false, null);
        IntegerAttribute cellCarrierFroId = new IntegerAttribute(CELL_CARRIER_FRO_ID, false);
        moData.registerTransientAttr((Attribute)cellCarrierFroId);
        cellCarrierFroId.setValue(ValidateAttributes.checkAndGetIntAttribute(attributes, CELL_CARRIER_FRO_ID, "Psch"));
        return moData;
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }
}

