/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import PerformanceIRPConstDefs.FilterHolder;
import PerformanceIRPConstDefs.ObservationObjectHolder;
import PerformanceIRPConstDefs.ObservationObjectListHolder;
import PerformanceIRPConstDefs.RecordingType;
import PerformanceIRPConstDefs.RecordingTypeHolder;
import PerformanceIRPConstDefs.TimeWindowHolder;
import org.omg.CORBA.IntHolder;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.pms.event.EventSubscription;
import se.ericsson.cello.pms.event.ServiceNotCompleteException;
import se.ericsson.cello.pms.event.SubscriptionFailureException;
import se.ericsson.cello.pms.generic.FailedException;
import se.ericsson.cello.pms.generic.Filter;
import se.ericsson.cello.pms.generic.FilterInfo;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.InvalidFilterException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.InvalidTriggeringObjectException;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.cello.pms.generic.ScannerInfo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcGpehScannerProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehEventS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PredefRbsScannerGpehMo;

public class PredefRbsScannerGpehMoImpl
extends BoamManagedObjectWithAlarms
implements PredefRbsScannerGpehMo {
    private static final Class SELF = PredefRbsScannerGpehMoImpl.class;
    private static final ObservationClass[] emptyObservationClasses = new ObservationClass[0];
    private static PredefRbsScannerGpehMoImpl theOneAndOnly;
    private static final String SCANNER_NAME_PMS = "PREDEF.RBS.GPEH";
    private static final ScannerId PMS_GENERIC_SCANNER_ID;
    private static final int GPEH_SCANNER_MAL_CLIENT_ID = 0;
    private static final long GPEH_SCANNER_ID = 1L;
    private static final PerformanceIRPConstDefs.ObservationClass[] emptyObsClasses;
    private static final String SUPPORTED_OBS_OBJ_PMS = "GPEH_INTERNAL";
    private static final String[] SUPPORTED_OBSERVATION_ATTRIBUTES;
    private static final int NO_SUPPORTED_ATTRS;
    private static final String GPEH_SCANNER_SERVICE_TAG = "bcNmGpehHandler";
    private static final String FILE_LOCATION = "/c/pm_data/";
    public static final int MO_DATA_REVISION = 4010101;
    private final NcGpehScannerProxy ncGpehScannerProxy = NcGpehScannerProxy.instance();
    private final String[] attrsObserved = new String[NO_SUPPORTED_ATTRS];
    private PerformanceIRPConstDefs.PerformanceMonitoringState scannerState = PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
    private boolean resLayerRestarted = false;
    private EventSubscription eventSubscription = null;
    private boolean filterSuccessfullySet = false;
    private FilterInfo filterInfo;
    private RecordingType recordingType = null;
    private PerformanceIRPConstDefs.ObservationObject triggeringObject;
    private PerformanceIRPConstDefs.ObservationObject[] observationObjectList = new PerformanceIRPConstDefs.ObservationObject[0];
    private PerformanceIRPConstDefs.Filter filter;
    private int[] timeWindow;
    private int samplingRate;

    public PredefRbsScannerGpehMoImpl(ManagedObject parent, AttrList attributes, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, "PredefRbsScannerGpeh", identity, context);
        MessageLog.traceEnter(this.getClass(), " Normal constructor ");
        this.initMoData(userLabel, context);
        try {
            PmsPortalImpl.getPortal().registerScanner((Object)this, PMS_GENERIC_SCANNER_ID);
            this.ncGpehScannerProxy.registerForStatePropagation(context, this);
            this.addObservers(83, context);
        }
        catch (Exception e) {
            MessageLog.traceError(this.getClass(), "cannot register with PMSI: " + e.getMessage());
        }
    }

    public PredefRbsScannerGpehMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        theOneAndOnly = this;
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        try {
            PmsPortalImpl.getPortal().registerScanner((Object)this, PMS_GENERIC_SCANNER_ID);
            this.addObservers(83, null);
            this.ncGpehScannerProxy.registerForStatePropagation(null, this);
        }
        catch (Exception e) {
            MessageLog.traceError(this.getClass(), "init observer failed or cannot register with PMSI: " + e.getMessage());
        }
        MessageLog.trace(1, this.getClass(), "Recovered PM GPEH.");
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject ignoredSource, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PredefRbsScannerGpehMoImpl.class, "create()");
        if (theOneAndOnly == null) {
            theOneAndOnly = new PredefRbsScannerGpehMoImpl(parent, attributes, identity, "", context);
        }
        return theOneAndOnly;
    }

    public static PredefRbsScannerGpehMoImpl getInstance() {
        MessageLog.traceEnter(PredefRbsScannerGpehMoImpl.class, "getInstance()");
        return theOneAndOnly;
    }

    public static void _reset_onlyForTest() {
        MessageLog.traceEnter(PredefRbsScannerGpehMoImpl.class, "_reset_onlyForTest()");
        theOneAndOnly = null;
    }

    private void initMoData(String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), "PredefRbsScannerGpeh", true, context);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("maxStorageSize", 270);
        this.bcmStoreAndRegisterIntAttribute("maxFileSize", 270);
        this.bcmStoreAndRegisterStringAttribute(FILE_LOCATION, "");
        this.initAlarmStatus(0, context);
        this.myData.setRevision(4010101);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void serviceAvailable(String proxyName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "serviceAvailable() " + proxyName);
        if (this.resLayerRestarted) {
            this.resLayerRestarted = false;
            if (this.scannerState == PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE) {
                MessageLog.trace(7, this.getClass(), " Requesting GPEH Scanner cleanup at Resource Layer Restart. ");
                try {
                    this.ncGpehScannerProxy.cleanup(0, FILE_LOCATION);
                }
                catch (Exception e) {
                    MessageLog.trace(7, this.getClass(), " Failed cleanup towards BC part of GPEH Scanner: " + e.getMessage());
                }
                if (this.filterSuccessfullySet) {
                    MessageLog.trace(7, this.getClass(), " Requesting GPEH Scanner reactivation at Resource Layer Restart. ");
                    try {
                        for (int i = 0; i < NO_SUPPORTED_ATTRS; ++i) {
                            String aSupportedAttr = SUPPORTED_OBSERVATION_ATTRIBUTES[i];
                            if (!this.contains(aSupportedAttr, this.attrsObserved)) continue;
                            NodeBFunctionMo observedMo = this.findNodeBFunctionMo();
                            observedMo.gpehEvAttrAccessAdmitOff(aSupportedAttr);
                        }
                        this.eventSubscription.stop();
                        this.activateScanner();
                    }
                    catch (MoNotFoundException e) {
                        MessageLog.trace(7, this.getClass(), " Failed reactivation of GPEH Scanner: " + e.getMessage());
                        MessageLog.trace(7, this.getClass(), " Resetting GPEH Scanner State to SUSPENDED. ");
                        this.scannerState = PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
                        this.eventSubscription = null;
                    }
                    catch (FailedException e) {
                        MessageLog.trace(7, this.getClass(), " Failed reactivation of GPEH Scanner: " + e.getMessage());
                        MessageLog.trace(7, this.getClass(), " Resetting GPEH Scanner State to SUSPENDED. ");
                        this.scannerState = PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
                        this.eventSubscription = null;
                    }
                    MessageLog.trace(7, this.getClass(), " GPEH Scanner actions at Resource Layer Restart completed. ");
                } else {
                    MessageLog.traceError(this.getClass(), " GPEH Scanner implementation in ACTIVE state at Resource Layer Restart, but setFilter not successfully completed");
                }
            }
        }
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved()");
        this.resLayerRestarted = true;
    }

    public String getType() {
        return "PredefRbsScannerGpeh";
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "PredefRbsScannerGpeh", context);
        this.sendAVC("userLabel", value, context);
    }

    public int getScanState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getScanState() ");
        if (this.scannerState == PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE) {
            return 1;
        }
        return 0;
    }

    public int getMaxStorageSize(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxStorageSize() ");
        return this.bcmGetIntAttribute("maxStorageSize", context);
    }

    public void setMaxStorageSize(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMaxStorageSize() ");
        if (this.scannerState == PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE) {
            String msg = " maxStorageSize cannot be set while in ACTIVE state ";
            MessageLog.trace(2, this.getClass(), msg);
            throw new FailedException();
        }
        int maxFileSize = value;
        this.bcmSetIntAttribute("maxFileSize", maxFileSize, MAX_FILE_SIZE_MIN_VALUES, MAX_FILE_SIZE_MAX_VALUES, "PredefRbsScannerGpeh", context);
        this.bcmSetIntAttribute("maxStorageSize", value, MAX_STORAGE_SIZE_MIN_VALUES, MAX_STORAGE_SIZE_MAX_VALUES, "PredefRbsScannerGpeh", context);
        this.sendAVC("maxStorageSize", value, context);
    }

    public int getMaxFileSize(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxFileSize() ");
        return this.bcmGetIntAttribute("maxFileSize", context);
    }

    public String getFileLocation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFileLocation() ");
        return FILE_LOCATION;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setScannerState(PerformanceIRPConstDefs.PerformanceMonitoringState state) throws FailedException {
        MessageLog.traceEnter(this.getClass(), "setScannerState() ");
        if (state == this.scannerState) {
            MessageLog.trace(2, this.getClass(), " Scanner already is in requested state - no action taken.");
            return;
        }
        if (state == PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE) {
            if (this.filterSuccessfullySet) {
                this.activateScanner();
                this.scannerState = PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE;
                MessageLog.trace(2, this.getClass(), "setScannerState(ACTIVE) completed OK.");
                return;
            }
            MessageLog.trace(2, this.getClass(), " Cannot activate GPEH before a filter is set.");
            throw new FailedException();
        }
        if (state == PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED) {
            this.suspendScanner();
            this.scannerState = PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
            MessageLog.trace(2, this.getClass(), "setScannerState(SUSPENDED) completed OK.");
            return;
        }
        MessageLog.traceError(this.getClass(), " Unknown scannerState - SW Fault.");
        throw new FailedException();
    }

    public ScannerInfo getScannerInfo() {
        MessageLog.traceEnter(this.getClass(), "getScannerInfo()");
        String pmsiUserLabel = SCANNER_NAME_PMS;
        return new ScannerInfo(PMS_GENERIC_SCANNER_ID, pmsiUserLabel, this.scannerState, emptyObsClasses, this.observationObjectList, GranularityPeriod.MINUTES_15, GranularityPeriod.MINUTES_15);
    }

    private void setFilter(RecordingType recording_type, PerformanceIRPConstDefs.ObservationObject triggering_object, PerformanceIRPConstDefs.ObservationObject[] observation_object_list, PerformanceIRPConstDefs.Filter filter, int[] time_window, int sampling_rate) throws FailedException {
        MessageLog.traceEnter(this.getClass(), "setFilter() ");
        if (this.scannerState == PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE) {
            String msg = " Filter operation not allowed while in ACTIVE state.";
            MessageLog.trace(1, this.getClass(), msg);
            throw new FailedException();
        }
        if (observation_object_list.length != 1) {
            String msg = " Filter operation invoked with unsupported Observation Object List contents.";
            MessageLog.trace(1, this.getClass(), msg);
            throw new FailedException();
        }
        String[] requestedObsInstanceList = observation_object_list[0].instance_list;
        if (requestedObsInstanceList.length != 1) {
            String msg = " Filter operation invoked with unsupported Observation Object Instance List contents.";
            MessageLog.trace(1, this.getClass(), msg);
            throw new FailedException();
        }
        String requestedObsObject = requestedObsInstanceList[0];
        if (!requestedObsObject.equals(SUPPORTED_OBS_OBJ_PMS)) {
            String msg = " Filter operation invoked with unsupported Observation Object \"" + requestedObsObject + "\".";
            MessageLog.trace(1, this.getClass(), msg);
            throw new FailedException();
        }
        String[] requestedObsAttributes = observation_object_list[0].instance_attribute_list;
        int lReq = requestedObsAttributes.length;
        this.setFilterData(lReq, requestedObsAttributes);
        this.recordingType = recording_type;
        this.triggeringObject = triggering_object;
        this.observationObjectList = observation_object_list;
        this.filter = filter;
        this.timeWindow = time_window;
        this.samplingRate = sampling_rate;
    }

    private void setFilterData(int lReq, String[] requestedObsAttributes) throws FailedException {
        MessageLog.traceEnter(this.getClass(), "setFilterData() ");
        if (lReq < 1) {
            String msg = " Filter operation invoked without any event attributes.";
            MessageLog.trace(1, this.getClass(), msg);
            throw new FailedException();
        }
        for (int i = 0; i < lReq; ++i) {
            String aRequestedAttr = requestedObsAttributes[i];
            if (this.contains(aRequestedAttr, SUPPORTED_OBSERVATION_ATTRIBUTES)) continue;
            String msg = " Filter operation invoked with unsupported event attribute \"" + aRequestedAttr + "\".";
            MessageLog.trace(1, this.getClass(), msg);
            throw new FailedException();
        }
        for (int ind = 0; ind < NO_SUPPORTED_ATTRS; ++ind) {
            String aSupportedAttr = SUPPORTED_OBSERVATION_ATTRIBUTES[ind];
            this.attrsObserved[ind] = this.contains(aSupportedAttr, requestedObsAttributes) ? aSupportedAttr : null;
        }
        this.filterSuccessfullySet = true;
        MessageLog.trace(1, this.getClass(), " Filter data successfully set.");
    }

    public void lookupFilter(RecordingTypeHolder recording_type, ObservationObjectHolder triggering_object, ObservationObjectListHolder observation_object_list, FilterHolder filter, TimeWindowHolder time_window, IntHolder sampling_rate) throws FailedException {
        MessageLog.traceEnter(this.getClass(), "lookupFilter() ");
        if (!this.filterSuccessfullySet) {
            MessageLog.trace(2, this.getClass(), " Lookup  Filter invoked before a filter is set; returning defaults /empty values.");
        }
        recording_type.value = this.recordingType;
        triggering_object.value = this.triggeringObject;
        observation_object_list.value = this.observationObjectList;
        filter.value = this.filter;
        time_window.value = this.timeWindow;
        sampling_rate.value = this.samplingRate;
    }

    private boolean contains(String attr, String[] attrs) {
        MessageLog.traceEnter(this.getClass(), "contains() ");
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i] == null || !attr.equalsIgnoreCase(attrs[i])) continue;
            return true;
        }
        return false;
    }

    private void activateScanner() throws FailedException {
        MessageLog.traceEnter(this.getClass(), " activateScanner() ");
        try {
            IntegerAttribute maxStorageSizeAttribute = (IntegerAttribute)this.myData.getAttribute("maxStorageSize");
            int maxStorageSize = maxStorageSizeAttribute.getValue(null);
            IntegerAttribute maxFileSizeAttribute = (IntegerAttribute)this.myData.getAttribute("maxFileSize");
            int maxFileSize = maxFileSizeAttribute.getValue(null);
            ManagedElementMo managedElement = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
            String meUserLabel = managedElement.getUserLabel(null);
            String meLogicalName = managedElement.getLogicalName(null);
            MessageLog.trace(2, this.getClass(), "activateScanner(): Collect in-paramters for proxy call is done.");
            this.eventSubscription = EventSubscription.create((String)GPEH_SCANNER_SERVICE_TAG, (long)1L);
            MessageLog.trace(2, this.getClass(), "activateScanner():Renew event subscription with PMSIl is done.");
            BcGpehEventS[] gpehEvent = new BcGpehEventS[NO_SUPPORTED_ATTRS];
            int j = 0;
            for (int i = 0; i < NO_SUPPORTED_ATTRS; ++i) {
                if (this.attrsObserved[i] == null) continue;
                String anObservedAttribute = this.attrsObserved[i];
                NodeBFunctionMo observedMo = this.findNodeBFunctionMo();
                String ldnObservedMo = observedMo.getLocalDistinguishedName();
                int eventId = observedMo.gpehEvAttrName2EvId(anObservedAttribute);
                MessageLog.trace(2, this.getClass(), "activateScanner():Event ID provided by NodeBFunction:" + eventId);
                int pmsId = (int)this.eventSubscription.addEventAttribute(ldnObservedMo, anObservedAttribute);
                MessageLog.trace(2, this.getClass(), "activateScanner():pmsId:" + pmsId);
                gpehEvent[j] = new BcGpehEventS(eventId, pmsId);
                observedMo.gpehEvAttrAccessAdmitOn(anObservedAttribute);
                ++j;
            }
            int nrOfObservedAttributes = j;
            MessageLog.trace(2, this.getClass(), "activateScanner():Add attributes to the subscription is done.");
            this.eventSubscription.start();
            MessageLog.trace(2, this.getClass(), "activateScanner():Activate the subscriptions with the start method.");
            this.ncGpehScannerProxy.activateScanner(0, maxStorageSize, maxFileSize, meUserLabel, meLogicalName, nrOfObservedAttributes, gpehEvent, FILE_LOCATION);
            MessageLog.trace(2, this.getClass(), "activateScanner():Activate the [f]RO side of the scanner is done.");
        }
        catch (FroNotAccessibleException e) {
            MessageLog.trace(2, this.getClass(), " cannot access GPEH in BC: " + e.getMessage());
            throw new FailedException();
        }
        catch (FroRequestFailedException e) {
            MessageLog.trace(2, this.getClass(), " cannot activate GPEH in BC: " + e.getMessage());
            throw new FailedException();
        }
        catch (ServiceNotCompleteException e) {
            MessageLog.trace(2, this.getClass(), " cannot activate service in PMS: " + e.getMessage());
            throw new FailedException();
        }
        catch (SubscriptionFailureException e) {
            MessageLog.trace(2, this.getClass(), " cannot subscribe to PMS: " + e.getMessage());
            throw new FailedException();
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), " cannot get() from ManagedElement: " + e.getMessage());
            throw new FailedException();
        }
    }

    private void suspendScanner() throws FailedException {
        MessageLog.traceEnter(this.getClass(), " suspendScanner() ");
        try {
            NodeBFunctionMo observedMo = this.findNodeBFunctionMo();
            for (int i = 0; i < NO_SUPPORTED_ATTRS; ++i) {
                String aSupportedAttr = SUPPORTED_OBSERVATION_ATTRIBUTES[i];
                if (this.contains(aSupportedAttr, this.attrsObserved)) {
                    observedMo.gpehEvAttrAccessAdmitOff(aSupportedAttr);
                    continue;
                }
                observedMo.gpehEvAttrSetOff(aSupportedAttr);
            }
            this.eventSubscription.stop();
            MessageLog.trace(2, this.getClass(), "suspendScanner(): stop event generation for observed event attributes.");
            this.eventSubscription = null;
            this.ncGpehScannerProxy.suspendScanner(0);
            MessageLog.trace(2, this.getClass(), "suspendScanner(): stop the [f]RO side of the scanner.");
        }
        catch (FroNotAccessibleException e) {
            MessageLog.trace(2, this.getClass(), " cannot access GPEH in BC: " + e.getMessage());
            throw new FailedException();
        }
        catch (FroRequestFailedException e) {
            MessageLog.trace(2, this.getClass(), " cannot suspend GPEH in BC: " + e.getMessage());
            throw new FailedException();
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), " cannot access GPEH in MO NodeBFunction " + e.getMessage());
        }
    }

    private NodeBFunctionMo findNodeBFunctionMo() throws MoNotFoundException {
        int seekDepth = 2;
        MoIterator iter = BoamHelper.findMOs("NodeBFunction", 2);
        if (!iter.hasMoreElements()) {
            throw new MoNotFoundException(this.getType());
        }
        return (NodeBFunctionMo)iter.nextMo();
    }

    public void setState(PerformanceMonitoringState state) throws OverloadException {
        MessageLog.traceEnter(this.getClass(), "setState() ");
        PerformanceIRPConstDefs.PerformanceMonitoringState newState = PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
        if (state == PerformanceMonitoringState.ACTIVE) {
            newState = PerformanceIRPConstDefs.PerformanceMonitoringState.ACTIVE;
        }
        if (state == PerformanceMonitoringState.SUSPENDED) {
            newState = PerformanceIRPConstDefs.PerformanceMonitoringState.SUSPENDED;
        }
        try {
            this.setScannerState(newState);
        }
        catch (FailedException fe) {
            throw new OverloadException();
        }
    }

    private static PerformanceMonitoringState intToState(int intState) {
        MessageLog.traceEnter(SELF, "intToState() ");
        switch (intState) {
            case 0: {
                return PerformanceMonitoringState.SUSPENDED;
            }
            case 1: {
                return PerformanceMonitoringState.ACTIVE;
            }
        }
        throw new IllegalArgumentException();
    }

    public MonitoringTaskInfo getTaskInfo() {
        MessageLog.traceEnter(this.getClass(), "getTaskInfo() ");
        try {
            ObservationObject[] obsObj;
            if (this.filterInfo != null) {
                obsObj = this.filterInfo.getObservationObjectList();
            } else {
                MessageLog.trace(2, this.getClass(), " The filterInfo is not initiated, initating with empty ObservationObject[].");
                obsObj = new ObservationObject[]{};
            }
            return new MonitoringTaskInfo(PMS_GENERIC_SCANNER_ID, SCANNER_NAME_PMS, PredefRbsScannerGpehMoImpl.intToState(this.getScanState(null)), emptyObservationClasses, obsObj, GranularityPeriod.MINUTES_15, GranularityPeriod.MINUTES_15);
        }
        catch (MoAccessException e) {
            return null;
        }
    }

    public void delete() throws InvalidPerformanceMonitoringTypeException {
        MessageLog.traceEnter(this.getClass(), "delete() InvalidPerformanceMonitoringTypeException to be thrown");
        throw new InvalidPerformanceMonitoringTypeException();
    }

    public void setFilter(FilterInfo filterInfo) throws InvalidPerformanceMonitoringTypeException, InvalidObservationObjectListException, InvalidFilterException, InvalidTriggeringObjectException {
        MessageLog.traceEnter(this.getClass(), "setFilter()");
        RecordingType recordingType = this.convertFromPmsRecordingType(filterInfo.getRecordingType());
        PerformanceIRPConstDefs.ObservationObject obsObject = this.convertFromPmsOneObject(filterInfo.getTriggeringObject());
        PerformanceIRPConstDefs.ObservationObject[] obsObList = this.convertFromPmsObject(filterInfo.getObservationObjectList());
        PerformanceIRPConstDefs.Filter filter = this.convertToPmsFilter(filterInfo.getFilter());
        int[] timeWindow = filterInfo.getTimeWindow();
        this.filterInfo = filterInfo;
        try {
            this.setFilter(recordingType, obsObject, obsObList, filter, timeWindow, filterInfo.getSamplingRate());
        }
        catch (FailedException fe) {
            // empty catch block
        }
    }

    public FilterInfo lookupFilter() throws InvalidPerformanceMonitoringTypeException {
        MessageLog.traceEnter(this.getClass(), "lookupFilter()");
        return this.filterInfo;
    }

    private PerformanceIRPConstDefs.ObservationObject convertFromPmsOneObject(ObservationObject obsObj) {
        PerformanceIRPConstDefs.ObservationObject obs_obj = new PerformanceIRPConstDefs.ObservationObject(obsObj.instance_list, obsObj.instance_attribute_list);
        return obs_obj;
    }

    private PerformanceIRPConstDefs.Filter convertToPmsFilter(Filter filter) {
        PerformanceIRPConstDefs.Filter newFilter = new PerformanceIRPConstDefs.Filter(filter.attribute_name, filter.attribute_value);
        return newFilter;
    }

    private PerformanceIRPConstDefs.ObservationObject[] convertFromPmsObject(ObservationObject[] obsObjList) {
        PerformanceIRPConstDefs.ObservationObject[] result2 = new PerformanceIRPConstDefs.ObservationObject[obsObjList.length];
        for (int i = 0; i < obsObjList.length; ++i) {
            result2[i] = new PerformanceIRPConstDefs.ObservationObject(obsObjList[i].instance_list, obsObjList[i].instance_attribute_list);
        }
        return result2;
    }

    private RecordingType convertFromPmsRecordingType(se.ericsson.cello.pms.generic.RecordingType type) {
        if (type.value() == 0) {
            return RecordingType.EVENT_DATA;
        }
        if (type.value() == 1) {
            return RecordingType.MEASUREMENT_DATA;
        }
        return RecordingType.EVENT_AND_MESUREMENT_DATA;
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.ncGpehScannerProxy, froType, -2, context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return -2;
    }

    static {
        PMS_GENERIC_SCANNER_ID = new ScannerId(SCANNER_NAME_PMS);
        emptyObsClasses = new PerformanceIRPConstDefs.ObservationClass[0];
        SUPPORTED_OBSERVATION_ATTRIBUTES = new String[]{"gpehOverloadProtEv", "gpehUlSyncReachedEv", "gpehRlsSupStartedEv", "gpehRlsSupSyncEv", "gpehRlsSupLostSyncEv", "gpehRlsSupFoundSyncEv", "gpehRlsSupFailSyncEv"};
        NO_SUPPORTED_ATTRS = SUPPORTED_OBSERVATION_ATTRIBUTES.length;
    }
}

