/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmPreCondition;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;
import se.ericsson.wcdma.rbs.boam.pms.iface.Scannable;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.GroupScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsConst;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class MoScanner
implements Scannable,
FroStateObserver,
PmPreCondition {
    private static final int MAX_NUM_TRIES = 3;
    private static final int SLEEP_TIME = 3000;
    private final ManagedObject myMo;
    private final boolean isRecovery;
    private final Map counterScanners = new HashMap();
    private final ProxyScanner myProxy;
    private final int froId;
    private final int[] additionalInfo;
    private final int bbPoolId;
    private boolean creationCommitted = false;
    private List counterList;

    public MoScanner(ManagedObject mo, ProxyScanner proxy, int froId, int bbPoolId, List counters, int[] additionalInfo, boolean isRecovery, Coordinator context) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "MoScanner()");
        this.checkMo(mo);
        this.checkProxy(proxy);
        this.checkCounters(counters);
        this.myMo = mo;
        this.counterList = counters;
        this.isRecovery = isRecovery;
        this.myProxy = proxy;
        this.froId = froId;
        this.additionalInfo = additionalInfo;
        this.bbPoolId = bbPoolId;
        ((FroProxy)((Object)this.myProxy)).registerForStatePropagation(context, this);
        if (context == null) {
            this.commitCreate(counters);
        } else {
            try {
                context.registerResource((Resource)new PmsResource(this, counters));
            }
            catch (InactiveTransactionException e) {
                throw new TransactionRequiredException();
            }
        }
    }

    private void checkCounters(List counters) throws PmsException {
        if (counters == null || counters.size() == 0) {
            MessageLog.trace(3, this.getClass(), "The counters list is null or empty!!");
            throw new PmsException("The counters list is null or empty!!");
        }
    }

    private void checkMo(ManagedObject aMo) throws PmsException {
        if (aMo == null) {
            MessageLog.trace(3, this.getClass(), "Mo reference is null!!");
            throw new PmsException(" Mo reference is null");
        }
    }

    private void checkProxy(ProxyScanner aMo) throws PmsException {
        if (aMo == null) {
            MessageLog.trace(3, this.getClass(), "Proxy reference is null!!");
            throw new PmsException(" Proxy reference is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCreate(List counters) {
        MessageLog.trace(3, this.getClass(), "commitCreate()");
        HashMap<String, GroupScanner> groupScannerList = new HashMap<String, GroupScanner>(1);
        Map map = this.counterScanners;
        synchronized (map) {
            Iterator iterator = counters.iterator();
            while (iterator.hasNext()) {
                Counter counter = (Counter)iterator.next();
                CounterGroup cntGroup = counter.getGroup();
                try {
                    if (cntGroup != null) {
                        GroupScanner groupScanner;
                        if (!groupScannerList.containsKey(cntGroup.getGroupName())) {
                            groupScanner = new GroupScanner(this, cntGroup);
                            groupScannerList.put(cntGroup.getGroupName(), groupScanner);
                        } else {
                            groupScanner = (GroupScanner)groupScannerList.get(cntGroup.getGroupName());
                        }
                        this.counterScanners.put(counter.getName(), new CounterScanner(groupScanner, counter, this.isRecovery));
                        continue;
                    }
                    this.counterScanners.put(counter.getName(), new CounterScanner(this, counter, this.isRecovery));
                }
                catch (PmsException pmse) {
                    MessageLog.traceError(this.getClass(), "Couldn't create CounterScanner for counter: " + counter.getName(), (Throwable)((Object)pmse));
                }
            }
        }
        this.creationCommitted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitDelete() {
        MessageLog.trace(3, this.getClass(), "commitDelete()");
        CounterScanner scanObj = null;
        Map map = this.counterScanners;
        synchronized (map) {
            Collection list = this.counterScanners.values();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                scanObj = (CounterScanner)iter.next();
                scanObj.delete();
            }
            this.counterScanners.clear();
        }
    }

    public boolean isPmCounterStartable(String name, Coordinator context) throws MoAccessException {
        return ((BoamManagedObject)this.myMo).isPmCounterStartable(name, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "delete()");
        Map map = this.counterScanners;
        synchronized (map) {
            ((FroProxy)((Object)this.myProxy)).deregisterForStatePropagation(context, this);
            Collection list = this.counterScanners.values();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                CounterScanner scanObj = (CounterScanner)iter.next();
                scanObj.stop();
            }
        }
        if (context == null) {
            this.commitDelete();
        } else {
            try {
                context.registerResource((Resource)new PmsResource(this));
            }
            catch (InactiveTransactionException e) {
                throw new TransactionRequiredException();
            }
        }
    }

    public String getFDN() {
        return this.myMo.getFullDistinguishedName();
    }

    public String getLDN() {
        return this.myMo.getLocalDistinguishedName();
    }

    public String getTypeName() {
        return this.myMo.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getValue(String counterName) {
        CounterScanner counterScanner;
        MessageLog.trace(3, this.getClass(), "getValue(), counter name: " + counterName);
        Map map = this.counterScanners;
        synchronized (map) {
            counterScanner = (CounterScanner)this.counterScanners.get(counterName);
        }
        if (counterScanner == null) {
            MessageLog.traceError(this.getClass(), "MO: " + this.myMo.getLocalDistinguishedName() + ", counter not found: " + counterName);
            return PmsConst.getCounterDefaultArray(counterName);
        }
        if (!counterScanner.isCounterScannerActive()) {
            MessageLog.trace(3, this.getClass(), "getValue(), counter name: " + counterName + ", is not active!");
            int counterLength = this.getCounterLength(counterName);
            int[] returnArray = new int[counterLength];
            for (int index = 0; index < counterLength; ++index) {
                returnArray[index] = -1;
            }
            return returnArray;
        }
        MessageLog.trace(3, this.getClass(), "getValue(), counter name: " + counterName + " is active");
        return counterScanner.getValue();
    }

    private int getCounterLength(String counterName) {
        int counterLength = 1;
        Iterator ite = this.counterList.iterator();
        while (ite.hasNext()) {
            Counter singleCounter = (Counter)ite.next();
            if (!singleCounter.getName().equalsIgnoreCase(counterName)) continue;
            counterLength = singleCounter.getNoOfReturnElements();
            break;
        }
        return counterLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAvailable(String proxyName) {
        MessageLog.trace(3, this.getClass(), "serviceAvailable()");
        if (!this.creationCommitted) {
            for (int numTries = 0; !this.creationCommitted && numTries < 3; ++numTries) {
                MessageLog.trace(3, this.getClass(), "Creation not committed, waiting 3000 ms, try no " + (numTries + 1));
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        Map map = this.counterScanners;
        synchronized (map) {
            if (this.creationCommitted) {
                CounterScanner scanObj = null;
                Collection list = this.counterScanners.values();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    scanObj = (CounterScanner)iter.next();
                    scanObj.proxiesAvailable();
                }
            } else {
                MessageLog.traceError(this.getClass(), "Not possible to start all counters after service became published, creation not committed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(String proxyName) {
        MessageLog.trace(3, this.getClass(), "serviceRemoved()");
        Map map = this.counterScanners;
        synchronized (map) {
            CounterScanner scanObj = null;
            Collection list = this.counterScanners.values();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                scanObj = (CounterScanner)iter.next();
                scanObj.proxiesUnavailable();
            }
        }
    }

    public ScannedValue[] scan(String name) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "scan(),name:" + name + ", Mo: " + this.getFDN());
        return this.myProxy.getPmsAttribute(name, this.froId, this.bbPoolId, this.additionalInfo);
    }

    public void start(String counterOrGroupName, int granularityPeriod) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "start(), name: " + counterOrGroupName + ", granularityPeriod: " + granularityPeriod + ", Mo: " + this.getFDN());
        this.myProxy.pmsStart(counterOrGroupName, granularityPeriod, this.froId, this.bbPoolId, this.additionalInfo);
    }

    public void stop(String name) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "stop(),name:" + name + ", Mo: " + this.getFDN());
        this.myProxy.pmsStop(name, this.froId, this.bbPoolId, this.additionalInfo);
    }

    private static class PmsResource
    implements Resource {
        private final boolean atCreate;
        private final MoScanner delegate;
        private final List counters;

        public PmsResource(MoScanner moScanner, List counters) {
            this.delegate = moScanner;
            this.atCreate = true;
            this.counters = counters;
        }

        public PmsResource(MoScanner moScanner) {
            this.delegate = moScanner;
            this.atCreate = false;
            this.counters = null;
        }

        public void commit() {
            if (this.atCreate) {
                this.delegate.commitCreate(this.counters);
            } else {
                this.delegate.commitDelete();
            }
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }
}

