/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.pms.iface.PredefinedScannerState;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.RBScanner;

public class PredefinedScannerMgr {
    public static final int TX_TIME_OUT = 30;
    public static final int MASK_ALL = 3;
    public static final int NOT_CREATED = 0;
    public static final int CREATED_SUSPENDED = 1;
    public static final int CREATED_ACTIVE = 3;
    public static final int DELETED = 2;
    public static final String SCANNER_NAME_PREFIX = "PREDEF.";
    public static final String SCANNER_NAME_SUFFIX = ".STATS";
    public static final String SCANNER_NAME = "PREDEF.PRIMARY.STATS";
    private static PredefinedScannerMgr uniqueInstance = new PredefinedScannerMgr();
    private boolean isOmInitiated = false;
    private HashMap createdPredefinedScannerList = new HashMap(1);
    private PredefinedScannerState nodeBFunctionMo = null;
    private HashMap rbsPredefinedScannerList = new HashMap(1);

    private PredefinedScannerMgr() {
    }

    public void createPredefinedScanner(String scannerName, String[] classnames, String[][] counterArray, int mask) {
        MessageLog.trace(3, this.getClass(), "createPredefinedScanner() scannerName:" + scannerName);
        if (this.rbsPredefinedScannerList.containsKey(scannerName)) {
            PredefinedScanner predefScanner = (PredefinedScanner)this.rbsPredefinedScannerList.get(scannerName);
            for (int i = 0; i < classnames.length; ++i) {
                if (this.rbsPredefinedScannerList.containsValue(classnames[i])) continue;
                try {
                    predefScanner.addCountersForMo(classnames[i], counterArray[i]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    MessageLog.traceError(this.getClass(), "ArrayIndexOutOfBounds: index = " + i);
                }
            }
        } else {
            this.addToPredefinedScannerList(new PredefinedScanner(scannerName, classnames, counterArray, mask));
        }
    }

    public static PredefinedScannerMgr instance() {
        return uniqueInstance;
    }

    public synchronized void addToCreatedPredefScannerList(RBScanner predefScanner) throws PmsException {
        MessageLog.trace(3, this.getClass(), "addToCreatedPredefScannerList()");
        if (predefScanner == null || this.isUserDefScanner(predefScanner.getName())) {
            return;
        }
        if (this.createdPredefinedScannerList.containsKey(predefScanner.getName())) {
            MessageLog.traceError(this.getClass(), "Predefined Scanner already is created: " + predefScanner.getName());
            throw new PmsException("Predefined Scanner already is created: " + predefScanner.getName());
        }
        if (!this.verifyCounterList(predefScanner)) {
            MessageLog.trace(3, this.getClass(), "Created Predefined Scanner has out-of-date counter list: " + predefScanner.getName());
            throw new PmsException("Predefined Scanner has out-of-date counter list: " + predefScanner.getName());
        }
        this.createdPredefinedScannerList.put(predefScanner.getName(), predefScanner);
    }

    private boolean verifyCounterList(RBScanner rbScanner) {
        MessageLog.trace(3, this.getClass(), "verifyCounterList() for created RBScanner " + rbScanner.getName());
        ObservationClass[] ocList = rbScanner.getObservationClassList();
        PredefinedScanner predefScr = (PredefinedScanner)this.rbsPredefinedScannerList.get(rbScanner.getName());
        if (predefScr == null) {
            MessageLog.trace(3, this.getClass(), "Created Scanner not found among predefined scanners " + rbScanner.getName());
            return false;
        }
        if (predefScr.counterArray.length != ocList.length) {
            MessageLog.trace(3, this.getClass(), "Created/Predefined Scanners have different numbers of counters: " + ocList.length + "/" + predefScr.counterArray.length);
            return false;
        }
        for (int i = 0; i < ocList.length; ++i) {
            int classIndex = this.getIndex(predefScr.classnames, ocList[i].object_class_name);
            if (classIndex != -1) {
                if (predefScr.counterArray[classIndex].length != ocList[i].class_attribute_list.length) {
                    MessageLog.trace(3, this.getClass(), "Different number of counters in CPP-request VS. predefined scanner for mo : " + ocList[i].object_class_name);
                    return false;
                }
                for (int j = 0; j < ocList[i].class_attribute_list.length; ++j) {
                    int counterIndex = this.getIndex(predefScr.counterArray[classIndex], ocList[i].class_attribute_list[j]);
                    if (counterIndex != -1) continue;
                    MessageLog.trace(3, this.getClass(), "The counter " + ocList[i].class_attribute_list[j] + " was not found in predef scanner");
                    return false;
                }
                continue;
            }
            MessageLog.trace(3, this.getClass(), "Class name in CPP request does not correspond to the predef scanner " + ocList[i].object_class_name);
            return false;
        }
        return true;
    }

    private void checkAllRBSPredefScanner() {
        MessageLog.trace(3, this.getClass(), "checkAllRBSPredefScanner()");
        Set set = this.rbsPredefinedScannerList.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PredefinedScanner predef = (PredefinedScanner)this.rbsPredefinedScannerList.get(name);
            if (predef == null) continue;
            this.checkRBSPredefScanner(predef);
        }
    }

    private void checkRBSPredefScanner(PredefinedScanner scan) {
        MessageLog.trace(3, this.getClass(), "checkRBSPredefScanner()");
        if (!this.createdPredefinedScannerList.containsKey(scan.scannerName) && scan.state != 2) {
            this.createScanner(scan);
        } else {
            MessageLog.trace(3, this.getClass(), "No need to create RBS Predefined Scanner. It is externally deleted : " + scan.scannerName);
        }
    }

    private synchronized void createScanner(PredefinedScanner scan) {
        MessageLog.trace(3, this.getClass(), "createScanner()");
        ObservationClass[] obsClass = new ObservationClass[scan.classnames.length];
        int granPeriod = 900;
        int stateInfo = 3;
        for (int i = 0; i < scan.classnames.length; ++i) {
            obsClass[i] = new ObservationClass(scan.classnames[i], scan.counterArray[i]);
        }
        PerformanceMonitoringState state = null;
        if (scan.state == 1) {
            state = PerformanceMonitoringState.SUSPENDED;
            stateInfo = 1;
        } else {
            state = PerformanceMonitoringState.ACTIVE;
        }
        try {
            if (PmsPortalImpl.getPortal().createPerformanceMonitoring(obsClass, new ObservationObject[0], granPeriod, scan.scannerName, state) < 0) {
                MessageLog.trace(3, this.getClass(), "Failed to create RBS Predefined Scanner:" + scan.scannerName);
            } else {
                scan.state = stateInfo;
            }
        }
        catch (Exception e) {
            MessageLog.trace(3, this.getClass(), "Failed to create RBS Predefined Scanner:" + scan.scannerName + e);
        }
    }

    private boolean isUserDefScanner(String name) {
        return !name.startsWith(SCANNER_NAME_PREFIX) || !name.endsWith(SCANNER_NAME_SUFFIX);
    }

    private void addToPredefinedScannerList(PredefinedScanner predefScanner) {
        MessageLog.trace(3, this.getClass(), "addToPredefinedScannerList()");
        if (!this.rbsPredefinedScannerList.containsKey(predefScanner.scannerName)) {
            this.rbsPredefinedScannerList.put(predefScanner.scannerName, predefScanner);
        } else {
            MessageLog.trace(3, this.getClass(), "Predefined Scanner already is registered: " + predefScanner.scannerName);
        }
    }

    public synchronized void rollbackCreate(RBScanner predefScanner) {
        MessageLog.trace(3, this.getClass(), "rollbackCreate()");
        if (predefScanner == null) {
            return;
        }
        if (this.createdPredefinedScannerList.containsKey(predefScanner.getName())) {
            this.createdPredefinedScannerList.remove(predefScanner.getName());
        }
    }

    public synchronized void deleteScanner(RBScanner predefScanner) {
        MessageLog.trace(3, this.getClass(), "deleteScanner()");
        if (predefScanner == null) {
            return;
        }
        if (this.createdPredefinedScannerList.containsKey(predefScanner.getName())) {
            this.createdPredefinedScannerList.remove(predefScanner.getName());
        }
        if (this.rbsPredefinedScannerList.containsKey(predefScanner.getName())) {
            PredefinedScanner s = (PredefinedScanner)this.rbsPredefinedScannerList.get(predefScanner.getName());
            if (this.isOmInitiated) {
                s.state = 2;
                this.setPredefinedScannerState();
            }
        }
    }

    public void actviateSuspend(RBScanner predefScanner, int state) {
        MessageLog.trace(3, this.getClass(), "actviateSuspend()");
        if (predefScanner == null) {
            return;
        }
        if (this.rbsPredefinedScannerList.containsKey(predefScanner.getName()) && this.isOmInitiated) {
            PredefinedScanner s = (PredefinedScanner)this.rbsPredefinedScannerList.get(predefScanner.getName());
            if (s.state != 2) {
                s.state = state;
                this.setPredefinedScannerState();
            }
        }
    }

    public void setPredefinedScannerState(int value, PredefinedScannerState nodeBfunctionMo) {
        MessageLog.trace(3, this.getClass(), "setPredefinedScannerState()");
        Set set = this.rbsPredefinedScannerList.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PredefinedScanner predef = (PredefinedScanner)this.rbsPredefinedScannerList.get(name);
            if (predef == null) continue;
            predef.state = value >>> predef.myMask * 2 & 3;
        }
        this.nodeBFunctionMo = nodeBfunctionMo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        String orgName = "";
        try {
            try {
                MessageLog.trace(3, this.getClass(), "start()");
                orgName = Thread.currentThread().getName();
                Thread.currentThread().setName(orgName + "_PREDEFINED_SCANNER_MGR");
                MessageLog.trace(3, this.getClass(), "The thread name is change for traceability:" + orgName + "  ==> " + orgName + "_PREDEFINED_SCANNER_MGR");
                this.checkAllRBSPredefScanner();
                this.setPredefinedScannerState();
                this.isOmInitiated = true;
            }
            catch (Exception e) {
                MessageLog.traceError(this.getClass(), "Failed to at create and update of RBS Predefined Scanners!!", e);
                Object var4_3 = null;
                MessageLog.trace(3, this.getClass(), "start() is finished, put back the thread name to orginal:" + orgName);
                Thread.currentThread().setName(orgName);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            MessageLog.trace(3, this.getClass(), "start() is finished, put back the thread name to orginal:" + orgName);
            Thread.currentThread().setName(orgName);
            throw throwable;
        }
        MessageLog.trace(3, this.getClass(), "start() is finished, put back the thread name to orginal:" + orgName);
        Thread.currentThread().setName(orgName);
    }

    private void setPredefinedScannerState() {
        MessageLog.trace(3, this.getClass(), "setPredefinedScannerState()");
        Control control = null;
        int predefinedScannerState = 0;
        Coordinator context = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(30);
            context = control.getCoordinator();
            Set set = this.rbsPredefinedScannerList.keySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                PredefinedScanner predef = (PredefinedScanner)this.rbsPredefinedScannerList.get(name);
                if (predef == null) continue;
                predefinedScannerState |= predef.state << predef.myMask * 2;
            }
            this.nodeBFunctionMo.setPredefinedScannerState(predefinedScannerState, context);
            control.getTerminator().commit();
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(this.getClass(), "Failed to update RBS Predefined Scanners state!!", e);
        }
        catch (Exception e) {
            try {
                control.getTerminator().rollback();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            MessageLog.traceError(this.getClass(), "Failed to update RBS Predefined Scanners state!!", e);
        }
    }

    private int getIndex(String[] array, String stringToSearchFor) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(stringToSearchFor)) continue;
            return i;
        }
        return -1;
    }
}

