/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMoImpl;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class AtmTrafficDescriptorMoFactory
implements MoFactory {
    private static AtmTrafficDescriptorMoFactory instance = null;

    public static synchronized AtmTrafficDescriptorMoFactory instance() {
        if (instance == null) {
            instance = new AtmTrafficDescriptorMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("AtmTrafficDescriptor");
        if (moIterator != null && moIterator.size() > 1000) {
            throw new MaxNumberExceededException("Number of AtmTrafficDescriptors is exceeded", "AtmTrafficDescriptor");
        }
        ManagedObject managedObject3 = AtmTrafficDescriptorMoImpl.create(managedObject, attrList, string, managedObject2, coordinator);
        return managedObject3;
    }

    public ManagedObject recoverMo(MoData moData) throws MoNameAlreadyTakenException {
        AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl = null;
        try {
            atmTrafficDescriptorMoImpl = new AtmTrafficDescriptorMoImpl(moData);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Recovery of AtmTrafficDescriptor MO failed!!!", (Throwable)moAccessException);
        }
        return atmTrafficDescriptorMoImpl;
    }

    public String getMoTypeName() {
        return "AtmTrafficDescriptor";
    }

    public void registerFactory() {
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    private AtmTrafficDescriptorMoFactory() {
    }
}

