/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.ipoam.IpCalc;
import se.ericsson.cello.ipoam.OamSupervisionMoGen;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;

public class OamSupervisionMoImpl
extends OamSupervisionMoGen {
    public OamSupervisionMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public OamSupervisionMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void validateIpv4Address(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (string.equals("")) {
            return;
        }
        if (!Ipv4AddressValidation.isIpv4((String)string)) {
            throw new OperationNotAllowedException("IpAddress " + string + " is not valid Ipv4Address.", "OamSupervision");
        }
        if (Ipv4AddressValidation.isLoopBackIpAddress((String)string) || Ipv4AddressValidation.isMultiCastIpAddress((String)string) || new IpCalc().isBroadcastAddress(string)) {
            throw new IllegalAttributeValueException("Loopback ipAddress or a Multicast ipAddress or a BroadCast ipAddress" + string + "  cannot be set, choose other ipAddress ", "OamSupervision");
        }
    }
}

