/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import java.util.Vector;
import se.ericsson.cello.ipoam.IpCalc;
import se.ericsson.cello.ipoam.OspfAreaMo;
import se.ericsson.cello.ipoam.OspfMo;
import se.ericsson.cello.ipoam.OspfMoImpl;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAddAreaFroRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAreaGetAttrRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAreaMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAreaRange;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAreaSetAttrRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfDelAreaFroRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfGetCountersRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfSetAreaRangeRsp;
import se.ericsson.cello.ipoam.fropxy.Osa_OspfObjId;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class OspfAreaMoImpl
extends ManagedObjectBase
implements OspfAreaMo,
Reservable {
    private MoData data;
    private IntegerAttribute ospfAreaFroId;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private static OsaOspfAreaMgmntProxy froProxy = OsaOspfAreaMgmntProxy.instance();
    String[] fieldNames = new String[3];
    private static final int OSPF_SUCCESS = 0;
    private static final String OSPF_AREA_FRO_ID = "OspfAreaFroId";
    private static final int METRIC_TYPE_COMP = 0;
    private static final int METRIC_TYPE_NONCOMP = 1;
    private static final boolean DEFAULT_STUBAREA = false;
    private static final boolean DEFAULT_IMP_EXT_LSA = true;
    private static final boolean DEFAULT_SEND_AREA_SUM = false;
    private static final int DEFAULT_METRIC = 1;
    private static final int DEFAULT_METRIC_TYPE = 0;
    private static final int MAX_NUMBER_OF_OSPFAREAS = 4;
    private static final String[] reservedClasses = new String[]{"OspfInterface"};
    private static IpCalc ipc = new IpCalc();
    private static final int MO_DATA_REVISION_35 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Ospf");
        MoAttributeValidator.checkIdentity((String)"OspfArea", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"OspfArea", (int)4);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"OspfArea", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"stubArea", (AttrList)attrList, (boolean)false, (boolean)false, (String)"OspfArea");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"importExternalLsa", (AttrList)attrList, (boolean)false, (boolean)true, (String)"OspfArea");
        boolean bl3 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"sendAreaSummary", (AttrList)attrList, (boolean)false, (boolean)false, (String)"OspfArea");
        int n = OspfAreaMoImpl.checkAndGetStubAreaMetric(attrList);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"stubAreaMetricType", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"OspfArea");
        int n3 = OspfAreaMoImpl.checkAndGetAreaId(coordinator, managedObject, attrList);
        OsaOspfAreaRange[] osaOspfAreaRangeArray = OspfAreaMoImpl.checkAndGetRanges(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"OspfArea");
        return new OspfAreaMoImpl(managedObject, bl, bl2, bl3, n, n2, n3, osaOspfAreaRangeArray, string2, string, coordinator);
    }

    public static synchronized ManagedObject autoCreateMo(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        return new OspfAreaMoImpl(managedObject, false, true, false, 1, 0, 0, new OsaOspfAreaRange[0], "defaultOspfArea", "1", coordinator);
    }

    private OspfAreaMoImpl(ManagedObject managedObject, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, OsaOspfAreaRange[] osaOspfAreaRangeArray, String string, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "OspfArea", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int n4 = ((OspfMoImpl)managedObject).getOspfFroId(coordinator);
        String string3 = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string3, n4);
        int n5 = MaoFroTypeConverter.boolean2int((boolean)bl);
        int n6 = MaoFroTypeConverter.boolean2int((boolean)bl2);
        int n7 = MaoFroTypeConverter.boolean2int((boolean)bl3);
        OsaOspfAddAreaFroRsp osaOspfAddAreaFroRsp = froProxy.sendOspfAddAreaFroReq(coordinator.getTransactionID(), osa_OspfObjId, n3, n6, n5, n, n2, n7, osaOspfAreaRangeArray);
        if (osaOspfAddAreaFroRsp == null) {
            super.delete(coordinator);
            this.data.delete(coordinator);
            throw new FroNotAccessibleException("OspfArea", "OspfArea FRO");
        }
        if (osaOspfAddAreaFroRsp.getStatus() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "CreateFroReq: " + froProxy.getResultMsg(osaOspfAddAreaFroRsp.getStatus()), osaOspfAddAreaFroRsp.getStatus());
        }
        int n8 = osaOspfAddAreaFroRsp.getFroId();
        this.ospfAreaFroId = new IntegerAttribute(OSPF_AREA_FRO_ID, false, n8);
        this.data.registerPersistentAttr((Attribute)this.ospfAreaFroId);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.data.setRevision(3500);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public OspfAreaMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(OSPF_AREA_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.ospfAreaFroId = (IntegerAttribute)moData.getAttribute(OSPF_AREA_FRO_ID);
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (this.getNamingAttributeValue().equals("1")) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("OspfArea");
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (((OspfMo)this.getParent()).getAdministrativeState(coordinator) != 0) {
            throw new MoCanNotBeDeletedException("OspfAreaOSPF parent must be LOCKED prior to delete");
        }
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        OsaOspfDelAreaFroRsp osaOspfDelAreaFroRsp = froProxy.sendOspfDelAreaFroReq(coordinator.getTransactionID(), osa_OspfObjId);
        if (osaOspfDelAreaFroRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea FRO");
        }
        if (osaOspfDelAreaFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfAreaFro", "DeleteFroReq: " + froProxy.getResultMsg(osaOspfDelAreaFroRsp.getResult()), osaOspfDelAreaFroRsp.getResult());
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("OspfArea");
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        OsaOspfDelAreaFroRsp osaOspfDelAreaFroRsp = froProxy.sendOspfDelAreaFroReq(coordinator.getTransactionID(), osa_OspfObjId);
        if (osaOspfDelAreaFroRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea FRO");
        }
        if (osaOspfDelAreaFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "DeleteFroReq: " + froProxy.getResultMsg(osaOspfDelAreaFroRsp.getResult()), osaOspfDelAreaFroRsp.getResult());
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"OspfArea", (MoData)this.data, (SequenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"OspfArea", (MoData)this.data, (SequenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"OspfArea", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public boolean getStubArea(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        int n = (int)osaOspfAreaGetAttrRsp.getAreaIsStub();
        boolean bl = MaoFroTypeConverter.int2boolean((int)n);
        return bl;
    }

    public void setStubArea(boolean bl, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{"stubArea"};
        Object[] objectArray = new Object[]{bl};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        OsaOspfAreaSetAttrRsp osaOspfAreaSetAttrRsp = froProxy.sendOspfAreaSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 23, n);
        if (osaOspfAreaSetAttrRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfAreaSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "SetAttrReq: " + froProxy.getResultMsg(osaOspfAreaSetAttrRsp.getResult()), osaOspfAreaSetAttrRsp.getResult());
        }
    }

    public boolean getImportExternalLsa(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        int n = (int)osaOspfAreaGetAttrRsp.getAreaImportExt();
        boolean bl = MaoFroTypeConverter.int2boolean((int)n);
        return bl;
    }

    public void setImportExternalLsa(boolean bl, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{"importExternalLsa"};
        Object[] objectArray = new Object[]{bl};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        OsaOspfAreaSetAttrRsp osaOspfAreaSetAttrRsp = froProxy.sendOspfAreaSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 21, n);
        if (osaOspfAreaSetAttrRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfAreaSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "SetAttrReq: " + froProxy.getResultMsg(osaOspfAreaSetAttrRsp.getResult()), osaOspfAreaSetAttrRsp.getResult());
        }
    }

    public boolean getSendAreaSummary(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        int n = (int)osaOspfAreaGetAttrRsp.getAreaStubImportSummary();
        boolean bl = MaoFroTypeConverter.int2boolean((int)n);
        return bl;
    }

    public void setSendAreaSummary(boolean bl, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{"sendAreaSummary"};
        Object[] objectArray = new Object[]{bl};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        OsaOspfAreaSetAttrRsp osaOspfAreaSetAttrRsp = froProxy.sendOspfAreaSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 26, n);
        if (osaOspfAreaSetAttrRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfAreaSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "SetAttrReq: " + froProxy.getResultMsg(osaOspfAreaSetAttrRsp.getResult()), osaOspfAreaSetAttrRsp.getResult());
        }
    }

    public int getStubAreaMetric(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        int n = (int)osaOspfAreaGetAttrRsp.getAreaStubDefCost();
        return n;
    }

    public void setStubAreaMetric(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("stubAreaMetric", "OspfArea");
        }
        String[] stringArray = new String[]{"stubAreaMetric"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        OsaOspfAreaSetAttrRsp osaOspfAreaSetAttrRsp = froProxy.sendOspfAreaSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 24, n);
        if (osaOspfAreaSetAttrRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfAreaSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "SetAttrReq: " + froProxy.getResultMsg(osaOspfAreaSetAttrRsp.getResult()), osaOspfAreaSetAttrRsp.getResult());
        }
    }

    public int getStubAreaMetricType(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        int n = (int)osaOspfAreaGetAttrRsp.getAreaStubMetricType();
        return n;
    }

    public void setStubAreaMetricType(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0 || n > 1) {
            throw new ValueOutOfRangeException("stubAreaMetricType", "OspfArea");
        }
        String[] stringArray = new String[]{"stubAreaMetricType"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        OsaOspfAreaSetAttrRsp osaOspfAreaSetAttrRsp = froProxy.sendOspfAreaSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 25, n);
        if (osaOspfAreaSetAttrRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfAreaSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "SetAttrReq: " + froProxy.getResultMsg(osaOspfAreaSetAttrRsp.getResult()), osaOspfAreaSetAttrRsp.getResult());
        }
    }

    public int getAreaLsaChecksum(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        int n = (int)osaOspfAreaGetAttrRsp.getAreaLsaChksum();
        return n;
    }

    public String getAreaId(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        String string = new IpAddress((long)((int)osaOspfAreaGetAttrRsp.getAreaId())).toString();
        return string;
    }

    public String getOspfAreaId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public int getOspfAreaFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ospfAreaFroId.getValue(coordinator);
    }

    public Struct getRange0(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        OsaOspfAreaRange[] osaOspfAreaRangeArray = osaOspfAreaGetAttrRsp.getRange();
        if (osaOspfAreaRangeArray[0] == null) {
            Struct struct = this.fillEmptyStruct();
            return struct;
        }
        Object[] objectArray = new Object[]{new IpAddress((long)((int)osaOspfAreaRangeArray[0].ipAddr)).toString(), new IpAddress((long)((int)osaOspfAreaRangeArray[0].ipMask)).toString(), MaoFroTypeConverter.int2boolean((int)((int)osaOspfAreaRangeArray[0].advert))};
        this.fieldNames[0] = "ipAddress";
        this.fieldNames[1] = "subnetMask";
        this.fieldNames[2] = "advertise";
        StructImpl structImpl = new StructImpl(this.fieldNames, objectArray);
        return structImpl;
    }

    public Struct getRange1(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        OsaOspfAreaRange[] osaOspfAreaRangeArray = osaOspfAreaGetAttrRsp.getRange();
        if (osaOspfAreaRangeArray[1] == null) {
            Struct struct = this.fillEmptyStruct();
            return struct;
        }
        Object[] objectArray = new Object[]{new IpAddress((long)((int)osaOspfAreaRangeArray[1].ipAddr)).toString(), new IpAddress((long)((int)osaOspfAreaRangeArray[1].ipMask)).toString(), MaoFroTypeConverter.int2boolean((int)((int)osaOspfAreaRangeArray[1].advert))};
        this.fieldNames[0] = "ipAddress";
        this.fieldNames[1] = "subnetMask";
        this.fieldNames[2] = "advertise";
        StructImpl structImpl = new StructImpl(this.fieldNames, objectArray);
        return structImpl;
    }

    public Struct getRange2(Coordinator coordinator) throws MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp = this.getOspfAreaAttributes(coordinator);
        OsaOspfAreaRange[] osaOspfAreaRangeArray = osaOspfAreaGetAttrRsp.getRange();
        if (osaOspfAreaRangeArray[2] == null) {
            Struct struct = this.fillEmptyStruct();
            return struct;
        }
        Object[] objectArray = new Object[]{new IpAddress((long)((int)osaOspfAreaRangeArray[2].ipAddr)).toString(), new IpAddress((long)((int)osaOspfAreaRangeArray[2].ipMask)).toString(), MaoFroTypeConverter.int2boolean((int)((int)osaOspfAreaRangeArray[2].advert))};
        this.fieldNames[0] = "ipAddress";
        this.fieldNames[1] = "subnetMask";
        this.fieldNames[2] = "advertise";
        StructImpl structImpl = new StructImpl(this.fieldNames, objectArray);
        return structImpl;
    }

    public int getPmNoOfOspfSpfRuns(Coordinator coordinator) throws MoAccessException {
        int n = 4;
        return this.getOspfAreaPmCounters(n).getPmNoOfOspfSpfRuns();
    }

    public void actionAddAreaRange(Struct struct, int n, Coordinator coordinator) throws MoAccessException {
        String string;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string2, this.ospfAreaFroId.getValue(coordinator));
        if (struct.size() > 3) {
            throw new NoSuchFieldException("Unknown field in Ospf Area Range struct");
        }
        if (n > 3 || n < 0) {
            throw new ValueOutOfRangeException("areaRange", "OspfArea");
        }
        String string3 = (String)struct.getValue("ipAddress");
        if (string3 == null | (string = (String)struct.getValue("subnetMask")) == null) {
            throw new AttrMissingAtCreateException("areaRange", "OspfArea");
        }
        OspfAreaMoImpl.checkAddressRange(string3, string);
        int n2 = new IpAddress(string3).toInt();
        int n3 = new IpAddress(string).toInt();
        OspfAreaMoImpl.checkSubnetMask(n3);
        if (!(struct.getValue("advertise") instanceof Boolean)) {
            throw new WrongAttributeTypeException("advertise", "OspfArea");
        }
        boolean bl = (Boolean)struct.getValue("advertise");
        int n4 = MaoFroTypeConverter.boolean2int((boolean)bl);
        Struct struct2 = this.getRange0(coordinator);
        Struct struct3 = this.getRange1(coordinator);
        Struct struct4 = this.getRange2(coordinator);
        if (n == 0 && (OspfAreaMoImpl.checkOverlapRanges(struct, struct3) || OspfAreaMoImpl.checkOverlapRanges(struct, struct4))) {
            throw new ValueOutOfRangeException("RANGE0 Value should be Different from Range1 and Range2 ", "OspfArea");
        }
        if (n == 1 && (OspfAreaMoImpl.checkOverlapRanges(struct, struct2) || OspfAreaMoImpl.checkOverlapRanges(struct, struct4))) {
            throw new ValueOutOfRangeException("RANGE1 Value should be Different from Range0 and Range2 ", "OspfArea");
        }
        if (n == 2 && (OspfAreaMoImpl.checkOverlapRanges(struct, struct2) || OspfAreaMoImpl.checkOverlapRanges(struct, struct3))) {
            throw new ValueOutOfRangeException("RANGE2 Value should be Different from Range0 and Range1 ", "OspfArea");
        }
        OsaOspfAreaRange osaOspfAreaRange = new OsaOspfAreaRange();
        osaOspfAreaRange.rangeI = n;
        osaOspfAreaRange.ipAddr = n2;
        osaOspfAreaRange.ipMask = n3;
        osaOspfAreaRange.advert = n4;
        OsaOspfSetAreaRangeRsp osaOspfSetAreaRangeRsp = froProxy.sendOspfSetAreaRangeReq(coordinator.getTransactionID(), osa_OspfObjId, 1, osaOspfAreaRange);
        if (osaOspfSetAreaRangeRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfSetAreaRangeRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "ActionReq: " + froProxy.getResultMsg(osaOspfSetAreaRangeRsp.getResult()), osaOspfSetAreaRangeRsp.getResult());
        }
        String[] stringArray = new String[]{"range1", "range2"};
        Object[] objectArray = new Object[]{this.getRange1(coordinator), this.getRange2(coordinator)};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public void actionDeleteAreaRange(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n > 3 || n < 0) {
            throw new ValueOutOfRangeException("areaRange", "OspfArea");
        }
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        OsaOspfAreaRange osaOspfAreaRange = new OsaOspfAreaRange();
        osaOspfAreaRange.rangeI = n;
        osaOspfAreaRange.ipAddr = 0L;
        osaOspfAreaRange.ipMask = 0L;
        osaOspfAreaRange.advert = 0L;
        OsaOspfSetAreaRangeRsp osaOspfSetAreaRangeRsp = froProxy.sendOspfSetAreaRangeReq(coordinator.getTransactionID(), osa_OspfObjId, 1, osaOspfAreaRange);
        if (osaOspfSetAreaRangeRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfSetAreaRangeRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "ActionReq: " + froProxy.getResultMsg(osaOspfSetAreaRangeRsp.getResult()), osaOspfSetAreaRangeRsp.getResult());
        }
        String[] stringArray = new String[]{"range1", "range2"};
        Object[] objectArray = new Object[]{this.getRange1(coordinator), this.getRange2(coordinator)};
        OspfAreaMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    private OsaOspfAreaGetAttrRsp getOspfAreaAttributes(Coordinator coordinator) throws FroNotAccessibleException, FroRequestFailedException, MoAccessException {
        OsaOspfAreaGetAttrRsp osaOspfAreaGetAttrRsp;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(coordinator));
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if ((osaOspfAreaGetAttrRsp = froProxy.sendOspfAreaGetAttrReq(n, osa_OspfObjId)) == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfAreaGetAttrRsp.getStatus() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "GetAttrReq: " + froProxy.getResultMsg(osaOspfAreaGetAttrRsp.getStatus()), osaOspfAreaGetAttrRsp.getStatus());
        }
        return osaOspfAreaGetAttrRsp;
    }

    private OsaOspfGetCountersRsp getOspfAreaPmCounters(int n) throws FroNotAccessibleException, FroRequestFailedException {
        long[] lArray = new long[]{n, 0L};
        String string = "OspfArea";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfAreaFroId.getValue(null));
        OsaOspfGetCountersRsp osaOspfGetCountersRsp = froProxy.sendOspfGetCountersReq(osa_OspfObjId, lArray);
        if (osaOspfGetCountersRsp == null) {
            throw new FroNotAccessibleException("OspfArea", "OspfArea Fro");
        }
        if (osaOspfGetCountersRsp.getStatus() == 100) {
            osaOspfGetCountersRsp.setPmCountersUnavailable();
        } else if (osaOspfGetCountersRsp.getStatus() != 0) {
            throw new FroRequestFailedException("OspfArea", "OspfArea", "GetAttrReq: " + froProxy.getResultMsg(osaOspfGetCountersRsp.getStatus()), osaOspfGetCountersRsp.getStatus());
        }
        return osaOspfGetCountersRsp;
    }

    public String getType() {
        return "OspfArea";
    }

    private static int checkAndGetStubAreaMetric(AttrList attrList) throws MoAccessException {
        int n = 1;
        int n2 = attrList.indexOf("stubAreaMetric");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("stubAreaMetric", "OspfArea");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("stubAreaMetric", "OspfArea");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetAreaId(Coordinator coordinator, ManagedObject managedObject, AttrList attrList) throws MoAccessException {
        String string = null;
        int n = attrList.indexOf("areaId");
        if (n == -1) {
            throw new AttrMissingAtCreateException("OspfArea", "areaId");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("areaId", "OspfArea");
        }
        string = (String)attrList.getValue(n);
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!(managedObject2 instanceof OspfAreaMoImpl) || !((OspfAreaMoImpl)managedObject2).getAreaId(coordinator).equals(string)) continue;
            throw new AttrValueNotUniqueException("areaId", "OspfArea");
        }
        int n2 = new IpAddress(string).toInt();
        attrList.removeElementAt(n);
        return n2;
    }

    private static OsaOspfAreaRange[] checkAndGetRanges(AttrList attrList) throws MoAccessException {
        Vector<OsaOspfAreaRange> vector = new Vector<OsaOspfAreaRange>();
        OsaOspfAreaRange[] osaOspfAreaRangeArray = new OsaOspfAreaRange[3];
        osaOspfAreaRangeArray[0] = OspfAreaMoImpl.checkAndGetRange0(attrList);
        if (osaOspfAreaRangeArray[0] != null) {
            vector.addElement(osaOspfAreaRangeArray[0]);
        }
        Object[] objectArray = new OsaOspfAreaRange[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static OsaOspfAreaRange checkAndGetRange0(AttrList attrList) throws MoAccessException, IpFormatException {
        String string;
        Struct struct = null;
        int n = attrList.indexOf("range0");
        OsaOspfAreaRange osaOspfAreaRange = new OsaOspfAreaRange();
        if (n == -1) {
            return null;
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("range0", "OspfArea");
        }
        struct = (Struct)attrList.getValue(n);
        if (struct.size() > 3) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        String string2 = (String)struct.getValue("ipAddress");
        if (string2 == null | (string = (String)struct.getValue("subnetMask")) == null) {
            throw new AttrMissingAtCreateException("range0", "OspfArea");
        }
        OspfAreaMoImpl.checkAddressRange(string2, string);
        int n2 = new IpAddress(string2).toInt();
        int n3 = new IpAddress(string).toInt();
        OspfAreaMoImpl.checkSubnetMask(n3);
        if (!(struct.getValue("advertise") instanceof Boolean)) {
            throw new WrongAttributeTypeException("advertise", "OspfArea");
        }
        boolean bl = (Boolean)struct.getValue("advertise");
        int n4 = MaoFroTypeConverter.boolean2int((boolean)bl);
        osaOspfAreaRange.rangeI = 0L;
        osaOspfAreaRange.ipAddr = n2;
        osaOspfAreaRange.ipMask = n3;
        osaOspfAreaRange.advert = n4;
        attrList.removeElementAt(n);
        return osaOspfAreaRange;
    }

    private static void checkSubnetMask(int n) throws IpFormatException {
        int n2 = 0;
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        if (l != 0L) {
            while ((l & 1L) == 0L) {
                l >>>= 1;
                ++n2;
            }
            if (0xFFFFFFFFL >>> n2 != l) {
                throw new IpFormatException("Wrong subnet mask for OspfArea");
            }
        }
    }

    private Struct fillEmptyStruct() throws IpFormatException {
        Object[] objectArray = new Object[]{new IpAddress(0L).toString(), new IpAddress(0L).toString(), Boolean.FALSE};
        this.fieldNames[0] = "ipAddress";
        this.fieldNames[1] = "subnetMask";
        this.fieldNames[2] = "advertise";
        StructImpl structImpl = new StructImpl(this.fieldNames, objectArray);
        return structImpl;
    }

    private Osa_OspfObjId createOspfObj(String string, int n) {
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = n;
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        return osa_OspfObjId;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    private static void checkAddressRange(String string, String string2) throws MoAccessException {
        int n;
        String string3 = ipc.calcNetworkAddress(string, string2);
        int n2 = new IpAddress(string).toInt();
        if (n2 != (n = new IpAddress(string3).toInt())) {
            throw new ValueOutOfRangeException("IP Address is not belongs to IP Mask", "OspfArea");
        }
    }

    private static boolean checkOverlapRanges(Struct struct, Struct struct2) throws MoAccessException {
        IpAddress ipAddress = new IpAddress((String)struct.getValue("ipAddress"));
        IpAddress ipAddress2 = new IpAddress((String)struct.getValue("subnetMask"));
        IpAddress ipAddress3 = new IpAddress((String)struct2.getValue("ipAddress"));
        IpAddress ipAddress4 = new IpAddress((String)struct2.getValue("subnetMask"));
        if (ipAddress.equals((Object)IpAddress.getDefaultIpAddress()) || ipAddress3.equals((Object)IpAddress.getDefaultIpAddress())) {
            return false;
        }
        if (ipc.calcNetworkAddress(ipAddress.toString(), ipAddress4.toString()).equals(ipAddress3.toString())) {
            return true;
        }
        return ipc.calcNetworkAddress(ipAddress3.toString(), ipAddress2.toString()).equals(ipAddress.toString());
    }
}

