/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

class Step2ResetAction {
    private static final Class THIS_CLASS = Step2ResetAction.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final Map moAttributeMap = new HashMap();
    private final String moName;

    protected Step2ResetAction(Map moAttributeMap, String moName) {
        this.moAttributeMap.putAll(moAttributeMap);
        this.moName = moName;
    }

    protected void reset(ConverterContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "reset()");
        Iterator moDataIt = context.getMoDataAccessor().getByType(this.moName).iterator();
        logger.traceDebug(THIS_CLASS, "Start reseting attributes for mo: " + this.moName);
        while (moDataIt.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)moDataIt.next();
            try {
                TransactionWrapper transactionWrapper = context.getTransactionWrapperFactory().create();
                moDataWrapper.handleTransaction(transactionWrapper.getCoordinator(), MoData.WRITE_ACCESS);
                Iterator moAttributeIt = this.moAttributeMap.keySet().iterator();
                while (moAttributeIt.hasNext()) {
                    String name = this.checkString((String)moAttributeIt.next(), "No attribute name specified in " + AueUtil.doubleQuote(this.getClass().getName()));
                    String value = this.checkString((String)this.moAttributeMap.get(name), "No attribute value specified in " + AueUtil.doubleQuote(this.getClass().getName()));
                    Attribute attribute = moDataWrapper.getAttribute(name);
                    this.setAttribute(value, attribute);
                }
                transactionWrapper.commit();
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
        }
        logger.traceDebug(THIS_CLASS, "Reseting attributes for mo: " + this.moName + " is complete");
        logger.traceReturn(THIS_CLASS, "reset()");
    }

    private void setAttribute(String value, Attribute attribute) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        if (attribute instanceof BooleanAttribute) {
            ((BooleanAttribute)attribute).setValue(Boolean.valueOf(value).booleanValue());
            logger.traceDebug(THIS_CLASS, "Value: " + Boolean.valueOf(value) + " is set for BooleanAttribute: " + attribute.getName());
        } else if (attribute instanceof FloatAttribute) {
            ((FloatAttribute)attribute).setValue(Float.parseFloat(value));
            logger.traceDebug(THIS_CLASS, "Value: " + Float.parseFloat(value) + " is set for FloatAttribute: " + attribute.getName());
        } else if (attribute instanceof IntegerAttribute) {
            ((IntegerAttribute)attribute).setValue(Integer.parseInt(value));
            logger.traceDebug(THIS_CLASS, "Value: " + Integer.parseInt(value) + " is set for IntegerAttribute: " + attribute.getName());
        } else if (attribute instanceof LongAttribute) {
            ((LongAttribute)attribute).setValue(Long.parseLong(value));
            logger.traceDebug(THIS_CLASS, "Value: " + Long.parseLong(value) + " is set for LongAttribute: " + attribute.getName());
        } else if (attribute instanceof ReferenceAttribute) {
            ((ReferenceAttribute)attribute).setValue(null);
            logger.traceDebug(THIS_CLASS, "Value: null is set for ReferenceAttribute: " + attribute.getName() + " as default, if the ReferenceAttribute wants to be set, this should be done after the upgrade");
        } else if (attribute instanceof SequenceAttribute) {
            Attribute[] attributeArray = ((SequenceAttribute)attribute).getValue(null);
            logger.traceDebug(THIS_CLASS, "Set SequenceAttribute: " + attribute.getName());
            ((SequenceAttribute)attribute).setValue(this.returnAttributeArray(attributeArray, value));
        } else if (attribute instanceof StringAttribute) {
            ((StringAttribute)attribute).setValue(value);
            logger.traceDebug(THIS_CLASS, "Value: " + value + " is set for StringAttribute: " + attribute.getName());
        } else {
            if (attribute instanceof StructAttribute) {
                logger.traceError(THIS_CLASS, "Can't reset StructAttribute, it's not implemented");
                throw new CrbsAueException("To reset mao StructAttribute isn't implemented");
            }
            logger.traceError(THIS_CLASS, "Can't reset attribute, it's an unknown type");
            throw new CrbsAueException("Fail to reset mao attribute, unknown type: " + attribute);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    protected Attribute[] returnAttributeArray(Attribute[] attributeArray, String sequence) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "returnAttributeArray()");
        String separator = ",";
        StringBuffer buffer = new StringBuffer(sequence);
        if (buffer.toString().indexOf(",") != -1) {
            buffer.append(",");
            int counter = 0;
            while (buffer.length() > 0) {
                int separatorPosition = buffer.toString().indexOf(",");
                if (separatorPosition == -1) continue;
                attributeArray[counter] = this.returnAttribute(attributeArray[counter], buffer.toString().substring(0, separatorPosition));
                buffer.delete(0, separatorPosition + 1);
                ++counter;
            }
        } else {
            attributeArray[0] = this.returnAttribute(attributeArray[0], buffer.toString().substring(0, buffer.length()));
        }
        logger.traceReturn(THIS_CLASS, "returnAttributeArray()");
        return attributeArray;
    }

    protected Attribute returnAttribute(Attribute attribute, String element) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "returnAttribute()");
        if (attribute instanceof BooleanAttribute) {
            ((BooleanAttribute)attribute).setValue(Boolean.valueOf(element).booleanValue());
            logger.traceDebug(THIS_CLASS, "Value (for SequenceAttribute): " + Boolean.valueOf(element) + " is set for BooleanAttribute: " + attribute.getName());
        } else if (attribute instanceof FloatAttribute) {
            ((FloatAttribute)attribute).setValue(Float.parseFloat(element));
            logger.traceDebug(THIS_CLASS, "Value (for SequenceAttribute): " + Float.parseFloat(element) + " is set for FloatAttribute: " + attribute.getName());
        } else if (attribute instanceof IntegerAttribute) {
            ((IntegerAttribute)attribute).setValue(Integer.parseInt(element));
            logger.traceDebug(THIS_CLASS, "Value (for SequenceAttribute): " + Integer.parseInt(element) + " is set for IntegerAttribute: " + attribute.getName());
        } else if (attribute instanceof LongAttribute) {
            ((LongAttribute)attribute).setValue(Long.parseLong(element));
            logger.traceDebug(THIS_CLASS, "Value (for SequenceAttribute): " + Long.parseLong(element) + " is set for LongAttribute: " + attribute.getName());
        } else if (attribute instanceof StringAttribute) {
            ((StringAttribute)attribute).setValue(element);
            logger.traceDebug(THIS_CLASS, "Value (for SequenceAttribute): " + element + " is set for StringAttribute: " + attribute.getName());
        } else {
            logger.traceError(THIS_CLASS, "Can't reset attribute (for SequenceAttribute), it's an unknown type");
            throw new CrbsAueException("Fail to reset mao SequenceAttribute, unknown type: " + attribute);
        }
        logger.traceReturn(THIS_CLASS, "returnAttribute()");
        return attribute;
    }

    private String checkString(String string, String errorMsg) throws CrbsAueException {
        if (string == null) {
            throw new CrbsAueException(errorMsg);
        }
        return string;
    }

    public Map getMoAttributeMap() {
        return this.moAttributeMap;
    }
}

