/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedByOtherUserException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.OtherLoaderName;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.swmanagement.ActiveOtherLMsMo;
import se.ericsson.cello.swmanagement.OtherLoaderNameDB_Handler;
import se.ericsson.cello.swmanagement.suaccess.ActiveOtherLMsMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class ActiveOtherLMsMoImpl
extends ManagedObjectBase
implements ActiveOtherLMsMo,
Reservable,
ActiveOtherLMsMoSU_Access {
    private static ActiveOtherLMsMoImpl instance = null;
    private MoData data;
    private static final String ActiveOtherLMsId = "1";
    private static final String[] reservedClasses = new String[]{"SwAllocation"};
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1"};
    private StringAttribute userLabel;
    private SequenceAttribute otherLoaderNameContents;
    private SequenceAttribute activeLMs;
    private SequenceAttribute reservedBy;
    private static final int MO_DATA_REVISION_70 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;

    public static synchronized ActiveOtherLMsMoImpl instance() {
        try {
            if (instance == null) {
                instance = new ActiveOtherLMsMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            UpgradeTrace.error((Class)ActiveOtherLMsMoImpl.class, (String)"Create instance of ActiveOtherLMs MO failed", (String)"MoNameAlreadyTakenException caught.", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    private ActiveOtherLMsMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement")).getMo(), "ActiveOtherLMs", ActiveOtherLMsId, null);
    }

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        throw new MoCanNotBeCreatedException("ActiveOtherLMs");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAttribute(String anAttrNames[], Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator) + "\n\tanAttrName: " + string));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAttributes(String anAttrNames[], Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator) + "\n\tanAttrNames: " + Lib.toString((String[])stringArray)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            ManagedObject[] managedObjectArray;
            Object[] objectArray2;
            if (stringArray[i].equalsIgnoreCase("ActiveOtherLMsId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = this.userLabel.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("otherLoaderNameContents")) {
                objectArray2 = this.otherLoaderNameContents.getValue(coordinator);
                managedObjectArray = new ManagedObject[objectArray2.length];
                for (n = 0; n < objectArray2.length; ++n) {
                    managedObjectArray[n] = ((ReferenceAttribute)objectArray2[n]).getValue(coordinator);
                }
                objectArray[i] = managedObjectArray;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeLMs")) {
                objectArray2 = this.activeLMs.getValue(coordinator);
                managedObjectArray = new ManagedObject[objectArray2.length];
                for (n = 0; n < objectArray2.length; ++n) {
                    managedObjectArray[n] = ((ReferenceAttribute)objectArray2[n]).getValue(coordinator);
                }
                objectArray[i] = managedObjectArray;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"getAttributes(String anAttrNames[], Coordinator c)", (String)("reservedBy: " + this.reservedBy));
                objectArray2 = this.reservedBy.getValue(coordinator);
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"getAttributes(String anAttrNames[], Coordinator c)", (String)("theReservedByAttributes: " + Lib.toString((Object[])objectArray2)));
                managedObjectArray = new ManagedObject[objectArray2.length];
                for (n = 0; n < objectArray2.length; ++n) {
                    managedObjectArray[n] = ((ReferenceAttribute)objectArray2[n]).getValue(coordinator);
                }
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"getAttributes(String anAttrNames[], Coordinator c)", (String)("The attribute 'reservedBy' contents: " + Lib.toString((ManagedObject[])managedObjectArray)));
                objectArray[i] = managedObjectArray;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ReservedSwAllocationMo")) {
                objectArray[i] = this.getReservedSwAllocationMo(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "ActiveOtherLMs");
        }
        return objectArray;
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getActiveOtherLMsId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ActiveOtherLMsId", coordinator);
    }

    public ManagedObject[] getOtherLoaderNameContents(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("otherLoaderNameContents", coordinator);
    }

    public ManagedObject[] getActiveLMs(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("activeLMs", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public ManagedObject getReservedSwAllocationMo(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedSwAllocationMo(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!(managedObjectArray[i] instanceof SwAllocationMoSU_Access)) continue;
            return managedObjectArray[i];
        }
        return null;
    }

    public String getType() {
        return "ActiveOtherLMs";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve(ManagedObject aSwAllocationMo, Coordinator c)", (String)("aSwAllocationMo: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (this.getReservedSwAllocationMo(null) != null) {
            throw new MoReservedByOtherUserException(managedObject.getLocalDistinguishedName(), this.getReservedSwAllocationMo(null).getLocalDistinguishedName());
        }
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"ActiveOtherLMs", (MoData)this.data, (SequenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject aSwAllocationMo,  Coordinator c)", (String)("aSwAllocationMo: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"ActiveOtherLMs", (MoData)this.data, (SequenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void setActiveOtherLoaderNameLoadModules(ManagedObject[] managedObjectArray, Collection collection, boolean bl) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setActiveOtherLoaderNameLoadModules ( ManagedObject[] aPublishedLoadModules, Collection anOtherLoaderNamesAndPaths, boolean anIsTableToBeUpdated )", (String)("aPublishedLoadModules: " + Lib.toString((ManagedObject[])managedObjectArray) + "\n\tanOtherLoaderNamesAndPaths: " + collection + "\n\tanIsTableToBeUpdated: " + bl));
        try {
            if (managedObjectArray != null) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"setActiveOtherLoaderNameLoadModules ( ManagedObject[] aPublishedLoadModules, Collection anOtherLoaderNamesAndPaths, boolean anIsTableToBeUpdated )", (String)("Number of published Load Modules: " + managedObjectArray.length));
                if (bl) {
                    this.updateOtherLoaderNameTable(collection);
                    this.setOtherLoaderNameContents(managedObjectArray);
                } else {
                    this.setOtherLoaderNameContents(managedObjectArray);
                }
            }
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"setActiveOtherLoaderNameLoadModules ( ManagedObject[] aPublishedLoadModules, Collection anOtherLoaderNamesAndPaths, boolean anIsTableToBeUpdated )", (String)("anActiveLoadModules: " + Lib.toString((ManagedObject[])managedObjectArray) + "\n\tanOtherLoaderNamesAndPaths: " + collection + "\n\tanIsTableToBeUpdated: " + bl + "Throwable caught when trying to set the attribute otherLoaderNameContents." + "\n\tThrowable message: " + throwable), (Throwable)throwable);
        }
    }

    public void setActiveLoadModules(ManagedObject[] managedObjectArray) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setActiveLoadModules(ManagedObject[] anActiveLoadModules)", (String)("anActiveLoadModules: " + Lib.toString((ManagedObject[])managedObjectArray)));
        try {
            if (managedObjectArray != null) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"setActiveLoadModules(ManagedObject[] anActiveLoadModules)", (String)("Number of active Load Modules: " + managedObjectArray.length));
                this.setActiveLMs(managedObjectArray);
            }
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"setActiveLoadModules(ManagedObject[] anActiveLoadModules)", (String)("anActiveLoadModules: " + Lib.toString((ManagedObject[])managedObjectArray) + "Throwable caught when trying to set the attribute activeLMs." + "\n\tThrowable message: " + throwable), (Throwable)throwable);
        }
    }

    private void setOtherLoaderNameContents(ManagedObject[] managedObjectArray) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setOtherLoaderNameContents (ManagedObject[] anActiveLoadModules)", (String)("anActiveLoadModules: " + Lib.toString((ManagedObject[])managedObjectArray)));
        Control control = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(60000);
            Coordinator coordinator = control.getCoordinator();
            this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            ReferenceAttribute referenceAttribute = null;
            this.otherLoaderNameContents.setValue((Attribute[])new ReferenceAttribute[0]);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                referenceAttribute = new ReferenceAttribute("otherLoaderNameContents", false);
                referenceAttribute.setValue(managedObjectArray[i]);
                this.otherLoaderNameContents.addElement((Attribute)referenceAttribute);
            }
            control.getTerminator().commit();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"setOtherLoaderNameContents ( ManagedObject[] anActiveLoadModules )", (String)("Throwable caught when trying to set the attribute otherLoaderNameContents.\n\tThrowable message: " + throwable), (Throwable)throwable);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    private void setActiveLMs(ManagedObject[] managedObjectArray) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setActiveLMs (ManagedObject[] anActiveLoadModules)", (String)("anActiveLoadModules: " + Lib.toString((ManagedObject[])managedObjectArray)));
        Control control = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(60000);
            Coordinator coordinator = control.getCoordinator();
            this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            ReferenceAttribute referenceAttribute = null;
            this.activeLMs.setValue((Attribute[])new ReferenceAttribute[0]);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                referenceAttribute = new ReferenceAttribute("activeLMs", false);
                referenceAttribute.setValue(managedObjectArray[i]);
                this.activeLMs.addElement((Attribute)referenceAttribute);
            }
            control.getTerminator().commit();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"setActiveLMs (ManagedObject[] anActiveLoadModules)", (String)("Throwable caught when trying to set the attribute activeLMs.\n\tThrowable message: " + throwable), (Throwable)throwable);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String anUserLabel, Coordinator c)", (String)("anUserLabel: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"ActiveOtherLMs", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public void recover(MoData moData) throws MoNameAlreadyTakenException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"recover(MoData aRecoveredData)", (String)("aRecoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("otherLoaderNameContents");
        moDataRecoveryHelper.assertAttribute("activeLMs");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.otherLoaderNameContents = (SequenceAttribute)moData.getAttribute("otherLoaderNameContents");
        this.activeLMs = (SequenceAttribute)moData.getAttribute("activeLMs");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
    }

    synchronized void registerData() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"registerData()");
        if (this.data == null) {
            try {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"registerData()", (String)"Creating persistent attributes with default values.");
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                this.data = new MoData(this.getLocalDistinguishedName(), "ActiveOtherLMs", true, coordinator);
                this.reservedBy = new SequenceAttribute("reservedBy", true);
                this.data.registerPersistentAttr((Attribute)this.reservedBy);
                this.otherLoaderNameContents = new SequenceAttribute("otherLoaderNameContents", true);
                this.data.registerPersistentAttr((Attribute)this.otherLoaderNameContents);
                this.activeLMs = new SequenceAttribute("activeLMs", true);
                this.data.registerPersistentAttr((Attribute)this.activeLMs);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.data.setRevision(7000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"registerData()", (String)"Persistent attributes created.");
            }
            catch (TransactionRequiredException transactionRequiredException) {
                UpgradeTrace.error(this.getClass(), (String)"start of SwManagement failed", (String)"TransactionRequiredException caught.", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                UpgradeTrace.error(this.getClass(), (String)"start of SwManagement failed", (String)"TransactionRolledBackException caught.", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                UpgradeTrace.error(this.getClass(), (String)"start of SwManagement failed", (String)"InactiveTransactionException caught.", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                UpgradeTrace.error(this.getClass(), (String)"start of SwManagement failed", (String)"MoAccessException caught.", (Throwable)moAccessException);
            }
        }
    }

    private void updateOtherLoaderNameTable(Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"updateOtherLoaderNameTable(Collection anOtherLoaderNameInformations)", (String)("anOtherLoaderNameInformations: " + collection));
        try {
            OtherLoaderNameDB_Handler otherLoaderNameDB_Handler = new OtherLoaderNameDB_Handler();
            otherLoaderNameDB_Handler.deleteTable();
            otherLoaderNameDB_Handler.createTable();
            Iterator iterator = collection.iterator();
            OtherLoaderName otherLoaderName = null;
            int n = 1;
            while (iterator.hasNext()) {
                otherLoaderName = (OtherLoaderName)iterator.next();
                otherLoaderNameDB_Handler.updateRow(n, otherLoaderName.getOtherLoaderName(), otherLoaderName.getDestFilePathName());
                ++n;
            }
        }
        catch (MoAccessException moAccessException) {
            UpgradeTrace.error(this.getClass(), (String)"updateOtherLoaderNameTable(Collection anOtherLoaderNameInformations)", (String)"MoAccessException caught.", (Throwable)moAccessException);
            throw moAccessException;
        }
    }
}

