/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement.suaccess;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.swmanagement.suaccess.ExtendedLoadModuleRefInfo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleRefInfo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeRefInfo;
import se.ericsson.cello.util.library.Lib;

public class PiuTypeLoadListInfo {
    private Collection myPiuTypeRefInfos = new LinkedList();
    private Collection myLoadModuleRefInfos = new LinkedList();

    public PiuTypeLoadListInfo() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PiuTypeLoadListInfo()");
    }

    public PiuTypeLoadListInfo(String string, String string2) {
        this.myPiuTypeRefInfos = this.convertToPiuTypeRefInfos(string);
        this.myLoadModuleRefInfos = this.convertToLoadModuleRefInfos(string2);
    }

    public PiuTypeLoadListInfo(Collection collection, Collection collection2) {
        this.myPiuTypeRefInfos = collection;
        this.myLoadModuleRefInfos = collection2;
    }

    public void addPiuTypeRefInfo(PiuTypeRefInfo piuTypeRefInfo) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addPiuTypeRefInfo(PiuTypeRefInfo aPiuTypeRefInfo)", (String)("aPiuTypeRefInfo: " + piuTypeRefInfo));
        this.myPiuTypeRefInfos.add(piuTypeRefInfo);
    }

    public void addPiuTypeRefInfos(Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addPiuTypeRefInfos(Collection aPiuTypeRefInfos)", (String)("aPiuTypeRefInfos: " + collection));
        this.myPiuTypeRefInfos.addAll(collection);
    }

    public void addLoadModuleRefInfo(LoadModuleRefInfo loadModuleRefInfo) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addLoadModuleRefInfo(LoadModuleRefInfo aLoadModuleRefInfo)", (String)("aLoadModuleRefInfo: " + loadModuleRefInfo));
        this.myLoadModuleRefInfos.add(loadModuleRefInfo);
    }

    public void addLoadModuleRefInfos(Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addLoadModuleRefInfos(Collection aLoadModuleRefInfos)", (String)("aLoadModuleRefInfos: " + collection));
        this.myLoadModuleRefInfos.addAll(collection);
    }

    public Collection getPiuTypeRefInfos() {
        return this.myPiuTypeRefInfos;
    }

    public Collection getLoadModuleRefInfos() {
        return this.myLoadModuleRefInfos;
    }

    public Collection getLoadModuleRefInfos(Collection collection) {
        if (collection == null) {
            return this.myLoadModuleRefInfos;
        }
        HashSet<LoadModuleRefInfo> hashSet = new HashSet<LoadModuleRefInfo>(1);
        LoadModuleRefInfo loadModuleRefInfo = null;
        Iterator iterator = this.myLoadModuleRefInfos.iterator();
        while (iterator.hasNext()) {
            loadModuleRefInfo = (LoadModuleRefInfo)iterator.next();
            if (!collection.contains(loadModuleRefInfo.getTag())) continue;
            hashSet.add(loadModuleRefInfo);
        }
        return hashSet;
    }

    public boolean containsPiuTypeRefInfo(PiuTypeRefInfo piuTypeRefInfo) {
        if (piuTypeRefInfo == null) {
            return true;
        }
        boolean bl = false;
        PiuTypeRefInfo piuTypeRefInfo2 = null;
        Iterator iterator = this.myPiuTypeRefInfos.iterator();
        while (iterator.hasNext()) {
            piuTypeRefInfo2 = (PiuTypeRefInfo)iterator.next();
            if (!piuTypeRefInfo2.isEqual(piuTypeRefInfo)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String toLogString() throws MoAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        PiuTypeRefInfo piuTypeRefInfo = null;
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        Iterator iterator = null;
        if (this.myPiuTypeRefInfos.size() == 0) {
            stringBuffer.append("\t\tPiuTypeRef none\n");
        } else {
            iterator = this.myPiuTypeRefInfos.iterator();
            while (iterator.hasNext()) {
                piuTypeRefInfo = (PiuTypeRefInfo)iterator.next();
                piuTypeMoSU_Access = (PiuTypeMoSU_Access)MoRepository.instance().lookup(piuTypeRefInfo.getLdn());
                stringBuffer.append(piuTypeRefInfo.toLogString(piuTypeMoSU_Access));
            }
        }
        ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        if (this.myLoadModuleRefInfos.size() == 0) {
            stringBuffer.append("\t\tLoadModuleRef none\n");
        } else {
            iterator = this.myLoadModuleRefInfos.iterator();
            while (iterator.hasNext()) {
                extendedLoadModuleRefInfo = (ExtendedLoadModuleRefInfo)iterator.next();
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)MoRepository.instance().lookup(extendedLoadModuleRefInfo.getLdn());
                stringBuffer.append(extendedLoadModuleRefInfo.toLogString(loadModuleMoSU_Access));
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "\n\tPiuTypeRefInfos: " + this.myPiuTypeRefInfos + "\n\n\tLoadModuleRefInfos: " + this.myLoadModuleRefInfos;
    }

    private Collection convertToPiuTypeRefInfos(String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToPiuTypeRefInfos(String aPiuTypeRefInfoPersistentString)", (String)("aPiuTypeRefInfoPersistentString: " + string));
        HashSet<PiuTypeRefInfo> hashSet = new HashSet<PiuTypeRefInfo>(1);
        Collection collection = this.convertToBaseRefInfoLists(string);
        Iterator iterator = collection.iterator();
        LinkedList linkedList = null;
        while (iterator.hasNext()) {
            linkedList = (LinkedList)iterator.next();
            if (linkedList.size() != 1) {
                UpgradeTrace.error(this.getClass(), (String)"convertToPiuTypeRefInfos(String aPiuTypeRefInfoPersistentString)", (String)("\n\tWrong database format for LoadModuleRefInfo. The information will be ignored.\n\ttheBaseRefInfoList: " + linkedList + "\n\taPiuTypeRefInfoPersistentString: " + string));
            }
            hashSet.add(new PiuTypeRefInfo((String)linkedList.get(0)));
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"convertToPiuTypeRefInfos(String aPiuTypeRefInfoPersistentString)", (String)("Returning - thePiuTypeRefInfos: " + hashSet));
        return hashSet;
    }

    private Collection convertToLoadModuleRefInfos(String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToLoadModuleRefInfos(String aLoadModuleRefInfoPersistentString)", (String)("aLoadModuleRefInfoPersistentString: " + string));
        HashSet<ExtendedLoadModuleRefInfo> hashSet = new HashSet<ExtendedLoadModuleRefInfo>(1);
        Collection collection = this.convertToBaseRefInfoLists(string);
        Iterator iterator = collection.iterator();
        ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
        LinkedList linkedList = null;
        while (iterator.hasNext()) {
            linkedList = (LinkedList)iterator.next();
            if (linkedList.size() != 8) {
                UpgradeTrace.error(this.getClass(), (String)"convertToLoadModuleRefInfos(String aLoadModuleRefInfoPersistentString)", (String)("\n\tWrong database format for LoadModuleRefInfo. The information will be ignored.\n\ttheBaseRefInfoList: " + linkedList + "\n\taLoadModuleRefInfoPersistentStringg: " + string));
            }
            extendedLoadModuleRefInfo = new ExtendedLoadModuleRefInfo((String)linkedList.get(0), (String)linkedList.get(1), (String)linkedList.get(2), (String)linkedList.get(3), (String)linkedList.get(4), (String)linkedList.get(5), (String)linkedList.get(6), (String)linkedList.get(7));
            hashSet.add(extendedLoadModuleRefInfo);
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"convertToLoadModuleRefInfos(String aLoadModuleRefInfoPersistentString)", (String)("Returning - theLoadModuleRefInfos: " + hashSet));
        return hashSet;
    }

    private Collection convertToBaseRefInfoLists(String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToBaseRefInfos(String aBaseRefInfoString)", (String)("aBaseRefInfoString: " + string));
        HashSet<LinkedList> hashSet = new HashSet<LinkedList>(1);
        if (string != null) {
            LinkedList linkedList = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            String string2 = stringTokenizer.nextToken();
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"convertToBaseRefInfos(String aBaseRefInfoString)", (String)("theLoadListNumber: " + string2));
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                linkedList = Lib.getSubStrings((String)string3, (String)"&");
                hashSet.add(linkedList);
            }
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"convertToBaseRefInfos(String aBaseRefInfoString)", (String)("Returning - theBaseRefInfoLists: " + hashSet));
        return hashSet;
    }
}

