/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import se.ericsson.cello.faultmanagement.AlarmIRP_1Impl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.HealthCheckCoordinator;
import se.ericsson.cello.managedelement.HealthCheckResult;
import se.ericsson.cello.managedelement.HealthCheckResultObserver;
import se.ericsson.cello.managedelement.HealthCheckSchedule;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.managedelement.ManagedElementMoFactory;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PlugInUnitRepository;
import se.ericsson.cello.managedelement.RestartNode;
import se.ericsson.cello.managedelement.SU_ME_HealthCheckCoordinator;
import se.ericsson.cello.managedelement.ScheduleManager;
import se.ericsson.cello.managedelement.ScheduledHealthCheck;
import se.ericsson.cello.managedelement.ServiceMissingException;
import se.ericsson.cello.managedelement.StartTime;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetFtcRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetNodeIdRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetTopologyVersionRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeMgmntProxy;
import se.ericsson.cello.managedelement.fropxy.OsaMePhasedRestartCheckRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetNodeIdRsp;
import se.ericsson.cello.managedelement.meaccess.ConfigurationVersionMO_HandlerAccess;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerFactoryAccessBase;
import se.ericsson.cello.managedelement.meaccess.UpgradePackageAccess;
import se.ericsson.cello.managedelement.meaccess.UpgradePackageChecksumVerifier;
import se.ericsson.cello.managedelement.osa_me_managedelement_mi;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.RestartRankEnum;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MosiNotificationSender;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pms.ne.NEInfoSupplier;
import se.ericsson.cello.pms.ne.NESupplier;
import se.ericsson.cello.productinventory.NodeProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.scheduler.Scheduler;
import se.ericsson.cello.support.scheduler.SchedulerImpl;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class ManagedElementMoImpl
extends CelloMao
implements ManagedElementMo,
ManagedElementMoSU_Access,
Mib,
NodeProductData,
Runnable,
NEInfoSupplier,
HealthCheckResultObserver {
    public static final int CELLO_ME_TOPOLOGY_AMX = 0;
    public static final int CELLO_ME_TOPOLOGY_IDL1 = 1;
    public static final int CELLO_ME_TOPOLOGY_EGEM2 = 2;
    public static final int CELLO_ME_TOPOLOGY_IDL1_5 = 3;
    public static final int CELLO_ME_TOPOLOGY_SIMCELLO = 4;
    public static final int CELLO_ME_TOPOLOGY_IDL1_IDL2 = 5;
    public static final int CELLO_ME_TOPOLOGY_UNDEF = 255;
    private OsaMeMgmntProxy osaMeMgmntProxy = OsaMeMgmntProxy.instance();
    private static ManagedElementMoImpl theOneAndOnly;
    private int restartRank;
    private StringAttribute userLabel;
    private StringAttribute productType;
    private StringAttribute mibPrefix;
    private StringAttribute modelRelease;
    private StringAttribute modelVersion;
    private StringAttribute modelType;
    private SequenceAttribute applicationConfiguration = null;
    private SequenceAttribute healthCheckSchedule = null;
    private HealthCheckResult healthCheckResult = new HealthCheckResult();
    private ScheduleManager scheduleMgr = null;
    private static final int MANAGED_ELEMENT_FRO_ID = 0;
    private static final String MANAGED_ELEMENT_ID_VALUE = "1";
    private MoData data;
    private static final String MIB_PREFIX = "MibPrefix";
    private static final String ME_RESTART_RANK_VALUE = "MeRestartRankvalue";
    private static final String ME_RESTART_REASON_VALUE = "MeRestartReasonvalue";
    private static final String ME_RESTART_INFO = "MeRestartInfo";
    private static final String MIM_RELEASE = "mimRelease";
    private static final String MIM_VERSION = "mimVersion";
    private static final String MIM_TYPE = "mimName";
    private static final String MIB_NAME_VALUE = "Cello";
    private static String[] mimInfoNames;
    private static final String[] SUPPORTED_VERSIONS;
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(osa_me_managedelement_mi.class);
    public static final String HEALTH_CHECK = "HealthCheck";
    private static final int MO_DATA_REVISION_60 = 6000;
    private static final int MO_DATA_REVISION_601 = 6010;
    private static final int MO_DATA_REVISION_61 = 6100;
    private static final int MO_DATA_REVISION_LATEST = 6100;
    private static final int CELLO_ME_CM_INIT = 1;
    private static final int CELLO_ME_CM_NOT_CONFIGURED = 2;
    private static final int CELLO_ME_CM_ACTIVE = 3;
    private static final int CELLO_ME_CM_UNAVAILABLE = 4;
    private static final int CELLO_ME_CM_PASSIVE_NOT_READY = 5;
    private static final int CELLO_ME_CM_PASSIVE_READY = 6;

    public static synchronized ManagedElementMoImpl instance() {
        try {
            if (theOneAndOnly == null) {
                theOneAndOnly = new ManagedElementMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"Create instance of ManagedElement MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return theOneAndOnly;
    }

    synchronized void start() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, (Class)ManagedElementMoImpl.class, (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.productType = new StringAttribute("ProductType", false);
                this.productType.setValue("Node");
                this.data.registerPersistentAttr((Attribute)this.productType);
                this.mibPrefix = new StringAttribute(MIB_PREFIX, false);
                this.data.registerPersistentAttr((Attribute)this.mibPrefix);
                this.modelRelease = new StringAttribute(MIM_RELEASE, false);
                this.data.registerPersistentAttr((Attribute)this.modelRelease);
                this.modelVersion = new StringAttribute(MIM_VERSION, false);
                this.data.registerPersistentAttr((Attribute)this.modelVersion);
                this.modelType = new StringAttribute(MIM_TYPE, false);
                this.data.registerPersistentAttr((Attribute)this.modelType);
                this.applicationConfiguration = new SequenceAttribute("applicationConfiguration", true);
                this.data.registerPersistentAttr((Attribute)this.applicationConfiguration);
                this.healthCheckSchedule = new SequenceAttribute("healthCheckSchedule", false);
                this.data.registerPersistentAttr((Attribute)this.healthCheckSchedule);
                this.data.setRevision(6100);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.osaMeMgmntProxy.registerForNotifications(coordinator, this, 0);
                this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 0);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of Equipment failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of Managed Element failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of Managed Element failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of Managed Element failed", (Throwable)moAccessException);
            }
        }
        ProductRepository.instance().registerNode((NodeProductData)this);
    }

    void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, this);
        moDataRecoveryHelper.assertMoDataRevision(6100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("ProductType");
        moDataRecoveryHelper.assertAttribute(MIB_PREFIX);
        moDataRecoveryHelper.assertAttribute(MIM_RELEASE);
        moDataRecoveryHelper.assertAttribute(MIM_VERSION);
        moDataRecoveryHelper.assertAttribute(MIM_TYPE);
        moDataRecoveryHelper.assertAttribute("healthCheckSchedule");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.productType = (StringAttribute)moData.getAttribute("ProductType");
        this.mibPrefix = (StringAttribute)moData.getAttribute(MIB_PREFIX);
        this.modelRelease = (StringAttribute)moData.getAttribute(MIM_RELEASE);
        this.modelVersion = (StringAttribute)moData.getAttribute(MIM_VERSION);
        this.modelType = (StringAttribute)moData.getAttribute(MIM_TYPE);
        this.applicationConfiguration = (SequenceAttribute)this.data.getAttribute("applicationConfiguration");
        if (this.applicationConfiguration == null) {
            this.applicationConfiguration = new SequenceAttribute("applicationConfiguration", true);
            this.data.registerPersistentAttr((Attribute)this.applicationConfiguration);
        }
        this.healthCheckSchedule = (SequenceAttribute)this.data.getAttribute("healthCheckSchedule");
        try {
            HealthCheckSchedule healthCheckSchedule = new HealthCheckSchedule(this.healthCheckSchedule);
            this.scheduleMgr.setSchedule(healthCheckSchedule.toScheduleTimes());
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Recovered health check schedule is corrupt, schedule will not be activated.", (Throwable)exception);
        }
        RestartNode.restartIfNull(this.applicationConfiguration, "Recovered attribute applicationConfiguration is null");
        this.osaMeMgmntProxy.subscribeService();
        this.osaMeMgmntProxy.registerForNotifications(null, this, 0);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 0);
    }

    public void delete(Coordinator coordinator) throws UndeletableMoException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        return this.getSupportedVersions();
    }

    public String getType() {
        return "ManagedElement";
    }

    public String getManagedElementId(Coordinator coordinator) throws MoAccessException {
        return MANAGED_ELEMENT_ID_VALUE;
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"ManagedElement", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setSite(String string, Coordinator coordinator) throws MoAccessException {
        if (string.length() > 255) {
            throw new ValueOutOfRangeException("site", "ManagedElement");
        }
        String[] stringArray = this.getFroNodeData(coordinator);
        this.setFroNodeData(coordinator, stringArray.getLogicalName(), stringArray.getProductName(), stringArray.getProductNumber(), stringArray.getProductRevision(), string);
        stringArray = new String[]{"site"};
        Object[] objectArray = new Object[]{string};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getSite(Coordinator coordinator) throws MoAccessException {
        return this.getFroNodeData(coordinator).getSite();
    }

    public void setLogicalName(String string, Coordinator coordinator) throws MoAccessException {
        if (string.length() > 255) {
            throw new ValueOutOfRangeException("logicalName", "ManagedElement");
        }
        String[] stringArray = this.getFroNodeData(coordinator);
        this.setFroNodeData(coordinator, string, stringArray.getProductName(), stringArray.getProductNumber(), stringArray.getProductRevision(), stringArray.getSite());
        stringArray = new String[]{"logicalName"};
        Object[] objectArray = new Object[]{string};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getLogicalName(Coordinator coordinator) throws MoAccessException {
        return this.getFroNodeData(coordinator).getLogicalName();
    }

    public String getProductType(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.productType.getValue(null);
    }

    public void setProductName(String string, Coordinator coordinator) throws MoAccessException {
        if (string.length() > 12) {
            throw new ValueOutOfRangeException("productName", "ManagedElement");
        }
        String[] stringArray = this.getFroNodeData(coordinator);
        this.setFroNodeData(coordinator, stringArray.getLogicalName(), string, stringArray.getProductNumber(), stringArray.getProductRevision(), stringArray.getSite());
        stringArray = new String[]{"productName"};
        Object[] objectArray = new Object[]{string};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setProductNameFromSU(String string, Coordinator coordinator) throws MoAccessException {
        this.setProductName(string, coordinator);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        return this.getFroNodeData(coordinator).getProductName();
    }

    public void setProductNumber(String string, Coordinator coordinator) throws MoAccessException {
        if (string.length() > 24) {
            throw new ValueOutOfRangeException("productNumber", "ManagedElement");
        }
        OsaMeGetNodeIdRsp osaMeGetNodeIdRsp = this.getFroNodeData(coordinator);
        this.setFroNodeData(coordinator, osaMeGetNodeIdRsp.getLogicalName(), osaMeGetNodeIdRsp.getProductName(), string, osaMeGetNodeIdRsp.getProductRevision(), osaMeGetNodeIdRsp.getSite());
    }

    public void setProductNumberFromSU(String string, Coordinator coordinator) throws MoAccessException {
        this.setProductNumber(string, coordinator);
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        return this.getFroNodeData(coordinator).getProductNumber();
    }

    public void setProductRevision(String string, Coordinator coordinator) throws MoAccessException {
        if (string.length() > 7) {
            throw new ValueOutOfRangeException("productRevision", "ManagedElement");
        }
        String[] stringArray = this.getFroNodeData(coordinator);
        this.setFroNodeData(coordinator, stringArray.getLogicalName(), stringArray.getProductName(), stringArray.getProductNumber(), string, stringArray.getSite());
        stringArray = new String[]{"productRevision"};
        Object[] objectArray = new Object[]{string};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setProductRevisionFromSU(String string, Coordinator coordinator) throws MoAccessException {
        this.setProductRevision(string, coordinator);
    }

    public String getProductRevision(Coordinator coordinator) throws MoAccessException {
        return this.getFroNodeData(coordinator).getProductRevision();
    }

    public void run() {
        try {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OsaMeMgmntProxy.instance().sendOsaMe2RestartReq(this.restartRank);
        }
        catch (Exception exception) {
            MessageLog.info(this.getClass(), (String)"run: ");
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
        }
    }

    public int actionStartHealthCheck(Coordinator coordinator) throws MoAccessException {
        StartTime startTime = StartTime.now();
        int n = -1;
        ServiceRepository serviceRepository = this.getMaoContext().getServiceRepository();
        UpgradePackageChecksumVerifier upgradePackageChecksumVerifier = (UpgradePackageChecksumVerifier)serviceRepository.getService(UpgradePackageChecksumVerifier.class);
        if (upgradePackageChecksumVerifier == null) {
            throw new ServiceMissingException(UpgradePackageChecksumVerifier.class);
        }
        if (upgradePackageChecksumVerifier.isHealthCheckOngoing()) {
            n = 1;
        } else if (upgradePackageChecksumVerifier.isUpgradeOngoing(HEALTH_CHECK)) {
            n = 2;
        } else {
            HealthCheckCoordinator healthCheckCoordinator = new HealthCheckCoordinator(startTime, this.osaMeMgmntProxy, upgradePackageChecksumVerifier, this);
            n = this.osaMeMgmntProxy.sendOsaMeFsHealthCheckReq(healthCheckCoordinator.getRequestId());
            if (n == 0) {
                new Thread(healthCheckCoordinator.getRunnable()).start();
            } else {
                healthCheckCoordinator.cancel();
            }
        }
        return n;
    }

    public void healthCheckResultUpdated(HealthCheckResult healthCheckResult) {
        this.healthCheckResult = healthCheckResult;
        Struct struct = healthCheckResult.toStruct();
        NotificationSender.instance().pushAVC((ManagedObject)this, new String[]{"healthCheckResult"}, new Object[]{struct});
    }

    public Struct getHealthCheckResult(Coordinator coordinator) {
        return this.healthCheckResult.toStruct();
    }

    public void setHealthCheckSchedule(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        if (structArray == null || structArray.length > 14) {
            throw new ValueOutOfRangeException("healthCheckSchedule", "ManagedElement");
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        HealthCheckSchedule healthCheckSchedule = null;
        try {
            healthCheckSchedule = new HealthCheckSchedule(structArray);
        }
        catch (Exception exception) {
            throw new ValueOutOfRangeException("healthCheckSchedule:" + exception.getMessage(), "ManagedElement");
        }
        try {
            this.scheduleMgr.setSchedule(healthCheckSchedule.toScheduleTimes(), coordinator);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw new TransactionRequiredException();
        }
        this.healthCheckSchedule.setValue(healthCheckSchedule.toAttributes());
        String[] stringArray = new String[]{"healthCheckSchedule"};
        Object[] objectArray = new Object[]{healthCheckSchedule.toStructs()};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public Struct[] getHealthCheckSchedule(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct[] structArray = null;
        try {
            HealthCheckSchedule healthCheckSchedule = new HealthCheckSchedule(this.healthCheckSchedule);
            structArray = healthCheckSchedule.toStructs();
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Unexpected error occurred reading the health schedule", (Throwable)exception);
            structArray = new Struct[]{};
        }
        return structArray;
    }

    public void actionManualRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        AccessControlHelper.performAccessControl();
        if (!RestartReasonEnum.inManualRange((int)n2)) {
            throw new ValueOutOfRangeException(ME_RESTART_REASON_VALUE, "ManagedElement");
        }
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(ME_RESTART_RANK_VALUE, "ManagedElement");
        }
        if (string.length() > 80) {
            throw new ValueOutOfRangeException(ME_RESTART_INFO, "ManagedElement");
        }
        Thread thread = new Thread((Runnable)new RestartDelay(n, n2, string), "ManagedElementRestart");
        thread.start();
    }

    public void systemInitiatedRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        AccessControlHelper.performAccessControl();
        if (!RestartReasonEnum.inSystemRange((int)n2)) {
            throw new ValueOutOfRangeException(ME_RESTART_REASON_VALUE, "ManagedElement");
        }
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(ME_RESTART_RANK_VALUE, "ManagedElement");
        }
        if (string.length() > 80) {
            string = string.substring(0, 77) + "...";
        }
        Thread thread = new Thread((Runnable)new RestartDelay(n, n2, string), "ManagedElementRestart");
        thread.start();
    }

    public void systemInitiatedRestartFromSU(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        this.systemInitiatedRestart(n, n2, string, coordinator);
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        return this.getProductRevision(coordinator);
    }

    public ManagedObject getRootMo() {
        return this;
    }

    public void setModelType(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.modelType.setValue(string);
    }

    public String getModelType() {
        try {
            this.data.handleTransaction(null, MoData.READ_ACCESS);
            return this.modelType.getValue(null);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)"getModelType failed", (Throwable)transactionRequiredException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"getModelType failed", (Throwable)moAccessException);
        }
        return null;
    }

    public String getMimName(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.modelType.getValue(coordinator);
    }

    public Struct[] getApplicationConfiguration(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct[] structArray = new Struct[this.applicationConfiguration.size()];
        int n = 0;
        Enumeration enumeration = this.applicationConfiguration.elements();
        while (enumeration.hasMoreElements()) {
            structArray[n] = ((StructAttribute)enumeration.nextElement()).getValue(coordinator);
            ++n;
        }
        return structArray;
    }

    public String getApplicationConfigurationName(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("name");
        }
        return null;
    }

    public String getApplicationConfigurationValue(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("value");
        }
        return null;
    }

    public void setApplicationConfiguration(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.applicationConfiguration.setValue((Attribute[])new StructAttribute[0]);
        for (int i = 0; i < structArray.length; ++i) {
            StructAttribute structAttribute = new StructAttribute("", true);
            StringAttribute stringAttribute = new StringAttribute("name", true, (String)structArray[i].getValue("name"));
            structAttribute.addElement((Attribute)stringAttribute);
            StringAttribute stringAttribute2 = new StringAttribute("value", true, (String)structArray[i].getValue("value"));
            structAttribute.addElement((Attribute)stringAttribute2);
            this.applicationConfiguration.addElement((Attribute)structAttribute);
        }
    }

    public void requestForDiskHealthCheck() throws MoAccessException {
        new SU_ME_HealthCheckCoordinator().execute(this.osaMeMgmntProxy);
    }

    public Struct getMimInfo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[]{this.modelType.getValue(coordinator), this.modelVersion.getValue(coordinator), this.modelRelease.getValue(coordinator)};
        StructImpl structImpl = new StructImpl(mimInfoNames, objectArray);
        return structImpl;
    }

    public void setModelVersion(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.modelVersion.setValue(string);
    }

    public String getModelVersion() {
        try {
            this.data.handleTransaction(null, MoData.READ_ACCESS);
            return this.modelVersion.getValue(null);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)"getModelVersion failed", (Throwable)transactionRequiredException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"getModelVersion failed", (Throwable)moAccessException);
        }
        return null;
    }

    public void setModelRelease(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.modelRelease.setValue(string);
    }

    public String getModelRelease() {
        try {
            this.data.handleTransaction(null, MoData.READ_ACCESS);
            return this.modelRelease.getValue(null);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)"getModelRelease failed", (Throwable)transactionRequiredException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"getModelRelease failed", (Throwable)moAccessException);
        }
        return null;
    }

    public void setMibPrefix(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string != null) {
            this.mibPrefix.setValue(string);
            try {
                coordinator.registerResource((Resource)new TxResource(string));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"setMibPrefix:  ", (Throwable)inactiveTransactionException);
            }
        }
    }

    public String getMibPrefix() {
        String string = "";
        if (this.data != null) {
            try {
                this.data.handleTransaction(null, MoData.READ_ACCESS);
                string = this.mibPrefix.getValue(null);
                if (string == null) {
                    string = InetAddress.getLocalHost().toString();
                }
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"getMibPrefix failed", (Throwable)transactionRequiredException);
            }
            catch (UnknownHostException unknownHostException) {
                MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"getMibPrefix failed", (Throwable)unknownHostException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ManagedElementMoImpl.class, (String)"getMibPrefix failed", (Throwable)moAccessException);
            }
        }
        return string;
    }

    public String getMibName() {
        return MIB_NAME_VALUE;
    }

    public String[] getFaultTolerantCoreStates(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaMeGetFtcRsp osaMeGetFtcRsp = this.getFtcState(coordinator);
        int[] nArray = osaMeGetFtcRsp.getPiuId();
        int[] nArray2 = osaMeGetFtcRsp.getFtcState();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        if (nArray != null && nArray2 != null) {
            for (int i = 0; i < nArray.length; ++i) {
                ManagedObject managedObject = this.getPiuFromFroId(nArray[i], coordinator);
                if (managedObject == null) continue;
                stringArray[n] = managedObject.getLocalDistinguishedName() + ";ftcState=" + this.getState(nArray2[i]);
                ++n;
            }
        }
        String[] stringArray2 = new String[n];
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray2[n] = stringArray[i];
            ++n;
        }
        return stringArray2;
    }

    public ManagedObject[] getFtcsMos(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaMeGetFtcRsp osaMeGetFtcRsp = this.getFtcState(coordinator);
        int[] nArray = osaMeGetFtcRsp.getPiuId();
        int[] nArray2 = osaMeGetFtcRsp.getFtcState();
        ManagedObject[] managedObjectArray = new ManagedObject[nArray.length];
        int n = 0;
        if (nArray != null && nArray2 != null) {
            for (int i = 0; i < nArray.length; ++i) {
                ManagedObject managedObject = this.getPiuFromFroId(nArray[i], coordinator);
                if (managedObject == null) continue;
                managedObjectArray[n] = managedObject;
                ++n;
            }
        }
        ManagedObject[] managedObjectArray2 = new ManagedObject[n];
        n = 0;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] == null) continue;
            managedObjectArray2[n] = managedObjectArray[i];
            ++n;
        }
        return managedObjectArray2;
    }

    public int[] getFtcStates(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaMeGetFtcRsp osaMeGetFtcRsp = this.getFtcState(coordinator);
        int[] nArray = osaMeGetFtcRsp.getPiuId();
        int[] nArray2 = osaMeGetFtcRsp.getFtcState();
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        if (nArray != null && nArray2 != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (this.getPiuFromFroId(nArray[i], coordinator) == null) continue;
                nArray3[n] = nArray2[i];
                ++n;
            }
        }
        int[] nArray4 = new int[n];
        n = 0;
        for (int i = 0; i < nArray3.length; ++i) {
            if (nArray3[i] == 0) continue;
            nArray4[n] = nArray3[i];
            ++n;
        }
        return nArray4;
    }

    public boolean isIDL1_IDL2(Coordinator coordinator) throws MoAccessException {
        int n = this.getTopologyVersion(coordinator);
        MessageLog.trace((int)5, (Class)ManagedElementMoImpl.class, (String)("Topology Version = " + this.getTopologyMsg(n)));
        return n == 5;
    }

    private OsaMeGetNodeIdRsp getFroNodeData(Coordinator coordinator) throws MoAccessException {
        OsaMeGetNodeIdRsp osaMeGetNodeIdRsp;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if ((osaMeGetNodeIdRsp = this.osaMeMgmntProxy.sendOsaMeGetNodeIdReq(n)) == null) {
            throw new FroNotAccessibleException("ManagedElement", "ManagedElementProxy");
        }
        if (osaMeGetNodeIdRsp.getResult() != 1) {
            throw new FroRequestFailedException("ManagedElement", "ManagedElement", "GetAttrReq: " + this.osaMeMgmntProxy.getResultMsg(osaMeGetNodeIdRsp.getResult()), osaMeGetNodeIdRsp.getResult());
        }
        return osaMeGetNodeIdRsp;
    }

    private void setFroNodeData(Coordinator coordinator, String string, String string2, String string3, String string4, String string5) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        OsaMeSetNodeIdRsp osaMeSetNodeIdRsp = this.osaMeMgmntProxy.sendOsaMeSetNodeIdReq(coordinator.getTransactionID(), string, string2, string3, string4, string5);
        if (osaMeSetNodeIdRsp == null) {
            throw new FroNotAccessibleException("ManagedElement", "ManagedElementProxy");
        }
        if (osaMeSetNodeIdRsp.getResult() != 1) {
            throw new FroRequestFailedException("ManagedElement", "ManagedElement", "SetAttrReq: " + this.osaMeMgmntProxy.getResultMsg(osaMeSetNodeIdRsp.getResult()), osaMeSetNodeIdRsp.getResult());
        }
    }

    private OsaMeGetFtcRsp getFtcState(Coordinator coordinator) throws MoAccessException {
        OsaMeGetFtcRsp osaMeGetFtcRsp;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if ((osaMeGetFtcRsp = this.osaMeMgmntProxy.sendOsaMeGetFtcStateReq(n)) == null) {
            throw new FroNotAccessibleException("ManagedElement", "ManagedElementProxy");
        }
        return osaMeGetFtcRsp;
    }

    public int getTopologyVersion(Coordinator coordinator) throws MoAccessException {
        OsaMeGetTopologyVersionRsp osaMeGetTopologyVersionRsp;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        if ((osaMeGetTopologyVersionRsp = this.osaMeMgmntProxy.sendOsaMeGetTopologyVersionReq(n)) == null) {
            throw new FroNotAccessibleException("ManagedElement", "ManagedElementProxy");
        }
        return osaMeGetTopologyVersionRsp.getTopologyVersion();
    }

    private ManagedObject getPiuFromFroId(int n, Coordinator coordinator) throws MoAccessException {
        PlugInUnitRepository plugInUnitRepository = (PlugInUnitRepository)this.getMaoContext().getServiceRepository().getService(PlugInUnitRepository.class);
        if (plugInUnitRepository != null) {
            return plugInUnitRepository.lookupInstance(n, coordinator);
        }
        MessageLog.info(this.getClass(), (String)"PlugInUnitRepository not registered in ServiceRepository.");
        return null;
    }

    public String getUserName() {
        String string = "";
        try {
            string = this.getLogicalName(null);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info((Class)ManagedElementMoImpl.class, (String)"Unable to retrieve userName for PMS");
        }
        return string;
    }

    public String getSoftwareVersion() {
        String string = "";
        try {
            MO_HandlerFactoryAccessBase mO_HandlerFactoryAccessBase = (MO_HandlerFactoryAccessBase)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccessBase.class);
            ConfigurationVersionMO_HandlerAccess configurationVersionMO_HandlerAccess = mO_HandlerFactoryAccessBase.getConfigurationVersionMO_HandlerAccess();
            UpgradePackageAccess upgradePackageAccess = configurationVersionMO_HandlerAccess.getCurrentUpgradePackageForME(null);
            if (upgradePackageAccess != null) {
                string = upgradePackageAccess.getUpgradePackageDocumentIdForME(null);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)"Unable to retrieve softwareVersion for PMS");
        }
        return string;
    }

    protected void registerInPMS() {
        NESupplier.instance().registerNE((NEInfoSupplier)this);
    }

    public String getState(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "Init";
                break;
            }
            case 2: {
                string = "NotConfigured";
                break;
            }
            case 3: {
                string = "Active";
                break;
            }
            case 4: {
                string = "Unavailable";
                break;
            }
            case 5: {
                string = "PassiveNotReady";
                break;
            }
            case 6: {
                string = "PassiveReady";
                break;
            }
            default: {
                string = "UnknownState: " + n;
            }
        }
        return string;
    }

    public String getTopologyMsg(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "CELLO_ME_TOPOLOGY_AMX:" + n;
                break;
            }
            case 1: {
                string = "CELLO_ME_TOPOLOGY_IDL1:" + n;
                break;
            }
            case 2: {
                string = "CELLO_ME_TOPOLOGY_EGEM2: " + n;
                break;
            }
            case 3: {
                string = "CELLO_ME_TOPOLOGY_IDL1_5: " + n;
                break;
            }
            case 4: {
                string = "CELLO_ME_TOPOLOGY_SIMCELLO: " + n;
                break;
            }
            case 5: {
                string = "CELLO_ME_TOPOLOGY_IDL1_IDL2: " + n;
                break;
            }
            case 255: {
                string = "CELLO_ME_TOPOLOGY_UNDEF: OxFF";
                break;
            }
            default: {
                string = "UNKNOWN TOPOLOGY VERSION: " + n;
            }
        }
        return string;
    }

    private ManagedElementMoImpl() throws MoNameAlreadyTakenException {
        super(null, ManagedElementMoFactory.instance().getMoTypeName(), MANAGED_ELEMENT_ID_VALUE, null);
        MibMgr.instance().registerMib((Mib)this);
        ServiceLocatorFacade.getRepository().addService((Object)this, ManagedElementMoSU_Access.class, null);
        this.scheduleMgr = new ScheduleManager("File system health check", new ScheduledHealthCheck(this), (Scheduler)SchedulerImpl.instance());
    }

    public boolean getPhasedRestartCheckReq() throws MoAccessException {
        boolean bl = false;
        try {
            OsaMePhasedRestartCheckRsp osaMePhasedRestartCheckRsp = this.osaMeMgmntProxy.sendOsaMePhasedRestartCheckReq();
            if (osaMePhasedRestartCheckRsp != null) {
                MessageLog.info(this.getClass(), (String)"Received Phased Restart Response from FRO");
                bl = true;
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            MessageLog.traceError(this.getClass(), (String)"Unable to retrieve Phased Restart Response from FRO", (Throwable)froNotAccessibleException);
        }
        return bl;
    }

    static {
        mimInfoNames = new String[]{MIM_TYPE, MIM_VERSION, MIM_RELEASE};
        SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3", "SU_4"};
    }

    private static class RestartDelay
    implements Runnable {
        private int restartRank;
        private int restartReason;
        private String restartInfo;

        RestartDelay(int n, int n2, String string) {
            this.restartRank = n;
            this.restartReason = n2;
            this.restartInfo = string;
        }

        public void run() {
            try {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                OsaMeMgmntProxy.instance().sendOsaMe3RestartReq(this.restartRank, this.restartReason, this.restartInfo);
            }
            catch (Exception exception) {
                MessageLog.info(this.getClass(), (String)"run: ");
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
            }
        }
    }

    private static class TxResource
    implements Resource {
        private String mibPrefix = "";

        public TxResource(String string) {
            this.mibPrefix = string;
        }

        public void commit() {
            AlarmIRP_1Impl.instance().notifyAlarmListRebuilt();
            MosiNotificationSender.mibPrefixValueChanged((String)this.mibPrefix);
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }
}

