/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.managedelement.StructDstRuleImpl;
import se.ericsson.cello.managedelement.StructNtpKeyDataImpl;
import se.ericsson.cello.managedelement.TimeSettingMoGen;
import se.ericsson.cello.managedelement.mom.EnumDstMonth;
import se.ericsson.cello.managedelement.mom.StructDstRule;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.StringChecksUtils;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateManager;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class TimeSettingMoImpl
extends TimeSettingMoGen
implements LogContentInspector {
    protected static ServiceProvider serviceProvider;
    private static final int NODE_UTC_TIME_MIN = 0;
    private static final int TIMESETTING_FRO_ID = 1;
    private static final int DST_DAY_RULE_MAX_LENGTH = 9;
    private static final int MONTH_FIRST_DAY = 1;
    private static int serviceProviderState;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public TimeSettingMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, maoFroIndicationHandler);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "TimeSetting");
    }

    public TimeSettingMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, true, froProxy, maoFroIndicationHandler);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "TimeSetting");
    }

    public void addParameterNames(ParameterNames parameterNames) {
        parameterNames.add("dstEndRuleString");
        parameterNames.add("dstStartRuleString");
    }

    protected void validateTimeOffset(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateTimeOffset(string, setRequestContext);
        this.validateFormat(string, "", "[-]dd:dd", "Should be in the form [-]hh:mm");
    }

    private void validateFormat(String string, String string2, String string3, String string4) throws IllegalAttributeValueException {
        boolean bl = true;
        if (!string.equals(string2)) {
            bl = StringChecksUtils.validateFormatWithOptionalChars((String)string, (String)string3);
        }
        if (!bl) {
            throw new IllegalAttributeValueException("Wrong attribute format." + string4, "TimeSetting");
        }
    }

    protected void validateDaylightSavingTimeOffset(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateDaylightSavingTimeOffset(string, setRequestContext);
        this.validateSimpleFormat(string, "", "dd:dd", " Should be in the form hh:mm");
    }

    private void validateSimpleFormat(String string, String string2, String string3, String string4) throws IllegalAttributeValueException {
        boolean bl = true;
        if (!string.equals(string2)) {
            bl = StringChecksUtils.validateFormat((String)string, (String)string3);
        }
        if (!bl) {
            throw new IllegalAttributeValueException("Wrong attribute format. " + string4, "TimeSetting");
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return 1;
    }

    protected void validateGpsToUtcLeapSecondsChangeDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateGpsToUtcLeapSecondsChangeDate(string, setRequestContext);
        this.validateFormat(string, "", "[-]dddd-dd-dd", "Should be in the form [-]yyyy-mm-dd)");
    }

    private Object getOfDeprecatedAttributes(GetRequestContext getRequestContext, String string, String string2) throws MoAccessException {
        StringParameter stringParameter = (StringParameter)getRequestContext.getParameter(string);
        if (stringParameter == null) {
            throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: " + string2, "getAttributes", -1);
        }
        return stringParameter.getValue();
    }

    protected Object handleGetDaylightSavingTimeStartDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstStartRuleString", "daylightSavingTimeStartDate");
    }

    private void setOfDeprecatedAttributes(String string, String string2, SetRequestContext setRequestContext, String string3, String string4, String string5) throws MoAccessException {
        String string6 = "";
        if (string != null && string != string6) {
            if (string.equals(string2)) {
                throw new OperationNotAllowedException("The daylightSavingStartDate and daylightSavingEndDate must not be equal", "TimeSetting");
            }
            this.validateSimpleFormat(string, string6, "dddd-dd-dd dd:dd", " Should be in the form yyyy-mm-dd hh:mm");
            this.validateStringDstDates(string, string3);
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter(string5, string));
        if (string != null) {
            Struct struct = TimeSettingMoImpl.convertStringDsttoStructDst(string);
            setRequestContext.addParameter(this.froProxy, (Parameter)StructDstRuleImpl.toStructParameter(struct, "TimeSetting", string4));
            setRequestContext.addAvcNotification(string4, (Object)struct);
        }
        setRequestContext.addAvcNotification(string3, (Object)string);
    }

    protected void handleSetDaylightSavingTimeStartDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeEndDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeStartDate", "daylightSavingTimeStartRule", "dstStartRuleString");
    }

    protected Object handleGetDaylightSavingTimeEndDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstEndRuleString", "daylightSavingTimeEndDate");
    }

    protected void handleSetDaylightSavingTimeEndDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeStartDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeEndDate", "daylightSavingTimeEndRule", "dstEndRuleString");
    }

    protected Object handleGetDaylightSavingTimeOffDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstEndRuleString", "daylightSavingTimeOffDate");
    }

    protected void handleSetDaylightSavingTimeOffDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeOnDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeOffDate", "daylightSavingTimeEndRule", "dstEndRuleString");
    }

    protected Object handleGetDaylightSavingTimeOnDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstStartRuleString", "daylightSavingTimeOnDate");
    }

    protected void handleSetDaylightSavingTimeOnDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeOffDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeOnDate", "daylightSavingTimeStartRule", "dstStartRuleString");
    }

    public void actionSetNodeUTCTime(long l, Coordinator coordinator) throws MoAccessException {
        Object object;
        if (l < 0L) {
            throw new ValueOutOfRangeException("TimeSetting", "NodeUTCTime can not be set to a time before January 1,1970, 00:00:00 GMT.");
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        MoIterator moIterator = MoRepository.instance().lookupType("NtpServer");
        while (moIterator != null && moIterator.hasMoreElements()) {
            object = (NtpServerMo)moIterator.nextElement();
            if (!object.getServiceActive(coordinator)) continue;
            throw new ActionNotAllowedException("TimeSetting", "serviceActive must be false on all NtpServer. " + object.getLocalDistinguishedName() + " is active");
        }
        object = new ArrayList();
        ((ArrayList)object).add(new UnsignedIntParameter("nodeUTCTime", l /= 1000L));
        this.froProxy.actionWithCfm(coordinator, 1, 101, (Collection)object);
    }

    public void actionInstallNtpKeys(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        ArrayParameter arrayParameter = StructNtpKeyDataImpl.toArrayParameter(structArray, "TimeSetting", "installNtpKeys_ntpKeyDataList", 10);
        this.validateNtpKeyDataList(structArray);
        arrayList.add(arrayParameter);
        this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 103, arrayList);
    }

    private void validateNtpKeyDataList(Struct[] structArray) throws MoAccessException {
        String[] stringArray = new String[]{"09", "20", "23", "0A", "00"};
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            if (!hashSet.add(struct.getValue("ntpKeyId"))) {
                throw new ActionNotAllowedException("TimeSetting", "ntpKeyId should be unique");
            }
            String string = (String)struct.getValue("ntpKey");
            MoAttributeValidator.validateForIllegalCharacters((String)"ntpKey", (String)string, (String)"TimeSetting");
            if (string.indexOf("#") != -1 || string.indexOf(" ") != -1 || string.indexOf("`") != -1 || string.indexOf("\u00b4") != -1) {
                throw new IllegalAttributeValueException("Attribute (ntpKey) contains one or more illegal characters", "TimeSetting");
            }
            if (string.length() > 20 && string.length() % 2 != 0) {
                throw new ValueOutOfRangeException("ntpKey String should have even number of characters when length is greater than 20", "TimeSetting");
            }
            if (string.length() <= 20) continue;
            String[] stringArray2 = new String[string.length() / 2];
            int n = 0;
            int n2 = 2;
            for (int j = 0; j < string.length() / 2; ++j) {
                stringArray2[j] = string.substring(n, n2);
                for (int k = 0; k < stringArray.length; ++k) {
                    if (!stringArray2[j].equalsIgnoreCase(stringArray[k])) continue;
                    throw new IllegalAttributeValueException("Attribute (ntpKey) contains unsupported hex characters: " + stringArray[k], "TimeSetting");
                }
                n = n2;
                n2 += 2;
            }
        }
    }

    public void actionRemoveNtpKeys(int[] nArray, Coordinator coordinator) throws MoAccessException {
        int n;
        Object object;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (nArray.length == 0) {
            throw new ValueOutOfRangeException("TimeSetting", "There should be at least one ntpKeyId specified");
        }
        MoIterator moIterator = MoRepository.instance().lookupType("NtpServer");
        while (moIterator != null && moIterator.hasMoreElements()) {
            object = (NtpServerMo)moIterator.nextMo();
            int n2 = object.getNtpKeyId(null);
            for (n = 0; n < nArray.length; ++n) {
                if (n2 != nArray[n]) continue;
                throw new ActionNotAllowedException("TimeSetting", "Trying to remove ntpKeyId set on NtpServer " + object.getLocalDistinguishedName());
            }
        }
        object = new ArrayList();
        ArrayParameter arrayParameter = new ArrayParameter("removeNtpKeys_ntpKeyIdList");
        for (n = 0; n < nArray.length; ++n) {
            arrayParameter.add((Parameter)new SignedIntParameter("removeNtpKeys_ntpKeyIdList_member", nArray[n]));
        }
        ((ArrayList)object).add(arrayParameter);
        this.froProxy.actionWithCfm(coordinator, 1, 104, (Collection)object);
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        String string;
        Struct struct;
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("daylightSavingTimeStartRule")) {
            struct = (Struct)setRequestContext.getAttributeFromRequest("daylightSavingTimeStartRule");
            string = this.getDaylightSavingTimeEndDate(coordinator);
            this.addDstRulesInSet(struct, string, "dstStartRuleString", "daylightSavingTimeStartRule", setRequestContext, "dstEndRuleString");
        }
        if (setRequestContext.isIncludedInRequest("daylightSavingTimeEndRule")) {
            struct = (Struct)setRequestContext.getAttributeFromRequest("daylightSavingTimeEndRule");
            string = this.getDaylightSavingTimeStartDate(coordinator);
            this.addDstRulesInSet(struct, string, "dstEndRuleString", "daylightSavingTimeEndRule", setRequestContext, "dstEndRuleString");
        }
    }

    private void addDstRulesInSet(Struct struct, String string, String string2, String string3, SetRequestContext setRequestContext, String string4) throws MoAccessException {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        Coordinator coordinator = setRequestContext.getCoordinator();
        boolean bl = false;
        boolean bl2 = false;
        String string5 = this.format.format(calendar.getTime());
        String string6 = this.validateDstRule(struct, n);
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter(string2, string6));
        String string7 = (String)struct.getValue("time");
        String string8 = (String)struct.getValue("dayRule");
        if (string7.equals("24:00") && string8.length() == 1 || string8.length() == 2) {
            struct = TimeSettingMoImpl.convertStringDsttoStructDst(string6);
            setRequestContext.replaceParameter(this.froProxy, (Parameter)StructDstRuleImpl.toStructParameter(struct, "TimeSetting", string3));
        }
        if (!string.equals("") && !string6.equals("")) {
            boolean bl3;
            if (string3.equalsIgnoreCase("daylightSavingTimeEndRule")) {
                bl = this.compareStartandEndRules(string6, string);
                bl3 = this.compareStartandEndRules(string5, this.addOffSetToTime(string6, coordinator));
                if (!bl) {
                    bl2 = this.checkDstDatesTimeDiff(string6, string);
                }
                if (bl3) {
                    bl = false;
                }
            } else {
                bl = this.compareStartandEndRules(string, string6);
                bl3 = this.compareStartandEndRules(string5, this.addOffSetToTime(string, coordinator));
                if (!bl) {
                    bl2 = this.checkDstDatesTimeDiff(string, string6);
                }
                if (bl3) {
                    bl = false;
                }
            }
            if (bl || bl2) {
                Struct struct2 = string3.equalsIgnoreCase("daylightSavingTimeEndRule") ? struct : this.getDaylightSavingTimeEndRule(coordinator);
                String string9 = this.validateDstRule(struct2, ++n);
                setRequestContext.replaceParameter(this.froProxy, (Parameter)new StringParameter(string4, string9));
            }
        }
    }

    private boolean checkDstDatesTimeDiff(String string, String string2) {
        try {
            Date date = this.format.parse(string2);
            Date date2 = this.format.parse(string);
            long l = date2.getTime() - date.getTime();
            long l2 = l / 3600000L;
            if (l2 < 24L) {
                return true;
            }
        }
        catch (ParseException parseException) {
            MessageLog.traceError(this.getClass(), (String)("parse exception: " + parseException.toString()));
        }
        return false;
    }

    private String addOffSetToTime(String string, Coordinator coordinator) throws MoAccessException {
        if (string.equals("")) {
            return string;
        }
        try {
            String string2 = this.getTimeOffset(coordinator);
            boolean bl = false;
            if (string2.equals("")) {
                return string;
            }
            if (string2.startsWith("-")) {
                string2 = string2.substring(1, string2.length());
                bl = true;
            } else {
                string2 = "-" + string2;
            }
            int n = string2.indexOf(":");
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length());
            if (!bl) {
                string4 = "-" + string4;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.format.parse(string));
            calendar.setTimeZone(this.format.getTimeZone());
            calendar.add(12, Integer.parseInt(string4));
            calendar.add(11, Integer.parseInt(string3));
            return this.format.format(calendar.getTime());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return string;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateDstRule(Struct struct, int n) throws MoAccessException {
        String string;
        Struct struct2 = struct;
        boolean bl = this.isDeFaultValues(struct);
        if (bl) {
            return "";
        }
        String string2 = "0";
        String string3 = (String)struct2.getValue("time");
        this.checktimeRange(string3);
        int n2 = (Integer)struct2.getValue("month");
        MoGenUtil.checkEnumAttribute((String)"month", (int)n2, (int[])EnumDstMonth.VALUES_ARRAY, (String)"TimeSetting");
        String string4 = Integer.toString(n2);
        if (string4.length() == 1) {
            string4 = string2.concat(string4);
        }
        if ((string = (String)struct2.getValue("dayRule")) != null) {
            int n3;
            if (string.length() > 9) {
                throw new ValueOutOfRangeException("Invalid dayRule given", "dayRule", "TimeSetting");
            }
            if (string.length() == 1) {
                this.validateSimpleFormat(string, "", "d", "dayRule should be in the format d if dayRule is of single digit");
                if (string.equals(string2)) {
                    throw new IllegalAttributeValueException("dayRule value cannot be 0", "dayRule", "TimeSetting");
                }
                string = string2.concat(string);
            } else if (string.length() == 2) {
                this.validateSimpleFormat(string, "", "dd", "should be in the format dd if dayRule is of double digit");
                int n4 = Integer.parseInt(string);
                n3 = this.getMonthLastDate(n2, n);
                if (n4 < 1) throw new IllegalAttributeValueException("dayRule value cannot be greater than the last date of the given month", "dayRule", "TimeSetting");
                if (n4 > n3) {
                    throw new IllegalAttributeValueException("dayRule value cannot be greater than the last date of the given month", "dayRule", "TimeSetting");
                }
            } else if (string.startsWith("last")) {
                if (string.length() != 7) throw new IllegalAttributeValueException("if dayRule starts with last then it should be in the format DDD, where DDD can be Sun, Mon, Tue, Wed, Thu, Fri, Sat", "dayRule", "TimeSetting");
                String string5 = string.substring(4);
                this.validateDDD(string5);
                n3 = this.getDayOfWeek(string5);
                int n5 = this.getLastDDDdate(n3, n2, n);
                string = Integer.toString(n5);
            } else {
                if (Lib.containsWhiteSpace((String)string)) {
                    string = Lib.removeWhiteSpaces((String)string);
                }
                String string6 = string.substring(0, 3);
                this.validateDDD(string6);
                n3 = this.getMonthLastDate(n2, n);
                String string7 = "";
                int n6 = 0;
                if (string.length() == 6) {
                    this.validateSimpleFormat(string, "", "www>=d", "should be in the format DDD >= N");
                    string7 = string.substring(5);
                    n6 = Integer.parseInt(string7);
                } else {
                    if (string.length() != 7) throw new IllegalAttributeValueException("Wrong format of dayRule entered", "dayRule", "TimeSetting");
                    this.validateSimpleFormat(string, "", "www>=dd", "should be in the format DDD >= N");
                    string7 = string.substring(5);
                    n6 = Integer.parseInt(string7);
                    if (n6 > n3) {
                        throw new IllegalAttributeValueException(string7 + " should not be greater than last date of the given month", "dayRule", "TimeSetting");
                    }
                }
                int n7 = this.getDayOfWeek(string6);
                int n8 = this.getDDDdate(n6, n7, n3, n2, n);
                if (n8 == 0) {
                    throw new IllegalAttributeValueException("There is no " + string6 + " greater than " + string7, "dayRule", "TimeSetting");
                }
                string = Integer.toString(n8);
                if (string.length() == 1) {
                    string = string2.concat(string);
                }
            }
        }
        String string8 = n + "-" + string4 + "-" + string + " " + string3;
        String string9 = "";
        try {
            Date date = this.format.parse(string8);
            return this.format.format(date);
        }
        catch (ParseException parseException) {
            MessageLog.traceError(this.getClass(), (String)("parse exception: " + parseException.toString()));
        }
        return string9;
    }

    private boolean isDeFaultValues(Struct struct) throws MoAccessException {
        String string = (String)struct.getValue("dayRule");
        String string2 = (String)struct.getValue("time");
        int n = (Integer)struct.getValue("month");
        if (n == 1) {
            if (string.equals("") && !string2.equals("")) {
                throw new IllegalAttributeValueException("If given dayRule and month are  of default values then the value of time entered should be default", "TimeSetting");
            }
            if (string2.equals("") && !string.equals("")) {
                throw new IllegalAttributeValueException("If given time and month are  of default values then the value of dayRule entered should be default", "TimeSetting");
            }
            if (string.equals("") && string2.equals("")) {
                return true;
            }
        } else if (string.equals("")) {
            if (n != 1 && !string2.equals("")) {
                throw new IllegalAttributeValueException("if given dayRule is of default value then the other values of struct entered should be default", "TimeSetting");
            }
        } else if (string2.equals("") && n != 1 && !string.equals("")) {
            throw new IllegalAttributeValueException("if given time is of default value then the other values of struct entered should be default", "TimeSetting");
        }
        return false;
    }

    private void validateDDD(String string) throws IllegalAttributeValueException {
        this.validateSimpleFormat(string, "", "www", "should be in the format DDD");
        if (!(string.equalsIgnoreCase("Sun") || string.equalsIgnoreCase("Mon") || string.equalsIgnoreCase("Tue") || string.equalsIgnoreCase("Wed") || string.equalsIgnoreCase("Thu") || string.equalsIgnoreCase("Fri") || string.equalsIgnoreCase("Sat"))) {
            throw new IllegalAttributeValueException("DDD can only be Sun, Mon, Tue, Wed, Thu, Fri, Sat", "dayRule", "TimeSetting");
        }
    }

    private int getDDDdate(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n5, n4 - 1, n);
        int n6 = calendar.get(7);
        int n7 = 0;
        if (n2 == n6) {
            return n;
        }
        n7 = n6 < n2 ? n2 - n6 : (n2 += 7) - n6;
        if (n + n7 > n3) {
            return 0;
        }
        return n + n7;
    }

    private int getLastDDDdate(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        int n4 = this.getMonthLastDate(n2, n3);
        calendar.set(n3, n2 - 1, n4);
        int n5 = calendar.get(7);
        int n6 = 0;
        if (n == n5) {
            return n4;
        }
        n6 = n5 > n ? n5 - n : (n5 += 7) - n;
        return n4 - n6;
    }

    private int getDayOfWeek(String string) {
        if (string.equalsIgnoreCase("Sun")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Mon")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Tue")) {
            return 3;
        }
        if (string.equalsIgnoreCase("Wed")) {
            return 4;
        }
        if (string.equalsIgnoreCase("Thu")) {
            return 5;
        }
        if (string.equalsIgnoreCase("Fri")) {
            return 6;
        }
        if (string.equalsIgnoreCase("Sat")) {
            return 7;
        }
        return 0;
    }

    private int getMonthLastDate(int n, int n2) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0 ? 29 : 28;
    }

    private static Struct convertStringDsttoStructDst(String string) {
        if (string.equals("")) {
            StructImpl structImpl = new StructImpl(StructDstRule.ELEMENT_NAMES, StructDstRule.ELEMENT_DEFAULTVALUES);
            return structImpl;
        }
        String string2 = string.substring(5, 7);
        String string3 = string.substring(8, 10);
        String string4 = string.substring(11);
        if (string3.startsWith("0")) {
            string3 = string3.substring(1);
        }
        if (string2.startsWith("0")) {
            string2 = string2.substring(1);
        }
        int n = Integer.parseInt(string2);
        Struct struct = StructDstRule.createStruct(string3, n, string4);
        return struct;
    }

    protected void updateParamChangedInd(Map map, String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (string.equals("daylightSavingTimeOn")) {
            try {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("daylightSavingTimeOn");
                Calendar calendar = Calendar.getInstance();
                String string2 = this.format.format(calendar.getTime());
                MessageLog.info(this.getClass(), (String)("DST switches to " + signedIntParameter.getBoolean() + " at " + string2));
                if (!signedIntParameter.getBoolean()) {
                    TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                    Control control = transactionFactory.create(3600);
                    Coordinator coordinator = control.getCoordinator();
                    String string3 = this.addOffSetToTime(this.getDaylightSavingTimeStartDate(coordinator), coordinator);
                    String string4 = this.addOffSetToTime(this.getDaylightSavingTimeEndDate(coordinator), coordinator);
                    if (!string4.equals("") && !string3.equals("")) {
                        String string5 = "";
                        String string6 = "";
                        Struct struct = this.getDaylightSavingTimeEndRule(coordinator);
                        Struct struct2 = this.getDaylightSavingTimeStartRule(coordinator);
                        int n = Integer.parseInt(string3.substring(0, 4));
                        int n2 = Integer.parseInt(string4.substring(0, 4));
                        boolean bl = this.compareStartandEndRules(string3, string2);
                        boolean bl2 = this.compareStartandEndRules(string2, string4);
                        if (!bl2) {
                            ++n2;
                        }
                        string5 = this.validateDstRule(struct, n2);
                        if (bl) {
                            ++n;
                        }
                        string6 = this.validateDstRule(struct2, n);
                        if (!bl2 || bl) {
                            String[] stringArray = new String[]{"dstEndRuleString", "dstStartRuleString"};
                            Object[] objectArray = new Object[]{string5, string6};
                            SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
                            setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("dstEndRuleString", string5));
                            setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("dstStartRuleString", string6));
                            setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
                            setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
                            control.getTerminator().commit();
                            serviceProviderState = 1;
                            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
                            return;
                        }
                    }
                    control.getTerminator().commit();
                }
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                transactionRolledBackException.printStackTrace();
                MessageLog.traceError(this.getClass(), (String)("rollback exception: " + transactionRolledBackException.toString()));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                inactiveTransactionException.printStackTrace();
                MessageLog.traceError(this.getClass(), (String)("InactiveTransactionException : " + inactiveTransactionException.toString()));
            }
        }
    }

    private boolean compareStartandEndRules(String string, String string2) {
        try {
            Date date = this.format.parse(string2);
            Date date2 = this.format.parse(string);
            if (date2.before(date)) {
                return true;
            }
        }
        catch (ParseException parseException) {
            MessageLog.traceError(this.getClass(), (String)("parse exception: " + parseException.toString()));
        }
        return false;
    }

    private void validateStringDstDates(String string, String string2) throws MoAccessException {
        int n = Integer.parseInt(string.substring(0, 4));
        String string3 = string.substring(5, 7);
        String string4 = string.substring(8, 10);
        String string5 = string.substring(11);
        this.checktimeRange(string5);
        if (string3.startsWith("0")) {
            string3 = string3.substring(1);
        }
        int n2 = Integer.parseInt(string3);
        MoGenUtil.checkEnumAttribute((String)"month", (int)n2, (int[])EnumDstMonth.VALUES_ARRAY, (String)"TimeSetting");
        if (string4.startsWith("0")) {
            string4 = string4.substring(1);
        }
        int n3 = this.getMonthLastDate(n2, n);
        int n4 = Integer.parseInt(string4);
        if (n4 > n3) {
            throw new ValueOutOfRangeException(string2, "TimeSetting", "The day entered is greater than " + n3 + " that is the last date of the given month");
        }
    }

    private void checktimeRange(String string) throws MoAccessException {
        if (string != null) {
            this.validateSimpleFormat(string, "", "dd:dd", "time should be in the format dd:dd");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2);
                if (n < 0 || n > 24) {
                    throw new ValueOutOfRangeException("hour should be in the range 0 to 24", "time", "TimeSetting");
                }
                String string3 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string3);
                if (n == 24 && n2 != 0) {
                    throw new ValueOutOfRangeException("if hour is 24 then minute can only be 0", "time", "TimeSetting");
                }
                if (n2 < 0 || n2 > 59) {
                    throw new ValueOutOfRangeException("minute should be in the range 0 to 59", "time", "TimeSetting");
                }
            }
        }
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        if (string.equalsIgnoreCase("nodeUTCTime")) {
            UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)getRequestContext.getParameter("nodeUTCTime");
            object = new Long(unsignedIntParameter.getValue() * 1000L);
        } else if (string.equalsIgnoreCase("daylightSavingTimeEndRule") || string.equalsIgnoreCase("daylightSavingTimeStartRule")) {
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            StructParameter structParameter = (StructParameter)getRequestContext.getParameter(string);
            String string2 = this.validateDstRule(StructDstRuleImpl.toStruct(structParameter), n);
            StringParameter stringParameter = string.equalsIgnoreCase("daylightSavingTimeStartRule") ? (StringParameter)getRequestContext.getParameter("dstStartRuleString") : (StringParameter)getRequestContext.getParameter("dstEndRuleString");
            if (string2.equals("") && !string2.equals(stringParameter.getValue())) {
                Control control = null;
                try {
                    TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                    control = transactionFactory.create(3600);
                    Coordinator coordinator = control.getCoordinator();
                    Struct struct = TimeSettingMoImpl.convertStringDsttoStructDst(stringParameter.getValue());
                    String[] stringArray = new String[]{string};
                    Object[] objectArray = new Object[]{struct};
                    SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)StructDstRuleImpl.toStructParameter(struct, "TimeSetting", string));
                    setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
                    setRequestContextImpl.addAvcNotification(string, (Object)struct);
                    setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
                    control.getTerminator().commit();
                    return struct;
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    MessageLog.traceError(this.getClass(), (String)("rollback exception: " + transactionRolledBackException.toString()));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)("Inactive Transaction Exception: " + inactiveTransactionException.toString()));
                }
            }
            return StructDstRuleImpl.toStruct(structParameter);
        }
        return object;
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (string.equalsIgnoreCase("installNtpKeys")) {
                return this.blankNtpKeyValue(objectArray);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }

    private Object[] blankNtpKeyValue(Object[] objectArray) {
        try {
            Struct[] structArray = (Struct[])objectArray[0];
            Struct[] structArray2 = new Struct[structArray.length];
            String[] stringArray = new String[]{"ntpKeyId", "keyType", "ntpKey"};
            for (int i = 0; i < structArray2.length; ++i) {
                Object[] objectArray2 = new Object[]{structArray[i].getValue("ntpKeyId"), structArray[i].getValue("keyType"), "*****"};
                structArray2[i] = new StructImpl(stringArray, objectArray2);
            }
            objectArray[0] = structArray2;
            return objectArray;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + (Object)((Object)moAccessException)));
            return null;
        }
    }

    static {
        serviceProviderState = 2;
    }

    static class DstServiceProviderImpl
    implements ServiceProvider {
        public String getServiceName() {
            return "DST.CHANGED";
        }

        public int getState() {
            return serviceProviderState;
        }
    }
}

