/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.controller;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.ActionExecutionListener;
import se.ericsson.cello.emt.moproperties.controller.AttributeModelFetcherListener;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.moproperties.controller.ProgressController;
import se.ericsson.cello.emt.moproperties.controller.PushAttributeValueListener;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModel;
import se.ericsson.cello.emt.moproperties.view.MoPropertiesView;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.ActionModel;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoPropertiesControllerImpl
implements MoPropertiesController {
    private MoPropertiesModel myMoPropModel = null;
    private MoPropertiesView myMoPropView = null;
    private Configuration myConfiguration = null;
    private ProgressController myProgressController = null;
    private List<Thread> myOngoingAttrWorkerThreads = new ArrayList<Thread>(0);
    private List<Thread> myOngoingActionWorkerThreads = new ArrayList<Thread>(0);

    public MoPropertiesControllerImpl(MoPropertiesModel aModel) {
        this.myMoPropModel = aModel;
        this.myConfiguration = this.myMoPropModel.getConfiguration();
    }

    @Override
    public void initializeView() {
        if (null != this.myMoPropView) {
            this.myMoPropView.initialize();
        }
    }

    @Override
    public MoPropertiesModel getModel() {
        return this.myMoPropModel;
    }

    @Override
    public void setView(MoPropertiesView moPropView) {
        this.myMoPropView = moPropView;
    }

    @Override
    public void showUIView(boolean visible) {
        if (null != this.myMoPropView) {
            this.myMoPropView.showUI(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAttributeModelsAsynchronous(final String attributeGroupName, final AttributeModelFetcherListener listener) {
        MoPropLog.logger().fine("start a worker thread to fetch the attribute models from the MoModel");
        Runnable attrModelFetcherRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block23: {
                    if (null == MoPropertiesControllerImpl.this.myConfiguration.getSelectedActionName()) {
                        MoPropertiesControllerImpl.this.myMoPropView.startAttributeStatusProgressMonitor("Reading attribute values...");
                    }
                    List<AttributeModel> resultList = null;
                    try {
                        boolean continueWithNotification;
                        if (null == listener) break block23;
                        if (null == attributeGroupName) {
                            MoPropLog.logger().fine("get the ordinary attribute models (no attribute group name is defined)");
                            resultList = MoPropertiesControllerImpl.this.myMoPropModel.getMoModel().getOrdinaryAttributeModels();
                        } else {
                            MoPropLog.logger().fine("get the attribute models for attribute group name :" + attributeGroupName);
                            resultList = MoPropertiesControllerImpl.this.myMoPropModel.getMoModel().getGroupedAttributeModels(attributeGroupName);
                        }
                        List list = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                        synchronized (list) {
                            continueWithNotification = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.contains(Thread.currentThread());
                        }
                        if (continueWithNotification) {
                            listener.notifyAttributeModelsDone(resultList);
                        }
                    }
                    catch (Exception e) {
                        MoPropLog.logger().severe("Failed to read attribute information., error: " + e.getMessage());
                        MoPropertiesControllerImpl.this.showErrorMessage("Failed to read attribute information.", e);
                    }
                    finally {
                        boolean workIsOngoing = true;
                        List list = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                        synchronized (list) {
                            MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.remove(Thread.currentThread());
                            if (MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.size() <= 0) {
                                workIsOngoing = false;
                            }
                        }
                        if (!workIsOngoing) {
                            MoPropertiesControllerImpl.this.myMoPropView.stopAttributeStatusProgressMonitor();
                        }
                    }
                }
            }
        };
        Thread attrModelFetcherThread = new Thread(attrModelFetcherRunner, "attrModelFetcherThread");
        List<Thread> list = this.myOngoingAttrWorkerThreads;
        synchronized (list) {
            this.myOngoingAttrWorkerThreads.add(attrModelFetcherThread);
        }
        attrModelFetcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAttributeModelsAsynchronousForSelectedAttributes(String attributeGroupName, final AttributeModelFetcherListener listener, final List<String> listOfAttrNames) {
        MoPropLog.logger().fine("start a worker thread to fetch the attribute models from the MoModel");
        Runnable attrModelFetcherRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block22: {
                    if (null == MoPropertiesControllerImpl.this.myConfiguration.getSelectedActionName()) {
                        MoPropertiesControllerImpl.this.myMoPropView.startAttributeStatusProgressMonitor("Reading attribute values...");
                    }
                    List<AttributeModel> resultList = null;
                    try {
                        boolean continueWithNotification;
                        if (null == listener) break block22;
                        if (null != listOfAttrNames && listOfAttrNames.size() > 0) {
                            resultList = MoPropertiesControllerImpl.this.myMoPropModel.getMoModel().getAttributeModels(listOfAttrNames);
                        }
                        List list = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                        synchronized (list) {
                            continueWithNotification = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.contains(Thread.currentThread());
                        }
                        if (continueWithNotification) {
                            listener.notifyAttributeModelsDone(resultList);
                        }
                    }
                    catch (Exception e) {
                        MoPropLog.logger().severe("Failed to read attribute information., error: " + e.getMessage());
                        MoPropertiesControllerImpl.this.showErrorMessage("Failed to read attribute information.", e);
                    }
                    finally {
                        boolean workIsOngoing = true;
                        List list = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                        synchronized (list) {
                            MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.remove(Thread.currentThread());
                            if (MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.size() <= 0) {
                                workIsOngoing = false;
                            }
                        }
                        if (!workIsOngoing) {
                            MoPropertiesControllerImpl.this.myMoPropView.stopAttributeStatusProgressMonitor();
                        }
                    }
                }
            }
        };
        Thread attrModelFetcherThread = new Thread(attrModelFetcherRunner, "attrModelFetcherThread");
        List<Thread> list = this.myOngoingAttrWorkerThreads;
        synchronized (list) {
            this.myOngoingAttrWorkerThreads.add(attrModelFetcherThread);
        }
        attrModelFetcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopOngoingAsynchronousWork() {
        List<Thread> list = this.myOngoingAttrWorkerThreads;
        synchronized (list) {
            this.myOngoingAttrWorkerThreads.clear();
            if (null != this.myProgressController) {
                this.myProgressController.stop();
            }
        }
    }

    @Override
    public void showErrorMessage(String reason, Exception e) {
        if (null != this.myMoPropView) {
            this.myMoPropView.showErrorMessage(reason, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionAsynchronous(final ActionModel actionModel, final ActionExecutionListener listener) {
        MoPropLog.logger().fine("start a worker thread to execute an action");
        Runnable executeActionRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                boolean actionSucceeded = true;
                TypeValue actionResultTypeValue = null;
                try {
                    try {
                        MoPropLog.logger().fine("before actionModel.execute().");
                        actionResultTypeValue = actionModel.execute();
                        if (MoPropertiesControllerImpl.this.myProgressController != null) {
                            MoPropertiesControllerImpl.this.myProgressController.actionExecuted(true);
                        }
                        actionSucceeded = true;
                    }
                    catch (Exception e) {
                        actionSucceeded = false;
                        if (MoPropertiesControllerImpl.this.myProgressController != null) {
                            MoPropertiesControllerImpl.this.myProgressController.actionExecuted(false);
                        }
                        if (null == actionModel) {
                            MoPropLog.logger().severe("Failed to execute the action: null :" + e.getMessage());
                            MoPropertiesControllerImpl.this.showErrorMessage("Could not execute the action", e);
                        } else {
                            MoPropLog.logger().severe("Failed to execute the action: " + actionModel.getName() + ":" + e.getMessage());
                            MoPropertiesControllerImpl.this.showErrorMessage("Could not execute the action " + actionModel.getName(), e);
                        }
                        Object var5_4 = null;
                        List list4 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads;
                        // MONITORENTER : list4
                        boolean continueWithNotification2 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.contains(Thread.currentThread());
                        // MONITOREXIT : list4
                        if (continueWithNotification2) {
                            listener.notifyActionIsDone(actionModel, actionResultTypeValue, actionSucceeded);
                        }
                        boolean workIsOngoing = true;
                        List list3 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads;
                        // MONITORENTER : list3
                        MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.remove(Thread.currentThread());
                        if (MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.size() <= 0) {
                            workIsOngoing = false;
                        }
                        // MONITOREXIT : list3
                        if (workIsOngoing) return;
                        return;
                    }
                    Object var5_3 = null;
                    List list = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads;
                    // MONITORENTER : list
                    boolean continueWithNotification2 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.contains(Thread.currentThread());
                    // MONITOREXIT : list
                    if (continueWithNotification2) {
                        listener.notifyActionIsDone(actionModel, actionResultTypeValue, actionSucceeded);
                    }
                    boolean workIsOngoing = true;
                    List list2 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads;
                    // MONITORENTER : list2
                    MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.remove(Thread.currentThread());
                    if (MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.size() <= 0) {
                        workIsOngoing = false;
                    }
                    // MONITOREXIT : list2
                    if (workIsOngoing) return;
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    List list = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads;
                    // MONITORENTER : list
                    boolean continueWithNotification2 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.contains(Thread.currentThread());
                    // MONITOREXIT : list
                    if (continueWithNotification2) {
                        listener.notifyActionIsDone(actionModel, actionResultTypeValue, actionSucceeded);
                    }
                    boolean workIsOngoing = true;
                    List list3 = MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads;
                    // MONITORENTER : list3
                    MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.remove(Thread.currentThread());
                    if (MoPropertiesControllerImpl.this.myOngoingActionWorkerThreads.size() <= 0) {
                        workIsOngoing = false;
                    }
                    // MONITOREXIT : list3
                    if (workIsOngoing) throw throwable;
                    throw throwable;
                }
            }
        };
        String actionName = actionModel.getName();
        MoPropLog.logger().fine("About to spawn a worker thread to execute the action: " + actionName);
        Thread executeActionThread = new Thread(executeActionRunner, "executeActionThread");
        List<Thread> list = this.myOngoingActionWorkerThreads;
        synchronized (list) {
            this.myOngoingActionWorkerThreads.add(executeActionThread);
        }
        executeActionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushUpdatedAttributeModelValuesToNodeAsynchronous(final PushAttributeValueListener listener) {
        MoPropLog.logger().fine("start a worker thread to push attribute models from the MoModel");
        Runnable setAttrValueRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                if (null == MoPropertiesControllerImpl.this.myConfiguration.getSelectedActionName()) {
                    MoPropertiesControllerImpl.this.myMoPropView.startAttributeStatusProgressMonitor("Setting attribute values...");
                }
                boolean result = false;
                try {
                    block19: {
                        try {
                            if (null == listener) break block19;
                            MoPropLog.logger().fine("before myMoPropModel.getMoModel().pushUpdatedAttributeModelValuesToNode()");
                            MoPropertiesControllerImpl.this.myMoPropModel.getMoModel().pushUpdatedAttributeModelValuesToNode();
                            result = true;
                        }
                        catch (Exception e) {
                            result = false;
                            MoPropLog.logger().severe("Failed to push updated attribute values to the node, error: " + e.getMessage());
                            MoPropertiesControllerImpl.this.showErrorMessage("Failed to set attribute values to the node.", e);
                            Object var4_3 = null;
                            List list4 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                            // MONITORENTER : list4
                            boolean continueWithNotification2222 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.contains(Thread.currentThread());
                            // MONITOREXIT : list4
                            if (continueWithNotification2222) {
                                listener.notifyPushAttributeValuesToNodeIsDone(result);
                            }
                            boolean workIsOngoing = true;
                            List list3 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                            // MONITORENTER : list3
                            MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.remove(Thread.currentThread());
                            if (MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.size() <= 0) {
                                workIsOngoing = false;
                            }
                            // MONITOREXIT : list3
                            if (workIsOngoing) return;
                            MoPropertiesControllerImpl.this.myMoPropView.stopAttributeStatusProgressMonitor();
                            return;
                        }
                    }
                    Object var4_2 = null;
                    List list = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                    // MONITORENTER : list
                    boolean continueWithNotification2222 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.contains(Thread.currentThread());
                    // MONITOREXIT : list
                    if (continueWithNotification2222) {
                        listener.notifyPushAttributeValuesToNodeIsDone(result);
                    }
                    boolean workIsOngoing = true;
                    List list2 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                    // MONITORENTER : list2
                    MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.remove(Thread.currentThread());
                    if (MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.size() <= 0) {
                        workIsOngoing = false;
                    }
                    // MONITOREXIT : list2
                    if (workIsOngoing) return;
                    MoPropertiesControllerImpl.this.myMoPropView.stopAttributeStatusProgressMonitor();
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    List list = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                    // MONITORENTER : list
                    boolean continueWithNotification2222 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.contains(Thread.currentThread());
                    // MONITOREXIT : list
                    if (continueWithNotification2222) {
                        listener.notifyPushAttributeValuesToNodeIsDone(result);
                    }
                    boolean workIsOngoing = true;
                    List list3 = MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads;
                    // MONITORENTER : list3
                    MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.remove(Thread.currentThread());
                    if (MoPropertiesControllerImpl.this.myOngoingAttrWorkerThreads.size() <= 0) {
                        workIsOngoing = false;
                    }
                    // MONITOREXIT : list3
                    if (workIsOngoing) throw throwable;
                    MoPropertiesControllerImpl.this.myMoPropView.stopAttributeStatusProgressMonitor();
                    throw throwable;
                }
            }
        };
        Thread setAttrValueThread = new Thread(setAttrValueRunner, "setAttrValueThread");
        List<Thread> list = this.myOngoingAttrWorkerThreads;
        synchronized (list) {
            this.myOngoingAttrWorkerThreads.add(setAttrValueThread);
        }
        setAttrValueThread.start();
    }

    @Override
    public MoPropertiesView getView() {
        return this.myMoPropView;
    }

    @Override
    public boolean shouldDisplayAttributesProgressForExecTheAction() {
        boolean allAttrExists;
        List<String> attrList;
        boolean result = false;
        this.myProgressController = this.getProgressController();
        result = null != this.myProgressController ? (null != (attrList = this.myProgressController.getProgressSupervisionAttributes()) && attrList.size() > 0 ? (allAttrExists = this.myMoPropModel.getMoModel().areAttributesValid(attrList)) : false) : false;
        return result;
    }

    @Override
    public ProgressController getProgressController() {
        if (null == this.myProgressController) {
            ProgressController progContr = null;
            if (this.myMoPropModel.getConfiguration().displayActionProgress()) {
                progContr = new ProgressController();
                progContr.setConfiguration(this.myMoPropModel.getConfiguration());
                progContr.setMoModel(this.myMoPropModel.getMoModel());
                boolean success = progContr.isInitiatedSuccessfully();
                this.myProgressController = success ? progContr : null;
            } else {
                this.myProgressController = null;
            }
        }
        return this.myProgressController;
    }

    @Override
    public boolean shouldDisplayProgressBarForExecTheAction() {
        boolean result = true;
        result = this.myMoPropModel.getConfiguration().displayActionProgress();
        return result;
    }

    @Override
    public String getMoActionParameterValue(String name) {
        return this.myMoPropModel.getConfiguration().getMoActionParameterValues().get(name);
    }
}

