/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.AttributeModelFetcherListener;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.motools.common.gui.components.AttributeJLabel;
import se.ericsson.cello.emt.motools.common.gui.components.ComponentFactory;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LabelledComponentTable;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.mimparser.MomAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGroupGUI
extends LabelledComponentTable
implements GUI_Container,
AttributeModelFetcherListener {
    private static final long serialVersionUID = 342600234831211010L;
    private List<AttributeModel> myAttrModelList = null;
    private String attrGroupName = null;
    private DataTypeGUI[] memberGUIs = null;
    private JPanel myOwner = null;
    private MoPropertiesController myMoPropController = null;
    private boolean isValidInput = true;
    private JScrollPane myParentScrollPane = null;

    public AttributeGroupGUI(MoPropertiesController controller, boolean visible, GUI_Container container, JPanel owner, String groupName, int nrOfAttributes, ToolServices myToolServices) {
        super(groupName, groupName, 2, 2, null, null, visible, container, myToolServices);
        super.setCounterLabel(nrOfAttributes);
        this.attrGroupName = groupName;
        this.myOwner = owner;
        this.myMoPropController = controller;
    }

    public AttributeGroupGUI(MoPropertiesController controller, boolean visible, GUI_Container container, JPanel owner, String groupName, boolean showButton, ToolServices myToolServices, JScrollPane parentScrollPane) {
        super("", "", 2, 2, visible, container, myToolServices);
        this.fullName = groupName;
        this.attrGroupName = groupName;
        this.myOwner = owner;
        this.myMoPropController = controller;
        this.myParentScrollPane = parentScrollPane;
    }

    @Override
    protected void buttonPressed() {
        MoPropLog.logger().fine("user wants to expand/collapse an attribute group: " + this.attrGroupName);
        this.initBuildOfAttributesArea();
        super.buttonPressed();
    }

    public void initBuildOfAttributesArea() {
        if (null == this.memberGUIs) {
            MoPropLog.logger().fine("before myMoPropController.getAttributeModelsAsync for attr group: " + this.attrGroupName);
            this.myMoPropController.getAttributeModelsAsynchronous(this.attrGroupName, this);
        } else {
            MoPropLog.logger().fine("no need to read get attribute models, since the GUI is already initialized, attr group: " + this.attrGroupName);
        }
    }

    public void initBuildOfAttributesArea(List<String> listOfAttrNames) {
        if (null == this.memberGUIs) {
            MoPropLog.logger().fine("before myMoPropController.getAttributeModelsAsync for attr group: " + this.attrGroupName);
            this.myMoPropController.getAttributeModelsAsynchronousForSelectedAttributes(this.attrGroupName, this, listOfAttrNames);
        } else {
            MoPropLog.logger().fine("no need to read get attribute models, since the GUI is already initialized, attr group: " + this.attrGroupName);
        }
    }

    @Override
    public void notifyAttributeModelsDone(final List<AttributeModel> attributeModelList) {
        MoPropLog.logger().fine("thread name : " + Thread.currentThread().getName());
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AttributeGroupGUI.this.notifyAttributeModelsDone(attributeModelList);
                    AttributeGroupGUI.this.sendNotification();
                }
            });
        } else if (null != attributeModelList) {
            this.myAttrModelList = attributeModelList;
            MoPropLog.logger().fine("before buildAttributesArea()");
            this.buildAttributesArea();
        } else {
            MoPropLog.logger().severe("No attribute models were included in the notification from controller.");
        }
    }

    private void sendNotification() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AttributeGroupGUI.this.myToolServices.sendEmNotification(GuiTestEventTypes.MO_PROPERTIES_PANEL_UPDATED, this.getClass().getSimpleName() + " attributes fetched.", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
            }
        });
    }

    private LabelledComponentTable buildAttributesArea() {
        MoPropLog.logger().fine("");
        if (null == this.memberGUIs) {
            if (null == this.myAttrModelList) {
                this.myAttrModelList = new ArrayList<AttributeModel>(0);
            }
            Iterator<AttributeModel> attrModelIter = this.myAttrModelList.iterator();
            this.memberGUIs = new DataTypeGUI[this.myAttrModelList.size()];
            AttributeModel attrModel = null;
            int attributeCount = 0;
            while (attrModelIter.hasNext()) {
                attrModel = attrModelIter.next();
                JPanel labelPanel = new JPanel();
                JPanel infoBtnPanel = new JPanel();
                labelPanel.setLayout(new FlowLayout(0, 0, 0));
                InformationButtonGui infoButtonGui = new InformationButtonGui(this, this.myToolServices);
                infoButtonGui.setName(attrModel.getName());
                infoButtonGui.setDescription(attrModel.getMomAttribute().getExtendedDescription());
                infoBtnPanel.add(infoButtonGui);
                labelPanel.add(infoBtnPanel);
                labelPanel.add(new AttributeJLabel(attrModel));
                labelPanel.setName(attrModel.getName() + "_Name");
                this.addI(labelPanel);
                DataTypeGUI valueGUI = null;
                boolean ro = attrModel.isReadOnly() || attrModel.isRestricted();
                valueGUI = ComponentFactory.create(attrModel.getTypeValue(), ro, this, attrModel.getName(), false, this.myToolServices);
                valueGUI.getPanel().setName(attrModel.getName() + "_Value");
                this.addI(valueGUI);
                valueGUI.setLayout(new FlowLayout(0, 0, 12));
                this.memberGUIs[attributeCount++] = valueGUI;
            }
            if (null != this.myParentScrollPane) {
                Runnable setScrollPosition = new Runnable(){

                    public void run() {
                        AttributeGroupGUI.this.myParentScrollPane.getViewport().setViewPosition(new Point(0, 0));
                    }
                };
                SwingUtilities.invokeLater(setScrollPosition);
            }
            if (null != this.attrGroupName && attributeCount > 0) {
                Border border = BorderFactory.createEtchedBorder(1);
                this.tablePanel.setBorder(border);
            }
        }
        return this;
    }

    @Override
    public void updateNeeded() {
        this.panel.invalidate();
        this.container.updateNeeded();
    }

    public void setIsValid(boolean isValid) {
        this.isValidInput = isValid;
        MoPropLog.logger().fine("isValidInput:" + this.isValidInput);
    }

    @Override
    public boolean faultyValueEntered() {
        boolean result = false;
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfElements = myGuis.length;
        for (int i = 0; i < numberOfElements && !(result = myGuis[i].faultyValueEntered()); ++i) {
        }
        return result;
    }

    @Override
    public void valueChanged() {
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfElements = myGuis.length;
        DataTypeGUI aGUI = null;
        boolean anyChange = false;
        boolean changed = false;
        for (int i = 0; i < numberOfElements; ++i) {
            aGUI = myGuis[i];
            changed = false;
            if (aGUI.isModified()) {
                anyChange = true;
                changed = true;
            }
            if (!changed) continue;
            this.setIsValid(!aGUI.faultyValueEntered());
        }
        this.setModified(anyChange);
    }

    public DataTypeGUI[] getMemberGUIs() {
        if (null == this.memberGUIs) {
            return new DataTypeGUI[0];
        }
        return this.memberGUIs;
    }

    @Override
    public void refreshValue() {
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfElements = myGuis.length;
        for (int i = 0; i < numberOfElements; ++i) {
            myGuis[i].refreshValue();
        }
        this.setModified(false);
    }

    @Override
    public String applyValue() {
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfElements = myGuis.length;
        for (int i = 0; i < numberOfElements; ++i) {
            myGuis[i].applyValue();
        }
        this.setModified(false);
        return null;
    }

    @Override
    public void setValue(String value) {
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfElements = myGuis.length;
        for (int i = 0; i < numberOfElements; ++i) {
            myGuis[i].setValue(value);
        }
        this.setModified(false);
    }

    @Override
    public void setGUIEditable(boolean editable) {
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfElements = myGuis.length;
        for (int i = 0; i < numberOfElements; ++i) {
            myGuis[i].setGUIEditable(editable);
        }
    }

    public boolean pushUpdatedAttrGuiToAttributeModels() {
        boolean anyChange = false;
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfAttributes = myGuis.length;
        AttributeModel attr = null;
        StringBuilder message = new StringBuilder();
        message.append("Modifying following attribute(s) can cause disturbances:\n\n");
        boolean showDialog = false;
        for (int i = 0; i < numberOfAttributes; ++i) {
            attr = this.myAttrModelList.get(i);
            MomAttribute momAttribute = attr.getMomAttribute();
            if (!myGuis[i].isModified() || momAttribute.getDisturbances() == null) continue;
            message.append(momAttribute.getName());
            message.append(": ");
            message.append(momAttribute.getDisturbances());
            message.append("\n");
            showDialog = true;
        }
        message.append("\nDo you want to proceed?\n");
        if (!showDialog) {
            anyChange = this.setAllModifiedAttributes();
        } else if (this.reallySetTheAttributes(message.toString())) {
            anyChange = this.setAllModifiedAttributes();
        }
        return anyChange;
    }

    private boolean setAllModifiedAttributes() {
        boolean anyChange = false;
        DataTypeGUI[] myGuis = this.getMemberGUIs();
        int numberOfAttributes = myGuis.length;
        DataTypeGUI guiAttr = null;
        AttributeModel attr = null;
        for (int i = 0; i < numberOfAttributes; ++i) {
            guiAttr = myGuis[i];
            attr = this.myAttrModelList.get(i);
            if (guiAttr.isModified()) {
                anyChange = true;
                guiAttr.applyValue();
                continue;
            }
            MoPropLog.logger().log(Level.INFO, "NOT Modified Attribute Value =" + attr);
        }
        return anyChange;
    }

    private boolean reallySetTheAttributes(String disturbancesMessage) {
        boolean reallyDoIt = true;
        Object[] options = new Object[]{"Yes", "No"};
        Object result = options[1];
        String title = this.myMoPropController.getModel().getConfiguration().getManagerTitle() + " - Warning";
        String nodetype = this.myMoPropController.getModel().getConfiguration().getNodeType();
        NarrowOptionPane narrowOptionPane = new NarrowOptionPane(70);
        narrowOptionPane.setMessage(disturbancesMessage);
        narrowOptionPane.setMessageType(2);
        narrowOptionPane.setOptionType(0);
        narrowOptionPane.setOptions(options);
        narrowOptionPane.setInitialValue(options[1]);
        JDialog dialog = narrowOptionPane.createDialog(this.myOwner, title);
        StringBuilder headerText = new StringBuilder();
        if (null != nodetype) {
            headerText.append(nodetype);
            headerText.append(" ");
        }
        headerText.append("Disturbance!");
        JPanel headerPanel = new JPanel(new BorderLayout(5, 8));
        if (null != nodetype) {
            Image nodeImage = this.myMoPropController.getModel().getConfiguration().getIconImage();
            ImageIcon nodeImageIcon = new ImageIcon(nodeImage);
            JLabel iconLabel = new JLabel(headerText.toString(), nodeImageIcon, 0);
            headerPanel.add((Component)iconLabel, "Center");
        } else {
            JLabel textLabel = new JLabel(headerText.toString(), 0);
            headerPanel.add((Component)textLabel, "Center");
        }
        headerPanel.add((Component)new JPanel(), "North");
        headerPanel.add((Component)new JPanel(), "South");
        dialog.add((Component)headerPanel, "North");
        dialog.pack();
        dialog.setVisible(true);
        result = narrowOptionPane.getValue();
        if (result != options[0]) {
            reallyDoIt = false;
        }
        return reallyDoIt;
    }

    class NarrowOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = -6030192043650018176L;
        int maxCharactersPerLineCount = 50;

        NarrowOptionPane(int maxCharactersPerLineCount) {
            this.maxCharactersPerLineCount = maxCharactersPerLineCount;
        }

        public int getMaxCharactersPerLineCount() {
            return this.maxCharactersPerLineCount;
        }
    }
}

