/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.view.gui;

import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModel;
import se.ericsson.cello.emt.moproperties.view.MoPropertiesView;
import se.ericsson.cello.emt.nodeservices.NodeServices;

public class TmpMoPropertiesGui
extends JFrame
implements MoPropertiesView {
    private static final long serialVersionUID = 1L;
    private MoPropertiesController myController = null;
    private MoPropertiesModel myModel;
    private NodeServices myNodeServices;
    private JTextArea jlbHelloWorld;

    public TmpMoPropertiesGui(MoPropertiesController aC, MoPropertiesModel aM) {
        this.myController = aC;
        this.myModel = aM;
    }

    public void initialize() {
        MoPropLog.logger().log(Level.INFO, "");
    }

    public void nodeConnectionLost() {
        MoPropLog.logger().log(Level.INFO, "");
    }

    public void nodeConnectionRestored() {
        MoPropLog.logger().log(Level.INFO, "");
    }

    public void showUI(boolean visible) {
        MoPropLog.logger().log(Level.INFO, "");
        this.buildGui();
        this.setVisible(visible);
    }

    public JComponent getComponent() {
        return this.jlbHelloWorld;
    }

    private void buildGui() {
        MoPropLog.logger().log(Level.INFO, "");
        try {
            this.myNodeServices = this.myModel.getToolServices().getNodeServices();
            String moPropModelLdn = this.myController.getModel().getLDN();
            MoPropLog.logger().log(Level.INFO, "moPropModelLdn=" + moPropModelLdn);
            String nealRootLDN = this.myNodeServices.getNode().getCmService().getRootMo().getLdn();
            MoPropLog.logger().log(Level.INFO, "nealRootLDN=" + nealRootLDN);
            String mimModelRootClass = this.myNodeServices.getMimModel().getRoot().getName();
            MoPropLog.logger().log(Level.INFO, "mimModelRootClass=" + mimModelRootClass);
            StringBuffer clientText = new StringBuffer();
            clientText.append("MoProperties\n");
            clientText.append("\n");
            clientText.append("Ldn=<" + moPropModelLdn + ">\n");
            clientText.append("rootLDN accessed via NEAL=<" + nealRootLDN + ">\n");
            clientText.append("root mo class in mom, accessed via MimParser=<" + mimModelRootClass + ">\n");
            this.jlbHelloWorld = new JTextArea();
            this.jlbHelloWorld.setText(clientText.toString());
            this.jlbHelloWorld.setEditable(false);
            this.add(this.jlbHelloWorld);
            this.setSize(550, 250);
        }
        catch (Exception e) {
            MoPropLog.logger().log(Level.SEVERE, "", e);
            throw new RuntimeException(e);
        }
    }

    public void setController(MoPropertiesController controller) {
        MoPropLog.logger().log(Level.INFO, "");
        this.myController = controller;
    }

    public void setModel(MoPropertiesModel model) {
        MoPropLog.logger().log(Level.INFO, "");
        this.myModel = model;
    }

    public void exit() {
    }

    public void startAttributeStatusProgressMonitor(String message) {
    }

    public void stopAttributeStatusProgressMonitor() {
    }

    public void showErrorMessage(String reason, Exception e) {
    }
}

