/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch.view.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import se.ericsson.cello.emt.mosearch.MoSearchLog;
import se.ericsson.cello.emt.mosearch.model.MoSearchModel;
import se.ericsson.cello.emt.motools.common.mimparser.MimCompatibility;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplate;
import se.ericsson.cello.emt.motools.common.momodel.StartMo;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.BooleanTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.ClassTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.CorbaTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.EnumTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.SequenceTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StructTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.Tool;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoSearchController {
    private static final String emptyValue = "";
    private MoTemplate moTemplate;
    private StartMo myStartMo;
    private MoSearchModel mySearchModel;
    final String stringType = "string";
    final String integerType = "long";
    final String enumType = "enum";
    final String sequenceType = "sequence";
    final String booleanType = "boolean";
    final String classType = "class";
    final String structType = "struct";
    final String floatType = "float";
    final String octetArrayType = "octetArray";
    final String arrayRefMsg = "Only possible for empty array of references.";
    final String objectRefMsg = "Only possible to search for empty references.";
    final int maxLengthToolTip = 86;

    public MoSearchController(MoSearchModel searchModel) {
        this.mySearchModel = searchModel;
        if (!this.mySearchModel.getStartMo().getMoRef().exists()) {
            MessageDialog message = MessageDialogFactory.createMessageDialog((String)("The LDN " + searchModel.getConfiguration().getLdn() + " does not exist on the node. The LDN will be set to ManagedElement=1."), (String)"Click Close to continue.", (boolean)false, null);
            message.setVisible(true);
            MoSearchLog.logger().warning("The MO " + searchModel.getConfiguration().getMoClass() + " is not specified");
            this.mySearchModel.setLdn("ManagedElement=1");
            this.mySearchModel.getConfiguration().setMoClassSpecified(false);
        }
        this.myStartMo = searchModel.getStartMo();
    }

    public MoTemplate getMoTemplate() {
        return this.moTemplate;
    }

    public void setMoTemplate(String moName) {
        MoSearchLog.logger().fine("Setting mo template to: " + moName);
        List<MoTemplate> list = this.myStartMo.getSearchableMOs();
        for (MoTemplate element : list) {
            if (!element.getName().equalsIgnoreCase(moName)) continue;
            MoSearchLog.logger().fine("Succesful change to mo template: " + moName);
            this.moTemplate = element;
        }
    }

    public String getAttributeType(String attrName) {
        TypeValue typeValue = this.getTypeValue(attrName);
        if (typeValue == null) {
            return null;
        }
        if (typeValue instanceof CorbaTypeValue) {
            CorbaTypeValue corbaTypeValue = (CorbaTypeValue)typeValue;
            return corbaTypeValue.getMomCorbaTypeAttribute().getXmlType();
        }
        if (typeValue instanceof StructTypeValue) {
            StructTypeValue structTypeValue = (StructTypeValue)typeValue;
            return structTypeValue.getMomStruct().getXmlType();
        }
        if (typeValue instanceof SequenceTypeValue) {
            SequenceTypeValue sequenceTypeValue = (SequenceTypeValue)typeValue;
            return sequenceTypeValue.getMomSequence().getXmlType();
        }
        if (typeValue instanceof EnumTypeValue) {
            EnumTypeValue enumTypeValue = (EnumTypeValue)typeValue;
            return enumTypeValue.getMomEnum().getXmlType();
        }
        if (typeValue instanceof ClassTypeValue) {
            ClassTypeValue classTypeValue = (ClassTypeValue)typeValue;
            return classTypeValue.getMomClass().getXmlType();
        }
        return null;
    }

    public boolean isEnum(String attrName) {
        CorbaTypeValue corbaTypeValue;
        MoSearchLog.logger().finer("Determing whether " + attrName + " is an enum attribute");
        boolean result = false;
        if (attrName.equalsIgnoreCase(emptyValue)) {
            return false;
        }
        if (attrName == null || attrName.equals(emptyValue)) {
            return false;
        }
        TypeValue typeValue = this.getTypeValue(attrName);
        if (typeValue == null) {
            MoSearchLog.logger().fine(attrName + " is not an valid attribute to " + this.moTemplate.getName());
            return false;
        }
        if (typeValue instanceof EnumTypeValue) {
            result = true;
        } else if (typeValue instanceof CorbaTypeValue && (corbaTypeValue = (CorbaTypeValue)typeValue) instanceof BooleanTypeValue) {
            result = true;
        }
        return result;
    }

    public String getEnumValue(String attribute, String key) {
        TypeValue typeValue = this.getTypeValue(attribute);
        if (typeValue == null) {
            throw new RuntimeException("Could not get enumvalue: " + key + " for attribute: " + attribute + ". This attribute does not exist.");
        }
        if (typeValue instanceof EnumTypeValue) {
            EnumTypeValue enumTypeValue = (EnumTypeValue)typeValue;
            return enumTypeValue.getEnumValue(key);
        }
        if (typeValue instanceof CorbaTypeValue) {
            if (key.startsWith("TRUE")) {
                return "TRUE";
            }
            return "FALSE";
        }
        throw new RuntimeException("Attribute: " + attribute + " is not an enum value");
    }

    public Object[] getEnumMembers(String attrName) {
        TypeValue typeValue = this.getTypeValue(attrName);
        if (typeValue == null) {
            throw new RuntimeException("Attribute : " + attrName + "does not exist");
        }
        if (typeValue instanceof EnumTypeValue) {
            EnumTypeValue enumTypeValue = (EnumTypeValue)typeValue;
            Object[] members = enumTypeValue.getAllEnumMemberDisplaySymbolsNoStrikethrough();
            return members;
        }
        return new Object[]{"TRUE[1]", "FALSE[0]"};
    }

    public TypeValue getTypeValue(String attrName) {
        List<AttributeModel> list = this.moTemplate.getAttributeModels();
        Iterator<AttributeModel> iter = list.iterator();
        TypeValue typeValue = null;
        while (iter.hasNext()) {
            AttributeModel element = iter.next();
            if (!element.getName().equalsIgnoreCase(attrName)) continue;
            typeValue = element.getTypeValue();
        }
        return typeValue;
    }

    public String getTypeHelpText(String attrName) {
        if (attrName.equalsIgnoreCase(emptyValue)) {
            return emptyValue;
        }
        if (this.moTemplate == null) {
            return emptyValue;
        }
        TypeValue typeValue = this.getTypeValue(attrName);
        if (typeValue == null) {
            return emptyValue;
        }
        String typeHelp = emptyValue;
        if (typeValue instanceof CorbaTypeValue) {
            CorbaTypeValue corbaTypeValue = (CorbaTypeValue)typeValue;
            typeHelp = this.getMomCorbaTypeHelp(corbaTypeValue);
        } else if (typeValue instanceof SequenceTypeValue) {
            typeHelp = "Only possible for empty array of references.";
        } else if (typeValue instanceof EnumTypeValue) {
            EnumTypeValue enumTypeValue = (EnumTypeValue)typeValue;
            String[] enumMembers = enumTypeValue.getAllEnumMemberDisplaySymbolsNoStrikethrough();
            String symbolsAndValues = emptyValue;
            for (int i = 0; i < enumMembers.length; ++i) {
                symbolsAndValues = symbolsAndValues + enumMembers[i] + " ";
            }
            typeHelp = "Use numeric value. " + symbolsAndValues;
            int len = typeHelp.length();
            if (len > 83) {
                typeHelp = typeHelp.substring(0, 83) + "...";
            }
        } else {
            typeHelp = typeValue instanceof ClassTypeValue ? "Only possible to search for empty references." : emptyValue;
        }
        return typeHelp;
    }

    private String getMomCorbaTypeHelp(CorbaTypeValue corbaTypeValue) {
        String min = corbaTypeValue.getMinAsStringValue();
        String max = corbaTypeValue.getMaxAsStringValue();
        String type = corbaTypeValue.getMomCorbaTypeAttribute().getXmlType();
        if (min.equalsIgnoreCase(emptyValue) || max.equalsIgnoreCase(emptyValue)) {
            return type;
        }
        String typeHelp = emptyValue;
        typeHelp = type.equalsIgnoreCase("boolean") ? "TRUE, FALSE" : type + "[" + min + "..." + max + "]";
        return typeHelp;
    }

    public Object[] getAttributes(String motype) {
        this.setMoTemplate(motype);
        if (this.moTemplate == null) {
            throw new RuntimeException("Mo type: " + motype + "does not exist");
        }
        List<AttributeModel> attrs = this.moTemplate.getAttributeModels();
        Iterator<AttributeModel> iterator = attrs.iterator();
        Vector<String> v = new Vector<String>(20);
        while (iterator.hasNext()) {
            AttributeModel attributeModel = iterator.next();
            if (!this.isAttributeSupported(attributeModel)) continue;
            v.add(attributeModel.getName());
        }
        Object[] arr = v.toArray();
        Arrays.sort(arr);
        return arr;
    }

    private boolean isAttributeSupported(AttributeModel attributeModel) {
        return this.isTypeSupported(attributeModel.getTypeValue()) && MimCompatibility.getObsolete(attributeModel.getMomEntity()) == null && !MimCompatibility.isInterfaceOnly(attributeModel.getMomEntity());
    }

    private boolean isTypeSupported(TypeValue typeValue) {
        boolean result = false;
        if (typeValue == null) {
            return false;
        }
        if (typeValue instanceof CorbaTypeValue) {
            result = true;
        } else if (typeValue instanceof EnumTypeValue) {
            result = true;
        } else if (typeValue instanceof ClassTypeValue) {
            result = true;
        } else if (typeValue instanceof SequenceTypeValue) {
            SequenceTypeValue momSequence = (SequenceTypeValue)typeValue;
            if (momSequence.getMomSequence().getType() instanceof MomClass) {
                result = true;
            } else {
                try {
                    if (momSequence.getMomSequence().getType() instanceof MoRef) {
                        result = true;
                    }
                }
                catch (NoClassDefFoundError classloadingProblem) {
                    MoSearchLog.logger().fine("This must be old mimparser" + classloadingProblem.getMessage());
                }
            }
        }
        return result;
    }

    public Object[] getAvailableObjectTypes() {
        String moClassToSearchFor;
        List<MoTemplate> list = this.myStartMo.getSearchableMOs();
        Iterator<MoTemplate> iter = list.iterator();
        Vector<String> momClassesV = new Vector<String>();
        Object[] momClasses = new String[list.size()];
        int i = 0;
        while (iter.hasNext()) {
            MoTemplate moTemplate = iter.next();
            momClasses[i] = moTemplate.getName();
            momClassesV.add(moTemplate.getName());
            ++i;
        }
        if (this.mySearchModel.getConfiguration().moClassSpecified() && momClassesV.contains(moClassToSearchFor = this.mySearchModel.getConfiguration().getMoClass())) {
            momClasses = new String[]{moClassToSearchFor};
            return momClasses;
        }
        Arrays.sort(momClasses);
        return momClasses;
    }

    public Object[] getHyperTools() {
        ArrayList<String> list = new ArrayList<String>();
        List<Tool> hyperTools = this.mySearchModel.getConfiguration().getHyperTools();
        for (Tool tool : hyperTools) {
            list.add(tool.getName());
        }
        return list.toArray();
    }

    public List<String> getSelectedLdns(JTable mySearchResultTable) {
        ArrayList<String> list = new ArrayList<String>();
        int[] sRows = mySearchResultTable.getSelectedRows();
        if (sRows == null || sRows.length == 0) {
            MoSearchLog.logger().fine("No Selection when wanting open MO.");
            return list;
        }
        int n = sRows.length;
        for (int i = 0; i < n; ++i) {
            list.add(mySearchResultTable.getValueAt(sRows[i], 0).toString());
        }
        return list;
    }
}

