/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.config.impl;

import java.awt.Image;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.toolservices.Tool;
import se.ericsson.cello.emt.motools.common.utils.impl.MoLogger;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonConfiguration
implements Configuration {
    private static final String HELPSERVICE_CONFIG = "HELPSERVICE_CONFIG";
    private static final String MOSEARCH_CONFIG = "MOSEARCH_CONFIG";
    private static final String MOSEARCH_NAME = "MOSEARCH_NAME";
    private static final String PREFERENCESERVICE_NAME = "PREFERENCESERVICE_NAME";
    private static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";
    private Image iconImage = null;
    private String iconToPassOn = null;
    protected Properties properties = null;

    public CommonConfiguration(Properties properties) {
        this.properties = properties;
        this.iconToPassOn = properties.getProperty("TOOL_ICON");
        IconHelper helper = new IconHelper();
        this.iconImage = helper.getIconImage(this.iconToPassOn);
    }

    @Override
    public String getAddress() {
        return this.properties.getProperty("address");
    }

    @Override
    public String getPort() {
        return this.properties.getProperty("httpPort");
    }

    @Override
    public List<String> getLdns() {
        LinkedList<String> ldnList = new LinkedList<String>();
        String ldns = this.properties.getProperty("LDNs");
        if (ldns == null) {
            return ldnList;
        }
        String[] ldnsArray = ldns.split(";");
        ldnList.addAll(Arrays.asList(ldnsArray));
        return ldnList;
    }

    @Override
    public String getCustomApplName() {
        return this.properties.getProperty("CUSTOM_APPL_NAME", "the property CUSTOM_APPL_NAME is not defined");
    }

    @Override
    public String getManagerTitle() {
        return this.properties.getProperty("MANAGER_TITLE", "Element Manager");
    }

    @Override
    public String getIconToPassOn() {
        return this.iconToPassOn;
    }

    @Override
    public Tool getNodeServicesTool() {
        String nodeServConfig = this.properties.getProperty("NODESERVICES_CONFIG", "NODESERVICES_CONFIG is not defined");
        String nodeServName = this.properties.getProperty("NODESERVICES_NAME", "NODESERVICES_NAME is not defined");
        String nodeServKey = "not defined";
        Tool nodeServTool = new Tool(nodeServKey, nodeServConfig, nodeServName);
        return nodeServTool;
    }

    @Override
    public Tool getUserPreferenceTool() {
        String prefServConfig = this.properties.getProperty("PREFERENCESERVICE_CONFIG", "PREFERENCESERVICE_CONFIG is not defined");
        String prefServName = this.properties.getProperty(PREFERENCESERVICE_NAME, "User Preference Service");
        String prefServKey = "not defined";
        Tool prefServTool = new Tool(prefServKey, prefServConfig, prefServName);
        return prefServTool;
    }

    @Override
    public Tool getMoSearchTool() {
        String moSearchConfig = this.properties.getProperty(MOSEARCH_CONFIG, "MOSEARCH_CONFIG is not defined");
        String moSearchName = this.properties.getProperty(MOSEARCH_NAME, "MOSEARCH_NAME is not defined");
        String moSearchKey = "not defined";
        Tool moSearchTool = new Tool(moSearchKey, moSearchConfig, moSearchName);
        return moSearchTool;
    }

    @Override
    public List<Tool> getHyperTools() {
        String[] hyperKeyArray;
        LinkedList<Tool> hyperToolList = new LinkedList<Tool>();
        String strHyperTools = this.properties.getProperty("HYPER_TOOL_KEYS");
        if (strHyperTools == null) {
            return hyperToolList;
        }
        for (String hyperKey : hyperKeyArray = strHyperTools.split(";")) {
            String nameKey = hyperKey + "_NAME";
            String hyperToolName = this.properties.getProperty(nameKey, nameKey + " is not defined");
            String configKey = hyperKey + "_CONFIG";
            String hyperToolConfigFile = this.properties.getProperty(configKey, configKey + " is not defined");
            Tool hyperTool = new Tool(hyperKey, hyperToolConfigFile, hyperToolName);
            hyperToolList.add(hyperTool);
        }
        return hyperToolList;
    }

    @Override
    public String getSelectedActionName() {
        return null;
    }

    @Override
    public List<String> getSelectedAttrNames() {
        return null;
    }

    @Override
    public String getLdn() {
        List<String> ldnList = this.getLdns();
        if (ldnList != null && ldnList.size() > 0) {
            return ldnList.get(0);
        }
        return null;
    }

    @Override
    public void setLdn(String ldn) {
    }

    @Override
    public Image getIconImage() {
        return this.iconImage;
    }

    @Override
    public String getMoClass() {
        return null;
    }

    @Override
    public boolean moClassSpecified() {
        return false;
    }

    @Override
    public void setMoClassSpecified(boolean isMoClassSpecified) {
    }

    @Override
    public String getHelpApplication() {
        return this.properties.getProperty(HELPSERVICE_CONFIG);
    }

    @Override
    public String getTitle() {
        return this.getAddress() + " - " + this.getManagerTitle() + " - " + this.getCustomApplName();
    }

    @Override
    public Properties getSupersedingProperties() {
        Properties tempProp = new Properties();
        String strSupersedingList = this.properties.getProperty(SUPERSEDING_PARAMETER_LIST);
        if (strSupersedingList != null) {
            String[] supersedingListArray;
            tempProp.put(SUPERSEDING_PARAMETER_LIST, strSupersedingList);
            for (String supersedingName : supersedingListArray = strSupersedingList.split(";")) {
                String supersedingValue = this.properties.getProperty(supersedingName);
                if (supersedingValue == null) continue;
                tempProp.put(supersedingName, supersedingValue);
            }
        }
        String nodeAddresWithoutPort = this.getAddress();
        String nodeHttpPort = this.getPort();
        if (nodeAddresWithoutPort != null) {
            tempProp.put("address", nodeAddresWithoutPort);
        }
        if (nodeHttpPort != null) {
            tempProp.put("httpPort", nodeHttpPort);
        }
        return tempProp;
    }

    @Override
    public String getSourceMO() {
        return null;
    }

    @Override
    public String getNodeType() {
        String type = this.properties.getProperty("NODE_TYPE");
        if (type == null) {
            MoLogger.logger().info("Property NODE_TYPE not set.");
        }
        return type;
    }

    @Override
    public boolean displayActionProgress() {
        return false;
    }

    @Override
    public String getProgressCountAttribute() {
        return null;
    }

    @Override
    public String getProgressStart() {
        return null;
    }

    @Override
    public String getProgressTotal() {
        return null;
    }

    @Override
    public List<String> getProgressSupervisionAttributes() {
        return null;
    }

    @Override
    public boolean initiallyExpandStructs() {
        return false;
    }

    @Override
    public boolean initiallyExpandSequences() {
        return false;
    }

    @Override
    public String getProgressDisplayAttribute() {
        return null;
    }

    @Override
    public List<String> getProgressStopAttributes() {
        return null;
    }

    @Override
    public String getProgressAdditionalAction() {
        return null;
    }

    @Override
    public HashMap<String, String> getMoActionParameterValues() {
        return null;
    }
}

