/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.EnumComboBoxEditor;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.BooleanTypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class BooleanGUI
extends DataTypeGUI {
    private static final long serialVersionUID = -6735451257376100166L;
    private BooleanTypeValue myBooleanTypeValue = null;
    private int initialIndex;
    private int previousIndex;
    private boolean readOnly;
    private JComboBox valueC = null;
    private JLabel labelC = null;
    private JLabel statusC;
    private BooleanComboListener myListener = null;
    private JPanel panel;
    private JTextField hiddenTextField = null;

    public BooleanGUI(BooleanTypeValue aBooleanTypeValue, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super(aBooleanTypeValue, container, aToolServices);
        this.myBooleanTypeValue = aBooleanTypeValue;
        this.readOnly = isReadOnly;
        this.panel = this.getPanel();
        JPanel panel1 = new JPanel(new FlowLayout(0, 0, 0));
        this.panel.add(panel1);
        String[] allValues = new String[]{"true", "false"};
        String initialValue = this.myBooleanTypeValue.getValueAsString();
        this.valueC = new JComboBox<String>(allValues);
        this.valueC.setEditable(true);
        this.myListener = new BooleanComboListener();
        this.valueC.addActionListener(this.myListener);
        this.initialIndex = initialValue.equalsIgnoreCase("true") ? 0 : 1;
        this.previousIndex = this.initialIndex;
        this.valueC.setSelectedIndex(this.initialIndex);
        this.valueC.setSize(this.valueC.getPreferredSize());
        panel1.add((Component)this.valueC, "West");
        this.hiddenTextField = new JTextField();
        EnumComboBoxEditor myEditor = null;
        myEditor = new EnumComboBoxEditor(allValues[0]);
        if (this.readOnly) {
            this.setOpaque(false);
            this.setBorder(null);
            myEditor.setBackgroundColor(myEditor.getEditorComponent().getBackground());
        } else {
            myEditor.setBackgroundColor(this.hiddenTextField.getBackground());
        }
        this.valueC.setEditor(myEditor);
        this.valueC.setToolTipText("boolean");
        this.valueC.setName("valueField");
        if (!this.myBooleanTypeValue.isValueDefined() && !supportNullValue) {
            if (this.myBooleanTypeValue.getNameValue() == null) {
                this.labelC = new JLabel("[null]");
                panel1.add(this.labelC);
            }
            this.statusC = new JLabel(" Value out of range. Displaying arbitrary value!");
            panel1.add(this.statusC);
        }
    }

    public String getValue() {
        String displayedValue = (String)this.valueC.getSelectedItem();
        return displayedValue;
    }

    public void setValue(String value) {
        this.valueC.setSelectedItem(value);
        this.valueC.setForeground(this.hiddenTextField.getForeground());
        this.initialIndex = this.valueC.getSelectedIndex();
        this.setModified(false);
        this.getPanel().validate();
    }

    public void verifyInput() {
        int selectedIndex = this.valueC.getSelectedIndex();
        if (selectedIndex != this.previousIndex) {
            if (this.readOnly) {
                this.valueC.setSelectedIndex(this.initialIndex);
            } else {
                this.setModified(true);
                this.previousIndex = selectedIndex;
                this.getPanel().validate();
            }
        }
    }

    class BooleanComboListener
    implements ActionListener {
        BooleanComboListener() {
        }

        public void actionPerformed(ActionEvent e) {
            BooleanGUI.this.verifyInput();
        }
    }
}

