/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.FlowLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.ericsson.cello.emt.motools.common.gui.components.ComponentFactory;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.EnumGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LabelledComponentTable;
import se.ericsson.cello.emt.motools.common.mimparser.MimCompatibility;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.CorbaTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StructTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;

public class StructGUI
extends LabelledComponentTable
implements GUI_Container {
    private static final long serialVersionUID = 7607706864345910485L;
    private StructTypeValue myStructAttrModel;
    private boolean isValidInput = true;
    private Map<String, DataTypeGUI> myGuiMemberMap = null;
    private boolean readOnly;
    private HashMap<String, MomStructMember> allMomStructMembers = new HashMap();

    public StructGUI(StructTypeValue aAttributeModel, boolean visible, boolean readOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super("", "", 2, 2, null, null, visible, container, aToolServices);
        this.readOnly = readOnly;
        this.myStructAttrModel = aAttributeModel;
        this.myGuiMemberMap = new HashMap<String, DataTypeGUI>();
        this.panel.setName(aAttributeModel.getName() + "Panel");
        this.getPanel().setName(aAttributeModel.getName() + "_Value");
        List<TypeValue> attrModelMemberList = this.myStructAttrModel.getMembers();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SortByName
        implements Comparator<TypeValue> {
            SortByName() {
            }

            @Override
            public int compare(TypeValue o1, TypeValue o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }
        SortByName comp = new SortByName();
        Collections.sort(attrModelMemberList, comp);
        MomStruct momStruct = this.myStructAttrModel.getMomStruct();
        Iterator momStructIter = momStruct.getMembers();
        MomStructMember aStructMember = null;
        while (momStructIter.hasNext()) {
            aStructMember = (MomStructMember)momStructIter.next();
            this.allMomStructMembers.put(aStructMember.getName(), aStructMember);
        }
        Iterator<TypeValue> iter = attrModelMemberList.iterator();
        TypeValue aMemberAttrModel = null;
        String aMemberName = null;
        while (iter.hasNext()) {
            aMemberAttrModel = iter.next();
            JPanel infoLabelPanel = new JPanel();
            infoLabelPanel.setLayout(new FlowLayout(0, 0, 0));
            InformationButtonGui infoButtonGui = new InformationButtonGui(this, aToolServices);
            aMemberName = aMemberAttrModel.getName();
            infoButtonGui.setName(aMemberName);
            infoButtonGui.setDescription(this.getMemberDescription(aMemberAttrModel));
            infoLabelPanel.add(infoButtonGui);
            infoLabelPanel.add(new JLabel(this.getTextForNameLabel(aMemberAttrModel)));
            infoLabelPanel.setName(aMemberName + "_Name");
            this.addI(infoLabelPanel);
            DataTypeGUI memberGUI = ComponentFactory.create(aMemberAttrModel, this.readOnly, this, aMemberName, supportNullValue, aToolServices);
            this.myGuiMemberMap.put(aMemberName, memberGUI);
            memberGUI.setLayout(new FlowLayout(0, 0, 8));
            this.addI(memberGUI);
        }
    }

    public String applyValue() {
        int numberOfMembers = this.myStructAttrModel.getMembers().size();
        DataTypeGUI aGui = null;
        for (int i = 0; i < numberOfMembers; ++i) {
            aGui = (DataTypeGUI)this.getComponent(i * 2 + 1);
            aGui.applyValue();
        }
        this.setModified(false);
        return null;
    }

    public void setValue(String value) {
        int numberOfMembers = this.myStructAttrModel.getMembers().size();
        for (int i = 0; i < numberOfMembers; ++i) {
            DataTypeGUI valueGUI = (DataTypeGUI)this.getComponent(i * 2 + 1);
            if (valueGUI instanceof EnumGUI) {
                ((EnumGUI)valueGUI).addItem(value);
            }
            valueGUI.setValue(value);
        }
        this.setModified(false);
    }

    public void setGUIEditable(boolean editable) {
        Set<String> keySet = this.myGuiMemberMap.keySet();
        Iterator<String> iter = keySet.iterator();
        DataTypeGUI aCompGui = null;
        String aMemberName = null;
        while (iter.hasNext()) {
            aMemberName = iter.next();
            aCompGui = this.myGuiMemberMap.get(aMemberName);
            aCompGui.setGUIEditable(editable);
        }
    }

    public void refreshValue() {
        throw new RuntimeException("refreshValue shall never be used!!!!");
    }

    public void updateNeeded() {
        this.panel.invalidate();
        this.container.updateNeeded();
    }

    public void setIsValid(boolean isValid) {
        this.isValidInput = isValid;
    }

    public boolean faultyValueEntered() {
        return !this.isValidInput;
    }

    public void valueChanged() {
        boolean anyChange = false;
        boolean anyFaulty = false;
        Set<String> keySet = this.myGuiMemberMap.keySet();
        Iterator<String> iter = keySet.iterator();
        DataTypeGUI aCompGui = null;
        String aMemberName = null;
        while (iter.hasNext()) {
            aMemberName = iter.next();
            aCompGui = this.myGuiMemberMap.get(aMemberName);
            if (aCompGui.isModified()) {
                anyChange = true;
            }
            if (!aCompGui.faultyValueEntered()) continue;
            anyFaulty = true;
        }
        this.setIsValid(!anyFaulty);
        this.setModified(anyChange);
    }

    public DataTypeGUI[] getMemberGUIs() {
        return this.myGuiMemberMap.values().toArray(new DataTypeGUI[0]);
    }

    private String getMemberDescription(TypeValue model) {
        String description = "";
        String descriptionOfTheMomStructMember = this.allMomStructMembers.get(model.getName()).getExtendedDescription();
        if (null != descriptionOfTheMomStructMember) {
            description = descriptionOfTheMomStructMember;
        }
        return description;
    }

    private String getTextForNameLabel(TypeValue aMemberAttributeModel) {
        boolean isDeprecated;
        StringBuilder labelTextBuilder = new StringBuilder("");
        String attrModelName = aMemberAttributeModel.getName();
        boolean bl = isDeprecated = null != MimCompatibility.getDeprecated((MomEntity)this.allMomStructMembers.get(attrModelName));
        if (isDeprecated) {
            labelTextBuilder.append("<html><strike>");
        }
        labelTextBuilder.append(attrModelName);
        if (aMemberAttributeModel instanceof CorbaTypeValue) {
            String unit = ((CorbaTypeValue)aMemberAttributeModel).getMomCorbaTypeAttribute().getUnit();
            String multiplicationFactor = ((CorbaTypeValue)aMemberAttributeModel).getMomCorbaTypeAttribute().getMultiplicationFactor();
            if (unit != null) {
                labelTextBuilder.append(" (");
                if (multiplicationFactor != null && !multiplicationFactor.equals("1")) {
                    labelTextBuilder.append(multiplicationFactor);
                    labelTextBuilder.append(" * ");
                }
                labelTextBuilder.append(unit);
                labelTextBuilder.append(")");
            }
        }
        labelTextBuilder.append(":");
        if (isDeprecated) {
            labelTextBuilder.append("</strike></html>");
        }
        return labelTextBuilder.toString();
    }
}

