/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Base64;
import se.ericsson.security.cppsec.esa.EsaTimeValidator;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.proxy.EsaProxyFactory;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstants;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;

public class EsaDataVerification {
    private static final String START_TAG_OF_BODY = "<body>";
    private static final String STOP_TAG_OF_BODY = "</body>";
    private static final char SEPARATOR = ';';
    private final EsaConstants constants = EsaConstantsFactory.getEsaConstants();

    public static byte[] calculateSha1(String string) throws SecurityActivationException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityActivationException("Support for algorithm SHA-1 is missing on node!", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurityActivationException("Support for encoding UTF-8 is missing on node!", unsupportedEncodingException);
        }
    }

    public static String calculateSha1Base64(String string) throws SecurityActivationException {
        return EsaDataVerification.convertToBase64(EsaDataVerification.calculateSha1(string));
    }

    private static String convertToBase64(byte[] byArray) {
        return new String(Base64.encode((byte[])byArray));
    }

    public boolean checkCurrentEnrollmentData(String string, String string2) throws SecurityActivationException {
        String string3 = EsaDataVerification.calculateSha1Base64(string);
        return !this.compareWithStateFile(string3, string2);
    }

    public boolean checkCurrentIpsecEnrollmentData(String string) throws SecurityActivationException {
        String string2 = EsaDataVerification.calculateSha1Base64(string);
        return !this.compareWithIpsecStateFile(string2);
    }

    public boolean checkResetAllowed() {
        boolean bl = false;
        try {
            String string = EsaDataVerification.extractFileContent(this.constants.getEsaResetFilePath());
            int n = string.indexOf(59);
            if (-1 != n) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = EsaDataVerification.extractFileContent(string2);
                String string5 = this.findIscfBody(string4);
                String string6 = this.removeSpaces(string5);
                this.verifyIscfHash(string6, string3);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            EsaReportLogger.getInstance().logMessage("Exception caught when performing pre-reset check. Reset will not be allowed.");
        }
        return bl;
    }

    public boolean resetFileExists() {
        File file = new File(this.constants.getEsaResetFilePath());
        return file.exists();
    }

    public boolean installIndicatorIsSet() {
        File file = new File(this.constants.getEsaInstallFilePath());
        return file.exists();
    }

    protected boolean compareWithStateFile(String string, String string2) {
        boolean bl = false;
        try {
            EsaReportLogger.getInstance().logMessage("Extracting stored OTP from " + string2);
            String string3 = EsaDataVerification.extractFileContent(string2);
            if ("".equals(string3)) {
                EsaReportLogger.getInstance().logMessage("Incorrect format of state file! Performing new enrollment!");
            } else if (string3.equals(string)) {
                bl = true;
                EsaReportLogger.getInstance().logMessage("Enrollment has already been performed with current data.");
            } else {
                EsaReportLogger.getInstance().logMessage("New and current configuration does not match. Performing new enrollment!");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            EsaReportLogger.getInstance().logMessage("No previous state file found. Performing new enrollment!");
        }
        catch (IOException iOException) {
            EsaReportLogger.getInstance().logMessage("Previous state file could not be read. Performing new enrollment!");
        }
        return bl;
    }

    protected boolean compareWithIpsecStateFile(String string) {
        boolean bl = false;
        try {
            String string2 = EsaDataVerification.extractFileContent(this.constants.getEsaIpsecStateFilePath());
            if ("".equals(string2)) {
                EsaReportLogger.getInstance().logMessage("Incorrect format of state file! Performing new enrollment!");
            } else if (string2.equals(string)) {
                bl = true;
                EsaReportLogger.getInstance().logMessage("Enrollment has already been performed with current data.");
            } else {
                EsaReportLogger.getInstance().logMessage("New and current configuration does not match. Performing new enrollment!");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            EsaReportLogger.getInstance().logMessage("No previous esa.state found. Performing new enrollment!");
        }
        catch (IOException iOException) {
            EsaReportLogger.getInstance().logMessage("Previous esa.state could not be read. Performing new enrollment!");
        }
        return bl;
    }

    public void deleteFiles() {
        EsaDataVerification.deleteStateFile();
        EsaDataVerification.deleteResetFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableReset(String string) {
        EsaReportLogger.getInstance().logMessage("Creating file esa.Reset");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.constants.getEsaResetFilePath(), false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            try {
                String string2 = EsaDataVerification.extractFileContent(string);
                String string3 = this.findIscfBody(string2);
                String string4 = this.removeSpaces(string3);
                outputStreamWriter.write(string);
                outputStreamWriter.write(59);
                outputStreamWriter.write(EsaDataVerification.calculateSha1Base64(string4));
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Throwable throwable) {
            EsaReportLogger.getInstance().logMessage("Failed to write new esa.reset");
        }
    }

    public boolean indicateInstall() {
        boolean bl = true;
        EsaReportLogger.getInstance().logMessage("Creating file esa.install");
        try {
            File file = new File(this.constants.getEsaInstallFilePath());
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Throwable throwable) {
            bl = false;
            EsaReportLogger.getInstance().logMessage("Failed to create esa.install");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String extractFileContent(String string) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedInputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            bufferedInputStream.close();
        }
    }

    protected String findIscfBody(String string) throws SecurityActivationInputException {
        int n = string.indexOf(START_TAG_OF_BODY);
        int n2 = string.lastIndexOf(START_TAG_OF_BODY);
        int n3 = string.indexOf(STOP_TAG_OF_BODY);
        int n4 = string.lastIndexOf(STOP_TAG_OF_BODY);
        if (n == -1 || n3 == -1 || n != n2 || n3 != n4) {
            throw new SecurityActivationInputException("The provided ISCF does not contain the correct XML tag <body>..</body>.");
        }
        return string.substring(n, n3 + STOP_TAG_OF_BODY.length());
    }

    protected String removeSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= ' ') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void verifyIscf(String string, String string2, String string3, String string4, String string5, String string6) throws SecurityActivationException, SecurityActivationInputException {
        if (!EsaTimeValidator.checkValidTime(string5, string6)) {
            throw new SecurityActivationInputException("The ISCF is not valid at this time!");
        }
        try {
            String string7 = EsaDataVerification.extractFileContent(string);
            String string8 = this.findIscfBody(string7);
            String string9 = this.removeSpaces(string8);
            this.verifyIscfSize(string9);
            this.verifyIscfHash(string9, string3);
            this.verifyIscfHmac(string9, string2, string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SecurityActivationInputException("The ISCF was not found! Provided path: " + string, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new SecurityActivationInputException("The ISCF could not be read! Provided path: " + string, iOException);
        }
    }

    protected void verifyIscfHash(String string, String string2) throws SecurityActivationException, SecurityActivationInputException {
        String string3 = EsaDataVerification.calculateSha1Base64(string);
        if (!string3.equals(string2)) {
            throw new SecurityActivationInputException("The ISCF does not have a correct hash. Provided / Actual: " + string2 + " / " + string3);
        }
    }

    protected void verifyIscfHmac(String string, String string2, String string3) throws SecurityActivationException, SecurityActivationInputException {
        byte[] byArray = EsaProxyFactory.getEsaProxy().calculateHmacSha1(string, string2);
        String string4 = EsaDataVerification.convertToBase64(byArray);
        if (!string3.equals(string4)) {
            throw new SecurityActivationInputException("The ISCF and RIC does not match!");
        }
    }

    protected void verifyIscfSize(String string) throws SecurityActivationInputException {
        if (string.getBytes().length >= 64000) {
            throw new SecurityActivationInputException("The body of the ISCF can not be larger than 64000 bytes! Current size: " + string.getBytes().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStateFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.constants.getEsaStateFilePath(), false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            try {
                outputStreamWriter.write(EsaDataVerification.calculateSha1Base64(string));
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Throwable throwable) {
            EsaReportLogger.getInstance().logMessage("Failed to write new esa.state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIpsecStateFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.constants.getEsaIpsecStateFilePath(), false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            try {
                outputStreamWriter.write(EsaDataVerification.calculateSha1Base64(string));
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Throwable throwable) {
            EsaReportLogger.getInstance().logMessage("Failed to write new esaIpsec.state");
        }
    }

    public static void deleteResetFile() {
        String string = EsaConstantsFactory.getEsaConstants().getEsaResetFilePath();
        File file = new File(string);
        if (!file.delete()) {
            EsaReportLogger.getInstance().logMessage("Unable to delete file: " + string);
        }
    }

    public void removeInstallIndicator() {
        String string = EsaConstantsFactory.getEsaConstants().getEsaInstallFilePath();
        File file = new File(string);
        if (!file.delete()) {
            EsaReportLogger.getInstance().logMessage("Unable to delete file: " + string);
        }
    }

    public static void deleteIpsecStateFile() {
        String string = EsaConstantsFactory.getEsaConstants().getEsaIpsecStateFilePath();
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            EsaReportLogger.getInstance().logMessage("Unable to delete file: " + string);
        }
    }

    public static void deleteStateFile() {
        String string = EsaConstantsFactory.getEsaConstants().getEsaStateFilePath();
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            EsaReportLogger.getInstance().logMessage("Unable to delete file: " + string);
        }
    }
}

