/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.checksum;

import java.util.ArrayList;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.security.SecurityMo;
import se.ericsson.security.cppsec.esa.EsaSecurityChecksums;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.checksum.Checksum;
import se.ericsson.security.cppsec.esa.checksum.EsaSecurityChecksumsImpl;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.SecurityData;
import se.ericsson.security.cppsec.esa.proxy.EsaProxyFactory;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstants;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;
import se.ericsson.security.cppsec.esa.wrapper.MoRepositoryWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MoRepositoryWrapperFactory;

public class ChecksumCalculator {
    private final MoRepositoryWrapper moRepository;
    private final SecurityMo securityMo;
    private final ManagedElementDataMo managedElementDataMo;
    private final EsaConstants constants;
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();
    private SecurityData securityData;

    public ChecksumCalculator(SecurityData securityData) {
        this.moRepository = MoRepositoryWrapperFactory.getMoRepositoryWrapper();
        this.securityMo = (SecurityMo)this.moRepository.lookup("ManagedElement=1,SystemFunctions=1,Security=1");
        this.managedElementDataMo = (ManagedElementDataMo)this.moRepository.lookup("ManagedElement=1,ManagedElementData=1");
        this.constants = EsaConstantsFactory.getEsaConstants();
        this.securityData = securityData;
    }

    public EsaSecurityChecksums calculateChecksums() throws SecurityActivationException {
        if (this.securityMo == null || this.managedElementDataMo == null) {
            throw new SecurityActivationException("Invalid system configuration, missing Managed Objects.");
        }
        String string = this.calculateChecksumSl1();
        String string2 = this.calculateChecksumSl2();
        String string3 = this.calculateChecksumSl3();
        String string4 = this.calculateChecksumSsh();
        EsaSecurityChecksumsImpl esaSecurityChecksumsImpl = new EsaSecurityChecksumsImpl(string, string2, string3, string4);
        return esaSecurityChecksumsImpl;
    }

    private String calculateChecksumSsh() throws SecurityActivationException {
        String string = EsaProxyFactory.getEsaProxy().getSshRsaKey();
        return string;
    }

    private String calculateChecksumSl1() throws SecurityActivationException {
        try {
            Checksum checksum = new Checksum();
            checksum.addInt(this.securityMo.getFileTransferClientMode(null));
            checksum.addBoolean(this.securityMo.getTelnetAndFTPServersActive(null));
            checksum.addInt(this.securityData.getWantedSecurityLevel());
            checksum.addInt(this.securityMo.getOperationalSecurityLevel(null));
            return checksum.getValue();
        }
        catch (Throwable throwable) {
            throw new SecurityActivationException("Unable to calculate checksum for SL1: ", throwable);
        }
    }

    private String calculateChecksumSl2() throws SecurityActivationException {
        try {
            Checksum checksum = new Checksum();
            int n = checksum.addCertsFromDir(this.constants.getCorbaPeersPath());
            checksum.addInt(n);
            checksum.addString(this.managedElementDataMo.getLogonServerAddress(null));
            return checksum.getValue();
        }
        catch (Throwable throwable) {
            throw new SecurityActivationException("Unable to calculate checksum for SL2: ", throwable);
        }
    }

    private String calculateChecksumSl3() throws SecurityActivationException {
        try {
            Checksum checksum = new Checksum();
            int n = checksum.addCertsFromDir(this.constants.getLocalAaDbFileSignersPath());
            int n2 = checksum.addCertsFromDir(this.constants.getAAServersPath());
            checksum.addInt(n + n2);
            checksum.addFile(this.constants.getLocalAuthorizationFilePath());
            checksum.addFile(this.constants.getLocalUserDbFilePath());
            String[] stringArray = this.securityMo.getAAServerIPAddressList(null);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("0.0.0.0") || stringArray[i].equals("")) continue;
                arrayList.add(stringArray[i]);
            }
            checksum.addStringArray(arrayList.toArray(new String[0]));
            checksum.addInt(this.securityMo.getAuthorizationCacheTimeOut(null));
            checksum.addInt(this.securityMo.getCertExpirWarnTime(null));
            return checksum.getValue();
        }
        catch (Throwable throwable) {
            throw new SecurityActivationException("Unable to calculate checksum for SL3: ", throwable);
        }
    }
}

