/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.checksum;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.security.cppsec.esa.IpSecChecksums;
import se.ericsson.security.cppsec.esa.IpSecInstallationException;
import se.ericsson.security.cppsec.esa.checksum.Checksum;
import se.ericsson.security.cppsec.esa.checksum.IpSecChecksumsImpl;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstants;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;
import se.ericsson.security.cppsec.esa.wrapper.MoRepositoryWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MoRepositoryWrapperFactory;

public class IpSecChecksumCalculator {
    private final MoRepositoryWrapper moRepository = MoRepositoryWrapperFactory.getMoRepositoryWrapper();
    private final IpSecMo ipSecMo = (IpSecMo)this.moRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
    private final EsaConstants constants = EsaConstantsFactory.getEsaConstants();

    public IpSecChecksums calculateIpSecChecksum() throws IpSecInstallationException {
        if (this.ipSecMo == null) {
            throw new IpSecInstallationException("Invalid system configuration, missing IpSecMo.");
        }
        String string = this.calculateChecksum();
        IpSecChecksumsImpl ipSecChecksumsImpl = new IpSecChecksumsImpl(string);
        return ipSecChecksumsImpl;
    }

    private String calculateChecksum() throws IpSecInstallationException {
        try {
            Checksum checksum = new Checksum();
            checksum.addInt(this.ipSecMo.getCertExpirWarnTime(null));
            return checksum.getValue();
        }
        catch (Throwable throwable) {
            throw new IpSecInstallationException("Unable to calculate checksum for SL1: ", throwable);
        }
    }
}

