/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.Level2ConfigSettings;
import se.ericsson.security.cppsec.esa.model.elements.LogonServerAddressElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class Level2ConfigSettingsElement
extends StackElement
implements Level2ConfigSettings {
    private static final String CERT_EXPIR_WARN_TIME = "certExpirWarnTime";
    private static final String INSTALL_TRUSTED_CERTS_DURATION = "installTrustedCertDuration";
    private static final String AUTO_UPDATE_CERT_ENROLLMENT_SERVER = "autoUpdateCertEnrollmentServer";
    public static final String LEVEL2CONFIGSETTINGS = "level2ConfigSettings";
    private String certExpirWarnTime;
    private String installTrustedCertDuration;
    private String autoUpdateCertEnrollmentServer;
    private ArrayList logonServerAddresses = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        LogonServerAddressElement logonServerAddressElement = null;
        if ("logonServerAddress".equalsIgnoreCase(string2)) {
            logonServerAddressElement = new LogonServerAddressElement();
            if (this.logonServerAddresses == null) {
                this.logonServerAddresses = new ArrayList();
            }
            this.logonServerAddresses.add(logonServerAddressElement);
        }
        return logonServerAddressElement;
    }

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.certExpirWarnTime = super.getOptionalAttribute(attributes, CERT_EXPIR_WARN_TIME, "90");
        this.installTrustedCertDuration = super.getOptionalAttribute(attributes, INSTALL_TRUSTED_CERTS_DURATION, "30");
        this.autoUpdateCertEnrollmentServer = super.getOptionalAttribute(attributes, AUTO_UPDATE_CERT_ENROLLMENT_SERVER, "");
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(this.certExpirWarnTime);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SecurityActivationInputException("Level2ConfigSettingsElement attribute certExpirWarnTime invalid value - " + this.certExpirWarnTime, numberFormatException);
        }
        if (n2 < 2 || n2 > 365) {
            throw new SecurityActivationInputException("Level2ConfigSettingsElement attribute certExpirWarnTime invalid value - " + this.certExpirWarnTime);
        }
        try {
            n = Integer.parseInt(this.installTrustedCertDuration);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("Level2ConfigSettings attribute installTrustedCertDuration invalid value - " + this.installTrustedCertDuration, throwable);
        }
        if (n < 5 || n > 600) {
            throw new SecurityActivationInputException("Level2ConfigSettings attribute installTrustedCertDuration invalid value - " + this.installTrustedCertDuration);
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.logonServerAddresses == null || this.logonServerAddresses.size() == 0) {
            throw new SecurityActivationInputException("Level2ConfigSettings element is not consistent - it must contain at least one LogonServerAddress element");
        }
        int n = this.logonServerAddresses.size();
        for (int i = 0; i < n; ++i) {
            ((LogonServerAddressElement)this.logonServerAddresses.get(i)).checkConsistency();
        }
    }

    public List getLogonServerAddresses() {
        return this.logonServerAddresses;
    }

    public Integer getCertExpirWarnTime() {
        return Integer.valueOf(this.certExpirWarnTime);
    }

    public Integer getInstallTrustedCertDuration() {
        return Integer.valueOf(this.installTrustedCertDuration);
    }

    public String getAutoUpdateCertEnrollmentServer() {
        return this.autoUpdateCertEnrollmentServer;
    }
}

