/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.MetaData;
import se.ericsson.security.cppsec.esa.model.util.EsaDateHelper;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class MetaDataElement
extends StackElement
implements MetaData {
    private static final String LOGICAL_NAME = "logicalName";
    private static final String NOT_VALID_AFTER = "notValidAfter";
    private static final String CREATION_TIME = "creationTime";
    public static final String METADATA = "metaData";
    private String creationTime;
    private String notValidAfter;
    private String logicalName;

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.creationTime = super.getRequiredAttribute(attributes, CREATION_TIME);
        this.notValidAfter = super.getRequiredAttribute(attributes, NOT_VALID_AFTER);
        this.logicalName = super.getRequiredAttribute(attributes, LOGICAL_NAME);
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        if (!EsaDateHelper.checkDateAndTime(this.creationTime)) {
            throw new SecurityActivationInputException("MetaData attribute creationTime is not valid - " + this.creationTime);
        }
        if (!EsaDateHelper.checkDateAndTime(this.notValidAfter)) {
            throw new SecurityActivationInputException("MetaData attribute notValidAfter is not valid - " + this.notValidAfter);
        }
    }

    public String getCreationtime() {
        return this.creationTime;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getNotValidAfter() {
        return this.notValidAfter;
    }
}

