/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.passwd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;

public class PasswordManager {
    private static final String PASSWD_FILE_NAME = "passwd";
    private static final String PASSWD_TMP_FILE_NAME = "tmppasswd";
    String PASSWD_FILE_PATH;
    String PASSWD_TMP_FILE_PATH;
    private static final String DEFAULT_PASSWORD_FILE = "/se/ericsson/security/cppsec/esa/passwd/defaultPasswdFile";
    boolean defaultPasswordRestored = false;
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();

    public PasswordManager() {
        this.PASSWD_FILE_PATH = EsaConstantsFactory.getEsaConstants().getSecurityPath() + "/" + PASSWD_FILE_NAME;
        this.PASSWD_TMP_FILE_PATH = EsaConstantsFactory.getEsaConstants().getSecurityPath() + "/" + PASSWD_TMP_FILE_NAME;
    }

    public final void restorePasswordFile() {
        File file = new File(this.PASSWD_TMP_FILE_PATH);
        if (file.exists()) {
            this.reportLogger.logMessage("Restoring passwd file from backup");
            file.renameTo(new File(this.PASSWD_FILE_PATH));
        } else {
            this.reportLogger.logMessage("No passwd backup exists");
            this.restoreDefaultPasswordFile();
        }
    }

    public void deleteDefaultPasswordFile() {
        if (this.defaultPasswordRestored) {
            File file = new File(this.PASSWD_FILE_PATH);
            this.reportLogger.logMessage("Removing default password file");
            if (file.delete()) {
                this.reportLogger.logMessage("Default password file sucessfully removed");
            } else {
                this.reportLogger.logMessage("Could not remove default password file");
            }
        }
    }

    public final void backupPasswordFile() {
        this.reportLogger.logMessage("Attempting to create backup of passwd file");
        File file = new File(this.PASSWD_FILE_PATH);
        if (!file.exists()) {
            this.reportLogger.logMessage("There is no passwd file. Ignoring backup");
        } else {
            File file2 = new File(this.PASSWD_TMP_FILE_PATH);
            if (file2.exists() && !file2.delete()) {
                this.reportLogger.logMessage("Failed to delete the temporary passwd file");
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(this.PASSWD_FILE_PATH));
                this.writeFromStream(fileInputStream, file2);
                this.defaultPasswordRestored = false;
                this.reportLogger.logMessage("Backup of password file successfully created");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.reportLogger.logMessage("Could not make backup of password file", fileNotFoundException);
            }
            catch (IOException iOException) {
                this.reportLogger.logMessage("Could not make backup of password file", iOException);
            }
        }
    }

    private void restoreDefaultPasswordFile() {
        this.reportLogger.logMessage("Restoring ESA default password file");
        File file = new File(this.PASSWD_FILE_PATH);
        try {
            InputStream inputStream = PasswordManager.class.getResourceAsStream(DEFAULT_PASSWORD_FILE);
            this.writeFromStream(inputStream, file);
            this.defaultPasswordRestored = true;
            this.reportLogger.logMessage("Restored password file using ESA default password file. Password is set to change_me");
        }
        catch (IOException iOException) {
            this.reportLogger.logMessage("Could not make backup of password file", iOException);
        }
    }

    public void deletebackupPasswordFile() {
        File file = new File(this.PASSWD_TMP_FILE_PATH);
        if (file.exists()) {
            this.reportLogger.logMessage("Removing temporary password file");
            if (file.delete()) {
                this.reportLogger.logMessage("Temporary password file sucessfully removed");
            } else {
                this.reportLogger.logMessage("Could not remove temporary password file");
            }
        }
    }

    private void writeFromStream(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = inputStream.read();
        while (n != -1) {
            fileOutputStream.write(n);
            n = inputStream.read();
        }
        inputStream.close();
        fileOutputStream.close();
    }
}

