/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractAuxControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class RadioDotRI
extends AbstractAuxControlledAuxillaryUnitRI {
    public static final String NAME = "RadioDot";
    private static final String PIU_TYPE_PRODUCT_NAME = "RD";
    private static final String AU_TYPE = "RD";
    private static final String[] myInstallationPhases = new String[]{"GenericSettingsPhase", "RadioDotDeletionPhase"};
    private MoInstance sectorMoi;
    private MoInstance sectorAntennaMoi;
    private MoInstance auxPiuMoi;
    private MoInstance boardMoi;
    private String auxPiuLdn;
    private final String ldn;
    private int sectorNumber;
    private int radioDotNumber;

    public RadioDotRI(Rbs rbs, String string, String string2, int n) throws BemException {
        super(NAME, rbs, 28, "RD", string2);
        this.setSwLoadable(false);
        this.sectorMoi = new FixedRdnMoi(rbs.getNodeBFunctionMoi(), MimSector.MOTYPENAME, SectorUtil.getSectorRdn()[n - 1]);
        this.sectorAntennaMoi = new SectorAntennaMoi(rbs.getEquipmentMoi(), this.sectorMoi, n, 1);
        String string3 = "RD" + "-" + string;
        this.auxPiuMoi = new FixedRdnMoi(this.sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, string3);
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimDeviceGroup.MOTYPENAME, "RD");
        this.ldn = this.boardMoi.getLdn();
        this.sectorNumber = n;
        this.radioDotNumber = Integer.valueOf(string);
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    public String getDisplayName() {
        return "RadioDot: " + this.getLdn();
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals(myInstallationPhases[0])) {
            this.setPositionCoordinatesForRD();
        }
    }

    public void uninstall(String string) throws BemException {
        super.uninstall(string);
        if (string.equals(myInstallationPhases[1])) {
            super.handleDeletionPhase();
        }
    }

    private void setPositionCoordinatesForRD() throws BemException {
        NalNameValue[] nalNameValueArray;
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        String string = "";
        String string2 = PrefixUtil.getRadioDotPrefix(this.sectorNumber, this.radioDotNumber);
        string = string2 + "longitude";
        IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterServerObject(string);
        string = string2 + "latitude";
        IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterServerObject(string);
        string = string2 + "altitude";
        IntegerParameter integerParameter3 = (IntegerParameter)this.rbs.getCustomerParameterServerObject(string);
        string = string2 + "geoDatum";
        StringParameter stringParameter = (StringParameter)this.rbs.getCustomerParameterServerObject(string);
        if (integerParameter.hasValueChanged() || integerParameter2.hasValueChanged() || integerParameter3.hasValueChanged() || stringParameter.hasValueChanged()) {
            nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("longitude", new Integer(integerParameter.getValueMom().toString())), Nal.getFactory().getNameValue("latitude", new Integer(integerParameter2.getValueMom().toString())), Nal.getFactory().getNameValue("altitude", new Integer(integerParameter3.getValueMom().toString())), Nal.getFactory().getNameValue("geoDatum", stringParameter.getValueMom())};
            vector.add(Nal.getFactory().getNameValue("positionCoordinates", Nal.getFactory().getStruct(nalNameValueArray)));
        }
        if (vector.size() > 0) {
            nalNameValueArray = this.getMo(this.auxPiuLdn);
            this.setAttributes((BemMo)nalNameValueArray, vector);
        }
    }

    public void setLoadedValueForAU() throws BemException {
        BemMo bemMo = this.getMo(this.auxPiuLdn);
        if (this.isExisting(bemMo)) {
            try {
                NalStruct nalStruct = (NalStruct)this.getAttribute(bemMo, "positionCoordinates");
                if (nalStruct != null && nalStruct.getSize() > 0) {
                    String string = PrefixUtil.getRadioDotPrefix(this.sectorNumber, this.radioDotNumber);
                    String string2 = string + "radioDotNumber";
                    if (this.rbs.isParameterSupported(string2)) {
                        this.rbs.getCustomerParameterServerObject(string2).setLoadedValue(new Integer(this.radioDotNumber));
                    }
                    if (this.rbs.isParameterSupported(string2 = string + "longitude")) {
                        this.rbs.getCustomerParameterServerObject(string2).setLoadedValue(nalStruct.getMemberValue("longitude"));
                    }
                    if (this.rbs.isParameterSupported(string2 = string + "latitude")) {
                        this.rbs.getCustomerParameterServerObject(string2).setLoadedValue(nalStruct.getMemberValue("latitude"));
                    }
                    if (this.rbs.isParameterSupported(string2 = string + "altitude")) {
                        this.rbs.getCustomerParameterServerObject(string2).setLoadedValue(nalStruct.getMemberValue("altitude"));
                    }
                    if (this.rbs.isParameterSupported(string2 = string + "geoDatum")) {
                        this.rbs.getCustomerParameterServerObject(string2).setLoadedValue(nalStruct.getMemberValue("geoDatum"));
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new BemException(noSuchFieldException);
            }
        }
    }
}

