/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.autointegration;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.InformativeText;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class FinalizeRbsConfigurationRI
extends AbstractResourceItem {
    public static String NAME = "FinalizeRbsConfigurationRI";
    private static final String[] myInstallationPhases = new String[]{"FinalizeRbsConfigurationPhase"};
    protected MoInstance rbsConfigurationMoi;
    protected BemMo rbsConfigurationMo;
    private String rbsConfigurationLdn;

    public FinalizeRbsConfigurationRI(Rbs rbs) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        if (rbs == null) {
            ExceptionProperties exceptionProperties = new ExceptionProperties();
            exceptionProperties.setProperty("ResourceItem  (RI)", this);
            exceptionProperties.setProperty("Failing Method", this.getClass().getName() + NAME);
            throw new BemException("Rbs is null", exceptionProperties);
        }
        this.rbsConfigurationLdn = rbs.getMoiRefs().getRbsConfigurationMoi().getLdn();
        this.rbsConfigurationMo = this.getMo(this.rbsConfigurationLdn);
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getLdn() {
        return this.rbsConfigurationLdn;
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            ExceptionProperties exceptionProperties = new ExceptionProperties();
            exceptionProperties.setProperty("ResourceItem  (RI)", this);
            exceptionProperties.setProperty("Failing Method", this.getClass().getName() + "install()");
            try {
                this.finalizeConfiguration(this.rbs.getRbsStep());
            }
            catch (Exception exception) {
                throw new BemException("Failed finalizeRbsConfiguration()", exceptionProperties, (Throwable)exception);
            }
        }
    }

    private void finalizeConfiguration(String string) throws Exception {
        MoHandler moHandler = this.rbs.getMoHandler();
        String string2 = this.finalizeRbsStep(string, moHandler);
        if (string2 != null && this.rbs.isAiOngoing()) {
            this.appendRbsInfoToConfigReport("Settings from " + string2 + " XML file", this.rbs, moHandler);
        }
        this.rbs.setWriteRbsConfigPhase(false);
    }

    private String finalizeRbsStep(String string, MoHandler moHandler) throws MoHandlerException {
        String string2 = null;
        if (string.equals("STEP_CABINET")) {
            string2 = "Cabinet Equipment";
            this.setConfigLevel(2, moHandler);
            this.setConfigPhases("Cabinet configuration completed", moHandler);
        } else if (string.equals("STEP_INT_OAM")) {
            string2 = "OAM Access";
            this.setConfigLevel(3, moHandler);
            this.setConfigPhases("OaM configuration completed", moHandler);
        } else if (string.equals("STEP_INT_SITE")) {
            string2 = "Site Equipment";
            if (this.isOssAttributesSet(moHandler)) {
                this.setConfigLevel(13, moHandler);
            } else {
                this.setConfigLevel(4, moHandler);
            }
            this.setConfigPhases("Site configuration completed", moHandler);
        } else {
            Nal.getLog().nalTrace(6, this.getClass(), "finalizeRbsStep(), rbsStep: " + string + " is not excpected");
        }
        return string2;
    }

    private void appendRbsInfoToConfigReport(String string, Rbs rbs, MoHandler moHandler) throws Exception, MoHandlerException {
        String string2 = this.getConfigReport(rbs, moHandler);
        string2 = string2 + "\n\n" + string + "\n";
        string2 = string2 + "=======================\n";
        string2 = string2 + this.getInformativeText(rbs);
        moHandler.setAttribute(this.rbsConfigurationMo, "configurationReport", string2);
    }

    private void setConfigLevel(int n, MoHandler moHandler) throws MoHandlerException {
        moHandler.setAttribute(this.rbsConfigurationMo, "rbsConfigLevel", new Integer(n));
    }

    private void setConfigPhases(String string, MoHandler moHandler) throws MoHandlerException {
        moHandler.setAttribute(this.rbsConfigurationMo, "rbsConfigPhase", string);
    }

    private String getConfigReport(Rbs rbs, MoHandler moHandler) throws Exception {
        return (String)moHandler.getAttribute(this.rbsConfigurationMo, "configurationReport");
    }

    private String getInformativeText(Rbs rbs) throws BemException {
        return new InformativeText(rbs).getInformativeText();
    }

    private boolean isOssAttributesSet(MoHandler moHandler) throws MoHandlerException {
        String string = (String)moHandler.getAttribute(this.rbsConfigurationMo, "ossCorbaNameServiceAddress");
        Integer n = (Integer)moHandler.getAttribute(this.rbsConfigurationMo, "ossCorbaNameServicePort");
        return string != null && string.length() > 0 && n > 0;
    }
}

