/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.LocationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.AbstractCabinetBasicCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.AutoConfigRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.DigitalSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ExternalNodeRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.JvmRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.NodeRestartRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.PmServiceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ProductInfoRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RedundantControlSystemParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ReliableProgramUniterRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RestartEscalationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AbsoluteTimeSynchEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AddDuwBoardSlotCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameterOnSlot2;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw.DuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw.InterPiuLinkCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw.MediumAccessUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw.ReliableProgramUniterDuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource.GpsSynchronizationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemAvailableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.InciConnectorInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ConfirmDialogParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.SwAllocOtherRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalNode;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFcuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimJvm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class CabinetBasicDuwCI
extends AbstractCabinetBasicCI
implements CustomerParameterListener {
    private ArrayList allResourceItems;
    private DigitalSubrackRI digitalSubrackRI;
    private SwAllocOtherRI swAllocOtherRI;
    private NodeRestartRI nodeRestartRI;
    private RestartEscalationRI restartEscalationRI;
    private ReliableProgramUniterRI rpuRI;
    private InterPiuLinkCableRI interpiuLinkCableRI;
    private ExternalNodeRI[] externalNodeRIs = new ExternalNodeRI[7];
    private InciConnectorInfo[] inciConnectorInfos = new InciConnectorInfo[7];
    private RedundantControlSystemParameter redundantControlSystemCustParam;
    private ConfirmDialogParameter restartCustParam;
    private AddDuwBoardSlotCustomerParameter addDuwBoardSlotCustomerParameter;
    private IntegerParameter addDuwBoardCabinetNumberCustomerParameter;
    private boolean isOpen = false;
    private AtfProviderImpl myAtfProvider;
    private RbsData rbsData;
    private ChildWithAttributeValues auxpiuFcuMoi;
    private GpsSynchronizationRI gpsSynchronizationRI;
    private AbsoluteTimeSynchEnabledParameter absoluteTimeSynchParam;
    private boolean supportSystemAvailable = false;
    private SupportSystemAvailableRI supportSystemAvailableRI = null;
    private GpsOutEnabledParameter gpsOutOnSlot1Param = null;
    private GpsOutEnabledParameterOnSlot2 gpsOutOnSlot2Param = null;
    private JvmRI jvmRI;

    public CabinetBasicDuwCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("CabinetBasicCI.open(): Already open");
        }
        this.initializeMoiResources();
        boolean bl = true;
        this.createBasicCommonResourceItems();
        if (this.allResourceItems != null) {
            this.initialiseCustomerParameters();
            if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
                this.createEcPortCustomerParametersDuw();
                super.createEcPortCustomerParametersExternalNode();
                this.createInciConnectorCustomerParameters();
            }
        } else {
            throw new BemException("CabinetBasicCI.open() can not find any resource items");
        }
        this.locationProvider = (LocationProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.isOpen = true;
        return bl;
    }

    private void createDigitalSubrackRi() throws BemException {
        if (this.digitalSubrackRI != null) {
            return;
        }
        this.rbsData = super.getRbsData();
        int n = this.rbsData.getNoOfSlots();
        String string = this.rbsData.getCabinetPosition();
        String string2 = this.rbsData.getSubrackPosition();
        HashMap hashMap = this.rbsData.getBoardPositions();
        Map map = this.rbsData.getRepertoireMap();
        this.digitalSubrackRI = new DigitalSubrackRI(this.getRbs(), n, string, string2, hashMap, super.getHubSubrackMoi(), map, this.interpiuLinkCableRI, this.supportSystemAvailable);
    }

    private void createSwAllocOtherRI() {
        if (this.swAllocOtherRI != null) {
            return;
        }
        this.swAllocOtherRI = new SwAllocOtherRI(this.rbs);
    }

    private void createBasicCommonResourceItems() throws BemException {
        String string;
        this.allResourceItems = new ArrayList();
        this.interpiuLinkCableRI = new InterPiuLinkCableRI(this.rbs, super.getEquipmentMoi());
        this.allResourceItems.add(this.interpiuLinkCableRI);
        this.createDigitalSubrackRi();
        this.allResourceItems.add(this.digitalSubrackRI);
        this.createSwAllocOtherRI();
        this.allResourceItems.add(this.swAllocOtherRI);
        String[] stringArray = this.rbsData.getProductData();
        this.allResourceItems.add(new ProductInfoRI(super.getRbs(), stringArray[0], stringArray[1], stringArray[2], 2));
        this.allResourceItems.add(new PmServiceRI(super.getRbs(), super.getPmServiceLdn()));
        ArrayList arrayList = this.digitalSubrackRI.getSubResourceItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.allResourceItems.add(arrayList.get(i));
        }
        String string2 = DuwUtil.getPrimaryDuwSlotLdn();
        int n = this.getSlotNumberFromSlotLdn(string2);
        int n2 = 2;
        if (DuwUtil.hasDualDuws()) {
            string = DuwUtil.getPrimaryDuwSlotLdn();
            n2 = this.getSlotNumberFromSlotLdn(string);
            n2 = 2;
        }
        this.rpuRI = new ReliableProgramUniterDuwRI(super.getRbs(), (HubSubrackMoi)super.getHubSubrackMoi(), n2, n, this.supportSystemAvailable);
        this.allResourceItems.add(this.rpuRI);
        string = DuwUtil.getPrimaryDuwPiuLdn();
        this.allResourceItems.add(new MediumAccessUnitRI(super.getRbs(), string));
        if (DuwUtil.hasDualDuws()) {
            String string3 = DuwUtil.getSecondaryDuwPiuLdn();
            this.allResourceItems.add(new MediumAccessUnitRI(super.getRbs(), string3));
        }
        this.allResourceItems.add(new AutoConfigRI(super.getRbs(), true, super.getManagedElementMoi().getLdn()));
        this.nodeRestartRI = new NodeRestartRI(this.rbs);
        this.allResourceItems.add(this.nodeRestartRI);
        this.restartEscalationRI = new RestartEscalationRI(super.getRbs(), super.getConfigurationVersionLdn());
        this.allResourceItems.add(this.restartEscalationRI);
        for (int i = 0; i < 7; ++i) {
            String string4 = String.valueOf(i + 1);
            this.externalNodeRIs[i] = new ExternalNodeRI(this.rbs, string4);
            this.allResourceItems.add(this.externalNodeRIs[i]);
        }
        if (!this.supportSystemAvailable) {
            this.supportSystemAvailableRI = new SupportSystemAvailableRI(super.getRbs(), false);
            this.allResourceItems.add(this.supportSystemAvailableRI);
        } else {
            this.addJvmRI();
            if (this.rbs.getRbsData().isRbs6000()) {
                this.gpsSynchronizationRI = new GpsSynchronizationRI(super.getRbs());
                this.allResourceItems.add(this.gpsSynchronizationRI);
            }
        }
    }

    private void addJvmRI() {
        SingleChildMoi singleChildMoi = new SingleChildMoi(this.rbs.getEquipmentMoi(), MimJvm.MOTYPENAME, "1");
        this.jvmRI = new JvmRI(this.rbs, singleChildMoi, null);
        this.allResourceItems.add(this.jvmRI);
    }

    private int getSlotNumberFromSlotLdn(String string) {
        int n = string.lastIndexOf("=");
        String string2 = string.substring(n + 1);
        int n2 = Integer.parseInt(string2);
        return n2;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("nodeRestart");
        arrayList.add("AddDuwBoardslot");
        if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
            arrayList.add("absoluteTimeSynchEnabled");
            arrayList.add("gpsOutEnabled");
            if (DuwUtil.hasDualDuws()) {
                arrayList.add("gpsOutEnabledOnSlot2");
            }
            arrayList.add("AddDuwBoardcabinetNumber");
        }
        super.setCustomerParametersFromSV(arrayList.toArray(new String[0]), serviceValue);
        if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
            super.setEcPortCustomerParameters(serviceValue);
            this.setInciConnectorCustomerParameters(serviceValue);
        }
    }

    private void initialiseCustomerParameters() throws BemException {
        Object object;
        this.redundantControlSystemCustParam = new RedundantControlSystemParameter();
        this.restartCustParam = new ConfirmDialogParameter();
        String string = "NO";
        String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimPlugInUnit.MOTYPENAME);
        ResourceItem resourceItem = null;
        if (stringArray.length > 1) {
            object = Integer.valueOf(stringArray[1]);
            resourceItem = this.digitalSubrackRI.getSubResourceItem((Integer)object);
        }
        object = new ParameterRestriction("Redundant control system ignored for RBS with DUW", 1);
        this.redundantControlSystemCustParam.addRestriction((ParameterRestriction)object);
        this.redundantControlSystemCustParam.setDefaultValue("NO");
        this.redundantControlSystemCustParam.setLoadedValue(string);
        this.restartCustParam.setDefaultValue("NO");
        this.restartCustParam.setLoadedValue("NO");
        super.addParameter(this.restartCustParam);
        this.redundantControlSystemCustParam.addCustomerParameterListener(this);
        this.digitalSubrackRI.registerCustomerParameter(this.redundantControlSystemCustParam);
        if (resourceItem != null) {
            resourceItem.registerCustomerParameter(this.redundantControlSystemCustParam);
        }
        this.addDuwBoardSlotCustomerParameter = new AddDuwBoardSlotCustomerParameter();
        super.addParameter(this.addDuwBoardSlotCustomerParameter);
        if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
            this.addDuwBoardCabinetNumberCustomerParameter = new IntegerParameter("AddDuwBoardcabinetNumber", new IntegerRange(1, this.rbs.getMaxCabinetNo()));
            this.addDuwBoardCabinetNumberCustomerParameter.setDefaultValue("##UNDEFINED");
            super.addParameter(this.addDuwBoardCabinetNumberCustomerParameter);
        }
        this.digitalSubrackRI.registerCustomerParameter(this.addDuwBoardSlotCustomerParameter);
        this.rpuRI.registerCustomerParameter(this.redundantControlSystemCustParam);
        this.nodeRestartRI.registerCustomerParameter(this.restartCustParam);
        if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
            this.absoluteTimeSynchParam = new AbsoluteTimeSynchEnabledParameter();
            this.absoluteTimeSynchParam.setDefaultValue("NO");
            this.absoluteTimeSynchParam.setLoadedValue(this.gpsSynchronizationRI.getLoadedValue("absoluteTimeSynchEnabled"));
            super.addParameter(this.absoluteTimeSynchParam);
            this.handledisbleOnSiteWizard();
            this.gpsOutOnSlot1Param = new GpsOutEnabledParameter();
            this.gpsOutOnSlot1Param.setDefaultValue("FALSE");
            this.gpsOutOnSlot1Param.setLoadedValue(this.gpsSynchronizationRI.getLoadedValue("gpsOutEnabled"));
            if (DuwUtil.hasDualDuws()) {
                this.gpsOutOnSlot2Param = new GpsOutEnabledParameterOnSlot2();
                this.gpsOutOnSlot2Param.setDefaultValue("FALSE");
                this.gpsOutOnSlot2Param.setLoadedValue(this.gpsSynchronizationRI.getLoadedValue("gpsOutEnabledOnSlot2"));
                super.addParameter(this.gpsOutOnSlot2Param);
            }
            super.addParameter(this.gpsOutOnSlot1Param);
        }
    }

    private void handledisbleOnSiteWizard() {
        BemMo bemMo = this.rbs.getMoHandler().getMo("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1,TuSyncRef=1");
        if (bemMo.isExisting()) {
            ParameterRestriction parameterRestriction = new ParameterRestriction("absoluteTimeSynchParam ignored when TuSyncRefMo exist", 1);
            this.absoluteTimeSynchParam.addRestriction(parameterRestriction);
        }
    }

    public ArrayList getNeededRIs() {
        if (this.isOpen) {
            String string = this.getRbs().getRbsStep();
            if (string.equals("STEP_EXPANSION")) {
                if (this.addDuwBoardSlotCustomerParameter.getValue().equals("2")) {
                    this.allResourceItems.add(this.digitalSubrackRI.getSubResourceItem(new Integer(2)));
                } else {
                    this.allResourceItems.remove(this.interpiuLinkCableRI);
                }
            } else if (string.equals("STEP_CABINET")) {
                try {
                    Integer n = new Integer(DuwUtil.getPrimaryDuwID());
                    if (!DuwUtil.isMicroRbsDuw()) {
                        n = new Integer(DuwUtil.getSecondaryDuwID());
                    }
                    if (!this.allResourceItems.contains(this.digitalSubrackRI.getSubResourceItem(n))) {
                        this.allResourceItems.add(this.digitalSubrackRI.getSubResourceItem(n));
                    }
                }
                catch (BemException bemException) {
                    bemException.printStackTrace();
                }
            } else {
                this.allResourceItems.remove(this.interpiuLinkCableRI);
            }
        }
        return this.allResourceItems;
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(super.getRIsToUninstall());
        return arrayList;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected AtfProvider getAtfProvider() {
        return this.getAtfProvider(0);
    }

    protected AtfProvider getAtfProvider(int n) {
        if (this.myAtfProvider == null) {
            Integer n2;
            try {
                this.createDigitalSubrackRi();
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(2, this.getClass(), "Failed creating digital subrack RI", bemException);
            }
            this.myAtfProvider = new AtfProviderImpl();
            String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimPlugInUnit.MOTYPENAME);
            String string = null;
            if (n == 0) {
                n2 = Integer.valueOf(stringArray[0]);
                DuwRI duwRI = (DuwRI)this.digitalSubrackRI.getSubResourceItem(n2);
                string = duwRI.getPiuLdn();
            } else {
                n2 = Integer.valueOf(stringArray[1]);
                DuwRI duwRI = (DuwRI)this.digitalSubrackRI.getSubResourceItem(n2);
                string = duwRI.getPiuLdn();
            }
            n2 = null;
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_BFU", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_CLU", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_FCU", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_PSU", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_XALM", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_SCU", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_SUP", string, (String)((Object)n2));
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_SAU", string, (String)((Object)n2));
        }
        return this.myAtfProvider;
    }

    protected void initializeMoiResources() {
        this.auxpiuFcuMoi = new ChildWithAttributeValues(super.getEquipmentMoi(), MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(13), "2");
        this.fcuMoi = new SingleChildMoi(this.auxpiuFcuMoi, MimFcuDeviceGroup.MOTYPENAME, "1");
    }

    public String[] getSlotsWithTuSynchRef() throws BemException {
        return new String[]{"1"};
    }

    public String[] getTuSynchRefLdns(String string) throws BemException {
        Integer n = Integer.valueOf(string);
        DuwRI duwRI = (DuwRI)this.digitalSubrackRI.getSubResourceItem(n);
        if (duwRI == null) {
            return new String[0];
        }
        return duwRI.getTuSynchRefLdns();
    }

    public String[] getGpsSynchRefLdns(String string) throws BemException {
        Integer n = Integer.valueOf(string);
        DuwRI duwRI = (DuwRI)this.digitalSubrackRI.getSubResourceItem(n);
        if (duwRI == null) {
            return new String[0];
        }
        return duwRI.getGpsSynchRefLdns();
    }

    public SyncRefInfo[] getTuSyncRefs(String string) throws BemException {
        String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimPlugInUnit.MOTYPENAME);
        Integer n = Integer.valueOf(stringArray[0]);
        DuwRI duwRI = (DuwRI)this.digitalSubrackRI.getSubResourceItem(n);
        return duwRI.getTuSynchRefs();
    }

    public SyncRefInfo[] getGpsSyncRefs(String string) throws BemException {
        String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimPlugInUnit.MOTYPENAME);
        Integer n = Integer.valueOf(stringArray[0]);
        DuwRI duwRI = (DuwRI)this.digitalSubrackRI.getSubResourceItem(n);
        return duwRI.getGpsSynchRefs();
    }

    public String[] getProcessorPiuLdns() throws BemException {
        return DuwUtil.getDuwPiuLdns();
    }

    public ConfigurationCheckReport checkConfiguration() {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        return configurationCheckReport;
    }

    public CustomerParameter getAddDuwBoardSlotCustomerParameter() {
        return this.addDuwBoardSlotCustomerParameter;
    }

    public void setSupportSystemAvailable(boolean bl) {
        this.supportSystemAvailable = bl;
    }

    public void checkConsistency(List list) throws BemException {
        super.checkConsistency(list);
        if (list.contains("absoluteTimeSynchEnabled") || list.contains("gpsOutEnabled")) {
            this.gpsSynchronizationRI.checkConsistency();
        }
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        if (this.gpsSynchronizationRI != null) {
            this.gpsSynchronizationRI.checkConsistency();
        }
        this.checkConflictsOfCabinetNumberForAddingDuw();
        this.checkInciConnectorConfiguration();
    }

    private void checkInciConnectorConfiguration() throws BemException, CustomerParameterException {
        if (this.rbs.isParameterSupported("supportSystemControl") && this.rbs.getRbsData().isRbs6000()) {
            for (int i = 0; i < 7; ++i) {
                InciConnectorInfo inciConnectorInfo = this.inciConnectorInfos[i];
                String string = inciConnectorInfo.getExternalNodeIdValue();
                String string2 = inciConnectorInfo.getUnitTypeValue();
                String string3 = inciConnectorInfo.getUnitNumberValue();
                String string4 = inciConnectorInfo.getSectorNumberValue();
                if (string3 == null || string3.equals("##UNDEFINED") || string.equals("##UNDEFINED")) continue;
                if (string2.equals("Radio")) {
                    this.checkRadioExistence(inciConnectorInfo, string3, string4);
                    continue;
                }
                if (string2.equals("EcBus")) {
                    if (string4 == null || string4.equals("##UNDEFINED")) continue;
                    String string5 = "Invalid sectorNumber configured for EcBus. It's no need to configure this parametr when the unitType is " + string2 + ".";
                    throw new CustomerParameterException(string5, inciConnectorInfo.getSectorNumberParameter());
                }
                throw new BemException("Invalid unit type(" + string2 + ") for InciConnector.");
            }
        }
    }

    private void checkRadioExistence(InciConnectorInfo inciConnectorInfo, String string, String string2) throws BemException, CustomerParameterException {
        int n;
        RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider();
        if (!radioEquipmentProvider.isSectorEquipped(Integer.parseInt(string2))) {
            String string3 = "The sectorNumber is not equipped on the node. The invalid sectorNumber is =" + string2 + ".";
            throw new CustomerParameterException(string3, inciConnectorInfo.getSectorNumberParameter());
        }
        AbstractRuRI[] abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(Integer.parseInt(string2));
        int n2 = n = null == abstractRuRIArray ? 0 : abstractRuRIArray.length;
        if (Integer.parseInt(string) > n) {
            throw new BemException("Invalid unitNumber configured for RadioUnit " + string + " of Sector " + string2 + " because Sector " + string2 + " contains only " + n + " radio unit(s).");
        }
    }

    private void checkConflictsOfCabinetNumberForAddingDuw() throws BemException {
        if (!this.getRbs().isModifyWiz()) {
            return;
        }
        String string = this.getAddingDuwCabinetNumberCPValueDuringModify();
        if (null == string) {
            return;
        }
        this.checkWhetherDualBoxConflictWithCabinetNumber(string);
        this.checkWhetherSupCascadingConflictWithCabinetNumber(string);
    }

    private void checkWhetherDualBoxConflictWithCabinetNumber(String string) throws BemException {
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType()) && !string.equals(String.valueOf(2))) {
            throw new BemException("For the support unit cascading configuration of RBS 6601 based on DUW 10, DUW 20, or DUW 30, \nand RBS 6302, a new DUW can only be added to cabinet=" + String.valueOf(2));
        }
    }

    private void checkWhetherSupCascadingConflictWithCabinetNumber(String string) throws BemException {
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        if (DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && RbsUtil.isRbsInSupCascadingMode(ecPortCustomerParameterProvider) && !string.equals(String.valueOf(2))) {
            throw new BemException("For the support unit cascading configuration of RBS 6601 based on DUW 31 or DUW 41, \na new DUW can only be added to cabinet=" + String.valueOf(2));
        }
    }

    private String getAddingDuwCabinetNumberCPValueDuringModify() throws BemException {
        String string = "AddDuwBoardcabinetNumber";
        if (!this.rbs.isParameterSupported(string)) {
            return null;
        }
        IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string);
        if (null == integerParameter || integerParameter.getValue().equals("##UNDEFINED")) {
            return null;
        }
        String string2 = integerParameter.getValue();
        return string2;
    }

    private void createEcPortCustomerParametersDuw() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            String[] stringArray = DuwUtil.hasDualDuws() ? new String[]{DuwUtil.getPrimaryDuwPiuLdn(), DuwUtil.getSecondaryDuwPiuLdn()} : new String[]{DuwUtil.getPrimaryDuwPiuLdn()};
            for (int i = 0; i < stringArray.length; ++i) {
                String string = String.valueOf(i + 1);
                String string2 = stringArray[i];
                LdnMoi ldnMoi = new LdnMoi(string2);
                SingleChildMoi singleChildMoi = new SingleChildMoi(ldnMoi, MimEcPort.MOTYPENAME, "1");
                BemMo bemMo = moHandler.getMo(singleChildMoi.getLdn());
                EcPortInfo ecPortInfo = super.createEcPortCustomerParameter("DUW");
                Enumeration enumeration = ecPortInfo.getUnitTypeParameter();
                enumeration.setLoadedValue("DUW");
                enumeration.addRestriction(this.ecPortReadOnlyRestriction);
                Enumeration enumeration2 = ecPortInfo.getUnitNumberParameter();
                enumeration2.setLoadedValue(string);
                enumeration2.addRestriction(this.ecPortReadOnlyRestriction);
                Enumeration enumeration3 = ecPortInfo.getHubPositionParameter();
                Enumeration enumeration4 = ecPortInfo.getCascadingOrderParameter();
                if (moHandler.isExisting(bemMo)) {
                    enumeration3.setLoadedValue((String)bemMo.getAttribute("hubPosition"));
                    if (!this.rbs.isCabinetWiz()) {
                        enumeration4.setLoadedValue((Integer)bemMo.getAttribute("cascadingOrder"));
                    }
                }
                Enumeration enumeration5 = ecPortInfo.getPortNumberParameter();
                enumeration5.setLoadedValue("1");
                enumeration5.addRestriction(this.ecPortReadOnlyRestriction);
                enumeration.addCustomerParameterListener(this);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
    }

    protected void createInciConnectorCustomerParameters() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            for (int i = 1; i <= 7; ++i) {
                BemMo bemMo;
                InciConnectorInfo inciConnectorInfo;
                EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"1", "2", "3", "4", "5", "6", "7"});
                EnumeratedRange enumeratedRange2 = new EnumeratedRange(new String[]{"1", "2", ""});
                EnumeratedRange enumeratedRange3 = new EnumeratedRange(new String[]{"EcBus", "Radio"});
                IntegerRange integerRange = new IntegerRange(new Integer(1), new Integer(7));
                EnumeratedRange enumeratedRange4 = new EnumeratedRange(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
                ParameterRestriction parameterRestriction = new ParameterRestriction("", 2);
                String string = BemUtil.getInciConnectorPrefix(i);
                String string2 = "";
                string2 = string + "externalNodeId";
                Enumeration enumeration = new Enumeration(string2, enumeratedRange);
                enumeration.addRestriction(parameterRestriction);
                super.addParameter(enumeration);
                string2 = string + "equipmentSupportFunctionId";
                Enumeration enumeration2 = new Enumeration(string2, enumeratedRange2);
                enumeration2.addRestriction(parameterRestriction);
                super.addParameter(enumeration2);
                string2 = string + "unitType";
                Enumeration enumeration3 = new Enumeration(string2, enumeratedRange3);
                enumeration3.setDefaultValue("Radio");
                enumeration3.addRestriction(parameterRestriction);
                super.addParameter(enumeration3);
                string2 = string + "unitNumber";
                IntegerParameter integerParameter = new IntegerParameter(string2, integerRange);
                integerParameter.addRestriction(parameterRestriction);
                super.addParameter(integerParameter);
                string2 = string + "sectorNumber";
                Enumeration enumeration4 = new Enumeration(string2, enumeratedRange4);
                enumeration4.addRestriction(parameterRestriction);
                super.addParameter(enumeration4);
                this.inciConnectorInfos[i - 1] = inciConnectorInfo = new InciConnectorInfo(enumeration, enumeration2, enumeration3, integerParameter, enumeration4);
                enumeration3.addCustomerParameterListener(this);
                FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.getEquipmentMoi(), MimExternalNode.MOTYPENAME, String.valueOf(i));
                BemMo bemMo2 = moHandler.getMo(fixedRdnMoi.getLdn());
                if (!moHandler.isExisting(bemMo2) || null != (bemMo = (BemMo)bemMo2.getAttribute("inciConnectorRef")) && null != bemMo.getDN() && !bemMo.getDN().equals("") && !bemMo.getType().equals(MimEcBus.MOTYPENAME) && !bemMo.getType().equals(MimAuxPlugInUnit.MOTYPENAME)) continue;
                enumeration.setLoadedValue(String.valueOf(i));
                enumeration2.setLoadedValue(BemUtil.getExNodeLoadedValue(this.rbs, bemMo2, "equipmentSupportFunctionId"));
                enumeration3.setLoadedValue(BemUtil.getExNodeLoadedValue(this.rbs, bemMo2, "unitType"));
                integerParameter.setLoadedValue(BemUtil.getExNodeLoadedValue(this.rbs, bemMo2, "unitNumber"));
                enumeration4.setLoadedValue(BemUtil.getExNodeLoadedValue(this.rbs, bemMo2, "sectorNumber"));
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
    }

    protected void setInciConnectorCustomerParameters(ServiceValue serviceValue) throws BemException {
        for (int i = 1; i <= 7; ++i) {
            Enumeration enumeration;
            String string = BemUtil.getInciConnectorPrefix(i);
            String string2 = serviceValue.getValue(string + "externalNodeId");
            String string3 = serviceValue.getValue(string + "equipmentSupportFunctionId");
            String string4 = serviceValue.getValue(string + "unitType");
            String string5 = serviceValue.getValue(string + "unitNumber");
            String string6 = serviceValue.getValue(string + "sectorNumber");
            if (string2 == null || string4 == null || string5 == null) continue;
            InciConnectorInfo inciConnectorInfo = this.inciConnectorInfos[i - 1];
            if (inciConnectorInfo == null) {
                throw new BemException("The " + i + "th of InciConnector CustomerParameters is not created");
            }
            Enumeration enumeration2 = inciConnectorInfo.getExternalNodeIdParameter();
            enumeration2.setValue(string2);
            if (string3 != null) {
                enumeration = inciConnectorInfo.getEquipmentSupportFunctionIdParameter();
                enumeration.setValue(string3);
            }
            enumeration = inciConnectorInfo.getUnitTypeParameter();
            enumeration.setValue(string4);
            IntegerParameter integerParameter = inciConnectorInfo.getUnitNumberParameter();
            integerParameter.setValue(string5);
            if (string6 == null) continue;
            Enumeration enumeration3 = inciConnectorInfo.getSectorNumberParameter();
            enumeration3.setValue(string6);
        }
    }
}

