/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;

public class CustomParaName {
    private Rbs rbs;
    private int maxNumberOfSector;
    private int maxNumberOfCarrier;
    private int startingSectorNumber;
    private String[][] useCellPseudoNameArray;
    private String[][] cellIdentityPseudoNameArray;
    private String[][] cellRangePseudoNameArray;
    private String[][] operatingBandPseudoNameArray;
    private String[][] hsCodeResourceIdPseudoNameArray;
    private String[][] nuOfTxBranchesPseudoNameArray;
    private String[][] basebandPoolIdPseudoNameArray;
    private String[][] numOfRxBranchesPseudoNameArray;
    private String[][] txBranchConfiguredPseudoNameArray;
    private String[][] txBranchConfigured2PseudoNameArray;
    private static String[] carrierAllocationModePseudoNameArray;

    public static String getCarrierAllocationModePseudoNameArrayByIndex(int n) {
        return carrierAllocationModePseudoNameArray[n];
    }

    public CustomParaName(Rbs rbs, int n) {
        this.rbs = rbs;
        this.startingSectorNumber = n;
        this.maxNumberOfSector = this.rbs.getMaxNumberOfSectors();
        this.maxNumberOfCarrier = this.rbs.getMaxNumberOfCarriers();
        this.initializePseudoNameArray();
        this.createParameterName();
    }

    private void initializePseudoNameArray() {
        carrierAllocationModePseudoNameArray = new String[this.maxNumberOfSector];
        this.useCellPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.cellIdentityPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.cellRangePseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.hsCodeResourceIdPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.nuOfTxBranchesPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.numOfRxBranchesPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.basebandPoolIdPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.operatingBandPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.txBranchConfiguredPseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
        this.txBranchConfigured2PseudoNameArray = new String[this.maxNumberOfSector][this.maxNumberOfCarrier];
    }

    public void createParameterName() {
        for (int i = 0; i < this.maxNumberOfSector; ++i) {
            for (int j = 0; j < this.maxNumberOfCarrier; ++j) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                int n2 = j + 1;
                String string = MessageFormat.format("S{0}_", new Integer(n));
                CustomParaName.carrierAllocationModePseudoNameArray[i] = string + "carrierAllocationMode";
                String string2 = MessageFormat.format("C{0}_", new Integer(n2));
                String string3 = string + string2;
                this.useCellPseudoNameArray[i][j] = string3 + "cellCreated";
                this.cellIdentityPseudoNameArray[i][j] = string3 + "cellIdentity";
                this.cellRangePseudoNameArray[i][j] = string3 + "cellRange";
                this.hsCodeResourceIdPseudoNameArray[i][j] = string3 + "hsCodeResourceId";
                this.nuOfTxBranchesPseudoNameArray[i][j] = string3 + "numberOfTxBranches";
                this.numOfRxBranchesPseudoNameArray[i][j] = string3 + "numberOfRxBranches";
                this.basebandPoolIdPseudoNameArray[i][j] = string3 + "baseBandPoolId";
                this.operatingBandPseudoNameArray[i][j] = string3 + "operatingBand";
                this.txBranchConfiguredPseudoNameArray[i][j] = string3 + "txBranchConfigured";
                this.txBranchConfigured2PseudoNameArray[i][j] = string3 + "txBranchConfigured2";
            }
        }
    }

    public String getCellIdentityName(int n, int n2) {
        return this.cellIdentityPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getUseCellPseudoName(int n, int n2) {
        return this.useCellPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getCellRangePseudoName(int n, int n2) {
        return this.cellRangePseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getHsCodeResourceIdPseudoName(int n, int n2) {
        return this.hsCodeResourceIdPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getNuOfTxBranchesPseudoName(int n, int n2) {
        return this.nuOfTxBranchesPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getNumOfRxBranchesPseudoName(int n, int n2) {
        return this.numOfRxBranchesPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getBasebandPoolIdPseudoName(int n, int n2) {
        return this.basebandPoolIdPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getOperatingBandPseudoName(int n, int n2) {
        return this.operatingBandPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getTxBranchConfiguredPseudoName(int n, int n2) {
        return this.txBranchConfiguredPseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    public String getTxBranchConfigured2PseudoName(int n, int n2) {
        return this.txBranchConfigured2PseudoNameArray[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][this.getCellIndexFromCellNumber(n2)];
    }

    private int getCellIndexFromCellNumber(int n) {
        return n - 1;
    }
}

