/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPortManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.BatteryBackupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.BfuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.BpaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.help.RDNHelper;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractHwUnitWithEcPortRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class BatteryManager {
    private static final String BFU_HW_UNIT_TYPE = "BFU";
    private static final String BPA_HW_UNIT_TYPE = "BPA";
    private Rbs rbs;
    private MoInstance equipmentMoi;
    private MoInstance equipmentSupportFunctionMoi;
    private MoInstance secondaryEquipmentSupportFunctionMoi;
    private int[] bfuPositions = new int[0];
    private int[] bpaPositions = new int[0];
    private IntegerRange bfuRange;
    private IntegerRange bpaRange;
    private TreeMap bfuRIs = new TreeMap();
    private TreeMap bpaRIs = new TreeMap();
    private BatteryBackupRI batteryBackupRI;
    private BatteryBackupRI batteryBackupSEsfRI;
    private boolean batterySupported;
    private int cabinetNumber;
    private String cabinetType;

    public BatteryManager(Rbs rbs, int[] nArray, int[] nArray2, IntegerRange integerRange, IntegerRange integerRange2, boolean bl) {
        this(rbs, nArray, nArray2, integerRange, integerRange2, bl, 1, null);
    }

    public BatteryManager(Rbs rbs, int[] nArray, int[] nArray2, IntegerRange integerRange, IntegerRange integerRange2, boolean bl, int n, String string) {
        this.rbs = rbs;
        this.bfuRange = integerRange;
        this.bpaRange = integerRange2;
        this.bfuPositions = nArray;
        this.bpaPositions = nArray2;
        this.batterySupported = bl;
        this.cabinetNumber = n;
        this.cabinetType = string;
        this.equipmentMoi = rbs.getEquipmentMoi();
        this.equipmentSupportFunctionMoi = new FixedRdnMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, "1");
        this.secondaryEquipmentSupportFunctionMoi = new FixedRdnMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, "2");
    }

    public int[] getBfuPositions() {
        return this.bfuPositions;
    }

    public int[] getBpaPositions() {
        return this.bpaPositions;
    }

    public IntegerRange getBfuRange() throws BemException {
        if (this.rbs.getRbsStep().equals("STEP_SITE")) {
            int n = this.bfuRange.getMaxValue();
            int n2 = this.getNumberOfInstalledBfus();
            this.bfuRange = new IntegerRange(n2, n);
        }
        return this.bfuRange;
    }

    public IntegerRange getBpaRange() throws BemException {
        if (this.rbs.getRbsStep().equals("STEP_SITE")) {
            int n = this.bpaRange.getMaxValue();
            int n2 = this.getNumberOfInstalledBpas();
            this.bpaRange = new IntegerRange(n2, n);
        }
        return this.bpaRange;
    }

    public void updateBoards(String string) throws BemException {
        if (string == BFU_HW_UNIT_TYPE) {
            for (int i = 0; i < this.bfuPositions.length; ++i) {
                BfuRI bfuRI = (BfuRI)this.bfuRIs.get(new Integer(this.bfuPositions[i]));
                if (bfuRI == null) continue;
                String string2 = bfuRI.getHubPosition();
                String string3 = this.lookupHubPos(string, string2, i + 1);
                bfuRI.setHubPosition(string3);
            }
        } else if (string == BPA_HW_UNIT_TYPE) {
            for (int i = 0; i < this.bpaPositions.length; ++i) {
                BpaRI bpaRI = (BpaRI)this.bpaRIs.get(new Integer(this.bpaPositions[i]));
                if (bpaRI == null) continue;
                String string4 = bpaRI.getHubPosition();
                String string5 = this.lookupHubPos(string, string4, i + 1);
                bpaRI.setHubPosition(string5);
            }
        }
        this.updateMoi();
    }

    private void updateMoi() throws BemException {
        if (this.batterySupported) {
            AbstractHwUnitWithEcPortRI abstractHwUnitWithEcPortRI;
            int n;
            for (n = 0; n < this.bfuPositions.length; ++n) {
                abstractHwUnitWithEcPortRI = (BfuRI)this.bfuRIs.get(new Integer(this.bfuPositions[n]));
                if (abstractHwUnitWithEcPortRI == null) continue;
                ((BfuRI)abstractHwUnitWithEcPortRI).updateMoi(this.equipmentMoi);
            }
            for (n = 0; n < this.bpaPositions.length; ++n) {
                abstractHwUnitWithEcPortRI = (BpaRI)this.bpaRIs.get(new Integer(this.bpaPositions[n]));
                if (abstractHwUnitWithEcPortRI == null) continue;
                ((BpaRI)abstractHwUnitWithEcPortRI).updateMoi(this.equipmentMoi);
            }
        }
    }

    private String lookupHubPos(String string, String string2, int n) {
        ApcHubPort apcHubPort;
        String string3 = string2;
        if ((string.equals(BFU_HW_UNIT_TYPE) || string.equals(BPA_HW_UNIT_TYPE)) && n > 0 && (apcHubPort = ApcHubPortManager.getInstance().getApcPortValue(this.cabinetType, string, n)) != null) {
            string3 = apcHubPort.getHubPosition();
        }
        return string3;
    }

    public void createAllRIs() throws BemException {
        if (this.batterySupported) {
            this.createBatteryBackupRI();
        }
    }

    private void createBatteryBackupRI() throws BemException {
        this.batteryBackupRI = new BatteryBackupRI(this.rbs, this.equipmentSupportFunctionMoi, this.cabinetNumber);
        this.batteryBackupSEsfRI = new BatteryBackupRI(this.rbs, this.secondaryEquipmentSupportFunctionMoi, this.cabinetNumber);
    }

    private void createBfuRIs(int n, List list) throws BemException {
        String string;
        String string2;
        Integer n2;
        BfuRI bfuRI;
        int n3;
        RDNHelper rDNHelper = RDNHelper.getInstance();
        for (n3 = 0; n3 < list.size(); ++n3) {
            bfuRI = new BfuRI(this.rbs, Integer.valueOf(list.get(n3).toString()), this.equipmentMoi);
            n2 = new Integer(this.bfuPositions[n3]);
            string2 = bfuRI.getHubPosition();
            string = this.lookupHubPos(BFU_HW_UNIT_TYPE, string2, n3 + 1);
            bfuRI.setHubPosition(string);
            this.bfuRIs.put(n2, bfuRI);
        }
        if (n > list.size()) {
            for (n3 = 0; n3 < n - list.size(); ++n3) {
                bfuRI = new BfuRI(this.rbs, rDNHelper.getPostfix(rDNHelper.getBfuRdnList()), this.equipmentMoi);
                n2 = new Integer(this.bfuPositions[list.size() + n3]);
                string2 = bfuRI.getHubPosition();
                string = this.lookupHubPos(BFU_HW_UNIT_TYPE, string2, list.size() + n3 + 1);
                bfuRI.setHubPosition(string);
                this.bfuRIs.put(n2, bfuRI);
            }
        }
    }

    private void createBpaRIs(int n, List list) throws BemException {
        String string;
        String string2;
        Integer n2;
        BpaRI bpaRI;
        int n3;
        RDNHelper rDNHelper = RDNHelper.getInstance();
        for (n3 = 0; n3 < list.size(); ++n3) {
            bpaRI = new BpaRI(this.rbs, Integer.valueOf(list.get(n3).toString()), this.equipmentMoi);
            n2 = new Integer(this.bpaPositions[n3]);
            string2 = bpaRI.getHubPosition();
            string = this.lookupHubPos(BPA_HW_UNIT_TYPE, string2, n3 + 1);
            bpaRI.setHubPosition(string);
            this.bpaRIs.put(n2, bpaRI);
        }
        if (n > list.size()) {
            for (n3 = 0; n3 < n - list.size(); ++n3) {
                bpaRI = new BpaRI(this.rbs, rDNHelper.getPostfix(rDNHelper.getBpaRdnList()), this.equipmentMoi);
                n2 = new Integer(this.bpaPositions[list.size() + n3]);
                string2 = bpaRI.getHubPosition();
                string = this.lookupHubPos(BPA_HW_UNIT_TYPE, string2, list.size() + n3 + 1);
                bpaRI.setHubPosition(string);
                this.bpaRIs.put(n2, bpaRI);
            }
        }
    }

    public ArrayList getRIsToBeInstalled(boolean bl, int n, int n2, List list, List list2) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list);
        Collections.sort(list2);
        if (bl && this.isBatterySupported()) {
            ArrayList arrayList2 = this.getNeededBatteryBackupRI();
            arrayList.addAll(arrayList2);
            arrayList2 = this.getNeededBfuRIs(bl, n, list);
            arrayList.addAll(arrayList2);
            arrayList2 = this.getNeededBpaRIs(bl, n2, list2);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public ArrayList getRIsToUninstall(int n, int n2, List list, List list2) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list);
        Collections.sort(list2);
        int n3 = list.size();
        int n4 = n3 - n;
        int n5 = list2.size();
        int n6 = n5 - n2;
        if (n4 > 0 || n6 > 0) {
            arrayList = this.getBfuAndBpaRIsToBeUnInstalled(n4, list, n6, list2);
        }
        if (BemUtil.isSecondaryESFReferred(this.rbs, this.cabinetNumber)) {
            arrayList.add(this.batteryBackupRI);
        } else {
            arrayList.add(this.batteryBackupSEsfRI);
        }
        return arrayList;
    }

    private ArrayList getBfuAndBpaRIsToBeUnInstalled(int n, List list, int n2, List list2) throws BemException {
        AbstractHwUnitWithEcPortRI abstractHwUnitWithEcPortRI;
        int n3;
        int n4;
        ArrayList<AbstractHwUnitWithEcPortRI> arrayList = new ArrayList<AbstractHwUnitWithEcPortRI>();
        this.createBfuRIs(n, list);
        this.createBpaRIs(n2, list2);
        Set set = this.bfuRIs.keySet();
        Object[] objectArray = set.toArray();
        for (n4 = n3 = objectArray.length; n4 > 0; --n4) {
            abstractHwUnitWithEcPortRI = (BfuRI)this.bfuRIs.get(objectArray[n4 - 1]);
            if (n <= 0 || !abstractHwUnitWithEcPortRI.isInstalled()) continue;
            arrayList.add(abstractHwUnitWithEcPortRI);
            --n;
        }
        set = this.bpaRIs.keySet();
        objectArray = set.toArray();
        for (n4 = n3 = objectArray.length; n4 > 0; --n4) {
            abstractHwUnitWithEcPortRI = (BpaRI)this.bpaRIs.get(objectArray[n4 - 1]);
            if (n2 <= 0 || !abstractHwUnitWithEcPortRI.isInstalled()) continue;
            arrayList.add(abstractHwUnitWithEcPortRI);
            --n2;
        }
        return arrayList;
    }

    private ArrayList getNeededBatteryBackupRI() {
        ArrayList<BatteryBackupRI> arrayList = new ArrayList<BatteryBackupRI>();
        if (BemUtil.isSecondaryESFReferred(this.rbs, this.cabinetNumber)) {
            arrayList.add(this.batteryBackupSEsfRI);
        } else {
            arrayList.add(this.batteryBackupRI);
        }
        return arrayList;
    }

    private ArrayList getNeededBfuRIs(boolean bl, int n, List list) throws BemException {
        ArrayList<BfuRI> arrayList = new ArrayList<BfuRI>();
        TreeMap treeMap = null;
        if (bl) {
            treeMap = this.bfuRIs;
            this.createBfuRIs(n, list);
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                BfuRI bfuRI = (BfuRI)entry.getValue();
                arrayList.add(bfuRI);
            }
        }
        return arrayList;
    }

    private ArrayList getNeededBpaRIs(boolean bl, int n, List list) throws BemException {
        ArrayList<BpaRI> arrayList = new ArrayList<BpaRI>();
        TreeMap treeMap = null;
        if (bl) {
            treeMap = this.bpaRIs;
            this.createBpaRIs(n, list);
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                BpaRI bpaRI = (BpaRI)entry.getValue();
                arrayList.add(bpaRI);
            }
        }
        return arrayList;
    }

    public boolean isBatterySupported() {
        return this.batterySupported;
    }

    public int getNumberOfBfus() {
        return this.bfuPositions.length;
    }

    public int getNumberOfBpas() {
        return this.bpaPositions.length;
    }

    public int getNumberOfInstalledBfus() throws BemException {
        int n = 0;
        Set set = this.bfuRIs.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            BfuRI bfuRI = (BfuRI)this.bfuRIs.get(n2);
            boolean bl = bfuRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfInstalledBpas() throws BemException {
        int n = 0;
        Set set = this.bpaRIs.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            BpaRI bpaRI = (BpaRI)this.bpaRIs.get(n2);
            boolean bl = bpaRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public boolean isBatteryBackupInstalled() throws BemException {
        boolean bl = false;
        if (this.batterySupported) {
            bl = this.batteryBackupRI.isInstalled() || this.batteryBackupSEsfRI.isInstalled();
        }
        return bl;
    }

    void setBatteryBackupRi(BatteryBackupRI batteryBackupRI, BatteryBackupRI batteryBackupRI2) {
        this.batteryBackupRI = batteryBackupRI;
        this.batteryBackupSEsfRI = batteryBackupRI2;
    }

    void setBatterySupported(boolean bl) {
        this.batterySupported = bl;
    }

    void setBfuRi(TreeMap treeMap) throws BemException {
        this.bfuRIs.putAll(treeMap);
    }

    void setBpaRi(TreeMap treeMap) throws BemException {
        this.bpaRIs.putAll(treeMap);
    }

    public Integer getBatteryType() throws BemException {
        return (Integer)this.getAttribute("batteryType");
    }

    public Integer getChargingMode() throws BemException {
        return (Integer)this.getAttribute("chargingMode");
    }

    public Integer getTestMode() throws BemException {
        return (Integer)this.getAttribute("testMode");
    }

    public Integer getMinimumStateOfHealth() throws BemException {
        return (Integer)this.getAttribute("minimumStateOfHealth");
    }

    public Integer getMinimumBackupTime() throws BemException {
        return (Integer)this.getAttribute("minimumBackupTime");
    }

    public Integer getTestStartDay() throws BemException {
        return (Integer)this.getAttribute("testStartDay");
    }

    public String getTestStartTime() throws BemException {
        return (String)this.getAttribute("testStartTime");
    }

    public String getbatteryInstallationDate() throws BemException {
        return (String)this.getAttribute("batteryInstallationDate");
    }

    public int[] getTestStartMonths() throws BemException {
        return (int[])this.getAttribute("testStartMonths");
    }

    public Boolean getSharedBattery() throws BemException {
        return (Boolean)this.getAttribute("sharedBattery");
    }

    public Integer getChargingVoltage() throws BemException {
        return (Integer)this.getAttribute("chargingVoltage");
    }

    public Integer getTempCompVoltageSlop() throws BemException {
        return (Integer)this.getAttribute("tempCompVoltageSlope");
    }

    public Integer getNominalTemp() throws BemException {
        return (Integer)this.getAttribute("nominalTemp");
    }

    public Integer getTempCompMinVoltage() throws BemException {
        return (Integer)this.getAttribute("tempCompMinVoltage");
    }

    public Integer getTempCompMaxVoltage() throws BemException {
        return (Integer)this.getAttribute("tempCompMaxVoltage");
    }

    public Integer getIncreasedChargeVoltage() throws BemException {
        return (Integer)this.getAttribute("increasedChargeVoltage");
    }

    public Integer getBoostChargeTime() throws BemException {
        return (Integer)this.getAttribute("boostChargeTime");
    }

    public Integer getBoostChargeTriggerVoltage() throws BemException {
        return (Integer)this.getAttribute("boostChargeTriggerVoltage");
    }

    public Integer getEqualizeChargeTime() throws BemException {
        return (Integer)this.getAttribute("equalizeChargeTime");
    }

    public Integer getEqualizeChargeCyclicInterval() throws BemException {
        return (Integer)this.getAttribute("equalizeChargeCyclicInterval");
    }

    public Integer getIntermittentChargeConnectVoltage() throws BemException {
        return (Integer)this.getAttribute("intermittentChargeConnectVoltage");
    }

    public Integer getIntermittentChargeConnectTime() throws BemException {
        return (Integer)this.getAttribute("intermittentChargeConnectTime");
    }

    public Integer getIntermittentChargeDisconnectTime() throws BemException {
        return (Integer)this.getAttribute("intermittentChargeDisconnectTime");
    }

    public Object getAttribute(String string) throws BemException {
        String string2 = this.batteryBackupRI.getLdn();
        if (BemUtil.isSecondaryESFReferred(this.rbs, this.cabinetNumber)) {
            string2 = this.batteryBackupSEsfRI.getLdn();
        }
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string2);
        Object object = null;
        try {
            object = moHandler.getAttribute(bemMo, string);
        }
        catch (Exception exception) {
            throw new BemException("BatteryManager.getAttribute()", "getAttribute()", string2, null, exception);
        }
        return object;
    }
}

