/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.FanSpeedSupervisionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimClimate;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class ClimateRI
extends AbstractResourceItem {
    private static final String NAME = "Climate";
    private static final String[] myInstallationPhases = new String[]{"CommonPowerSystemCreationPhase", "HwUnitDbControlledDeletionPhase"};
    private String climateLdn = null;
    private int climateControlModeAttributeValue;
    private boolean isBatterySupported = false;
    private boolean isBatteryConfigured = false;
    private int climateNumber = 0;

    public ClimateRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.climateNumber = n;
        this.climateLdn = new FixedRdnMoi(moInstance, MimClimate.MOTYPENAME, String.valueOf(n)).getLdn();
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            BemMo bemMo = super.getMo(this.climateLdn);
            boolean bl = bemMo.isExisting();
            try {
                Vector<NalNameValue> vector = new Vector<NalNameValue>();
                String string2 = String.valueOf(this.climateNumber);
                String string3 = PrefixUtil.getCabinetPrefix(string2) + "fanSpeedSupervision";
                if (this.rbs.isParameterSupported(string3)) {
                    FanSpeedSupervisionParameter fanSpeedSupervisionParameter = (FanSpeedSupervisionParameter)this.rbs.getCustomerParameterObject(string3);
                    if (!bl || fanSpeedSupervisionParameter.hasValueChanged()) {
                        Integer n = Integer.valueOf(fanSpeedSupervisionParameter.getValue());
                        NalNameValue nalNameValue = Nal.getFactory().getNameValue("fanSpeedSupervision", n);
                        vector.add(nalNameValue);
                    }
                }
                this.setClimateControlMode(vector);
                if (!bl) {
                    PowerSystemUtil.addControlDomainRef(vector, "controlDomainRef", this.climateNumber, this.rbs);
                    super.createMoIfNotExisting(this.climateLdn, vector);
                } else {
                    super.setAttributes(bemMo, vector);
                }
            }
            catch (BemException bemException) {
                throw new BemException(bemException.toString() + ". Can not create Climate MO.");
            }
        }
    }

    public String getDisplayName() {
        return "Climate: " + this.getLdn();
    }

    public String getLdn() {
        return this.climateLdn;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.climateLdn);
        try {
            Integer n;
            if (bemMo.isExisting() && (n = (Integer)moHandler.getAttribute(bemMo, "climateControlMode")) != null) {
                this.climateControlModeAttributeValue = n.compareTo(new Integer(1)) == 0 ? 1 : 0;
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        return bl;
    }

    public void uninstall(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            this.deleteMoIfExisting(this.climateLdn);
        }
    }

    public int getClimateControlModeValue() {
        return this.climateControlModeAttributeValue;
    }

    private void setClimateControlMode(Vector vector) throws BemException {
        if (this.isBatteryConfigured && this.isBatterySupported) {
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("climateControlMode", new Integer(1));
            vector.add(nalNameValue);
        }
    }

    public void setBatteryInfoForClimate(boolean bl, boolean bl2) {
        this.isBatteryConfigured = bl;
        this.isBatterySupported = bl2;
    }
}

