/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2PathVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2QosProfile;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal5TpVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmTrafficDescriptor;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimUniSaalProfile;
import se.ericsson.wcdma.rbs.bem.common.mim.MimUniSaalTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVpcTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVplTp;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class IubOverAtmManager {
    private static final boolean allowControlSystemRedundancy = false;
    private static final Integer toUserMaxSduSize = new Integer(2048);
    private static final Integer fromUserMaxSduSize = new Integer(2048);
    private static final Integer maxPd = new Integer(25);
    private static final Integer maxStat = new Integer(67);
    private static final Integer timerKeepAlive = new Integer(500);
    private static final Integer timerNoResponse = new Integer(4000);
    private static final Integer timerIdle = new Integer(2000);
    private static final Integer timerCC = new Integer(1000);
    private static final Integer timerPoll = new Integer(100);
    private static final Integer maxCC = new Integer(4);
    private static final Integer congestionOnSet = new Integer(90);
    private static final Integer congestionAbatement = new Integer(30);
    private static final String TRANSPORT_NETWORK_LDN = "ManagedElement=1,TransportNetwork=1";

    public static String getVplTpLdn(String string, String string2) {
        String string3 = "ManagedElement=1,TransportNetwork=1," + MimAtmPort.MOTYPENAME + "=" + string + "," + MimVplTp.MOTYPENAME + "=" + string2;
        return string3;
    }

    public static String getAtmTrafficDescriptorLdn(String string) {
        String string2 = "ManagedElement=1,TransportNetwork=1," + MimAtmTrafficDescriptor.MOTYPENAME + "=" + string;
        return string2;
    }

    public static String getAal5TpVccTpLdn(String string) {
        String string2 = "ManagedElement=1,TransportNetwork=1," + MimAal5TpVccTp.MOTYPENAME + "=" + string;
        return string2;
    }

    public static String getAal2PathVccTpLdn(String string) {
        String string2 = "ManagedElement=1,TransportNetwork=1," + MimAal2PathVccTp.MOTYPENAME + "=" + string;
        return string2;
    }

    public static String getAal2QosProfileLdn(String string) {
        String string2 = "ManagedElement=1,TransportNetwork=1," + MimAal2QosProfile.MOTYPENAME + "=" + string;
        return string2;
    }

    public static String getVpcTpLdn(String string, String string2, String string3) {
        String string4 = "ManagedElement=1,TransportNetwork=1," + MimAtmPort.MOTYPENAME + "=" + string3 + "," + MimVplTp.MOTYPENAME + "=" + string + "," + MimVpcTp.MOTYPENAME + "=" + string2;
        return string4;
    }

    public static String getUniSaalTpLdn(String string) {
        String string2 = "ManagedElement=1,TransportNetwork=1," + MimUniSaalTp.MOTYPENAME + "=" + string;
        return string2;
    }

    public static String getUniSaalProfileLdn(String string) {
        String string2 = "ManagedElement=1,TransportNetwork=1," + MimUniSaalProfile.MOTYPENAME + "=" + string;
        return string2;
    }

    public static Vector getVclTpAttributes(Integer n, BemMo bemMo) {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("externalVci", n));
        vector.add(Nal.getFactory().getNameValue("atmTrafficDescriptorId", bemMo));
        return vector;
    }

    public static Vector getAal5TpVccTpAttributes(Rbs rbs, BemMo bemMo) throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo2 = IubOverAtmManager.getProcessorMoPiu(rbs);
        vector.add(Nal.getFactory().getNameValue("processorId", bemMo2));
        vector.add(Nal.getFactory().getNameValue("vclTpId", bemMo));
        vector.add(Nal.getFactory().getNameValue("fromUserMaxSduSize", fromUserMaxSduSize));
        vector.add(Nal.getFactory().getNameValue("toUserMaxSduSize", toUserMaxSduSize));
        return vector;
    }

    public static Vector getUniSaalProfileAttributes(Integer n) {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("maxPD", maxPd), Nal.getFactory().getNameValue("maxStat", maxStat), Nal.getFactory().getNameValue("initialCredit", n), Nal.getFactory().getNameValue("timerKeepAlive", timerKeepAlive), Nal.getFactory().getNameValue("timerNoResponse", timerNoResponse), Nal.getFactory().getNameValue("timerIdle", timerIdle), Nal.getFactory().getNameValue("timerCC", timerCC), Nal.getFactory().getNameValue("timerPoll", timerPoll), Nal.getFactory().getNameValue("maxCC", maxCC), Nal.getFactory().getNameValue("congestionOnSet", congestionOnSet), Nal.getFactory().getNameValue("congestionAbatement", congestionAbatement)};
        NalStruct nalStruct = Nal.getFactory().getStruct(nalNameValueArray);
        vector.add(Nal.getFactory().getNameValue("profileData", nalStruct));
        return vector;
    }

    public static Vector getUniSaalTpAttributes(BemMo bemMo, BemMo bemMo2, Integer n) {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("uniSaalProfileId", bemMo));
        vector.add(Nal.getFactory().getNameValue("aal5TpVccTpId", bemMo2));
        vector.add(Nal.getFactory().getNameValue("maxSduSize", n));
        return vector;
    }

    private static BemMo getProcessorMoPiu(Rbs rbs) throws BemException {
        BemMo bemMo;
        MoHandler moHandler = rbs.getMoHandler();
        BemMo bemMo2 = null;
        try {
            BemMo[] bemMoArray;
            bemMo = moHandler.getRoot();
            if (DuwUtil.hasDuw()) {
                bemMoArray = DuwUtil.getPrimaryDuwPiuLdn();
                bemMo2 = moHandler.getMo((String)bemMoArray);
            }
            if (bemMo2 == null && (bemMoArray = moHandler.getChildren(bemMo, 10, MimGeneralProcessorUnit.MOTYPENAME, "")) != null && bemMoArray.length > 0) {
                bemMo2 = IubOverAtmManager.getProcessorWithLowestSlot(bemMoArray);
            }
            if (bemMo2 == null && (bemMoArray = moHandler.getChildren(bemMo, 10, MimCbu.MOTYPENAME, "")) != null && bemMoArray.length > 0) {
                bemMo2 = IubOverAtmManager.getProcessorWithLowestSlot(bemMoArray);
            }
            if (bemMo2 == null) {
                throw new BemException("IubOverAtmManager.getProcessorMo() Can not find GPB/CBU/DUW");
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(IubOverAtmManager.class + "getProcessorMoPiu()", (Throwable)moHandlerException);
        }
        bemMo = IubOverAtmManager.getPiuMo(bemMo2);
        return bemMo;
    }

    private static BemMo getProcessorWithLowestSlot(BemMo[] bemMoArray) {
        BemMo bemMo = null;
        if (bemMoArray.length > 0) {
            bemMo = bemMoArray[0];
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string;
                BemMo bemMo2 = bemMoArray[i];
                String string2 = bemMo.getDN();
                if (string2.compareTo(string = bemMo2.getDN()) <= 0) continue;
                bemMo = bemMo2;
            }
        }
        return bemMo;
    }

    private static BemMo getPiuMo(BemMo bemMo) {
        String string = bemMo.getType();
        BemMo bemMo2 = bemMo;
        while (!string.equals(MimPlugInUnit.MOTYPENAME)) {
            bemMo2 = bemMo2.getParent();
            string = bemMo2.getType();
        }
        return bemMo2;
    }

    public static boolean isIubRedunancyAllowed() {
        return false;
    }
}

